/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.telephony.SubscriptionManager;
import android.telephony.mbms.GroupCall;
import android.telephony.mbms.GroupCallCallback;
import android.telephony.mbms.InternalGroupCallCallback;
import android.telephony.mbms.InternalGroupCallSessionCallback;
import android.telephony.mbms.MbmsGroupCallSessionCallback;
import android.telephony.mbms.MbmsUtils;
import android.telephony.mbms.vendor.IMbmsGroupCallService;
import android.util.ArraySet;
import android.util.Log;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class MbmsGroupCallSession
implements AutoCloseable {
    private static final String LOG_TAG = "MbmsGroupCallSession";
    @SystemApi
    public static final String MBMS_GROUP_CALL_SERVICE_ACTION = "android.telephony.action.EmbmsGroupCall";
    public static final String MBMS_GROUP_CALL_SERVICE_OVERRIDE_METADATA = "mbms-group-call-service-override";
    private static AtomicBoolean sIsInitialized = new AtomicBoolean(false);
    private AtomicReference<IMbmsGroupCallService> mService = new AtomicReference<Object>(null);
    private IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        @Override
        public void binderDied() {
            sIsInitialized.set(false);
            MbmsGroupCallSession.this.mInternalCallback.onError(3, "Received death notification");
        }
    };
    private InternalGroupCallSessionCallback mInternalCallback;
    private Set<GroupCall> mKnownActiveGroupCalls = new ArraySet<GroupCall>();
    private final Context mContext;
    private int mSubscriptionId;

    private MbmsGroupCallSession(Context context, Executor executor, int subscriptionId, MbmsGroupCallSessionCallback callback) {
        this.mContext = context;
        this.mSubscriptionId = subscriptionId;
        this.mInternalCallback = new InternalGroupCallSessionCallback(callback, executor);
    }

    public static MbmsGroupCallSession create(Context context, int subscriptionId, Executor executor, final MbmsGroupCallSessionCallback callback) {
        if (!sIsInitialized.compareAndSet(false, true)) {
            throw new IllegalStateException("Cannot create two instances of MbmsGroupCallSession");
        }
        MbmsGroupCallSession session = new MbmsGroupCallSession(context, executor, subscriptionId, callback);
        final int result = session.bindAndInitialize();
        if (result != 0) {
            sIsInitialized.set(false);
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.onError(result, null);
                }
            });
            return null;
        }
        return session;
    }

    public static MbmsGroupCallSession create(Context context, Executor executor, MbmsGroupCallSessionCallback callback) {
        return MbmsGroupCallSession.create(context, SubscriptionManager.getDefaultSubscriptionId(), executor, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            IMbmsGroupCallService groupCallService = this.mService.get();
            if (groupCallService == null) {
                return;
            }
            groupCallService.dispose(this.mSubscriptionId);
            for (GroupCall s : this.mKnownActiveGroupCalls) {
                s.getCallback().stop();
            }
            this.mKnownActiveGroupCalls.clear();
        }
        catch (RemoteException remoteException) {
        }
        finally {
            this.mService.set(null);
            sIsInitialized.set(false);
            this.mInternalCallback.stop();
        }
    }

    public GroupCall startGroupCall(long tmgi, List<Integer> saiList, List<Integer> frequencyList, Executor executor, GroupCallCallback callback) {
        IMbmsGroupCallService groupCallService = this.mService.get();
        if (groupCallService == null) {
            throw new IllegalStateException("Middleware not yet bound");
        }
        InternalGroupCallCallback serviceCallback = new InternalGroupCallCallback(callback, executor);
        GroupCall serviceForApp = new GroupCall(this.mSubscriptionId, groupCallService, this, tmgi, serviceCallback);
        this.mKnownActiveGroupCalls.add(serviceForApp);
        try {
            int returnCode = groupCallService.startGroupCall(this.mSubscriptionId, tmgi, saiList, frequencyList, serviceCallback);
            if (returnCode == -1) {
                this.close();
                throw new IllegalStateException("Middleware must not return an unknown error code");
            }
            if (returnCode != 0) {
                this.mInternalCallback.onError(returnCode, null);
                return null;
            }
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "Remote process died");
            this.mService.set(null);
            sIsInitialized.set(false);
            this.mInternalCallback.onError(3, null);
            return null;
        }
        return serviceForApp;
    }

    public void onGroupCallStopped(GroupCall service) {
        this.mKnownActiveGroupCalls.remove(service);
    }

    private int bindAndInitialize() {
        return MbmsUtils.startBinding(this.mContext, MBMS_GROUP_CALL_SERVICE_ACTION, new ServiceConnection(){

            @Override
            public void onServiceConnected(ComponentName name, IBinder service) {
                int result;
                IMbmsGroupCallService groupCallService = IMbmsGroupCallService.Stub.asInterface(service);
                try {
                    result = groupCallService.initialize(MbmsGroupCallSession.this.mInternalCallback, MbmsGroupCallSession.this.mSubscriptionId);
                }
                catch (RemoteException e) {
                    Log.e(MbmsGroupCallSession.LOG_TAG, "Service died before initialization");
                    MbmsGroupCallSession.this.mInternalCallback.onError(103, e.toString());
                    sIsInitialized.set(false);
                    return;
                }
                catch (RuntimeException e) {
                    Log.e(MbmsGroupCallSession.LOG_TAG, "Runtime exception during initialization");
                    MbmsGroupCallSession.this.mInternalCallback.onError(103, e.toString());
                    sIsInitialized.set(false);
                    return;
                }
                if (result == -1) {
                    MbmsGroupCallSession.this.close();
                    throw new IllegalStateException("Middleware must not return an unknown error code");
                }
                if (result != 0) {
                    MbmsGroupCallSession.this.mInternalCallback.onError(result, "Error returned during initialization");
                    sIsInitialized.set(false);
                    return;
                }
                try {
                    groupCallService.asBinder().linkToDeath(MbmsGroupCallSession.this.mDeathRecipient, 0);
                }
                catch (RemoteException e) {
                    MbmsGroupCallSession.this.mInternalCallback.onError(3, "Middleware lost during initialization");
                    sIsInitialized.set(false);
                    return;
                }
                MbmsGroupCallSession.this.mService.set(groupCallService);
            }

            @Override
            public void onServiceDisconnected(ComponentName name) {
                sIsInitialized.set(false);
                MbmsGroupCallSession.this.mService.set(null);
            }
        });
    }
}

