/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.app.Service;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.telephony.INetworkService;
import android.telephony.INetworkServiceCallback;
import android.telephony.NetworkServiceCallback;
import android.telephony.Rlog;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;

@SystemApi
public abstract class NetworkService
extends Service {
    private final String TAG = NetworkService.class.getSimpleName();
    public static final String SERVICE_INTERFACE = "android.telephony.NetworkService";
    private static final int NETWORK_SERVICE_CREATE_NETWORK_SERVICE_PROVIDER = 1;
    private static final int NETWORK_SERVICE_REMOVE_NETWORK_SERVICE_PROVIDER = 2;
    private static final int NETWORK_SERVICE_REMOVE_ALL_NETWORK_SERVICE_PROVIDERS = 3;
    private static final int NETWORK_SERVICE_GET_REGISTRATION_INFO = 4;
    private static final int NETWORK_SERVICE_REGISTER_FOR_INFO_CHANGE = 5;
    private static final int NETWORK_SERVICE_UNREGISTER_FOR_INFO_CHANGE = 6;
    private static final int NETWORK_SERVICE_INDICATION_NETWORK_INFO_CHANGED = 7;
    private final HandlerThread mHandlerThread;
    private final NetworkServiceHandler mHandler;
    private final SparseArray<NetworkServiceProvider> mServiceMap = new SparseArray();
    @VisibleForTesting
    public final INetworkServiceWrapper mBinder = new INetworkServiceWrapper();

    public NetworkService() {
        this.mHandlerThread = new HandlerThread(this.TAG);
        this.mHandlerThread.start();
        this.mHandler = new NetworkServiceHandler(this.mHandlerThread.getLooper());
        this.log("network service created");
    }

    public abstract NetworkServiceProvider onCreateNetworkServiceProvider(int var1);

    @Override
    public IBinder onBind(Intent intent) {
        if (intent == null || !SERVICE_INTERFACE.equals(intent.getAction())) {
            this.loge("Unexpected intent " + intent);
            return null;
        }
        return this.mBinder;
    }

    @Override
    public boolean onUnbind(Intent intent) {
        this.mHandler.obtainMessage(3, 0, 0, null).sendToTarget();
        return false;
    }

    @Override
    public void onDestroy() {
        this.mHandlerThread.quit();
        super.onDestroy();
    }

    private final void log(String s) {
        Rlog.d(this.TAG, s);
    }

    private final void loge(String s) {
        Rlog.e(this.TAG, s);
    }

    private class INetworkServiceWrapper
    extends INetworkService.Stub {
        private INetworkServiceWrapper() {
        }

        @Override
        public void createNetworkServiceProvider(int slotIndex) {
            NetworkService.this.mHandler.obtainMessage(1, slotIndex, 0, null).sendToTarget();
        }

        @Override
        public void removeNetworkServiceProvider(int slotIndex) {
            NetworkService.this.mHandler.obtainMessage(2, slotIndex, 0, null).sendToTarget();
        }

        @Override
        public void requestNetworkRegistrationInfo(int slotIndex, int domain, INetworkServiceCallback callback) {
            NetworkService.this.mHandler.obtainMessage(4, slotIndex, domain, callback).sendToTarget();
        }

        @Override
        public void registerForNetworkRegistrationInfoChanged(int slotIndex, INetworkServiceCallback callback) {
            NetworkService.this.mHandler.obtainMessage(5, slotIndex, 0, callback).sendToTarget();
        }

        @Override
        public void unregisterForNetworkRegistrationInfoChanged(int slotIndex, INetworkServiceCallback callback) {
            NetworkService.this.mHandler.obtainMessage(6, slotIndex, 0, callback).sendToTarget();
        }
    }

    private class NetworkServiceHandler
    extends Handler {
        NetworkServiceHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message message) {
            int slotIndex = message.arg1;
            INetworkServiceCallback callback = (INetworkServiceCallback)message.obj;
            NetworkServiceProvider serviceProvider = (NetworkServiceProvider)NetworkService.this.mServiceMap.get(slotIndex);
            switch (message.what) {
                case 1: {
                    if (serviceProvider != null) break;
                    NetworkService.this.mServiceMap.put(slotIndex, NetworkService.this.onCreateNetworkServiceProvider(slotIndex));
                    break;
                }
                case 2: {
                    if (serviceProvider == null) break;
                    serviceProvider.close();
                    NetworkService.this.mServiceMap.remove(slotIndex);
                    break;
                }
                case 3: {
                    for (int i = 0; i < NetworkService.this.mServiceMap.size(); ++i) {
                        serviceProvider = (NetworkServiceProvider)NetworkService.this.mServiceMap.get(i);
                        if (serviceProvider == null) continue;
                        serviceProvider.close();
                    }
                    NetworkService.this.mServiceMap.clear();
                    break;
                }
                case 4: {
                    if (serviceProvider == null) break;
                    int domainId = message.arg2;
                    serviceProvider.requestNetworkRegistrationInfo(domainId, new NetworkServiceCallback(callback));
                    break;
                }
                case 5: {
                    if (serviceProvider == null) break;
                    serviceProvider.registerForInfoChanged(callback);
                    break;
                }
                case 6: {
                    if (serviceProvider == null) break;
                    serviceProvider.unregisterForInfoChanged(callback);
                    break;
                }
                case 7: {
                    if (serviceProvider == null) break;
                    serviceProvider.notifyInfoChangedToCallbacks();
                    break;
                }
            }
        }
    }

    public abstract class NetworkServiceProvider
    implements AutoCloseable {
        private final int mSlotIndex;
        private final List<INetworkServiceCallback> mNetworkRegistrationInfoChangedCallbacks = new ArrayList<INetworkServiceCallback>();

        public NetworkServiceProvider(int slotIndex) {
            this.mSlotIndex = slotIndex;
        }

        public final int getSlotIndex() {
            return this.mSlotIndex;
        }

        public void requestNetworkRegistrationInfo(int domain, NetworkServiceCallback callback) {
            callback.onRequestNetworkRegistrationInfoComplete(1, null);
        }

        public final void notifyNetworkRegistrationInfoChanged() {
            NetworkService.this.mHandler.obtainMessage(7, this.mSlotIndex, 0, null).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerForInfoChanged(INetworkServiceCallback callback) {
            List<INetworkServiceCallback> list = this.mNetworkRegistrationInfoChangedCallbacks;
            synchronized (list) {
                this.mNetworkRegistrationInfoChangedCallbacks.add(callback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregisterForInfoChanged(INetworkServiceCallback callback) {
            List<INetworkServiceCallback> list = this.mNetworkRegistrationInfoChangedCallbacks;
            synchronized (list) {
                this.mNetworkRegistrationInfoChangedCallbacks.remove(callback);
            }
        }

        private void notifyInfoChangedToCallbacks() {
            for (INetworkServiceCallback callback : this.mNetworkRegistrationInfoChangedCallbacks) {
                try {
                    callback.onNetworkStateChanged();
                }
                catch (RemoteException remoteException) {}
            }
        }

        @Override
        public abstract void close();
    }
}

