/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.Looper;
import android.telephony.CallAttributes;
import android.telephony.CellInfo;
import android.telephony.CellLocation;
import android.telephony.DataConnectionRealTimeInfo;
import android.telephony.PhoneCapability;
import android.telephony.PhysicalChannelConfig;
import android.telephony.PreciseCallState;
import android.telephony.PreciseDataConnectionState;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.emergency.EmergencyNumber;
import android.telephony.ims.ImsReasonInfo;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.IPhoneStateListener;
import dalvik.system.VMRuntime;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class PhoneStateListener {
    private static final String LOG_TAG = "PhoneStateListener";
    private static final boolean DBG = false;
    public static final int LISTEN_NONE = 0;
    public static final int LISTEN_SERVICE_STATE = 1;
    @Deprecated
    public static final int LISTEN_SIGNAL_STRENGTH = 2;
    public static final int LISTEN_MESSAGE_WAITING_INDICATOR = 4;
    public static final int LISTEN_CALL_FORWARDING_INDICATOR = 8;
    public static final int LISTEN_CELL_LOCATION = 16;
    public static final int LISTEN_CALL_STATE = 32;
    public static final int LISTEN_DATA_CONNECTION_STATE = 64;
    public static final int LISTEN_DATA_ACTIVITY = 128;
    public static final int LISTEN_SIGNAL_STRENGTHS = 256;
    public static final int LISTEN_OTASP_CHANGED = 512;
    public static final int LISTEN_CELL_INFO = 1024;
    @SystemApi
    public static final int LISTEN_PRECISE_CALL_STATE = 2048;
    @SystemApi
    public static final int LISTEN_PRECISE_DATA_CONNECTION_STATE = 4096;
    @Deprecated
    public static final int LISTEN_DATA_CONNECTION_REAL_TIME_INFO = 8192;
    @SystemApi
    public static final int LISTEN_SRVCC_STATE_CHANGED = 16384;
    @Deprecated
    public static final int LISTEN_OEM_HOOK_RAW_EVENT = 32768;
    public static final int LISTEN_CARRIER_NETWORK_CHANGE = 65536;
    @SystemApi
    public static final int LISTEN_VOICE_ACTIVATION_STATE = 131072;
    public static final int LISTEN_DATA_ACTIVATION_STATE = 262144;
    public static final int LISTEN_USER_MOBILE_DATA_STATE = 524288;
    public static final int LISTEN_PHYSICAL_CHANNEL_CONFIGURATION = 0x100000;
    public static final int LISTEN_PHONE_CAPABILITY_CHANGE = 0x200000;
    public static final int LISTEN_ACTIVE_DATA_SUBSCRIPTION_ID_CHANGE = 0x400000;
    @SystemApi
    public static final int LISTEN_RADIO_POWER_STATE_CHANGED = 0x800000;
    public static final int LISTEN_EMERGENCY_NUMBER_LIST = 0x1000000;
    @SystemApi
    public static final int LISTEN_CALL_DISCONNECT_CAUSES = 0x2000000;
    @SystemApi
    public static final int LISTEN_CALL_ATTRIBUTES_CHANGED = 0x4000000;
    @SystemApi
    public static final int LISTEN_IMS_CALL_DISCONNECT_CAUSES = 0x8000000;
    @UnsupportedAppUsage
    protected Integer mSubId;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    @UnsupportedAppUsage
    public final IPhoneStateListener callback;

    public PhoneStateListener() {
        this(null, Looper.myLooper());
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public PhoneStateListener(Looper looper) {
        this(null, looper);
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public PhoneStateListener(Integer subId) {
        this(subId, Looper.myLooper());
        if (subId != null && VMRuntime.getRuntime().getTargetSdkVersion() >= 29) {
            throw new IllegalArgumentException("PhoneStateListener with subId: " + subId + " is not supported, use default constructor");
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public PhoneStateListener(Integer subId, Looper looper) {
        this(subId, new HandlerExecutor(new Handler(looper)));
        if (subId != null && VMRuntime.getRuntime().getTargetSdkVersion() >= 29) {
            throw new IllegalArgumentException("PhoneStateListener with subId: " + subId + " is not supported, use default constructor");
        }
    }

    public PhoneStateListener(Executor executor) {
        this(null, executor);
    }

    private PhoneStateListener(Integer subId, Executor e) {
        if (e == null) {
            throw new IllegalArgumentException("PhoneStateListener Executor must be non-null");
        }
        this.mSubId = subId;
        this.callback = new IPhoneStateListenerStub(this, e);
    }

    public void onServiceStateChanged(ServiceState serviceState) {
    }

    @Deprecated
    public void onSignalStrengthChanged(int asu) {
    }

    public void onMessageWaitingIndicatorChanged(boolean mwi) {
    }

    public void onCallForwardingIndicatorChanged(boolean cfi) {
    }

    public void onCellLocationChanged(CellLocation location) {
    }

    public void onCallStateChanged(int state, String phoneNumber) {
    }

    public void onDataConnectionStateChanged(int state) {
    }

    public void onDataConnectionStateChanged(int state, int networkType) {
    }

    public void onDataActivity(int direction) {
    }

    public void onSignalStrengthsChanged(SignalStrength signalStrength) {
    }

    @UnsupportedAppUsage
    public void onOtaspChanged(int otaspMode) {
    }

    public void onCellInfoChanged(List<CellInfo> cellInfo) {
    }

    @SystemApi
    public void onPreciseCallStateChanged(PreciseCallState callState) {
    }

    @SystemApi
    public void onCallDisconnectCauseChanged(int disconnectCause, int preciseDisconnectCause) {
    }

    @SystemApi
    public void onImsCallDisconnectCauseChanged(ImsReasonInfo imsReasonInfo) {
    }

    @SystemApi
    public void onPreciseDataConnectionStateChanged(PreciseDataConnectionState dataConnectionState) {
    }

    @UnsupportedAppUsage
    public void onDataConnectionRealTimeInfoChanged(DataConnectionRealTimeInfo dcRtInfo) {
    }

    @SystemApi
    public void onSrvccStateChanged(int srvccState) {
    }

    @SystemApi
    public void onVoiceActivationStateChanged(int state) {
    }

    public void onDataActivationStateChanged(int state) {
    }

    public void onUserMobileDataStateChanged(boolean enabled) {
    }

    public void onPhysicalChannelConfigurationChanged(List<PhysicalChannelConfig> configs) {
    }

    public void onEmergencyNumberListChanged(Map<Integer, List<EmergencyNumber>> emergencyNumberList) {
    }

    @UnsupportedAppUsage
    public void onOemHookRawEvent(byte[] rawData) {
    }

    public void onPhoneCapabilityChanged(PhoneCapability capability) {
    }

    public void onActiveDataSubscriptionIdChanged(int subId) {
    }

    @SystemApi
    public void onCallAttributesChanged(CallAttributes callAttributes) {
    }

    @SystemApi
    public void onRadioPowerStateChanged(int state) {
    }

    public void onCarrierNetworkChange(boolean active) {
    }

    private void log(String s) {
        Rlog.d(LOG_TAG, s);
    }

    private static class IPhoneStateListenerStub
    extends IPhoneStateListener.Stub {
        private WeakReference<PhoneStateListener> mPhoneStateListenerWeakRef;
        private Executor mExecutor;

        IPhoneStateListenerStub(PhoneStateListener phoneStateListener, Executor executor) {
            this.mPhoneStateListenerWeakRef = new WeakReference<PhoneStateListener>(phoneStateListener);
            this.mExecutor = executor;
        }

        @Override
        public void onServiceStateChanged(ServiceState serviceState) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onServiceStateChanged(serviceState)));
        }

        @Override
        public void onSignalStrengthChanged(int asu) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onSignalStrengthChanged(asu)));
        }

        @Override
        public void onMessageWaitingIndicatorChanged(boolean mwi) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onMessageWaitingIndicatorChanged(mwi)));
        }

        @Override
        public void onCallForwardingIndicatorChanged(boolean cfi) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onCallForwardingIndicatorChanged(cfi)));
        }

        @Override
        public void onCellLocationChanged(Bundle bundle) {
            CellLocation location = CellLocation.newFromBundle(bundle);
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onCellLocationChanged(location)));
        }

        @Override
        public void onCallStateChanged(int state, String incomingNumber) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onCallStateChanged(state, incomingNumber)));
        }

        @Override
        public void onDataConnectionStateChanged(int state, int networkType) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> {
                psl.onDataConnectionStateChanged(state, networkType);
                psl.onDataConnectionStateChanged(state);
            }));
        }

        @Override
        public void onDataActivity(int direction) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onDataActivity(direction)));
        }

        @Override
        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onSignalStrengthsChanged(signalStrength)));
        }

        @Override
        public void onOtaspChanged(int otaspMode) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onOtaspChanged(otaspMode)));
        }

        @Override
        public void onCellInfoChanged(List<CellInfo> cellInfo) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onCellInfoChanged(cellInfo)));
        }

        @Override
        public void onPreciseCallStateChanged(PreciseCallState callState) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onPreciseCallStateChanged(callState)));
        }

        @Override
        public void onCallDisconnectCauseChanged(int disconnectCause, int preciseDisconnectCause) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onCallDisconnectCauseChanged(disconnectCause, preciseDisconnectCause)));
        }

        @Override
        public void onPreciseDataConnectionStateChanged(PreciseDataConnectionState dataConnectionState) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onPreciseDataConnectionStateChanged(dataConnectionState)));
        }

        @Override
        public void onDataConnectionRealTimeInfoChanged(DataConnectionRealTimeInfo dcRtInfo) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onDataConnectionRealTimeInfoChanged(dcRtInfo)));
        }

        @Override
        public void onSrvccStateChanged(int state) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onSrvccStateChanged(state)));
        }

        @Override
        public void onVoiceActivationStateChanged(int activationState) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onVoiceActivationStateChanged(activationState)));
        }

        @Override
        public void onDataActivationStateChanged(int activationState) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onDataActivationStateChanged(activationState)));
        }

        @Override
        public void onUserMobileDataStateChanged(boolean enabled) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onUserMobileDataStateChanged(enabled)));
        }

        @Override
        public void onOemHookRawEvent(byte[] rawData) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onOemHookRawEvent(rawData)));
        }

        @Override
        public void onCarrierNetworkChange(boolean active) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onCarrierNetworkChange(active)));
        }

        @Override
        public void onPhysicalChannelConfigurationChanged(List<PhysicalChannelConfig> configs) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onPhysicalChannelConfigurationChanged(configs)));
        }

        @Override
        public void onEmergencyNumberListChanged(Map emergencyNumberList) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onEmergencyNumberListChanged(emergencyNumberList)));
        }

        @Override
        public void onPhoneCapabilityChanged(PhoneCapability capability) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onPhoneCapabilityChanged(capability)));
        }

        @Override
        public void onRadioPowerStateChanged(int state) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onRadioPowerStateChanged(state)));
        }

        @Override
        public void onCallAttributesChanged(CallAttributes callAttributes) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onCallAttributesChanged(callAttributes)));
        }

        @Override
        public void onActiveDataSubIdChanged(int subId) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onActiveDataSubscriptionIdChanged(subId)));
        }

        @Override
        public void onImsCallDisconnectCauseChanged(ImsReasonInfo disconnectCause) {
            PhoneStateListener psl = (PhoneStateListener)this.mPhoneStateListenerWeakRef.get();
            if (psl == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> psl.onImsCallDisconnectCauseChanged(disconnectCause)));
        }
    }
}

