/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.data;

import android.annotation.SystemApi;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public final class DataProfile
implements Parcelable {
    public static final int TYPE_COMMON = 0;
    public static final int TYPE_3GPP = 1;
    public static final int TYPE_3GPP2 = 2;
    private final int mProfileId;
    private final String mApn;
    private final int mProtocolType;
    private final int mAuthType;
    private final String mUserName;
    private final String mPassword;
    private final int mType;
    private final int mMaxConnectionsTime;
    private final int mMaxConnections;
    private final int mWaitTime;
    private final boolean mEnabled;
    private final int mSupportedApnTypesBitmask;
    private final int mRoamingProtocolType;
    private final int mBearerBitmask;
    private final int mMtu;
    private final boolean mPersistent;
    private final boolean mPreferred;
    public static final Parcelable.Creator<DataProfile> CREATOR = new Parcelable.Creator<DataProfile>(){

        @Override
        public DataProfile createFromParcel(Parcel source) {
            return new DataProfile(source);
        }

        public DataProfile[] newArray(int size) {
            return new DataProfile[size];
        }
    };

    private DataProfile(int profileId, String apn, int protocolType, int authType, String userName, String password, int type, int maxConnectionsTime, int maxConnections, int waitTime, boolean enabled, int supportedApnTypesBitmask, int roamingProtocolType, int bearerBitmask, int mtu, boolean persistent, boolean preferred) {
        this.mProfileId = profileId;
        this.mApn = apn;
        this.mProtocolType = protocolType;
        if (authType == -1) {
            authType = TextUtils.isEmpty(userName) ? 0 : 3;
        }
        this.mAuthType = authType;
        this.mUserName = userName;
        this.mPassword = password;
        this.mType = type;
        this.mMaxConnectionsTime = maxConnectionsTime;
        this.mMaxConnections = maxConnections;
        this.mWaitTime = waitTime;
        this.mEnabled = enabled;
        this.mSupportedApnTypesBitmask = supportedApnTypesBitmask;
        this.mRoamingProtocolType = roamingProtocolType;
        this.mBearerBitmask = bearerBitmask;
        this.mMtu = mtu;
        this.mPersistent = persistent;
        this.mPreferred = preferred;
    }

    private DataProfile(Parcel source) {
        this.mProfileId = source.readInt();
        this.mApn = source.readString();
        this.mProtocolType = source.readInt();
        this.mAuthType = source.readInt();
        this.mUserName = source.readString();
        this.mPassword = source.readString();
        this.mType = source.readInt();
        this.mMaxConnectionsTime = source.readInt();
        this.mMaxConnections = source.readInt();
        this.mWaitTime = source.readInt();
        this.mEnabled = source.readBoolean();
        this.mSupportedApnTypesBitmask = source.readInt();
        this.mRoamingProtocolType = source.readInt();
        this.mBearerBitmask = source.readInt();
        this.mMtu = source.readInt();
        this.mPersistent = source.readBoolean();
        this.mPreferred = source.readBoolean();
    }

    public int getProfileId() {
        return this.mProfileId;
    }

    public String getApn() {
        return this.mApn;
    }

    public int getProtocolType() {
        return this.mProtocolType;
    }

    public int getAuthType() {
        return this.mAuthType;
    }

    public String getUserName() {
        return this.mUserName;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public int getType() {
        return this.mType;
    }

    public int getMaxConnectionsTime() {
        return this.mMaxConnectionsTime;
    }

    public int getMaxConnections() {
        return this.mMaxConnections;
    }

    public int getWaitTime() {
        return this.mWaitTime;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public int getSupportedApnTypesBitmask() {
        return this.mSupportedApnTypesBitmask;
    }

    public int getRoamingProtocolType() {
        return this.mRoamingProtocolType;
    }

    public int getBearerBitmask() {
        return this.mBearerBitmask;
    }

    public int getMtu() {
        return this.mMtu;
    }

    public boolean isPersistent() {
        return this.mPersistent;
    }

    public boolean isPreferred() {
        return this.mPreferred;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "DataProfile=" + this.mProfileId + "/" + this.mProtocolType + "/" + this.mAuthType + "/" + (Build.IS_USER ? "***/***/***" : this.mApn + "/" + this.mUserName + "/" + this.mPassword) + "/" + this.mType + "/" + this.mMaxConnectionsTime + "/" + this.mMaxConnections + "/" + this.mWaitTime + "/" + this.mEnabled + "/" + this.mSupportedApnTypesBitmask + "/" + this.mRoamingProtocolType + "/" + this.mBearerBitmask + "/" + this.mMtu + "/" + this.mPersistent + "/" + this.mPreferred;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mProfileId);
        dest.writeString(this.mApn);
        dest.writeInt(this.mProtocolType);
        dest.writeInt(this.mAuthType);
        dest.writeString(this.mUserName);
        dest.writeString(this.mPassword);
        dest.writeInt(this.mType);
        dest.writeInt(this.mMaxConnectionsTime);
        dest.writeInt(this.mMaxConnections);
        dest.writeInt(this.mWaitTime);
        dest.writeBoolean(this.mEnabled);
        dest.writeInt(this.mSupportedApnTypesBitmask);
        dest.writeInt(this.mRoamingProtocolType);
        dest.writeInt(this.mBearerBitmask);
        dest.writeInt(this.mMtu);
        dest.writeBoolean(this.mPersistent);
        dest.writeBoolean(this.mPreferred);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataProfile that = (DataProfile)o;
        return this.mProfileId == that.mProfileId && this.mProtocolType == that.mProtocolType && this.mAuthType == that.mAuthType && this.mType == that.mType && this.mMaxConnectionsTime == that.mMaxConnectionsTime && this.mMaxConnections == that.mMaxConnections && this.mWaitTime == that.mWaitTime && this.mEnabled == that.mEnabled && this.mSupportedApnTypesBitmask == that.mSupportedApnTypesBitmask && this.mRoamingProtocolType == that.mRoamingProtocolType && this.mBearerBitmask == that.mBearerBitmask && this.mMtu == that.mMtu && this.mPersistent == that.mPersistent && this.mPreferred == that.mPreferred && Objects.equals(this.mApn, that.mApn) && Objects.equals(this.mUserName, that.mUserName) && Objects.equals(this.mPassword, that.mPassword);
    }

    public int hashCode() {
        return Objects.hash(this.mProfileId, this.mApn, this.mProtocolType, this.mAuthType, this.mUserName, this.mPassword, this.mType, this.mMaxConnectionsTime, this.mMaxConnections, this.mWaitTime, this.mEnabled, this.mSupportedApnTypesBitmask, this.mRoamingProtocolType, this.mBearerBitmask, this.mMtu, this.mPersistent, this.mPreferred);
    }

    public static final class Builder {
        private int mProfileId;
        private String mApn;
        private int mProtocolType;
        private int mAuthType;
        private String mUserName;
        private String mPassword;
        private int mType;
        private int mMaxConnectionsTime;
        private int mMaxConnections;
        private int mWaitTime;
        private boolean mEnabled;
        private int mSupportedApnTypesBitmask;
        private int mRoamingProtocolType;
        private int mBearerBitmask;
        private int mMtu;
        private boolean mPersistent;
        private boolean mPreferred;

        public Builder setProfileId(int profileId) {
            this.mProfileId = profileId;
            return this;
        }

        public Builder setApn(String apn) {
            this.mApn = apn;
            return this;
        }

        public Builder setProtocolType(int protocolType) {
            this.mProtocolType = protocolType;
            return this;
        }

        public Builder setAuthType(int authType) {
            this.mAuthType = authType;
            return this;
        }

        public Builder setUserName(String userName) {
            this.mUserName = userName;
            return this;
        }

        public Builder setPassword(String password) {
            this.mPassword = password;
            return this;
        }

        public Builder setType(int type) {
            this.mType = type;
            return this;
        }

        public Builder setMaxConnectionsTime(int maxConnectionsTime) {
            this.mMaxConnectionsTime = maxConnectionsTime;
            return this;
        }

        public Builder setMaxConnections(int maxConnections) {
            this.mMaxConnections = maxConnections;
            return this;
        }

        public Builder setWaitTime(int waitTime) {
            this.mWaitTime = waitTime;
            return this;
        }

        public Builder enable(boolean isEnabled) {
            this.mEnabled = isEnabled;
            return this;
        }

        public Builder setSupportedApnTypesBitmask(int supportedApnTypesBitmask) {
            this.mSupportedApnTypesBitmask = supportedApnTypesBitmask;
            return this;
        }

        public Builder setRoamingProtocolType(int protocolType) {
            this.mRoamingProtocolType = protocolType;
            return this;
        }

        public Builder setBearerBitmask(int bearerBitmask) {
            this.mBearerBitmask = bearerBitmask;
            return this;
        }

        public Builder setMtu(int mtu) {
            this.mMtu = mtu;
            return this;
        }

        public Builder setPreferred(boolean isPreferred) {
            this.mPreferred = isPreferred;
            return this;
        }

        public Builder setPersistent(boolean isPersistent) {
            this.mPersistent = isPersistent;
            return this;
        }

        public DataProfile build() {
            return new DataProfile(this.mProfileId, this.mApn, this.mProtocolType, this.mAuthType, this.mUserName, this.mPassword, this.mType, this.mMaxConnectionsTime, this.mMaxConnections, this.mWaitTime, this.mEnabled, this.mSupportedApnTypesBitmask, this.mRoamingProtocolType, this.mBearerBitmask, this.mMtu, this.mPersistent, this.mPreferred);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

