/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.data;

import android.annotation.SystemApi;
import android.app.Service;
import android.content.Intent;
import android.net.LinkProperties;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.telephony.Rlog;
import android.telephony.data.DataCallResponse;
import android.telephony.data.DataProfile;
import android.telephony.data.DataServiceCallback;
import android.telephony.data.IDataService;
import android.telephony.data.IDataServiceCallback;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

@SystemApi
public abstract class DataService
extends Service {
    private static final String TAG = DataService.class.getSimpleName();
    public static final String SERVICE_INTERFACE = "android.telephony.data.DataService";
    public static final int REQUEST_REASON_UNKNOWN = 0;
    public static final int REQUEST_REASON_NORMAL = 1;
    public static final int REQUEST_REASON_SHUTDOWN = 2;
    public static final int REQUEST_REASON_HANDOVER = 3;
    private static final int DATA_SERVICE_CREATE_DATA_SERVICE_PROVIDER = 1;
    private static final int DATA_SERVICE_REMOVE_DATA_SERVICE_PROVIDER = 2;
    private static final int DATA_SERVICE_REMOVE_ALL_DATA_SERVICE_PROVIDERS = 3;
    private static final int DATA_SERVICE_REQUEST_SETUP_DATA_CALL = 4;
    private static final int DATA_SERVICE_REQUEST_DEACTIVATE_DATA_CALL = 5;
    private static final int DATA_SERVICE_REQUEST_SET_INITIAL_ATTACH_APN = 6;
    private static final int DATA_SERVICE_REQUEST_SET_DATA_PROFILE = 7;
    private static final int DATA_SERVICE_REQUEST_REQUEST_DATA_CALL_LIST = 8;
    private static final int DATA_SERVICE_REQUEST_REGISTER_DATA_CALL_LIST_CHANGED = 9;
    private static final int DATA_SERVICE_REQUEST_UNREGISTER_DATA_CALL_LIST_CHANGED = 10;
    private static final int DATA_SERVICE_INDICATION_DATA_CALL_LIST_CHANGED = 11;
    private final HandlerThread mHandlerThread;
    private final DataServiceHandler mHandler;
    private final SparseArray<DataServiceProvider> mServiceMap = new SparseArray();
    @VisibleForTesting
    public final IDataServiceWrapper mBinder = new IDataServiceWrapper();

    public DataService() {
        this.mHandlerThread = new HandlerThread(TAG);
        this.mHandlerThread.start();
        this.mHandler = new DataServiceHandler(this.mHandlerThread.getLooper());
        this.log("Data service created");
    }

    public abstract DataServiceProvider onCreateDataServiceProvider(int var1);

    @Override
    public IBinder onBind(Intent intent) {
        if (intent == null || !SERVICE_INTERFACE.equals(intent.getAction())) {
            this.loge("Unexpected intent " + intent);
            return null;
        }
        return this.mBinder;
    }

    @Override
    public boolean onUnbind(Intent intent) {
        this.mHandler.obtainMessage(3).sendToTarget();
        return false;
    }

    @Override
    public void onDestroy() {
        this.mHandlerThread.quit();
        super.onDestroy();
    }

    private void log(String s) {
        Rlog.d(TAG, s);
    }

    private void loge(String s) {
        Rlog.e(TAG, s);
    }

    private class IDataServiceWrapper
    extends IDataService.Stub {
        private IDataServiceWrapper() {
        }

        @Override
        public void createDataServiceProvider(int slotIndex) {
            DataService.this.mHandler.obtainMessage(1, slotIndex, 0).sendToTarget();
        }

        @Override
        public void removeDataServiceProvider(int slotIndex) {
            DataService.this.mHandler.obtainMessage(2, slotIndex, 0).sendToTarget();
        }

        @Override
        public void setupDataCall(int slotIndex, int accessNetworkType, DataProfile dataProfile, boolean isRoaming, boolean allowRoaming, int reason, LinkProperties linkProperties, IDataServiceCallback callback) {
            DataService.this.mHandler.obtainMessage(4, slotIndex, 0, new SetupDataCallRequest(accessNetworkType, dataProfile, isRoaming, allowRoaming, reason, linkProperties, callback)).sendToTarget();
        }

        @Override
        public void deactivateDataCall(int slotIndex, int cid, int reason, IDataServiceCallback callback) {
            DataService.this.mHandler.obtainMessage(5, slotIndex, 0, new DeactivateDataCallRequest(cid, reason, callback)).sendToTarget();
        }

        @Override
        public void setInitialAttachApn(int slotIndex, DataProfile dataProfile, boolean isRoaming, IDataServiceCallback callback) {
            DataService.this.mHandler.obtainMessage(6, slotIndex, 0, new SetInitialAttachApnRequest(dataProfile, isRoaming, callback)).sendToTarget();
        }

        @Override
        public void setDataProfile(int slotIndex, List<DataProfile> dps, boolean isRoaming, IDataServiceCallback callback) {
            DataService.this.mHandler.obtainMessage(7, slotIndex, 0, new SetDataProfileRequest(dps, isRoaming, callback)).sendToTarget();
        }

        @Override
        public void requestDataCallList(int slotIndex, IDataServiceCallback callback) {
            if (callback == null) {
                DataService.this.loge("requestDataCallList: callback is null");
                return;
            }
            DataService.this.mHandler.obtainMessage(8, slotIndex, 0, callback).sendToTarget();
        }

        @Override
        public void registerForDataCallListChanged(int slotIndex, IDataServiceCallback callback) {
            if (callback == null) {
                DataService.this.loge("registerForDataCallListChanged: callback is null");
                return;
            }
            DataService.this.mHandler.obtainMessage(9, slotIndex, 0, callback).sendToTarget();
        }

        @Override
        public void unregisterForDataCallListChanged(int slotIndex, IDataServiceCallback callback) {
            if (callback == null) {
                DataService.this.loge("unregisterForDataCallListChanged: callback is null");
                return;
            }
            DataService.this.mHandler.obtainMessage(10, slotIndex, 0, callback).sendToTarget();
        }
    }

    private class DataServiceHandler
    extends Handler {
        DataServiceHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message message) {
            int slotIndex = message.arg1;
            DataServiceProvider serviceProvider = (DataServiceProvider)DataService.this.mServiceMap.get(slotIndex);
            switch (message.what) {
                case 1: {
                    serviceProvider = DataService.this.onCreateDataServiceProvider(message.arg1);
                    if (serviceProvider == null) break;
                    DataService.this.mServiceMap.put(slotIndex, serviceProvider);
                    break;
                }
                case 2: {
                    if (serviceProvider == null) break;
                    serviceProvider.close();
                    DataService.this.mServiceMap.remove(slotIndex);
                    break;
                }
                case 3: {
                    for (int i = 0; i < DataService.this.mServiceMap.size(); ++i) {
                        serviceProvider = (DataServiceProvider)DataService.this.mServiceMap.get(i);
                        if (serviceProvider == null) continue;
                        serviceProvider.close();
                    }
                    DataService.this.mServiceMap.clear();
                    break;
                }
                case 4: {
                    if (serviceProvider == null) break;
                    SetupDataCallRequest setupDataCallRequest = (SetupDataCallRequest)message.obj;
                    serviceProvider.setupDataCall(setupDataCallRequest.accessNetworkType, setupDataCallRequest.dataProfile, setupDataCallRequest.isRoaming, setupDataCallRequest.allowRoaming, setupDataCallRequest.reason, setupDataCallRequest.linkProperties, setupDataCallRequest.callback != null ? new DataServiceCallback(setupDataCallRequest.callback) : null);
                    break;
                }
                case 5: {
                    if (serviceProvider == null) break;
                    DeactivateDataCallRequest deactivateDataCallRequest = (DeactivateDataCallRequest)message.obj;
                    serviceProvider.deactivateDataCall(deactivateDataCallRequest.cid, deactivateDataCallRequest.reason, deactivateDataCallRequest.callback != null ? new DataServiceCallback(deactivateDataCallRequest.callback) : null);
                    break;
                }
                case 6: {
                    if (serviceProvider == null) break;
                    SetInitialAttachApnRequest setInitialAttachApnRequest = (SetInitialAttachApnRequest)message.obj;
                    serviceProvider.setInitialAttachApn(setInitialAttachApnRequest.dataProfile, setInitialAttachApnRequest.isRoaming, setInitialAttachApnRequest.callback != null ? new DataServiceCallback(setInitialAttachApnRequest.callback) : null);
                    break;
                }
                case 7: {
                    if (serviceProvider == null) break;
                    SetDataProfileRequest setDataProfileRequest = (SetDataProfileRequest)message.obj;
                    serviceProvider.setDataProfile(setDataProfileRequest.dps, setDataProfileRequest.isRoaming, setDataProfileRequest.callback != null ? new DataServiceCallback(setDataProfileRequest.callback) : null);
                    break;
                }
                case 8: {
                    if (serviceProvider == null) break;
                    serviceProvider.requestDataCallList(new DataServiceCallback((IDataServiceCallback)message.obj));
                    break;
                }
                case 9: {
                    if (serviceProvider == null) break;
                    serviceProvider.registerForDataCallListChanged((IDataServiceCallback)message.obj);
                    break;
                }
                case 10: {
                    if (serviceProvider == null) break;
                    IDataServiceCallback callback = (IDataServiceCallback)message.obj;
                    serviceProvider.unregisterForDataCallListChanged(callback);
                    break;
                }
                case 11: {
                    if (serviceProvider == null) break;
                    DataCallListChangedIndication indication = (DataCallListChangedIndication)message.obj;
                    try {
                        indication.callback.onDataCallListChanged(indication.dataCallList);
                        break;
                    }
                    catch (RemoteException e) {
                        DataService.this.loge("Failed to call onDataCallListChanged. " + e);
                    }
                }
            }
        }
    }

    private static final class DataCallListChangedIndication {
        public final List<DataCallResponse> dataCallList;
        public final IDataServiceCallback callback;

        DataCallListChangedIndication(List<DataCallResponse> dataCallList, IDataServiceCallback callback) {
            this.dataCallList = dataCallList;
            this.callback = callback;
        }
    }

    private static final class SetDataProfileRequest {
        public final List<DataProfile> dps;
        public final boolean isRoaming;
        public final IDataServiceCallback callback;

        SetDataProfileRequest(List<DataProfile> dps, boolean isRoaming, IDataServiceCallback callback) {
            this.dps = dps;
            this.isRoaming = isRoaming;
            this.callback = callback;
        }
    }

    private static final class SetInitialAttachApnRequest {
        public final DataProfile dataProfile;
        public final boolean isRoaming;
        public final IDataServiceCallback callback;

        SetInitialAttachApnRequest(DataProfile dataProfile, boolean isRoaming, IDataServiceCallback callback) {
            this.dataProfile = dataProfile;
            this.isRoaming = isRoaming;
            this.callback = callback;
        }
    }

    private static final class DeactivateDataCallRequest {
        public final int cid;
        public final int reason;
        public final IDataServiceCallback callback;

        DeactivateDataCallRequest(int cid, int reason, IDataServiceCallback callback) {
            this.cid = cid;
            this.reason = reason;
            this.callback = callback;
        }
    }

    private static final class SetupDataCallRequest {
        public final int accessNetworkType;
        public final DataProfile dataProfile;
        public final boolean isRoaming;
        public final boolean allowRoaming;
        public final int reason;
        public final LinkProperties linkProperties;
        public final IDataServiceCallback callback;

        SetupDataCallRequest(int accessNetworkType, DataProfile dataProfile, boolean isRoaming, boolean allowRoaming, int reason, LinkProperties linkProperties, IDataServiceCallback callback) {
            this.accessNetworkType = accessNetworkType;
            this.dataProfile = dataProfile;
            this.isRoaming = isRoaming;
            this.allowRoaming = allowRoaming;
            this.linkProperties = linkProperties;
            this.reason = reason;
            this.callback = callback;
        }
    }

    public abstract class DataServiceProvider
    implements AutoCloseable {
        private final int mSlotIndex;
        private final List<IDataServiceCallback> mDataCallListChangedCallbacks = new ArrayList<IDataServiceCallback>();

        public DataServiceProvider(int slotIndex) {
            this.mSlotIndex = slotIndex;
        }

        public final int getSlotIndex() {
            return this.mSlotIndex;
        }

        public void setupDataCall(int accessNetworkType, DataProfile dataProfile, boolean isRoaming, boolean allowRoaming, int reason, LinkProperties linkProperties, DataServiceCallback callback) {
            if (callback != null) {
                callback.onSetupDataCallComplete(1, null);
            }
        }

        public void deactivateDataCall(int cid, int reason, DataServiceCallback callback) {
            if (callback != null) {
                callback.onDeactivateDataCallComplete(1);
            }
        }

        public void setInitialAttachApn(DataProfile dataProfile, boolean isRoaming, DataServiceCallback callback) {
            if (callback != null) {
                callback.onSetInitialAttachApnComplete(1);
            }
        }

        public void setDataProfile(List<DataProfile> dps, boolean isRoaming, DataServiceCallback callback) {
            if (callback != null) {
                callback.onSetDataProfileComplete(1);
            }
        }

        public void requestDataCallList(DataServiceCallback callback) {
            callback.onRequestDataCallListComplete(1, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerForDataCallListChanged(IDataServiceCallback callback) {
            List<IDataServiceCallback> list = this.mDataCallListChangedCallbacks;
            synchronized (list) {
                this.mDataCallListChangedCallbacks.add(callback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregisterForDataCallListChanged(IDataServiceCallback callback) {
            List<IDataServiceCallback> list = this.mDataCallListChangedCallbacks;
            synchronized (list) {
                this.mDataCallListChangedCallbacks.remove(callback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void notifyDataCallListChanged(List<DataCallResponse> dataCallList) {
            List<IDataServiceCallback> list = this.mDataCallListChangedCallbacks;
            synchronized (list) {
                for (IDataServiceCallback callback : this.mDataCallListChangedCallbacks) {
                    DataService.this.mHandler.obtainMessage(11, this.mSlotIndex, 0, new DataCallListChangedIndication(dataCallList, callback)).sendToTarget();
                }
            }
        }

        @Override
        public abstract void close();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeactivateDataReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetupDataReason {
    }
}

