/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.data;

import android.annotation.SystemApi;
import android.app.Service;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.telephony.Rlog;
import android.telephony.data.IQualifiedNetworksService;
import android.telephony.data.IQualifiedNetworksServiceCallback;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import java.util.List;

@SystemApi
public abstract class QualifiedNetworksService
extends Service {
    private static final String TAG = QualifiedNetworksService.class.getSimpleName();
    public static final String QUALIFIED_NETWORKS_SERVICE_INTERFACE = "android.telephony.data.QualifiedNetworksService";
    private static final int QNS_CREATE_NETWORK_AVAILABILITY_PROVIDER = 1;
    private static final int QNS_REMOVE_NETWORK_AVAILABILITY_PROVIDER = 2;
    private static final int QNS_REMOVE_ALL_NETWORK_AVAILABILITY_PROVIDERS = 3;
    private static final int QNS_UPDATE_QUALIFIED_NETWORKS = 4;
    private final HandlerThread mHandlerThread;
    private final QualifiedNetworksServiceHandler mHandler;
    private final SparseArray<NetworkAvailabilityProvider> mProviders = new SparseArray();
    @VisibleForTesting
    public final IQualifiedNetworksServiceWrapper mBinder = new IQualifiedNetworksServiceWrapper();

    public QualifiedNetworksService() {
        this.mHandlerThread = new HandlerThread(TAG);
        this.mHandlerThread.start();
        this.mHandler = new QualifiedNetworksServiceHandler(this.mHandlerThread.getLooper());
        this.log("Qualified networks service created");
    }

    public abstract NetworkAvailabilityProvider onCreateNetworkAvailabilityProvider(int var1);

    @Override
    public IBinder onBind(Intent intent) {
        if (intent == null || !QUALIFIED_NETWORKS_SERVICE_INTERFACE.equals(intent.getAction())) {
            this.loge("Unexpected intent " + intent);
            return null;
        }
        return this.mBinder;
    }

    @Override
    public boolean onUnbind(Intent intent) {
        this.mHandler.obtainMessage(3).sendToTarget();
        return false;
    }

    @Override
    public void onDestroy() {
        this.mHandlerThread.quit();
    }

    private void log(String s) {
        Rlog.d(TAG, s);
    }

    private void loge(String s) {
        Rlog.e(TAG, s);
    }

    private class IQualifiedNetworksServiceWrapper
    extends IQualifiedNetworksService.Stub {
        private IQualifiedNetworksServiceWrapper() {
        }

        @Override
        public void createNetworkAvailabilityProvider(int slotIndex, IQualifiedNetworksServiceCallback callback) {
            QualifiedNetworksService.this.mHandler.obtainMessage(1, slotIndex, 0, callback).sendToTarget();
        }

        @Override
        public void removeNetworkAvailabilityProvider(int slotIndex) {
            QualifiedNetworksService.this.mHandler.obtainMessage(2, slotIndex, 0).sendToTarget();
        }
    }

    private class QualifiedNetworksServiceHandler
    extends Handler {
        QualifiedNetworksServiceHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message message) {
            int slotIndex = message.arg1;
            NetworkAvailabilityProvider provider = (NetworkAvailabilityProvider)QualifiedNetworksService.this.mProviders.get(slotIndex);
            switch (message.what) {
                case 1: {
                    if (QualifiedNetworksService.this.mProviders.get(slotIndex) != null) {
                        QualifiedNetworksService.this.loge("Network availability provider for slot " + slotIndex + " already existed.");
                        return;
                    }
                    provider = QualifiedNetworksService.this.onCreateNetworkAvailabilityProvider(slotIndex);
                    if (provider != null) {
                        QualifiedNetworksService.this.mProviders.put(slotIndex, provider);
                        IQualifiedNetworksServiceCallback callback = (IQualifiedNetworksServiceCallback)message.obj;
                        provider.registerForQualifiedNetworkTypesChanged(callback);
                        break;
                    }
                    QualifiedNetworksService.this.loge("Failed to create network availability provider. slot index = " + slotIndex);
                    break;
                }
                case 2: {
                    if (provider == null) break;
                    provider.close();
                    QualifiedNetworksService.this.mProviders.remove(slotIndex);
                    break;
                }
                case 3: {
                    for (int i = 0; i < QualifiedNetworksService.this.mProviders.size(); ++i) {
                        provider = (NetworkAvailabilityProvider)QualifiedNetworksService.this.mProviders.get(i);
                        if (provider == null) continue;
                        provider.close();
                    }
                    QualifiedNetworksService.this.mProviders.clear();
                    break;
                }
                case 4: {
                    if (provider == null) break;
                    provider.onUpdateQualifiedNetworkTypes(message.arg2, (int[])message.obj);
                }
            }
        }
    }

    public abstract class NetworkAvailabilityProvider
    implements AutoCloseable {
        private final int mSlotIndex;
        private IQualifiedNetworksServiceCallback mCallback;
        private SparseArray<int[]> mQualifiedNetworkTypesList = new SparseArray();

        public NetworkAvailabilityProvider(int slotIndex) {
            this.mSlotIndex = slotIndex;
        }

        public final int getSlotIndex() {
            return this.mSlotIndex;
        }

        private void registerForQualifiedNetworkTypesChanged(IQualifiedNetworksServiceCallback callback) {
            this.mCallback = callback;
            if (this.mCallback != null) {
                for (int i = 0; i < this.mQualifiedNetworkTypesList.size(); ++i) {
                    try {
                        this.mCallback.onQualifiedNetworkTypesChanged(this.mQualifiedNetworkTypesList.keyAt(i), this.mQualifiedNetworkTypesList.valueAt(i));
                        continue;
                    }
                    catch (RemoteException e) {
                        QualifiedNetworksService.this.loge("Failed to call onQualifiedNetworksChanged. " + e);
                    }
                }
            }
        }

        public final void updateQualifiedNetworkTypes(int apnTypes, List<Integer> qualifiedNetworkTypes) {
            int[] qualifiedNetworkTypesArray = qualifiedNetworkTypes.stream().mapToInt(i -> i).toArray();
            QualifiedNetworksService.this.mHandler.obtainMessage(4, this.mSlotIndex, apnTypes, qualifiedNetworkTypesArray).sendToTarget();
        }

        private void onUpdateQualifiedNetworkTypes(int apnTypes, int[] qualifiedNetworkTypes) {
            this.mQualifiedNetworkTypesList.put(apnTypes, qualifiedNetworkTypes);
            if (this.mCallback != null) {
                try {
                    this.mCallback.onQualifiedNetworkTypesChanged(apnTypes, qualifiedNetworkTypes);
                }
                catch (RemoteException e) {
                    QualifiedNetworksService.this.loge("Failed to call onQualifiedNetworksChanged. " + e);
                }
            }
        }

        @Override
        public abstract void close();
    }
}

