/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.SystemApi;
import android.content.pm.IPackageManager;
import android.net.Uri;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.SubscriptionManager;
import android.telephony.ims.ImsException;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.aidl.IImsCapabilityCallback;
import android.telephony.ims.aidl.IImsRegistrationCallback;
import android.telephony.ims.feature.MmTelFeature;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.ITelephony;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

@SystemApi
public class ImsMmTelManager {
    private static final String TAG = "ImsMmTelManager";
    public static final int WIFI_MODE_WIFI_ONLY = 0;
    public static final int WIFI_MODE_CELLULAR_PREFERRED = 1;
    public static final int WIFI_MODE_WIFI_PREFERRED = 2;
    private int mSubId;

    public static ImsMmTelManager createForSubscriptionId(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            throw new IllegalArgumentException("Invalid subscription ID");
        }
        return new ImsMmTelManager(subId);
    }

    @VisibleForTesting
    public ImsMmTelManager(int subId) {
        this.mSubId = subId;
    }

    public void registerImsRegistrationCallback(Executor executor, RegistrationCallback c) throws ImsException {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null RegistrationCallback.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        if (!ImsMmTelManager.isImsAvailableOnDevice()) {
            throw new ImsException("IMS not available on device.", 2);
        }
        c.setExecutor(executor);
        try {
            ImsMmTelManager.getITelephony().registerImsRegistrationCallback(this.mSubId, c.getBinder());
        }
        catch (RemoteException | IllegalStateException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    public void unregisterImsRegistrationCallback(RegistrationCallback c) {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null RegistrationCallback.");
        }
        try {
            ImsMmTelManager.getITelephony().unregisterImsRegistrationCallback(this.mSubId, c.getBinder());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public void registerMmTelCapabilityCallback(Executor executor, CapabilityCallback c) throws ImsException {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null RegistrationCallback.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must include a non-null Executor.");
        }
        if (!ImsMmTelManager.isImsAvailableOnDevice()) {
            throw new ImsException("IMS not available on device.", 2);
        }
        c.setExecutor(executor);
        try {
            ImsMmTelManager.getITelephony().registerMmTelCapabilityCallback(this.mSubId, c.getBinder());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
        catch (IllegalStateException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    public void unregisterMmTelCapabilityCallback(CapabilityCallback c) {
        if (c == null) {
            throw new IllegalArgumentException("Must include a non-null RegistrationCallback.");
        }
        try {
            ImsMmTelManager.getITelephony().unregisterMmTelCapabilityCallback(this.mSubId, c.getBinder());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public boolean isAdvancedCallingSettingEnabled() {
        try {
            return ImsMmTelManager.getITelephony().isAdvancedCallingSettingEnabled(this.mSubId);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public void setAdvancedCallingSettingEnabled(boolean isEnabled) {
        try {
            ImsMmTelManager.getITelephony().setAdvancedCallingSettingEnabled(this.mSubId, isEnabled);
            return;
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public boolean isCapable(int capability, int imsRegTech) {
        try {
            return ImsMmTelManager.getITelephony().isCapable(this.mSubId, capability, imsRegTech);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public boolean isAvailable(int capability, int imsRegTech) {
        try {
            return ImsMmTelManager.getITelephony().isAvailable(this.mSubId, capability, imsRegTech);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public boolean isVtSettingEnabled() {
        try {
            return ImsMmTelManager.getITelephony().isVtSettingEnabled(this.mSubId);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public void setVtSettingEnabled(boolean isEnabled) {
        try {
            ImsMmTelManager.getITelephony().setVtSettingEnabled(this.mSubId, isEnabled);
            return;
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public boolean isVoWiFiSettingEnabled() {
        try {
            return ImsMmTelManager.getITelephony().isVoWiFiSettingEnabled(this.mSubId);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public void setVoWiFiSettingEnabled(boolean isEnabled) {
        try {
            ImsMmTelManager.getITelephony().setVoWiFiSettingEnabled(this.mSubId, isEnabled);
            return;
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public boolean isVoWiFiRoamingSettingEnabled() {
        try {
            return ImsMmTelManager.getITelephony().isVoWiFiRoamingSettingEnabled(this.mSubId);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public void setVoWiFiRoamingSettingEnabled(boolean isEnabled) {
        try {
            ImsMmTelManager.getITelephony().setVoWiFiRoamingSettingEnabled(this.mSubId, isEnabled);
            return;
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public void setVoWiFiNonPersistent(boolean isCapable, int mode) {
        try {
            ImsMmTelManager.getITelephony().setVoWiFiNonPersistent(this.mSubId, isCapable, mode);
            return;
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public int getVoWiFiModeSetting() {
        try {
            return ImsMmTelManager.getITelephony().getVoWiFiModeSetting(this.mSubId);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public void setVoWiFiModeSetting(int mode) {
        try {
            ImsMmTelManager.getITelephony().setVoWiFiModeSetting(this.mSubId, mode);
            return;
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public int getVoWiFiRoamingModeSetting() {
        try {
            return ImsMmTelManager.getITelephony().getVoWiFiRoamingModeSetting(this.mSubId);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public void setVoWiFiRoamingModeSetting(int mode) {
        try {
            ImsMmTelManager.getITelephony().setVoWiFiRoamingModeSetting(this.mSubId, mode);
            return;
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public void setRttCapabilitySetting(boolean isEnabled) {
        try {
            ImsMmTelManager.getITelephony().setRttCapabilitySetting(this.mSubId, isEnabled);
            return;
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    boolean isTtyOverVolteEnabled() {
        try {
            return ImsMmTelManager.getITelephony().isTtyOverVolteEnabled(this.mSubId);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    private static boolean isImsAvailableOnDevice() {
        IPackageManager pm = IPackageManager.Stub.asInterface(ServiceManager.getService("package"));
        if (pm == null) {
            return true;
        }
        try {
            return pm.hasSystemFeature("android.hardware.telephony.ims", 0);
        }
        catch (RemoteException remoteException) {
            return true;
        }
    }

    private static ITelephony getITelephony() {
        ITelephony binder = ITelephony.Stub.asInterface(ServiceManager.getService("phone"));
        if (binder == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        return binder;
    }

    public static class CapabilityCallback {
        private final CapabilityBinder mBinder = new CapabilityBinder(this);

        public void onCapabilitiesStatusChanged(MmTelFeature.MmTelCapabilities capabilities) {
        }

        public final IImsCapabilityCallback getBinder() {
            return this.mBinder;
        }

        public final void setExecutor(Executor executor) {
            this.mBinder.setExecutor(executor);
        }

        private static class CapabilityBinder
        extends IImsCapabilityCallback.Stub {
            private final CapabilityCallback mLocalCallback;
            private Executor mExecutor;

            CapabilityBinder(CapabilityCallback c) {
                this.mLocalCallback = c;
            }

            @Override
            public void onCapabilitiesStatusChanged(int config) {
                if (this.mLocalCallback == null) {
                    return;
                }
                Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> this.mLocalCallback.onCapabilitiesStatusChanged(new MmTelFeature.MmTelCapabilities(config))));
            }

            @Override
            public void onQueryCapabilityConfiguration(int capability, int radioTech, boolean isEnabled) {
            }

            @Override
            public void onChangeCapabilityConfigurationError(int capability, int radioTech, int reason) {
            }

            private void setExecutor(Executor executor) {
                this.mExecutor = executor;
            }
        }
    }

    public static class RegistrationCallback {
        private final RegistrationBinder mBinder = new RegistrationBinder(this);

        public void onRegistered(int imsTransportType) {
        }

        public void onRegistering(int imsTransportType) {
        }

        public void onUnregistered(ImsReasonInfo info) {
        }

        public void onTechnologyChangeFailed(int imsTransportType, ImsReasonInfo info) {
        }

        public void onSubscriberAssociatedUriChanged(Uri[] uris) {
        }

        public final IImsRegistrationCallback getBinder() {
            return this.mBinder;
        }

        public void setExecutor(Executor executor) {
            this.mBinder.setExecutor(executor);
        }

        private static class RegistrationBinder
        extends IImsRegistrationCallback.Stub {
            private static final Map<Integer, Integer> IMS_REG_TO_ACCESS_TYPE_MAP = new HashMap<Integer, Integer>(){
                {
                    this.put(-1, -1);
                    this.put(0, 1);
                    this.put(1, 2);
                }
            };
            private final RegistrationCallback mLocalCallback;
            private Executor mExecutor;

            RegistrationBinder(RegistrationCallback localCallback) {
                this.mLocalCallback = localCallback;
            }

            @Override
            public void onRegistered(int imsRadioTech) {
                if (this.mLocalCallback == null) {
                    return;
                }
                Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> this.mLocalCallback.onRegistered(RegistrationBinder.getAccessType(imsRadioTech))));
            }

            @Override
            public void onRegistering(int imsRadioTech) {
                if (this.mLocalCallback == null) {
                    return;
                }
                Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> this.mLocalCallback.onRegistering(RegistrationBinder.getAccessType(imsRadioTech))));
            }

            @Override
            public void onDeregistered(ImsReasonInfo info) {
                if (this.mLocalCallback == null) {
                    return;
                }
                Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> this.mLocalCallback.onUnregistered(info)));
            }

            @Override
            public void onTechnologyChangeFailed(int imsRadioTech, ImsReasonInfo info) {
                if (this.mLocalCallback == null) {
                    return;
                }
                Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> this.mLocalCallback.onTechnologyChangeFailed(RegistrationBinder.getAccessType(imsRadioTech), info)));
            }

            @Override
            public void onSubscriberAssociatedUriChanged(Uri[] uris) {
                if (this.mLocalCallback == null) {
                    return;
                }
                Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> this.mLocalCallback.onSubscriberAssociatedUriChanged(uris)));
            }

            private void setExecutor(Executor executor) {
                this.mExecutor = executor;
            }

            private static int getAccessType(int regType) {
                if (!IMS_REG_TO_ACCESS_TYPE_MAP.containsKey(regType)) {
                    Log.w(ImsMmTelManager.TAG, "RegistrationBinder - invalid regType returned: " + regType);
                    return -1;
                }
                return IMS_REG_TO_ACCESS_TYPE_MAP.get(regType);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WiFiCallingMode {
    }
}

