/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.SystemApi;
import android.os.Bundle;
import android.os.RemoteException;
import android.telephony.ims.ImsCallForwardInfo;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.ImsSsData;
import android.telephony.ims.ImsSsInfo;
import android.util.Log;
import com.android.ims.internal.IImsUtListener;

@SystemApi
public class ImsUtListener {
    private IImsUtListener mServiceInterface;
    private static final String LOG_TAG = "ImsUtListener";

    public void onUtConfigurationUpdated(int id2) {
        try {
            this.mServiceInterface.utConfigurationUpdated(null, id2);
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "utConfigurationUpdated: remote exception");
        }
    }

    public void onUtConfigurationUpdateFailed(int id2, ImsReasonInfo error) {
        try {
            this.mServiceInterface.utConfigurationUpdateFailed(null, id2, error);
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "utConfigurationUpdateFailed: remote exception");
        }
    }

    public void onUtConfigurationQueried(int id2, Bundle ssInfo) {
        try {
            this.mServiceInterface.utConfigurationQueried(null, id2, ssInfo);
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "utConfigurationQueried: remote exception");
        }
    }

    public void onUtConfigurationQueryFailed(int id2, ImsReasonInfo error) {
        try {
            this.mServiceInterface.utConfigurationQueryFailed(null, id2, error);
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "utConfigurationQueryFailed: remote exception");
        }
    }

    public void onUtConfigurationCallBarringQueried(int id2, ImsSsInfo[] cbInfo) {
        try {
            this.mServiceInterface.utConfigurationCallBarringQueried(null, id2, cbInfo);
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "utConfigurationCallBarringQueried: remote exception");
        }
    }

    public void onUtConfigurationCallForwardQueried(int id2, ImsCallForwardInfo[] cfInfo) {
        try {
            this.mServiceInterface.utConfigurationCallForwardQueried(null, id2, cfInfo);
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "utConfigurationCallForwardQueried: remote exception");
        }
    }

    public void onUtConfigurationCallWaitingQueried(int id2, ImsSsInfo[] cwInfo) {
        try {
            this.mServiceInterface.utConfigurationCallWaitingQueried(null, id2, cwInfo);
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "utConfigurationCallWaitingQueried: remote exception");
        }
    }

    public void onSupplementaryServiceIndication(ImsSsData ssData) {
        try {
            this.mServiceInterface.onSupplementaryServiceIndication(ssData);
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "onSupplementaryServiceIndication: remote exception");
        }
    }

    public ImsUtListener(IImsUtListener serviceInterface) {
        this.mServiceInterface = serviceInterface;
    }
}

