/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.SystemApi;
import android.content.pm.IPackageManager;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.SubscriptionManager;
import android.telephony.ims.ImsException;
import android.telephony.ims.aidl.IImsConfigCallback;
import com.android.internal.telephony.ITelephony;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

@SystemApi
public class ProvisioningManager {
    public static final String STRING_QUERY_RESULT_ERROR_GENERIC = "STRING_QUERY_RESULT_ERROR_GENERIC";
    public static final String STRING_QUERY_RESULT_ERROR_NOT_READY = "STRING_QUERY_RESULT_ERROR_NOT_READY";
    public static final int PROVISIONING_VALUE_DISABLED = 0;
    public static final int PROVISIONING_VALUE_ENABLED = 1;
    public static final int KEY_VOICE_OVER_WIFI_ROAMING_ENABLED_OVERRIDE = 26;
    public static final int KEY_VOICE_OVER_WIFI_MODE_OVERRIDE = 27;
    private int mSubId;

    public static ProvisioningManager createForSubscriptionId(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            throw new IllegalArgumentException("Invalid subscription ID");
        }
        return new ProvisioningManager(subId);
    }

    private ProvisioningManager(int subId) {
        this.mSubId = subId;
    }

    public void registerProvisioningChangedCallback(Executor executor, Callback callback) throws ImsException {
        if (!ProvisioningManager.isImsAvailableOnDevice()) {
            throw new ImsException("IMS not available on device.", 2);
        }
        callback.setExecutor(executor);
        try {
            ProvisioningManager.getITelephony().registerImsProvisioningChangedCallback(this.mSubId, callback.getBinder());
        }
        catch (RemoteException | IllegalStateException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    public void unregisterProvisioningChangedCallback(Callback callback) {
        try {
            ProvisioningManager.getITelephony().unregisterImsProvisioningChangedCallback(this.mSubId, callback.getBinder());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public int getProvisioningIntValue(int key) {
        try {
            return ProvisioningManager.getITelephony().getImsProvisioningInt(this.mSubId, key);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public String getProvisioningStringValue(int key) {
        try {
            return ProvisioningManager.getITelephony().getImsProvisioningString(this.mSubId, key);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public int setProvisioningIntValue(int key, int value) {
        try {
            return ProvisioningManager.getITelephony().setImsProvisioningInt(this.mSubId, key, value);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public int setProvisioningStringValue(int key, String value) {
        try {
            return ProvisioningManager.getITelephony().setImsProvisioningString(this.mSubId, key, value);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public void setProvisioningStatusForCapability(int capability, int tech, boolean isProvisioned) {
        try {
            ProvisioningManager.getITelephony().setImsProvisioningStatusForCapability(this.mSubId, capability, tech, isProvisioned);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public boolean getProvisioningStatusForCapability(int capability, int tech) {
        try {
            return ProvisioningManager.getITelephony().getImsProvisioningStatusForCapability(this.mSubId, capability, tech);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    private static boolean isImsAvailableOnDevice() {
        IPackageManager pm = IPackageManager.Stub.asInterface(ServiceManager.getService("package"));
        if (pm == null) {
            return true;
        }
        try {
            return pm.hasSystemFeature("android.hardware.telephony.ims", 0);
        }
        catch (RemoteException remoteException) {
            return true;
        }
    }

    private static ITelephony getITelephony() {
        ITelephony binder = ITelephony.Stub.asInterface(ServiceManager.getService("phone"));
        if (binder == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        return binder;
    }

    public static class Callback {
        private final CallbackBinder mBinder = new CallbackBinder(this);

        public void onProvisioningIntChanged(int item, int value) {
        }

        public void onProvisioningStringChanged(int item, String value) {
        }

        public final IImsConfigCallback getBinder() {
            return this.mBinder;
        }

        public void setExecutor(Executor executor) {
            this.mBinder.setExecutor(executor);
        }

        private static class CallbackBinder
        extends IImsConfigCallback.Stub {
            private final Callback mLocalConfigurationCallback;
            private Executor mExecutor;

            private CallbackBinder(Callback localConfigurationCallback) {
                this.mLocalConfigurationCallback = localConfigurationCallback;
            }

            @Override
            public final void onIntConfigChanged(int item, int value) {
                Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> this.mLocalConfigurationCallback.onProvisioningIntChanged(item, value)));
            }

            @Override
            public final void onStringConfigChanged(int item, String value) {
                Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> this.mLocalConfigurationCallback.onProvisioningStringChanged(item, value)));
            }

            private void setExecutor(Executor executor) {
                this.mExecutor = executor;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StringResultError {
    }
}

