/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.ims.RcsControllerCall;
import android.telephony.ims.RcsEvent;
import android.telephony.ims.RcsEventDescriptor;
import android.telephony.ims.RcsEventQueryResult;
import android.telephony.ims.RcsQueryContinuationToken;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class RcsEventQueryResultDescriptor
implements Parcelable {
    private final RcsQueryContinuationToken mContinuationToken;
    private final List<RcsEventDescriptor> mEvents;
    public static final Parcelable.Creator<RcsEventQueryResultDescriptor> CREATOR = new Parcelable.Creator<RcsEventQueryResultDescriptor>(){

        @Override
        public RcsEventQueryResultDescriptor createFromParcel(Parcel in) {
            return new RcsEventQueryResultDescriptor(in);
        }

        public RcsEventQueryResultDescriptor[] newArray(int size) {
            return new RcsEventQueryResultDescriptor[size];
        }
    };

    public RcsEventQueryResultDescriptor(RcsQueryContinuationToken continuationToken, List<RcsEventDescriptor> events) {
        this.mContinuationToken = continuationToken;
        this.mEvents = events;
    }

    protected RcsEventQueryResult getRcsEventQueryResult(RcsControllerCall rcsControllerCall) {
        List<RcsEvent> rcsEvents = this.mEvents.stream().map(rcsEvent -> rcsEvent.createRcsEvent(rcsControllerCall)).collect(Collectors.toList());
        return new RcsEventQueryResult(this.mContinuationToken, rcsEvents);
    }

    protected RcsEventQueryResultDescriptor(Parcel in) {
        this.mContinuationToken = (RcsQueryContinuationToken)in.readParcelable(RcsQueryContinuationToken.class.getClassLoader());
        this.mEvents = new LinkedList<RcsEventDescriptor>();
        in.readList(this.mEvents, null);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mContinuationToken, flags);
        dest.writeList(this.mEvents);
    }
}

