/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.net.Uri;
import android.telephony.ims.RcsControllerCall;
import android.telephony.ims.RcsMessageStoreException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class RcsFileTransferPart {
    public static final int NOT_SET = 0;
    public static final int DRAFT = 1;
    public static final int SENDING = 2;
    public static final int SENDING_PAUSED = 3;
    public static final int SENDING_FAILED = 4;
    public static final int SENDING_CANCELLED = 5;
    public static final int DOWNLOADING = 6;
    public static final int DOWNLOADING_PAUSED = 7;
    public static final int DOWNLOADING_FAILED = 8;
    public static final int DOWNLOADING_CANCELLED = 9;
    public static final int SUCCEEDED = 10;
    private final RcsControllerCall mRcsControllerCall;
    private int mId;

    RcsFileTransferPart(RcsControllerCall rcsControllerCall, int id2) {
        this.mRcsControllerCall = rcsControllerCall;
        this.mId = id2;
    }

    public void setId(int id2) {
        this.mId = id2;
    }

    public int getId() {
        return this.mId;
    }

    public void setFileTransferSessionId(String sessionId) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setFileTransferSessionId(this.mId, sessionId, callingPackage));
    }

    public String getFileTransferSessionId() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getFileTransferSessionId(this.mId, callingPackage));
    }

    public void setContentUri(Uri contentUri) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setFileTransferContentUri(this.mId, contentUri, callingPackage));
    }

    public Uri getContentUri() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getFileTransferContentUri(this.mId, callingPackage));
    }

    public void setContentMimeType(String contentMimeType) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setFileTransferContentType(this.mId, contentMimeType, callingPackage));
    }

    public String getContentMimeType() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getFileTransferContentType(this.mId, callingPackage));
    }

    public void setFileSize(long contentLength) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setFileTransferFileSize(this.mId, contentLength, callingPackage));
    }

    public long getFileSize() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getFileTransferFileSize(this.mId, callingPackage));
    }

    public void setTransferOffset(long transferOffset) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setFileTransferTransferOffset(this.mId, transferOffset, callingPackage));
    }

    public long getTransferOffset() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getFileTransferTransferOffset(this.mId, callingPackage));
    }

    public void setFileTransferStatus(int status) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setFileTransferStatus(this.mId, status, callingPackage));
    }

    public int getFileTransferStatus() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getFileTransferStatus(this.mId, callingPackage));
    }

    public int getWidth() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getFileTransferWidth(this.mId, callingPackage));
    }

    public void setWidth(int width) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setFileTransferWidth(this.mId, width, callingPackage));
    }

    public int getHeight() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getFileTransferHeight(this.mId, callingPackage));
    }

    public void setHeight(int height) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setFileTransferHeight(this.mId, height, callingPackage));
    }

    public long getLength() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getFileTransferLength(this.mId, callingPackage));
    }

    public void setLength(long length) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setFileTransferLength(this.mId, length, callingPackage));
    }

    public Uri getPreviewUri() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getFileTransferPreviewUri(this.mId, callingPackage));
    }

    public void setPreviewUri(Uri previewUri) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setFileTransferPreviewUri(this.mId, previewUri, callingPackage));
    }

    public String getPreviewMimeType() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getFileTransferPreviewType(this.mId, callingPackage));
    }

    public void setPreviewMimeType(String previewMimeType) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setFileTransferPreviewType(this.mId, previewMimeType, callingPackage));
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RcsFileTransferStatus {
    }
}

