/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.telephony.ims.RcsControllerCall;
import android.telephony.ims.RcsMessageStoreException;

public class RcsParticipant {
    private final RcsControllerCall mRcsControllerCall;
    private final int mId;

    public RcsParticipant(RcsControllerCall rcsControllerCall, int id2) {
        this.mRcsControllerCall = rcsControllerCall;
        this.mId = id2;
    }

    public String getCanonicalAddress() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getRcsParticipantCanonicalAddress(this.mId, callingPackage));
    }

    public String getAlias() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getRcsParticipantAlias(this.mId, callingPackage));
    }

    public void setAlias(String alias) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setRcsParticipantAlias(this.mId, alias, callingPackage));
    }

    public String getContactId() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getRcsParticipantContactId(this.mId, callingPackage));
    }

    public void setContactId(String contactId) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setRcsParticipantContactId(this.mId, contactId, callingPackage));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RcsParticipant)) {
            return false;
        }
        RcsParticipant other = (RcsParticipant)obj;
        return this.mId == other.mId;
    }

    public int hashCode() {
        return this.mId;
    }

    public int getId() {
        return this.mId;
    }
}

