/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.aidl;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Message;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.ims.ImsCallProfile;
import android.telephony.ims.aidl.IImsCapabilityCallback;
import android.telephony.ims.aidl.IImsMmTelListener;
import android.telephony.ims.aidl.IImsSmsListener;
import android.telephony.ims.feature.CapabilityChangeRequest;
import com.android.ims.internal.IImsCallSession;
import com.android.ims.internal.IImsEcbm;
import com.android.ims.internal.IImsMultiEndpoint;
import com.android.ims.internal.IImsUt;

public interface IImsMmTelFeature
extends IInterface {
    public void setListener(IImsMmTelListener var1) throws RemoteException;

    public int getFeatureState() throws RemoteException;

    public ImsCallProfile createCallProfile(int var1, int var2) throws RemoteException;

    public IImsCallSession createCallSession(ImsCallProfile var1) throws RemoteException;

    public int shouldProcessCall(String[] var1) throws RemoteException;

    public IImsUt getUtInterface() throws RemoteException;

    public IImsEcbm getEcbmInterface() throws RemoteException;

    public void setUiTtyMode(int var1, Message var2) throws RemoteException;

    public IImsMultiEndpoint getMultiEndpointInterface() throws RemoteException;

    public int queryCapabilityStatus() throws RemoteException;

    public void addCapabilityCallback(IImsCapabilityCallback var1) throws RemoteException;

    public void removeCapabilityCallback(IImsCapabilityCallback var1) throws RemoteException;

    public void changeCapabilitiesConfiguration(CapabilityChangeRequest var1, IImsCapabilityCallback var2) throws RemoteException;

    public void queryCapabilityConfiguration(int var1, int var2, IImsCapabilityCallback var3) throws RemoteException;

    public void setSmsListener(IImsSmsListener var1) throws RemoteException;

    public void sendSms(int var1, int var2, String var3, String var4, boolean var5, byte[] var6) throws RemoteException;

    public void acknowledgeSms(int var1, int var2, int var3) throws RemoteException;

    public void acknowledgeSmsReport(int var1, int var2, int var3) throws RemoteException;

    public String getSmsFormat() throws RemoteException;

    public void onSmsReady() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IImsMmTelFeature {
        private static final String DESCRIPTOR = "android.telephony.ims.aidl.IImsMmTelFeature";
        static final int TRANSACTION_setListener = 1;
        static final int TRANSACTION_getFeatureState = 2;
        static final int TRANSACTION_createCallProfile = 3;
        static final int TRANSACTION_createCallSession = 4;
        static final int TRANSACTION_shouldProcessCall = 5;
        static final int TRANSACTION_getUtInterface = 6;
        static final int TRANSACTION_getEcbmInterface = 7;
        static final int TRANSACTION_setUiTtyMode = 8;
        static final int TRANSACTION_getMultiEndpointInterface = 9;
        static final int TRANSACTION_queryCapabilityStatus = 10;
        static final int TRANSACTION_addCapabilityCallback = 11;
        static final int TRANSACTION_removeCapabilityCallback = 12;
        static final int TRANSACTION_changeCapabilitiesConfiguration = 13;
        static final int TRANSACTION_queryCapabilityConfiguration = 14;
        static final int TRANSACTION_setSmsListener = 15;
        static final int TRANSACTION_sendSms = 16;
        static final int TRANSACTION_acknowledgeSms = 17;
        static final int TRANSACTION_acknowledgeSmsReport = 18;
        static final int TRANSACTION_getSmsFormat = 19;
        static final int TRANSACTION_onSmsReady = 20;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IImsMmTelFeature asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IImsMmTelFeature) {
                return (IImsMmTelFeature)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setListener";
                }
                case 2: {
                    return "getFeatureState";
                }
                case 3: {
                    return "createCallProfile";
                }
                case 4: {
                    return "createCallSession";
                }
                case 5: {
                    return "shouldProcessCall";
                }
                case 6: {
                    return "getUtInterface";
                }
                case 7: {
                    return "getEcbmInterface";
                }
                case 8: {
                    return "setUiTtyMode";
                }
                case 9: {
                    return "getMultiEndpointInterface";
                }
                case 10: {
                    return "queryCapabilityStatus";
                }
                case 11: {
                    return "addCapabilityCallback";
                }
                case 12: {
                    return "removeCapabilityCallback";
                }
                case 13: {
                    return "changeCapabilitiesConfiguration";
                }
                case 14: {
                    return "queryCapabilityConfiguration";
                }
                case 15: {
                    return "setSmsListener";
                }
                case 16: {
                    return "sendSms";
                }
                case 17: {
                    return "acknowledgeSms";
                }
                case 18: {
                    return "acknowledgeSmsReport";
                }
                case 19: {
                    return "getSmsFormat";
                }
                case 20: {
                    return "onSmsReady";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    IImsMmTelListener _arg0 = IImsMmTelListener.Stub.asInterface(data.readStrongBinder());
                    this.setListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _result = this.getFeatureState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    ImsCallProfile _result = this.createCallProfile(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    ImsCallProfile _arg0 = 0 != data.readInt() ? ImsCallProfile.CREATOR.createFromParcel(data) : null;
                    IImsCallSession _result = this.createCallSession(_arg0);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    int _result = this.shouldProcessCall(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    IImsUt _result = this.getUtInterface();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    IImsEcbm _result = this.getEcbmInterface();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    Message _arg1 = 0 != data.readInt() ? Message.CREATOR.createFromParcel(data) : null;
                    this.setUiTtyMode(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    IImsMultiEndpoint _result = this.getMultiEndpointInterface();
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    int _result = this.queryCapabilityStatus();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    IImsCapabilityCallback _arg0 = IImsCapabilityCallback.Stub.asInterface(data.readStrongBinder());
                    this.addCapabilityCallback(_arg0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    IImsCapabilityCallback _arg0 = IImsCapabilityCallback.Stub.asInterface(data.readStrongBinder());
                    this.removeCapabilityCallback(_arg0);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    CapabilityChangeRequest _arg0 = 0 != data.readInt() ? CapabilityChangeRequest.CREATOR.createFromParcel(data) : null;
                    IImsCapabilityCallback _arg1 = IImsCapabilityCallback.Stub.asInterface(data.readStrongBinder());
                    this.changeCapabilitiesConfiguration(_arg0, _arg1);
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    IImsCapabilityCallback _arg2 = IImsCapabilityCallback.Stub.asInterface(data.readStrongBinder());
                    this.queryCapabilityConfiguration(_arg0, _arg1, _arg2);
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    IImsSmsListener _arg0 = IImsSmsListener.Stub.asInterface(data.readStrongBinder());
                    this.setSmsListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    boolean _arg4 = 0 != data.readInt();
                    byte[] _arg5 = data.createByteArray();
                    this.sendSms(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.acknowledgeSms(_arg0, _arg1, _arg2);
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.acknowledgeSmsReport(_arg0, _arg1, _arg2);
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    String _result = this.getSmsFormat();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    this.onSmsReady();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IImsMmTelFeature impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IImsMmTelFeature getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IImsMmTelFeature {
            private IBinder mRemote;
            public static IImsMmTelFeature sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setListener(IImsMmTelListener l) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(l != null ? l.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setListener(l);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getFeatureState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getFeatureState();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ImsCallProfile createCallProfile(int callSessionType, int callType) throws RemoteException {
                ImsCallProfile _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(callSessionType);
                    _data.writeInt(callType);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ImsCallProfile imsCallProfile = Stub.getDefaultImpl().createCallProfile(callSessionType, callType);
                        return imsCallProfile;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ImsCallProfile.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IImsCallSession createCallSession(ImsCallProfile profile) throws RemoteException {
                IImsCallSession _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (profile != null) {
                        _data.writeInt(1);
                        profile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IImsCallSession iImsCallSession = Stub.getDefaultImpl().createCallSession(profile);
                        return iImsCallSession;
                    }
                    _reply.readException();
                    _result = IImsCallSession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int shouldProcessCall(String[] uris) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(uris);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().shouldProcessCall(uris);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IImsUt getUtInterface() throws RemoteException {
                IImsUt _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IImsUt iImsUt = Stub.getDefaultImpl().getUtInterface();
                        return iImsUt;
                    }
                    _reply.readException();
                    _result = IImsUt.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IImsEcbm getEcbmInterface() throws RemoteException {
                IImsEcbm _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IImsEcbm iImsEcbm = Stub.getDefaultImpl().getEcbmInterface();
                        return iImsEcbm;
                    }
                    _reply.readException();
                    _result = IImsEcbm.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUiTtyMode(int uiTtyMode, Message onCompleteMessage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uiTtyMode);
                    if (onCompleteMessage != null) {
                        _data.writeInt(1);
                        onCompleteMessage.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setUiTtyMode(uiTtyMode, onCompleteMessage);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IImsMultiEndpoint getMultiEndpointInterface() throws RemoteException {
                IImsMultiEndpoint _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IImsMultiEndpoint iImsMultiEndpoint = Stub.getDefaultImpl().getMultiEndpointInterface();
                        return iImsMultiEndpoint;
                    }
                    _reply.readException();
                    _result = IImsMultiEndpoint.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int queryCapabilityStatus() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().queryCapabilityStatus();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addCapabilityCallback(IImsCapabilityCallback c) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(c != null ? c.asBinder() : null);
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addCapabilityCallback(c);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeCapabilityCallback(IImsCapabilityCallback c) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(c != null ? c.asBinder() : null);
                    boolean _status = this.mRemote.transact(12, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeCapabilityCallback(c);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void changeCapabilitiesConfiguration(CapabilityChangeRequest request, IImsCapabilityCallback c) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(c != null ? c.asBinder() : null);
                    boolean _status = this.mRemote.transact(13, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().changeCapabilitiesConfiguration(request, c);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void queryCapabilityConfiguration(int capability, int radioTech, IImsCapabilityCallback c) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(capability);
                    _data.writeInt(radioTech);
                    _data.writeStrongBinder(c != null ? c.asBinder() : null);
                    boolean _status = this.mRemote.transact(14, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().queryCapabilityConfiguration(capability, radioTech, c);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSmsListener(IImsSmsListener l) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(l != null ? l.asBinder() : null);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setSmsListener(l);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendSms(int token, int messageRef, String format, String smsc, boolean retry, byte[] pdu) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(token);
                    _data.writeInt(messageRef);
                    _data.writeString(format);
                    _data.writeString(smsc);
                    _data.writeInt(retry ? 1 : 0);
                    _data.writeByteArray(pdu);
                    boolean _status = this.mRemote.transact(16, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendSms(token, messageRef, format, smsc, retry, pdu);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acknowledgeSms(int token, int messageRef, int result) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(token);
                    _data.writeInt(messageRef);
                    _data.writeInt(result);
                    boolean _status = this.mRemote.transact(17, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().acknowledgeSms(token, messageRef, result);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acknowledgeSmsReport(int token, int messageRef, int result) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(token);
                    _data.writeInt(messageRef);
                    _data.writeInt(result);
                    boolean _status = this.mRemote.transact(18, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().acknowledgeSmsReport(token, messageRef, result);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getSmsFormat() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getSmsFormat();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public void onSmsReady() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(20, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onSmsReady();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IImsMmTelFeature {
        @Override
        public void setListener(IImsMmTelListener l) throws RemoteException {
        }

        @Override
        public int getFeatureState() throws RemoteException {
            return 0;
        }

        @Override
        public ImsCallProfile createCallProfile(int callSessionType, int callType) throws RemoteException {
            return null;
        }

        @Override
        public IImsCallSession createCallSession(ImsCallProfile profile) throws RemoteException {
            return null;
        }

        @Override
        public int shouldProcessCall(String[] uris) throws RemoteException {
            return 0;
        }

        @Override
        public IImsUt getUtInterface() throws RemoteException {
            return null;
        }

        @Override
        public IImsEcbm getEcbmInterface() throws RemoteException {
            return null;
        }

        @Override
        public void setUiTtyMode(int uiTtyMode, Message onCompleteMessage) throws RemoteException {
        }

        @Override
        public IImsMultiEndpoint getMultiEndpointInterface() throws RemoteException {
            return null;
        }

        @Override
        public int queryCapabilityStatus() throws RemoteException {
            return 0;
        }

        @Override
        public void addCapabilityCallback(IImsCapabilityCallback c) throws RemoteException {
        }

        @Override
        public void removeCapabilityCallback(IImsCapabilityCallback c) throws RemoteException {
        }

        @Override
        public void changeCapabilitiesConfiguration(CapabilityChangeRequest request, IImsCapabilityCallback c) throws RemoteException {
        }

        @Override
        public void queryCapabilityConfiguration(int capability, int radioTech, IImsCapabilityCallback c) throws RemoteException {
        }

        @Override
        public void setSmsListener(IImsSmsListener l) throws RemoteException {
        }

        @Override
        public void sendSms(int token, int messageRef, String format, String smsc, boolean retry, byte[] pdu) throws RemoteException {
        }

        @Override
        public void acknowledgeSms(int token, int messageRef, int result) throws RemoteException {
        }

        @Override
        public void acknowledgeSmsReport(int token, int messageRef, int result) throws RemoteException {
        }

        @Override
        public String getSmsFormat() throws RemoteException {
            return null;
        }

        @Override
        public void onSmsReady() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

