/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.feature;

import android.annotation.SystemApi;
import android.os.Bundle;
import android.os.Message;
import android.os.RemoteException;
import android.telephony.ims.ImsCallProfile;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.aidl.IImsCapabilityCallback;
import android.telephony.ims.aidl.IImsMmTelFeature;
import android.telephony.ims.aidl.IImsMmTelListener;
import android.telephony.ims.aidl.IImsSmsListener;
import android.telephony.ims.feature.CapabilityChangeRequest;
import android.telephony.ims.feature.ImsFeature;
import android.telephony.ims.stub.ImsCallSessionImplBase;
import android.telephony.ims.stub.ImsEcbmImplBase;
import android.telephony.ims.stub.ImsMultiEndpointImplBase;
import android.telephony.ims.stub.ImsSmsImplBase;
import android.telephony.ims.stub.ImsUtImplBase;
import android.util.Log;
import com.android.ims.internal.IImsCallSession;
import com.android.ims.internal.IImsEcbm;
import com.android.ims.internal.IImsMultiEndpoint;
import com.android.ims.internal.IImsUt;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public class MmTelFeature
extends ImsFeature {
    private static final String LOG_TAG = "MmTelFeature";
    private final IImsMmTelFeature mImsMMTelBinder = new IImsMmTelFeature.Stub(){

        @Override
        public void setListener(IImsMmTelListener l) {
            MmTelFeature.this.setListener(l);
        }

        @Override
        public int getFeatureState() throws RemoteException {
            try {
                return MmTelFeature.this.getFeatureState();
            }
            catch (Exception e) {
                throw new RemoteException(e.getMessage());
            }
        }

        @Override
        public ImsCallProfile createCallProfile(int callSessionType, int callType) throws RemoteException {
            Object object = MmTelFeature.this.mLock;
            synchronized (object) {
                try {
                    return MmTelFeature.this.createCallProfile(callSessionType, callType);
                }
                catch (Exception e) {
                    throw new RemoteException(e.getMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IImsCallSession createCallSession(ImsCallProfile profile) throws RemoteException {
            Object object = MmTelFeature.this.mLock;
            synchronized (object) {
                return MmTelFeature.this.createCallSessionInterface(profile);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int shouldProcessCall(String[] numbers) {
            Object object = MmTelFeature.this.mLock;
            synchronized (object) {
                return MmTelFeature.this.shouldProcessCall(numbers);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IImsUt getUtInterface() throws RemoteException {
            Object object = MmTelFeature.this.mLock;
            synchronized (object) {
                return MmTelFeature.this.getUtInterface();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IImsEcbm getEcbmInterface() throws RemoteException {
            Object object = MmTelFeature.this.mLock;
            synchronized (object) {
                return MmTelFeature.this.getEcbmInterface();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setUiTtyMode(int uiTtyMode, Message onCompleteMessage) throws RemoteException {
            Object object = MmTelFeature.this.mLock;
            synchronized (object) {
                try {
                    MmTelFeature.this.setUiTtyMode(uiTtyMode, onCompleteMessage);
                }
                catch (Exception e) {
                    throw new RemoteException(e.getMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IImsMultiEndpoint getMultiEndpointInterface() throws RemoteException {
            Object object = MmTelFeature.this.mLock;
            synchronized (object) {
                return MmTelFeature.this.getMultiEndpointInterface();
            }
        }

        @Override
        public int queryCapabilityStatus() {
            return MmTelFeature.this.queryCapabilityStatus().mCapabilities;
        }

        @Override
        public void addCapabilityCallback(IImsCapabilityCallback c) {
            MmTelFeature.this.addCapabilityCallback(c);
        }

        @Override
        public void removeCapabilityCallback(IImsCapabilityCallback c) {
            MmTelFeature.this.removeCapabilityCallback(c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void changeCapabilitiesConfiguration(CapabilityChangeRequest request, IImsCapabilityCallback c) {
            Object object = MmTelFeature.this.mLock;
            synchronized (object) {
                MmTelFeature.this.requestChangeEnabledCapabilities(request, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void queryCapabilityConfiguration(int capability, int radioTech, IImsCapabilityCallback c) {
            Object object = MmTelFeature.this.mLock;
            synchronized (object) {
                MmTelFeature.this.queryCapabilityConfigurationInternal(capability, radioTech, c);
            }
        }

        @Override
        public void setSmsListener(IImsSmsListener l) {
            MmTelFeature.this.setSmsListener(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendSms(int token, int messageRef, String format, String smsc, boolean retry, byte[] pdu) {
            Object object = MmTelFeature.this.mLock;
            synchronized (object) {
                MmTelFeature.this.sendSms(token, messageRef, format, smsc, retry, pdu);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void acknowledgeSms(int token, int messageRef, int result) {
            Object object = MmTelFeature.this.mLock;
            synchronized (object) {
                MmTelFeature.this.acknowledgeSms(token, messageRef, result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void acknowledgeSmsReport(int token, int messageRef, int result) {
            Object object = MmTelFeature.this.mLock;
            synchronized (object) {
                MmTelFeature.this.acknowledgeSmsReport(token, messageRef, result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getSmsFormat() {
            Object object = MmTelFeature.this.mLock;
            synchronized (object) {
                return MmTelFeature.this.getSmsFormat();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSmsReady() {
            Object object = MmTelFeature.this.mLock;
            synchronized (object) {
                MmTelFeature.this.onSmsReady();
            }
        }
    };
    public static final int PROCESS_CALL_IMS = 0;
    public static final int PROCESS_CALL_CSFB = 1;
    private IImsMmTelListener mListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setListener(IImsMmTelListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListener = listener;
            if (this.mListener != null) {
                this.onFeatureReady();
            }
        }
    }

    private void queryCapabilityConfigurationInternal(int capability, int radioTech, IImsCapabilityCallback c) {
        boolean enabled = this.queryCapabilityConfiguration(capability, radioTech);
        try {
            if (c != null) {
                c.onQueryCapabilityConfiguration(capability, radioTech, enabled);
            }
        }
        catch (RemoteException e) {
            Log.e(LOG_TAG, "queryCapabilityConfigurationInternal called on dead binder!");
        }
    }

    @Override
    public final MmTelCapabilities queryCapabilityStatus() {
        return new MmTelCapabilities(super.queryCapabilityStatus());
    }

    public final void notifyCapabilitiesStatusChanged(MmTelCapabilities c) {
        if (c == null) {
            throw new IllegalArgumentException("MmTelCapabilities must be non-null!");
        }
        super.notifyCapabilitiesStatusChanged(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyIncomingCall(ImsCallSessionImplBase c, Bundle extras) {
        if (c == null || extras == null) {
            throw new IllegalArgumentException("ImsCallSessionImplBase and Bundle can not be null.");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mListener == null) {
                throw new IllegalStateException("Session is not available.");
            }
            try {
                this.mListener.onIncomingCall(c.getServiceImpl(), extras);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyRejectedCall(ImsCallProfile callProfile, ImsReasonInfo reason) {
        if (callProfile == null || reason == null) {
            throw new IllegalArgumentException("ImsCallProfile and ImsReasonInfo must not be null.");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mListener == null) {
                throw new IllegalStateException("Session is not available.");
            }
            try {
                this.mListener.onRejectedCall(callProfile, reason);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyIncomingCallSession(IImsCallSession c, Bundle extras) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mListener == null) {
                throw new IllegalStateException("Session is not available.");
            }
            try {
                this.mListener.onIncomingCall(c, extras);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyVoiceMessageCountUpdate(int count) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mListener == null) {
                throw new IllegalStateException("Session is not available.");
            }
            try {
                this.mListener.onVoiceMessageCountUpdate(count);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean queryCapabilityConfiguration(int capability, int radioTech) {
        return false;
    }

    @Override
    public void changeEnabledCapabilities(CapabilityChangeRequest request, ImsFeature.CapabilityCallbackProxy c) {
    }

    public ImsCallProfile createCallProfile(int callSessionType, int callType) {
        return null;
    }

    public IImsCallSession createCallSessionInterface(ImsCallProfile profile) throws RemoteException {
        ImsCallSessionImplBase s = this.createCallSession(profile);
        return s != null ? s.getServiceImpl() : null;
    }

    public ImsCallSessionImplBase createCallSession(ImsCallProfile profile) {
        return null;
    }

    public int shouldProcessCall(String[] numbers) {
        return 0;
    }

    protected IImsUt getUtInterface() throws RemoteException {
        ImsUtImplBase utImpl = this.getUt();
        return utImpl != null ? utImpl.getInterface() : null;
    }

    protected IImsEcbm getEcbmInterface() throws RemoteException {
        ImsEcbmImplBase ecbmImpl = this.getEcbm();
        return ecbmImpl != null ? ecbmImpl.getImsEcbm() : null;
    }

    public IImsMultiEndpoint getMultiEndpointInterface() throws RemoteException {
        ImsMultiEndpointImplBase multiendpointImpl = this.getMultiEndpoint();
        return multiendpointImpl != null ? multiendpointImpl.getIImsMultiEndpoint() : null;
    }

    public ImsUtImplBase getUt() {
        return new ImsUtImplBase();
    }

    public ImsEcbmImplBase getEcbm() {
        return new ImsEcbmImplBase();
    }

    public ImsMultiEndpointImplBase getMultiEndpoint() {
        return new ImsMultiEndpointImplBase();
    }

    public void setUiTtyMode(int mode, Message onCompleteMessage) {
    }

    private void setSmsListener(IImsSmsListener listener) {
        this.getSmsImplementation().registerSmsListener(listener);
    }

    private void sendSms(int token, int messageRef, String format, String smsc, boolean isRetry, byte[] pdu) {
        this.getSmsImplementation().sendSms(token, messageRef, format, smsc, isRetry, pdu);
    }

    private void acknowledgeSms(int token, int messageRef, int result) {
        this.getSmsImplementation().acknowledgeSms(token, messageRef, result);
    }

    private void acknowledgeSmsReport(int token, int messageRef, int result) {
        this.getSmsImplementation().acknowledgeSmsReport(token, messageRef, result);
    }

    private void onSmsReady() {
        this.getSmsImplementation().onReady();
    }

    public ImsSmsImplBase getSmsImplementation() {
        return new ImsSmsImplBase();
    }

    private String getSmsFormat() {
        return this.getSmsImplementation().getSmsFormat();
    }

    @Override
    public void onFeatureRemoved() {
    }

    @Override
    public void onFeatureReady() {
    }

    @Override
    public final IImsMmTelFeature getBinder() {
        return this.mImsMMTelBinder;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProcessCallResult {
    }

    public static class Listener
    extends IImsMmTelListener.Stub {
        @Override
        public void onIncomingCall(IImsCallSession c, Bundle extras) {
        }

        @Override
        public void onRejectedCall(ImsCallProfile callProfile, ImsReasonInfo reason) {
        }

        @Override
        public void onVoiceMessageCountUpdate(int count) {
        }
    }

    public static class MmTelCapabilities
    extends ImsFeature.Capabilities {
        public static final int CAPABILITY_TYPE_VOICE = 1;
        public static final int CAPABILITY_TYPE_VIDEO = 2;
        public static final int CAPABILITY_TYPE_UT = 4;
        public static final int CAPABILITY_TYPE_SMS = 8;

        public MmTelCapabilities() {
        }

        @Deprecated
        public MmTelCapabilities(ImsFeature.Capabilities c) {
            this.mCapabilities = c.mCapabilities;
        }

        public MmTelCapabilities(int capabilities) {
            this.mCapabilities = capabilities;
        }

        @Override
        public final void addCapabilities(int capabilities) {
            super.addCapabilities(capabilities);
        }

        @Override
        public final void removeCapabilities(int capability) {
            super.removeCapabilities(capability);
        }

        @Override
        public final boolean isCapable(int capabilities) {
            return super.isCapable(capabilities);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder("MmTel Capabilities - [");
            builder.append("Voice: ");
            builder.append(this.isCapable(1));
            builder.append(" Video: ");
            builder.append(this.isCapable(2));
            builder.append(" UT: ");
            builder.append(this.isCapable(4));
            builder.append(" SMS: ");
            builder.append(this.isCapable(8));
            builder.append("]");
            return builder.toString();
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface MmTelCapability {
        }
    }
}

