/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.stub;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import java.util.Set;

@SystemApi
public final class ImsFeatureConfiguration
implements Parcelable {
    private final Set<FeatureSlotPair> mFeatures;
    public static final Parcelable.Creator<ImsFeatureConfiguration> CREATOR = new Parcelable.Creator<ImsFeatureConfiguration>(){

        @Override
        public ImsFeatureConfiguration createFromParcel(Parcel in) {
            return new ImsFeatureConfiguration(in);
        }

        public ImsFeatureConfiguration[] newArray(int size) {
            return new ImsFeatureConfiguration[size];
        }
    };

    public ImsFeatureConfiguration() {
        this.mFeatures = new ArraySet<FeatureSlotPair>();
    }

    public ImsFeatureConfiguration(Set<FeatureSlotPair> features) {
        this.mFeatures = new ArraySet<FeatureSlotPair>();
        if (features != null) {
            this.mFeatures.addAll(features);
        }
    }

    public Set<FeatureSlotPair> getServiceFeatures() {
        return new ArraySet<FeatureSlotPair>(this.mFeatures);
    }

    void addFeature(int slotId, int feature) {
        this.mFeatures.add(new FeatureSlotPair(slotId, feature));
    }

    protected ImsFeatureConfiguration(Parcel in) {
        int featurePairLength = in.readInt();
        this.mFeatures = new ArraySet<FeatureSlotPair>(featurePairLength);
        for (int i = 0; i < featurePairLength; ++i) {
            this.mFeatures.add(new FeatureSlotPair(in.readInt(), in.readInt()));
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        FeatureSlotPair[] featureSlotPairs = new FeatureSlotPair[this.mFeatures.size()];
        this.mFeatures.toArray(featureSlotPairs);
        dest.writeInt(featureSlotPairs.length);
        for (FeatureSlotPair featureSlotPair : featureSlotPairs) {
            dest.writeInt(featureSlotPair.slotId);
            dest.writeInt(featureSlotPair.featureType);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImsFeatureConfiguration)) {
            return false;
        }
        ImsFeatureConfiguration that = (ImsFeatureConfiguration)o;
        return this.mFeatures.equals(that.mFeatures);
    }

    public int hashCode() {
        return this.mFeatures.hashCode();
    }

    public static class Builder {
        ImsFeatureConfiguration mConfig = new ImsFeatureConfiguration();

        public Builder addFeature(int slotId, int featureType) {
            this.mConfig.addFeature(slotId, featureType);
            return this;
        }

        public ImsFeatureConfiguration build() {
            return this.mConfig;
        }
    }

    public static final class FeatureSlotPair {
        public final int slotId;
        public final int featureType;

        public FeatureSlotPair(int slotId, int featureType) {
            this.slotId = slotId;
            this.featureType = featureType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeatureSlotPair that = (FeatureSlotPair)o;
            if (this.slotId != that.slotId) {
                return false;
            }
            return this.featureType == that.featureType;
        }

        public int hashCode() {
            int result = this.slotId;
            result = 31 * result + this.featureType;
            return result;
        }

        public String toString() {
            return "{s=" + this.slotId + ", f=" + this.featureType + "}";
        }
    }
}

