/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.stub;

import android.annotation.SystemApi;
import android.net.Uri;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.aidl.IImsRegistration;
import android.telephony.ims.aidl.IImsRegistrationCallback;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public class ImsRegistrationImplBase {
    private static final String LOG_TAG = "ImsRegistrationImplBase";
    public static final int REGISTRATION_TECH_NONE = -1;
    public static final int REGISTRATION_TECH_LTE = 0;
    public static final int REGISTRATION_TECH_IWLAN = 1;
    private static final int REGISTRATION_STATE_UNKNOWN = -1;
    private static final int REGISTRATION_STATE_NOT_REGISTERED = 0;
    private static final int REGISTRATION_STATE_REGISTERING = 1;
    private static final int REGISTRATION_STATE_REGISTERED = 2;
    private final IImsRegistration mBinder = new IImsRegistration.Stub(){

        @Override
        public int getRegistrationTechnology() throws RemoteException {
            return ImsRegistrationImplBase.this.getConnectionType();
        }

        @Override
        public void addRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
            ImsRegistrationImplBase.this.addRegistrationCallback(c);
        }

        @Override
        public void removeRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
            ImsRegistrationImplBase.this.removeRegistrationCallback(c);
        }
    };
    private final RemoteCallbackList<IImsRegistrationCallback> mCallbacks = new RemoteCallbackList();
    private final Object mLock = new Object();
    private int mConnectionType = -1;
    private int mRegistrationState = -1;
    private ImsReasonInfo mLastDisconnectCause = new ImsReasonInfo();

    public final IImsRegistration getBinder() {
        return this.mBinder;
    }

    private void addRegistrationCallback(IImsRegistrationCallback c) throws RemoteException {
        this.mCallbacks.register(c);
        this.updateNewCallbackWithState(c);
    }

    private void removeRegistrationCallback(IImsRegistrationCallback c) {
        this.mCallbacks.unregister(c);
    }

    public final void onRegistered(int imsRadioTech) {
        this.updateToState(imsRadioTech, 2);
        this.mCallbacks.broadcast(c -> {
            try {
                c.onRegistered(imsRadioTech);
            }
            catch (RemoteException e) {
                Log.w(LOG_TAG, e + " onRegistrationConnected() - Skipping callback.");
            }
        });
    }

    public final void onRegistering(int imsRadioTech) {
        this.updateToState(imsRadioTech, 1);
        this.mCallbacks.broadcast(c -> {
            try {
                c.onRegistering(imsRadioTech);
            }
            catch (RemoteException e) {
                Log.w(LOG_TAG, e + " onRegistrationProcessing() - Skipping callback.");
            }
        });
    }

    public final void onDeregistered(ImsReasonInfo info) {
        this.updateToDisconnectedState(info);
        this.mCallbacks.broadcast(c -> {
            try {
                c.onDeregistered(info);
            }
            catch (RemoteException e) {
                Log.w(LOG_TAG, e + " onRegistrationDisconnected() - Skipping callback.");
            }
        });
    }

    public final void onTechnologyChangeFailed(int imsRadioTech, ImsReasonInfo info) {
        this.mCallbacks.broadcast(c -> {
            try {
                c.onTechnologyChangeFailed(imsRadioTech, info);
            }
            catch (RemoteException e) {
                Log.w(LOG_TAG, e + " onRegistrationChangeFailed() - Skipping callback.");
            }
        });
    }

    public final void onSubscriberAssociatedUriChanged(Uri[] uris) {
        this.mCallbacks.broadcast(c -> {
            try {
                c.onSubscriberAssociatedUriChanged(uris);
            }
            catch (RemoteException e) {
                Log.w(LOG_TAG, e + " onSubscriberAssociatedUriChanged() - Skipping callback.");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateToState(int connType, int newState) {
        Object object = this.mLock;
        synchronized (object) {
            this.mConnectionType = connType;
            this.mRegistrationState = newState;
            this.mLastDisconnectCause = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateToDisconnectedState(ImsReasonInfo info) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateToState(-1, 0);
            if (info != null) {
                this.mLastDisconnectCause = info;
            } else {
                Log.w(LOG_TAG, "updateToDisconnectedState: no ImsReasonInfo provided.");
                this.mLastDisconnectCause = new ImsReasonInfo();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final int getConnectionType() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConnectionType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNewCallbackWithState(IImsRegistrationCallback c) throws RemoteException {
        ImsReasonInfo disconnectInfo;
        int state;
        Object object = this.mLock;
        synchronized (object) {
            state = this.mRegistrationState;
            disconnectInfo = this.mLastDisconnectCause;
        }
        switch (state) {
            case 0: {
                c.onDeregistered(disconnectInfo);
                break;
            }
            case 1: {
                c.onRegistering(this.getConnectionType());
                break;
            }
            case 2: {
                c.onRegistered(this.getConnectionType());
                break;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImsRegistrationTech {
    }
}

