/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.mbms;

import android.os.Binder;
import android.telephony.mbms.IMbmsGroupCallSessionCallback;
import android.telephony.mbms.MbmsGroupCallSessionCallback;
import java.util.List;
import java.util.concurrent.Executor;

public class InternalGroupCallSessionCallback
extends IMbmsGroupCallSessionCallback.Stub {
    private final Executor mExecutor;
    private final MbmsGroupCallSessionCallback mAppCallback;
    private volatile boolean mIsStopped = false;

    public InternalGroupCallSessionCallback(MbmsGroupCallSessionCallback appCallback, Executor executor) {
        this.mAppCallback = appCallback;
        this.mExecutor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(final int errorCode, final String message) {
        if (this.mIsStopped) {
            return;
        }
        long token = Binder.clearCallingIdentity();
        try {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    InternalGroupCallSessionCallback.this.mAppCallback.onError(errorCode, message);
                }
            });
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAvailableSaisUpdated(final List currentSais, final List availableSais) {
        if (this.mIsStopped) {
            return;
        }
        long token = Binder.clearCallingIdentity();
        try {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    InternalGroupCallSessionCallback.this.mAppCallback.onAvailableSaisUpdated(currentSais, availableSais);
                }
            });
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceInterfaceAvailable(final String interfaceName, final int index) {
        if (this.mIsStopped) {
            return;
        }
        long token = Binder.clearCallingIdentity();
        try {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    InternalGroupCallSessionCallback.this.mAppCallback.onServiceInterfaceAvailable(interfaceName, index);
                }
            });
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @Override
    public void onMiddlewareReady() {
        if (this.mIsStopped) {
            return;
        }
        long token = Binder.clearCallingIdentity();
        try {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    InternalGroupCallSessionCallback.this.mAppCallback.onMiddlewareReady();
                }
            });
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    public void stop() {
        this.mIsStopped = true;
    }
}

