/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.mbms.vendor;

import android.annotation.SystemApi;
import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.mbms.DownloadProgressListener;
import android.telephony.mbms.DownloadRequest;
import android.telephony.mbms.DownloadStatusListener;
import android.telephony.mbms.FileInfo;
import android.telephony.mbms.FileServiceInfo;
import android.telephony.mbms.IDownloadProgressListener;
import android.telephony.mbms.IDownloadStatusListener;
import android.telephony.mbms.IMbmsDownloadSessionCallback;
import android.telephony.mbms.MbmsDownloadSessionCallback;
import android.telephony.mbms.vendor.IMbmsDownloadService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SystemApi
public class MbmsDownloadServiceBase
extends IMbmsDownloadService.Stub {
    private final Map<IBinder, DownloadStatusListener> mDownloadStatusListenerBinderMap = new HashMap<IBinder, DownloadStatusListener>();
    private final Map<IBinder, DownloadProgressListener> mDownloadProgressListenerBinderMap = new HashMap<IBinder, DownloadProgressListener>();
    private final Map<IBinder, IBinder.DeathRecipient> mDownloadCallbackDeathRecipients = new HashMap<IBinder, IBinder.DeathRecipient>();

    public int initialize(int subscriptionId, MbmsDownloadSessionCallback callback) throws RemoteException {
        return 0;
    }

    @Override
    public final int initialize(final int subscriptionId, final IMbmsDownloadSessionCallback callback) throws RemoteException {
        if (callback == null) {
            throw new NullPointerException("Callback must not be null");
        }
        final int uid = Binder.getCallingUid();
        int result = this.initialize(subscriptionId, new MbmsDownloadSessionCallback(){

            @Override
            public void onError(int errorCode, String message) {
                try {
                    if (errorCode == -1) {
                        throw new IllegalArgumentException("Middleware cannot send an unknown error.");
                    }
                    callback.onError(errorCode, message);
                }
                catch (RemoteException e) {
                    MbmsDownloadServiceBase.this.onAppCallbackDied(uid, subscriptionId);
                }
            }

            @Override
            public void onFileServicesUpdated(List<FileServiceInfo> services) {
                try {
                    callback.onFileServicesUpdated(services);
                }
                catch (RemoteException e) {
                    MbmsDownloadServiceBase.this.onAppCallbackDied(uid, subscriptionId);
                }
            }

            @Override
            public void onMiddlewareReady() {
                try {
                    callback.onMiddlewareReady();
                }
                catch (RemoteException e) {
                    MbmsDownloadServiceBase.this.onAppCallbackDied(uid, subscriptionId);
                }
            }
        });
        if (result == 0) {
            callback.asBinder().linkToDeath(new IBinder.DeathRecipient(){

                @Override
                public void binderDied() {
                    MbmsDownloadServiceBase.this.onAppCallbackDied(uid, subscriptionId);
                }
            }, 0);
        }
        return result;
    }

    @Override
    public int requestUpdateFileServices(int subscriptionId, List<String> serviceClasses) throws RemoteException {
        return 0;
    }

    @Override
    public int setTempFileRootDirectory(int subscriptionId, String rootDirectoryPath) throws RemoteException {
        return 0;
    }

    @Override
    public int download(DownloadRequest downloadRequest) throws RemoteException {
        return 0;
    }

    public int addStatusListener(DownloadRequest downloadRequest, DownloadStatusListener listener) throws RemoteException {
        return 0;
    }

    @Override
    public final int addStatusListener(final DownloadRequest downloadRequest, final IDownloadStatusListener listener) throws RemoteException {
        final int uid = Binder.getCallingUid();
        if (downloadRequest == null) {
            throw new NullPointerException("Download request must not be null");
        }
        if (listener == null) {
            throw new NullPointerException("Callback must not be null");
        }
        VendorDownloadStatusListener exposedCallback = new VendorDownloadStatusListener(listener){

            @Override
            protected void onRemoteException(RemoteException e) {
                MbmsDownloadServiceBase.this.onAppCallbackDied(uid, downloadRequest.getSubscriptionId());
            }
        };
        int result = this.addStatusListener(downloadRequest, exposedCallback);
        if (result == 0) {
            IBinder.DeathRecipient deathRecipient = new IBinder.DeathRecipient(){

                @Override
                public void binderDied() {
                    MbmsDownloadServiceBase.this.onAppCallbackDied(uid, downloadRequest.getSubscriptionId());
                    MbmsDownloadServiceBase.this.mDownloadStatusListenerBinderMap.remove(listener.asBinder());
                    MbmsDownloadServiceBase.this.mDownloadCallbackDeathRecipients.remove(listener.asBinder());
                }
            };
            this.mDownloadCallbackDeathRecipients.put(listener.asBinder(), deathRecipient);
            listener.asBinder().linkToDeath(deathRecipient, 0);
            this.mDownloadStatusListenerBinderMap.put(listener.asBinder(), exposedCallback);
        }
        return result;
    }

    public int removeStatusListener(DownloadRequest downloadRequest, DownloadStatusListener listener) throws RemoteException {
        return 0;
    }

    @Override
    public final int removeStatusListener(DownloadRequest downloadRequest, IDownloadStatusListener listener) throws RemoteException {
        if (downloadRequest == null) {
            throw new NullPointerException("Download request must not be null");
        }
        if (listener == null) {
            throw new NullPointerException("Callback must not be null");
        }
        IBinder.DeathRecipient deathRecipient = this.mDownloadCallbackDeathRecipients.remove(listener.asBinder());
        if (deathRecipient == null) {
            throw new IllegalArgumentException("Unknown listener");
        }
        listener.asBinder().unlinkToDeath(deathRecipient, 0);
        DownloadStatusListener exposedCallback = this.mDownloadStatusListenerBinderMap.remove(listener.asBinder());
        if (exposedCallback == null) {
            throw new IllegalArgumentException("Unknown listener");
        }
        return this.removeStatusListener(downloadRequest, exposedCallback);
    }

    public int addProgressListener(DownloadRequest downloadRequest, DownloadProgressListener listener) throws RemoteException {
        return 0;
    }

    @Override
    public final int addProgressListener(final DownloadRequest downloadRequest, final IDownloadProgressListener listener) throws RemoteException {
        final int uid = Binder.getCallingUid();
        if (downloadRequest == null) {
            throw new NullPointerException("Download request must not be null");
        }
        if (listener == null) {
            throw new NullPointerException("Callback must not be null");
        }
        VendorDownloadProgressListener exposedCallback = new VendorDownloadProgressListener(listener){

            @Override
            protected void onRemoteException(RemoteException e) {
                MbmsDownloadServiceBase.this.onAppCallbackDied(uid, downloadRequest.getSubscriptionId());
            }
        };
        int result = this.addProgressListener(downloadRequest, exposedCallback);
        if (result == 0) {
            IBinder.DeathRecipient deathRecipient = new IBinder.DeathRecipient(){

                @Override
                public void binderDied() {
                    MbmsDownloadServiceBase.this.onAppCallbackDied(uid, downloadRequest.getSubscriptionId());
                    MbmsDownloadServiceBase.this.mDownloadProgressListenerBinderMap.remove(listener.asBinder());
                    MbmsDownloadServiceBase.this.mDownloadCallbackDeathRecipients.remove(listener.asBinder());
                }
            };
            this.mDownloadCallbackDeathRecipients.put(listener.asBinder(), deathRecipient);
            listener.asBinder().linkToDeath(deathRecipient, 0);
            this.mDownloadProgressListenerBinderMap.put(listener.asBinder(), exposedCallback);
        }
        return result;
    }

    public int removeProgressListener(DownloadRequest downloadRequest, DownloadProgressListener listener) throws RemoteException {
        return 0;
    }

    @Override
    public final int removeProgressListener(DownloadRequest downloadRequest, IDownloadProgressListener listener) throws RemoteException {
        if (downloadRequest == null) {
            throw new NullPointerException("Download request must not be null");
        }
        if (listener == null) {
            throw new NullPointerException("Callback must not be null");
        }
        IBinder.DeathRecipient deathRecipient = this.mDownloadCallbackDeathRecipients.remove(listener.asBinder());
        if (deathRecipient == null) {
            throw new IllegalArgumentException("Unknown listener");
        }
        listener.asBinder().unlinkToDeath(deathRecipient, 0);
        DownloadProgressListener exposedCallback = this.mDownloadProgressListenerBinderMap.remove(listener.asBinder());
        if (exposedCallback == null) {
            throw new IllegalArgumentException("Unknown listener");
        }
        return this.removeProgressListener(downloadRequest, exposedCallback);
    }

    @Override
    public List<DownloadRequest> listPendingDownloads(int subscriptionId) throws RemoteException {
        return null;
    }

    @Override
    public int cancelDownload(DownloadRequest downloadRequest) throws RemoteException {
        return 0;
    }

    @Override
    public int requestDownloadState(DownloadRequest downloadRequest, FileInfo fileInfo) throws RemoteException {
        return 0;
    }

    @Override
    public int resetDownloadKnowledge(DownloadRequest downloadRequest) throws RemoteException {
        return 0;
    }

    @Override
    public void dispose(int subscriptionId) throws RemoteException {
    }

    public void onAppCallbackDied(int uid, int subscriptionId) {
    }

    @Override
    @SystemApi
    public IBinder asBinder() {
        return super.asBinder();
    }

    @Override
    @SystemApi
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        return super.onTransact(code, data, reply, flags);
    }

    private static abstract class VendorDownloadProgressListener
    extends DownloadProgressListener {
        private final IDownloadProgressListener mListener;

        public VendorDownloadProgressListener(IDownloadProgressListener listener) {
            this.mListener = listener;
        }

        @Override
        public void onProgressUpdated(DownloadRequest request, FileInfo fileInfo, int currentDownloadSize, int fullDownloadSize, int currentDecodedSize, int fullDecodedSize) {
            try {
                this.mListener.onProgressUpdated(request, fileInfo, currentDownloadSize, fullDownloadSize, currentDecodedSize, fullDecodedSize);
            }
            catch (RemoteException e) {
                this.onRemoteException(e);
            }
        }

        protected abstract void onRemoteException(RemoteException var1);
    }

    private static abstract class VendorDownloadStatusListener
    extends DownloadStatusListener {
        private final IDownloadStatusListener mListener;

        public VendorDownloadStatusListener(IDownloadStatusListener listener) {
            this.mListener = listener;
        }

        @Override
        public void onStatusUpdated(DownloadRequest request, FileInfo fileInfo, int state) {
            try {
                this.mListener.onStatusUpdated(request, fileInfo, state);
            }
            catch (RemoteException e) {
                this.onRemoteException(e);
            }
        }

        protected abstract void onRemoteException(RemoteException var1);
    }
}

