/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class PackedIntVector {
    private final int mColumns;
    private int mRows;
    private int mRowGapStart;
    private int mRowGapLength;
    private int[] mValues;
    private int[] mValueGap;

    public PackedIntVector(int columns) {
        this.mColumns = columns;
        this.mRows = 0;
        this.mRowGapStart = 0;
        this.mRowGapLength = this.mRows;
        this.mValues = null;
        this.mValueGap = new int[2 * columns];
    }

    public int getValue(int row, int column) {
        int columns = this.mColumns;
        if ((row | column) < 0 || row >= this.size() || column >= columns) {
            throw new IndexOutOfBoundsException(row + ", " + column);
        }
        if (row >= this.mRowGapStart) {
            row += this.mRowGapLength;
        }
        int value = this.mValues[row * columns + column];
        int[] valuegap = this.mValueGap;
        if (row >= valuegap[column]) {
            value += valuegap[column + columns];
        }
        return value;
    }

    public void setValue(int row, int column, int value) {
        int[] valuegap;
        if ((row | column) < 0 || row >= this.size() || column >= this.mColumns) {
            throw new IndexOutOfBoundsException(row + ", " + column);
        }
        if (row >= this.mRowGapStart) {
            row += this.mRowGapLength;
        }
        if (row >= (valuegap = this.mValueGap)[column]) {
            value -= valuegap[column + this.mColumns];
        }
        this.mValues[row * this.mColumns + column] = value;
    }

    private void setValueInternal(int row, int column, int value) {
        int[] valuegap;
        if (row >= this.mRowGapStart) {
            row += this.mRowGapLength;
        }
        if (row >= (valuegap = this.mValueGap)[column]) {
            value -= valuegap[column + this.mColumns];
        }
        this.mValues[row * this.mColumns + column] = value;
    }

    public void adjustValuesBelow(int startRow, int column, int delta) {
        if ((startRow | column) < 0 || startRow > this.size() || column >= this.width()) {
            throw new IndexOutOfBoundsException(startRow + ", " + column);
        }
        if (startRow >= this.mRowGapStart) {
            startRow += this.mRowGapLength;
        }
        this.moveValueGapTo(column, startRow);
        int n = column + this.mColumns;
        this.mValueGap[n] = this.mValueGap[n] + delta;
    }

    public void insertAt(int row, int[] values) {
        if (row < 0 || row > this.size()) {
            throw new IndexOutOfBoundsException("row " + row);
        }
        if (values != null && values.length < this.width()) {
            throw new IndexOutOfBoundsException("value count " + values.length);
        }
        this.moveRowGapTo(row);
        if (this.mRowGapLength == 0) {
            this.growBuffer();
        }
        ++this.mRowGapStart;
        --this.mRowGapLength;
        if (values == null) {
            for (int i = this.mColumns - 1; i >= 0; --i) {
                this.setValueInternal(row, i, 0);
            }
        } else {
            for (int i = this.mColumns - 1; i >= 0; --i) {
                this.setValueInternal(row, i, values[i]);
            }
        }
    }

    public void deleteAt(int row, int count) {
        if ((row | count) < 0 || row + count > this.size()) {
            throw new IndexOutOfBoundsException(row + ", " + count);
        }
        this.moveRowGapTo(row + count);
        this.mRowGapStart -= count;
        this.mRowGapLength += count;
    }

    public int size() {
        return this.mRows - this.mRowGapLength;
    }

    public int width() {
        return this.mColumns;
    }

    private final void growBuffer() {
        int columns = this.mColumns;
        int[] newvalues = ArrayUtils.newUnpaddedIntArray(GrowingArrayUtils.growSize(this.size()) * columns);
        int newsize = newvalues.length / columns;
        int[] valuegap = this.mValueGap;
        int rowgapstart = this.mRowGapStart;
        int after = this.mRows - (rowgapstart + this.mRowGapLength);
        if (this.mValues != null) {
            System.arraycopy(this.mValues, 0, newvalues, 0, columns * rowgapstart);
            System.arraycopy(this.mValues, (this.mRows - after) * columns, newvalues, (newsize - after) * columns, after * columns);
        }
        for (int i = 0; i < columns; ++i) {
            if (valuegap[i] < rowgapstart) continue;
            int n = i;
            valuegap[n] = valuegap[n] + (newsize - this.mRows);
            if (valuegap[i] >= rowgapstart) continue;
            valuegap[i] = rowgapstart;
        }
        this.mRowGapLength += newsize - this.mRows;
        this.mRows = newsize;
        this.mValues = newvalues;
    }

    private final void moveValueGapTo(int column, int where) {
        int[] valuegap = this.mValueGap;
        int[] values = this.mValues;
        int columns = this.mColumns;
        if (where == valuegap[column]) {
            return;
        }
        if (where > valuegap[column]) {
            for (int i = valuegap[column]; i < where; ++i) {
                int n = i * columns + column;
                values[n] = values[n] + valuegap[column + columns];
            }
        } else {
            for (int i = where; i < valuegap[column]; ++i) {
                int n = i * columns + column;
                values[n] = values[n] - valuegap[column + columns];
            }
        }
        valuegap[column] = where;
    }

    private final void moveRowGapTo(int where) {
        if (where == this.mRowGapStart) {
            return;
        }
        if (where > this.mRowGapStart) {
            int gapend;
            int moving = where + this.mRowGapLength - (this.mRowGapStart + this.mRowGapLength);
            int columns = this.mColumns;
            int[] valuegap = this.mValueGap;
            int[] values = this.mValues;
            for (int i = gapend = this.mRowGapStart + this.mRowGapLength; i < gapend + moving; ++i) {
                int destrow = i - gapend + this.mRowGapStart;
                for (int j = 0; j < columns; ++j) {
                    int val = values[i * columns + j];
                    if (i >= valuegap[j]) {
                        val += valuegap[j + columns];
                    }
                    if (destrow >= valuegap[j]) {
                        val -= valuegap[j + columns];
                    }
                    values[destrow * columns + j] = val;
                }
            }
        } else {
            int moving = this.mRowGapStart - where;
            int columns = this.mColumns;
            int[] valuegap = this.mValueGap;
            int[] values = this.mValues;
            int gapend = this.mRowGapStart + this.mRowGapLength;
            for (int i = where + moving - 1; i >= where; --i) {
                int destrow = i - where + gapend - moving;
                for (int j = 0; j < columns; ++j) {
                    int val = values[i * columns + j];
                    if (i >= valuegap[j]) {
                        val += valuegap[j + columns];
                    }
                    if (destrow >= valuegap[j]) {
                        val -= valuegap[j + columns];
                    }
                    values[destrow * columns + j] = val;
                }
            }
        }
        this.mRowGapStart = where;
    }
}

