/*
 * Decompiled with CFR 0.152.
 */
package android.util;

public final class ByteStringUtils {
    private static final char[] HEX_LOWERCASE_ARRAY = "0123456789abcdef".toCharArray();
    private static final char[] HEX_UPPERCASE_ARRAY = "0123456789ABCDEF".toCharArray();

    private ByteStringUtils() {
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null || bytes.length == 0 || bytes.length % 2 != 0) {
            return null;
        }
        int byteLength = bytes.length;
        int charCount = 2 * byteLength;
        char[] chars = new char[charCount];
        for (int i = 0; i < byteLength; ++i) {
            int byteHex = bytes[i] & 0xFF;
            chars[i * 2] = HEX_UPPERCASE_ARRAY[byteHex >>> 4];
            chars[i * 2 + 1] = HEX_UPPERCASE_ARRAY[byteHex & 0xF];
        }
        return new String(chars);
    }

    public static byte[] fromHexToByteArray(String str) {
        if (str == null || str.length() == 0 || str.length() % 2 != 0) {
            return null;
        }
        char[] chars = str.toCharArray();
        int charLength = chars.length;
        byte[] bytes = new byte[charLength / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(ByteStringUtils.getIndex(chars[i * 2]) << 4 & 0xF0 | ByteStringUtils.getIndex(chars[i * 2 + 1]) & 0xF);
        }
        return bytes;
    }

    private static int getIndex(char c) {
        for (int i = 0; i < HEX_UPPERCASE_ARRAY.length; ++i) {
            if (HEX_UPPERCASE_ARRAY[i] != c && HEX_LOWERCASE_ARRAY[i] != c) continue;
            return i;
        }
        return -1;
    }
}

