/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Environment;
import android.os.storage.StorageManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.LruCache;
import com.android.internal.annotations.VisibleForTesting;
import java.io.File;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class HashedStringCache {
    private static HashedStringCache sHashedStringCache = null;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final int HASH_CACHE_SIZE = 100;
    private static final int HASH_LENGTH = 8;
    @VisibleForTesting
    static final String HASH_SALT = "_hash_salt";
    @VisibleForTesting
    static final String HASH_SALT_DATE = "_hash_salt_date";
    @VisibleForTesting
    static final String HASH_SALT_GEN = "_hash_salt_gen";
    private static final long DAYS_TO_MILLIS = 86400000L;
    private static final int MAX_SALT_DAYS = 100;
    private final LruCache<String, String> mHashes;
    private final SecureRandom mSecureRandom;
    private final Object mPreferenceLock = new Object();
    private final MessageDigest mDigester;
    private byte[] mSalt;
    private int mSaltGen;
    private SharedPreferences mSharedPreferences;
    private static final String TAG = "HashedStringCache";
    private static final boolean DEBUG = false;

    private HashedStringCache() {
        this.mHashes = new LruCache(100);
        this.mSecureRandom = new SecureRandom();
        try {
            this.mDigester = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException impossible) {
            throw new RuntimeException(impossible);
        }
    }

    public static HashedStringCache getInstance() {
        if (sHashedStringCache == null) {
            sHashedStringCache = new HashedStringCache();
        }
        return sHashedStringCache;
    }

    public HashResult hashString(Context context, String tag, String clearText, int saltExpirationDays) {
        if (saltExpirationDays == -1 || context == null || TextUtils.isEmpty(clearText) || TextUtils.isEmpty(tag)) {
            return null;
        }
        this.populateSaltValues(context, tag, saltExpirationDays);
        String hashText = this.mHashes.get(clearText);
        if (hashText != null) {
            return new HashResult(hashText, this.mSaltGen);
        }
        this.mDigester.reset();
        this.mDigester.update(this.mSalt);
        this.mDigester.update(clearText.getBytes(UTF_8));
        byte[] bytes = this.mDigester.digest();
        int len = Math.min(8, bytes.length);
        hashText = Base64.encodeToString(bytes, 0, len, 3);
        this.mHashes.put(clearText, hashText);
        return new HashResult(hashText, this.mSaltGen);
    }

    private boolean checkNeedsNewSalt(String tag, int saltExpirationDays, long saltDate) {
        long now;
        long delta;
        if (saltDate == 0L || saltExpirationDays < -1) {
            return true;
        }
        if (saltExpirationDays > 100) {
            saltExpirationDays = 100;
        }
        return (delta = (now = System.currentTimeMillis()) - saltDate) >= (long)saltExpirationDays * 86400000L || delta < 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSaltValues(Context context, String tag, int saltExpirationDays) {
        Object object = this.mPreferenceLock;
        synchronized (object) {
            this.mSharedPreferences = this.getHashSharedPreferences(context);
            long saltDate = this.mSharedPreferences.getLong(tag + HASH_SALT_DATE, 0L);
            boolean needsNewSalt = this.checkNeedsNewSalt(tag, saltExpirationDays, saltDate);
            if (needsNewSalt) {
                this.mHashes.evictAll();
            }
            if (this.mSalt == null || needsNewSalt) {
                String saltString = this.mSharedPreferences.getString(tag + HASH_SALT, null);
                this.mSaltGen = this.mSharedPreferences.getInt(tag + HASH_SALT_GEN, 0);
                if (saltString == null || needsNewSalt) {
                    ++this.mSaltGen;
                    byte[] saltBytes = new byte[16];
                    this.mSecureRandom.nextBytes(saltBytes);
                    saltString = Base64.encodeToString(saltBytes, 3);
                    this.mSharedPreferences.edit().putString(tag + HASH_SALT, saltString).putInt(tag + HASH_SALT_GEN, this.mSaltGen).putLong(tag + HASH_SALT_DATE, System.currentTimeMillis()).apply();
                }
                this.mSalt = saltString.getBytes(UTF_8);
            }
        }
    }

    private SharedPreferences getHashSharedPreferences(Context context) {
        File prefsFile = new File(new File(Environment.getDataUserCePackageDirectory(StorageManager.UUID_PRIVATE_INTERNAL, context.getUserId(), context.getPackageName()), "shared_prefs"), "hashed_cache.xml");
        return context.getSharedPreferences(prefsFile, 0);
    }

    public class HashResult {
        public String hashedString;
        public int saltGeneration;

        public HashResult(String hString, int saltGen) {
            this.hashedString = hString;
            this.saltGeneration = saltGen;
        }
    }
}

