/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.annotation.UnsupportedAppUsage;
import android.graphics.Path;
import dalvik.annotation.optimization.FastNative;

public class PathParser {
    static final String LOGTAG = PathParser.class.getSimpleName();

    @UnsupportedAppUsage
    public static Path createPathFromPathData(String pathString) {
        if (pathString == null) {
            throw new IllegalArgumentException("Path string can not be null.");
        }
        Path path = new Path();
        PathParser.nParseStringForPath(path.mNativePath, pathString, pathString.length());
        return path;
    }

    public static void createPathFromPathData(Path outPath, PathData data) {
        PathParser.nCreatePathFromPathData(outPath.mNativePath, data.mNativePathData);
    }

    public static boolean canMorph(PathData pathDataFrom, PathData pathDataTo) {
        return PathParser.nCanMorph(pathDataFrom.mNativePathData, pathDataTo.mNativePathData);
    }

    public static boolean interpolatePathData(PathData outData, PathData fromData, PathData toData, float fraction2) {
        return PathParser.nInterpolatePathData(outData.mNativePathData, fromData.mNativePathData, toData.mNativePathData, fraction2);
    }

    private static native void nParseStringForPath(long var0, String var2, int var3);

    private static native long nCreatePathDataFromString(String var0, int var1);

    @FastNative
    private static native void nCreatePathFromPathData(long var0, long var2);

    @FastNative
    private static native long nCreateEmptyPathData();

    @FastNative
    private static native long nCreatePathData(long var0);

    @FastNative
    private static native boolean nInterpolatePathData(long var0, long var2, long var4, float var6);

    @FastNative
    private static native void nFinalize(long var0);

    @FastNative
    private static native boolean nCanMorph(long var0, long var2);

    @FastNative
    private static native void nSetPathData(long var0, long var2);

    public static class PathData {
        long mNativePathData = 0L;

        public PathData() {
            this.mNativePathData = PathParser.nCreateEmptyPathData();
        }

        public PathData(PathData data) {
            this.mNativePathData = PathParser.nCreatePathData(data.mNativePathData);
        }

        public PathData(String pathString) {
            this.mNativePathData = PathParser.nCreatePathDataFromString(pathString, pathString.length());
            if (this.mNativePathData == 0L) {
                throw new IllegalArgumentException("Invalid pathData: " + pathString);
            }
        }

        public long getNativePtr() {
            return this.mNativePathData;
        }

        public void setPathData(PathData source) {
            PathParser.nSetPathData(this.mNativePathData, source.mNativePathData);
        }

        protected void finalize() throws Throwable {
            if (this.mNativePathData != 0L) {
                PathParser.nFinalize(this.mNativePathData);
                this.mNativePathData = 0L;
            }
            super.finalize();
        }
    }
}

