/*
 * Decompiled with CFR 0.152.
 */
package android.util.jar;

import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.jar.StrictJarManifest;
import android.util.jar.StrictJarVerifier;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import libcore.io.IoBridge;
import libcore.io.IoUtils;
import libcore.io.Streams;

public final class StrictJarFile {
    private final long nativeHandle;
    private final FileDescriptor fd;
    private final StrictJarManifest manifest;
    private final StrictJarVerifier verifier;
    private final boolean isSigned;
    private final CloseGuard guard = CloseGuard.get();
    private boolean closed;

    public StrictJarFile(String fileName) throws IOException, SecurityException {
        this(fileName, true, true);
    }

    public StrictJarFile(FileDescriptor fd) throws IOException, SecurityException {
        this(fd, true, true);
    }

    public StrictJarFile(FileDescriptor fd, boolean verify, boolean signatureSchemeRollbackProtectionsEnforced) throws IOException, SecurityException {
        this("[fd:" + fd.getInt$() + "]", fd, verify, signatureSchemeRollbackProtectionsEnforced);
    }

    public StrictJarFile(String fileName, boolean verify, boolean signatureSchemeRollbackProtectionsEnforced) throws IOException, SecurityException {
        this(fileName, IoBridge.open(fileName, OsConstants.O_RDONLY), verify, signatureSchemeRollbackProtectionsEnforced);
    }

    private StrictJarFile(String name, FileDescriptor fd, boolean verify, boolean signatureSchemeRollbackProtectionsEnforced) throws IOException, SecurityException {
        this.nativeHandle = StrictJarFile.nativeOpenJarFile(name, fd.getInt$());
        this.fd = fd;
        try {
            if (verify) {
                HashMap<String, byte[]> metaEntries = this.getMetaEntries();
                this.manifest = new StrictJarManifest(metaEntries.get("META-INF/MANIFEST.MF"), true);
                this.verifier = new StrictJarVerifier(name, this.manifest, metaEntries, signatureSchemeRollbackProtectionsEnforced);
                Set<String> files = this.manifest.getEntries().keySet();
                for (String file : files) {
                    if (this.findEntry(file) != null) continue;
                    throw new SecurityException("File " + file + " in manifest does not exist");
                }
                this.isSigned = this.verifier.readCertificates() && this.verifier.isSignedJar();
            } else {
                this.isSigned = false;
                this.manifest = null;
                this.verifier = null;
            }
        }
        catch (IOException | SecurityException e) {
            StrictJarFile.nativeClose(this.nativeHandle);
            IoUtils.closeQuietly(fd);
            this.closed = true;
            throw e;
        }
        this.guard.open("close");
    }

    public StrictJarManifest getManifest() {
        return this.manifest;
    }

    public Iterator<ZipEntry> iterator() throws IOException {
        return new EntryIterator(this.nativeHandle, "");
    }

    public ZipEntry findEntry(String name) {
        return StrictJarFile.nativeFindEntry(this.nativeHandle, name);
    }

    public Certificate[][] getCertificateChains(ZipEntry ze) {
        if (this.isSigned) {
            return this.verifier.getCertificateChains(ze.getName());
        }
        return null;
    }

    @Deprecated
    public Certificate[] getCertificates(ZipEntry ze) {
        if (this.isSigned) {
            Certificate[][] certChains = this.verifier.getCertificateChains(ze.getName());
            int count = 0;
            for (Certificate[] chain : certChains) {
                count += chain.length;
            }
            Certificate[] certs = new Certificate[count];
            int i = 0;
            for (Certificate[] chain : certChains) {
                System.arraycopy(chain, 0, certs, i, chain.length);
                i += chain.length;
            }
            return certs;
        }
        return null;
    }

    public InputStream getInputStream(ZipEntry ze) {
        InputStream is = this.getZipInputStream(ze);
        if (this.isSigned) {
            StrictJarVerifier.VerifierEntry entry = this.verifier.initEntry(ze.getName());
            if (entry == null) {
                return is;
            }
            return new JarFileInputStream(is, ze.getSize(), entry);
        }
        return is;
    }

    public void close() throws IOException {
        if (!this.closed) {
            if (this.guard != null) {
                this.guard.close();
            }
            StrictJarFile.nativeClose(this.nativeHandle);
            IoUtils.closeQuietly(this.fd);
            this.closed = true;
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private InputStream getZipInputStream(ZipEntry ze) {
        if (ze.getMethod() == 0) {
            return new FDStream(this.fd, ze.getDataOffset(), ze.getDataOffset() + ze.getSize());
        }
        FDStream wrapped = new FDStream(this.fd, ze.getDataOffset(), ze.getDataOffset() + ze.getCompressedSize());
        int bufSize = Math.max(1024, (int)Math.min(ze.getSize(), 65535L));
        return new ZipInflaterInputStream(wrapped, new Inflater(true), bufSize, ze);
    }

    private HashMap<String, byte[]> getMetaEntries() throws IOException {
        HashMap<String, byte[]> metaEntries = new HashMap<String, byte[]>();
        EntryIterator entryIterator = new EntryIterator(this.nativeHandle, "META-INF/");
        while (entryIterator.hasNext()) {
            ZipEntry entry = (ZipEntry)entryIterator.next();
            metaEntries.put(entry.getName(), Streams.readFully(this.getInputStream(entry)));
        }
        return metaEntries;
    }

    private static native long nativeOpenJarFile(String var0, int var1) throws IOException;

    private static native long nativeStartIteration(long var0, String var2);

    private static native ZipEntry nativeNextEntry(long var0);

    private static native ZipEntry nativeFindEntry(long var0, String var2);

    private static native void nativeClose(long var0);

    public static class FDStream
    extends InputStream {
        private final FileDescriptor fd;
        private long endOffset;
        private long offset;

        public FDStream(FileDescriptor fd, long initialOffset, long endOffset) {
            this.fd = fd;
            this.offset = initialOffset;
            this.endOffset = endOffset;
        }

        @Override
        public int available() throws IOException {
            return this.offset < this.endOffset ? 1 : 0;
        }

        @Override
        public int read() throws IOException {
            return Streams.readSingleByte(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            FileDescriptor fileDescriptor = this.fd;
            synchronized (fileDescriptor) {
                long length = this.endOffset - this.offset;
                if ((long)byteCount > length) {
                    byteCount = (int)length;
                }
                try {
                    Os.lseek(this.fd, this.offset, OsConstants.SEEK_SET);
                }
                catch (ErrnoException e) {
                    throw new IOException(e);
                }
                int count = IoBridge.read(this.fd, buffer, byteOffset, byteCount);
                if (count > 0) {
                    this.offset += (long)count;
                    return count;
                }
                return -1;
            }
        }

        @Override
        public long skip(long byteCount) throws IOException {
            if (byteCount > this.endOffset - this.offset) {
                byteCount = this.endOffset - this.offset;
            }
            this.offset += byteCount;
            return byteCount;
        }
    }

    public static class ZipInflaterInputStream
    extends InflaterInputStream {
        private final ZipEntry entry;
        private long bytesRead = 0L;
        private boolean closed;

        public ZipInflaterInputStream(InputStream is, Inflater inf, int bsize, ZipEntry entry) {
            super(is, inf, bsize);
            this.entry = entry;
        }

        @Override
        public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            int i;
            try {
                i = super.read(buffer, byteOffset, byteCount);
            }
            catch (IOException e) {
                throw new IOException("Error reading data for " + this.entry.getName() + " near offset " + this.bytesRead, e);
            }
            if (i == -1) {
                if (this.entry.getSize() != this.bytesRead) {
                    throw new IOException("Size mismatch on inflated file: " + this.bytesRead + " vs " + this.entry.getSize());
                }
            } else {
                this.bytesRead += (long)i;
            }
            return i;
        }

        @Override
        public int available() throws IOException {
            if (this.closed) {
                return 0;
            }
            return super.available() == 0 ? 0 : (int)(this.entry.getSize() - this.bytesRead);
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.closed = true;
        }
    }

    static final class JarFileInputStream
    extends FilterInputStream {
        private final StrictJarVerifier.VerifierEntry entry;
        private long count;
        private boolean done = false;

        JarFileInputStream(InputStream is, long size, StrictJarVerifier.VerifierEntry e) {
            super(is);
            this.entry = e;
            this.count = size;
        }

        @Override
        public int read() throws IOException {
            if (this.done) {
                return -1;
            }
            if (this.count > 0L) {
                int r = super.read();
                if (r != -1) {
                    this.entry.write(r);
                    --this.count;
                } else {
                    this.count = 0L;
                }
                if (this.count == 0L) {
                    this.done = true;
                    this.entry.verify();
                }
                return r;
            }
            this.done = true;
            this.entry.verify();
            return -1;
        }

        @Override
        public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            if (this.done) {
                return -1;
            }
            if (this.count > 0L) {
                int r = super.read(buffer, byteOffset, byteCount);
                if (r != -1) {
                    int size = r;
                    if (this.count < (long)size) {
                        size = (int)this.count;
                    }
                    this.entry.write(buffer, byteOffset, size);
                    this.count -= (long)size;
                } else {
                    this.count = 0L;
                }
                if (this.count == 0L) {
                    this.done = true;
                    this.entry.verify();
                }
                return r;
            }
            this.done = true;
            this.entry.verify();
            return -1;
        }

        @Override
        public int available() throws IOException {
            if (this.done) {
                return 0;
            }
            return super.available();
        }

        @Override
        public long skip(long byteCount) throws IOException {
            return Streams.skipByReading(this, byteCount);
        }
    }

    static final class EntryIterator
    implements Iterator<ZipEntry> {
        private final long iterationHandle;
        private ZipEntry nextEntry;

        EntryIterator(long nativeHandle, String prefix) throws IOException {
            this.iterationHandle = StrictJarFile.nativeStartIteration(nativeHandle, prefix);
        }

        @Override
        public ZipEntry next() {
            if (this.nextEntry != null) {
                ZipEntry ze = this.nextEntry;
                this.nextEntry = null;
                return ze;
            }
            return StrictJarFile.nativeNextEntry(this.iterationHandle);
        }

        @Override
        public boolean hasNext() {
            if (this.nextEntry != null) {
                return true;
            }
            ZipEntry ze = StrictJarFile.nativeNextEntry(this.iterationHandle);
            if (ze == null) {
                return false;
            }
            this.nextEntry = ze;
            return true;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

