/*
 * Decompiled with CFR 0.152.
 */
package android.util.proto;

import android.util.proto.ProtoInputStream;
import android.util.proto.ProtoOutputStream;
import android.util.proto.ProtoStream;
import java.io.IOException;

public class ProtoUtils {
    public static void toAggStatsProto(ProtoOutputStream proto, long fieldId, long min, long average, long max) {
        long aggStatsToken = proto.start(fieldId);
        proto.write(0x10300000001L, min);
        proto.write(1112396529666L, average);
        proto.write(0x10300000003L, max);
        proto.end(aggStatsToken);
    }

    public static void toDuration(ProtoOutputStream proto, long fieldId, long startMs, long endMs) {
        long token = proto.start(fieldId);
        proto.write(0x10300000001L, startMs);
        proto.write(1112396529666L, endMs);
        proto.end(token);
    }

    public static void writeBitWiseFlagsToProtoEnum(ProtoOutputStream proto, long fieldId, int flags, int[] origEnums, int[] protoEnums) {
        if (protoEnums.length != origEnums.length) {
            throw new IllegalArgumentException("The length of origEnums must match protoEnums");
        }
        int len = origEnums.length;
        for (int i = 0; i < len; ++i) {
            if (origEnums[i] == 0 && flags == 0) {
                proto.write(fieldId, protoEnums[i]);
                return;
            }
            if ((flags & origEnums[i]) == 0) continue;
            proto.write(fieldId, protoEnums[i]);
        }
    }

    public static String currentFieldToString(ProtoInputStream proto) throws IOException {
        StringBuilder sb = new StringBuilder();
        int fieldNumber = proto.getFieldNumber();
        int wireType = proto.getWireType();
        sb.append("Offset : 0x" + Integer.toHexString(proto.getOffset()));
        sb.append("\nField Number : 0x" + Integer.toHexString(proto.getFieldNumber()));
        sb.append("\nWire Type : ");
        switch (wireType) {
            case 0: {
                sb.append("varint");
                long fieldConstant = ProtoStream.makeFieldId(fieldNumber, 0x10300000000L);
                sb.append("\nField Value : 0x" + Long.toHexString(proto.readLong(fieldConstant)));
                break;
            }
            case 1: {
                sb.append("fixed64");
                long fieldConstant = ProtoStream.makeFieldId(fieldNumber, 0x10600000000L);
                sb.append("\nField Value : 0x" + Long.toHexString(proto.readLong(fieldConstant)));
                break;
            }
            case 2: {
                sb.append("length delimited");
                long fieldConstant = ProtoStream.makeFieldId(fieldNumber, 0x10C00000000L);
                sb.append("\nField Bytes : " + proto.readBytes(fieldConstant));
                break;
            }
            case 3: {
                sb.append("start group");
                break;
            }
            case 4: {
                sb.append("end group");
                break;
            }
            case 5: {
                sb.append("fixed32");
                long fieldConstant = ProtoStream.makeFieldId(fieldNumber, 0x10700000000L);
                sb.append("\nField Value : 0x" + Integer.toHexString(proto.readInt(fieldConstant)));
                break;
            }
            default: {
                sb.append("unknown(" + proto.getWireType() + ")");
            }
        }
        return sb.toString();
    }
}

