/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.os.IBinder;
import com.android.internal.util.Preconditions;
import java.util.concurrent.Executor;

public abstract class CompositionSamplingListener {
    private final long mNativeListener;
    private final Executor mExecutor;

    public CompositionSamplingListener(Executor executor) {
        this.mExecutor = executor;
        this.mNativeListener = CompositionSamplingListener.nativeCreate(this);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mNativeListener != 0L) {
                CompositionSamplingListener.unregister(this);
                CompositionSamplingListener.nativeDestroy(this.mNativeListener);
            }
        }
        finally {
            super.finalize();
        }
    }

    public abstract void onSampleCollected(float var1);

    public static void register(CompositionSamplingListener listener, int displayId, IBinder stopLayer, Rect samplingArea) {
        Preconditions.checkArgument(displayId == 0, "default display only for now");
        CompositionSamplingListener.nativeRegister(listener.mNativeListener, stopLayer, samplingArea.left, samplingArea.top, samplingArea.right, samplingArea.bottom);
    }

    public static void unregister(CompositionSamplingListener listener) {
        CompositionSamplingListener.nativeUnregister(listener.mNativeListener);
    }

    private static void dispatchOnSampleCollected(CompositionSamplingListener listener, float medianLuma) {
        listener.mExecutor.execute(() -> listener.onSampleCollected(medianLuma));
    }

    private static native long nativeCreate(CompositionSamplingListener var0);

    private static native void nativeDestroy(long var0);

    private static native void nativeRegister(long var0, IBinder var2, int var3, int var4, int var5, int var6);

    private static native void nativeUnregister(long var0);
}

