/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.UnsupportedAppUsage;
import android.os.Looper;
import android.os.MessageQueue;
import android.util.Log;
import dalvik.annotation.optimization.FastNative;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;

public abstract class DisplayEventReceiver {
    public static final int VSYNC_SOURCE_APP = 0;
    public static final int VSYNC_SOURCE_SURFACE_FLINGER = 1;
    private static final String TAG = "DisplayEventReceiver";
    private final CloseGuard mCloseGuard = CloseGuard.get();
    @UnsupportedAppUsage
    private long mReceiverPtr;
    private MessageQueue mMessageQueue;

    private static native long nativeInit(WeakReference<DisplayEventReceiver> var0, MessageQueue var1, int var2);

    private static native void nativeDispose(long var0);

    @FastNative
    private static native void nativeScheduleVsync(long var0);

    @UnsupportedAppUsage
    public DisplayEventReceiver(Looper looper) {
        this(looper, 0);
    }

    public DisplayEventReceiver(Looper looper, int vsyncSource) {
        if (looper == null) {
            throw new IllegalArgumentException("looper must not be null");
        }
        this.mMessageQueue = looper.getQueue();
        this.mReceiverPtr = DisplayEventReceiver.nativeInit(new WeakReference<DisplayEventReceiver>(this), this.mMessageQueue, vsyncSource);
        this.mCloseGuard.open("dispose");
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose(true);
        }
        finally {
            super.finalize();
        }
    }

    public void dispose() {
        this.dispose(false);
    }

    private void dispose(boolean finalized) {
        if (this.mCloseGuard != null) {
            if (finalized) {
                this.mCloseGuard.warnIfOpen();
            }
            this.mCloseGuard.close();
        }
        if (this.mReceiverPtr != 0L) {
            DisplayEventReceiver.nativeDispose(this.mReceiverPtr);
            this.mReceiverPtr = 0L;
        }
        this.mMessageQueue = null;
    }

    @UnsupportedAppUsage
    public void onVsync(long timestampNanos, long physicalDisplayId, int frame) {
    }

    @UnsupportedAppUsage
    public void onHotplug(long timestampNanos, long physicalDisplayId, boolean connected) {
    }

    public void onConfigChanged(long timestampNanos, long physicalDisplayId, int configId) {
    }

    @UnsupportedAppUsage
    public void scheduleVsync() {
        if (this.mReceiverPtr == 0L) {
            Log.w(TAG, "Attempted to schedule a vertical sync pulse but the display event receiver has already been disposed.");
        } else {
            DisplayEventReceiver.nativeScheduleVsync(this.mReceiverPtr);
        }
    }

    @UnsupportedAppUsage
    private void dispatchVsync(long timestampNanos, long physicalDisplayId, int frame) {
        this.onVsync(timestampNanos, physicalDisplayId, frame);
    }

    @UnsupportedAppUsage
    private void dispatchHotplug(long timestampNanos, long physicalDisplayId, boolean connected) {
        this.onHotplug(timestampNanos, physicalDisplayId, connected);
    }

    private void dispatchConfigChanged(long timestampNanos, long physicalDisplayId, int configId) {
        this.onConfigChanged(timestampNanos, physicalDisplayId, configId);
    }
}

