/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Canvas;
import android.os.Handler;
import android.os.Message;
import android.os.Trace;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.util.Xml;
import android.view.ContextThemeWrapper;
import android.view.InflateException;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.FrameLayout;
import com.android.internal.R;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class LayoutInflater {
    private static final String TAG = LayoutInflater.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final String COMPILED_VIEW_DEX_FILE_NAME = "/compiled_view.dex";
    private static final String USE_PRECOMPILED_LAYOUT = "view.precompiled_layout_enabled";
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    @UnsupportedAppUsage(maxTargetSdk=28)
    protected final Context mContext;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private boolean mFactorySet;
    @UnsupportedAppUsage
    private Factory mFactory;
    @UnsupportedAppUsage
    private Factory2 mFactory2;
    @UnsupportedAppUsage
    private Factory2 mPrivateFactory;
    private Filter mFilter;
    private boolean mUseCompiledView;
    private ClassLoader mPrecompiledClassLoader;
    @UnsupportedAppUsage(maxTargetSdk=28)
    final Object[] mConstructorArgs = new Object[2];
    @UnsupportedAppUsage
    static final Class<?>[] mConstructorSignature = new Class[]{Context.class, AttributeSet.class};
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=123769490L)
    private static final HashMap<String, Constructor<? extends View>> sConstructorMap = new HashMap();
    private HashMap<String, Boolean> mFilterMap;
    private TypedValue mTempValue;
    private static final String TAG_MERGE = "merge";
    private static final String TAG_INCLUDE = "include";
    private static final String TAG_1995 = "blink";
    private static final String TAG_REQUEST_FOCUS = "requestFocus";
    private static final String TAG_TAG = "tag";
    private static final String ATTR_LAYOUT = "layout";
    @UnsupportedAppUsage
    private static final int[] ATTRS_THEME = new int[]{0x1010000};
    private static final ClassLoader BOOT_CLASS_LOADER = LayoutInflater.class.getClassLoader();

    protected LayoutInflater(Context context) {
        this.mContext = context;
        this.initPrecompiledViews();
    }

    protected LayoutInflater(LayoutInflater original, Context newContext) {
        this.mContext = newContext;
        this.mFactory = original.mFactory;
        this.mFactory2 = original.mFactory2;
        this.mPrivateFactory = original.mPrivateFactory;
        this.setFilter(original.mFilter);
        this.initPrecompiledViews();
    }

    public static LayoutInflater from(Context context) {
        LayoutInflater LayoutInflater2 = (LayoutInflater)context.getSystemService("layout_inflater");
        if (LayoutInflater2 == null) {
            throw new AssertionError((Object)"LayoutInflater not found.");
        }
        return LayoutInflater2;
    }

    public abstract LayoutInflater cloneInContext(Context var1);

    public Context getContext() {
        return this.mContext;
    }

    public final Factory getFactory() {
        return this.mFactory;
    }

    public final Factory2 getFactory2() {
        return this.mFactory2;
    }

    public void setFactory(Factory factory) {
        if (this.mFactorySet) {
            throw new IllegalStateException("A factory has already been set on this LayoutInflater");
        }
        if (factory == null) {
            throw new NullPointerException("Given factory can not be null");
        }
        this.mFactorySet = true;
        this.mFactory = this.mFactory == null ? factory : new FactoryMerger(factory, null, this.mFactory, this.mFactory2);
    }

    public void setFactory2(Factory2 factory) {
        if (this.mFactorySet) {
            throw new IllegalStateException("A factory has already been set on this LayoutInflater");
        }
        if (factory == null) {
            throw new NullPointerException("Given factory can not be null");
        }
        this.mFactorySet = true;
        if (this.mFactory == null) {
            this.mFactory2 = factory;
            this.mFactory = this.mFactory2;
        } else {
            this.mFactory2 = new FactoryMerger(factory, factory, this.mFactory, this.mFactory2);
            this.mFactory = this.mFactory2;
        }
    }

    @UnsupportedAppUsage
    public void setPrivateFactory(Factory2 factory) {
        this.mPrivateFactory = this.mPrivateFactory == null ? factory : new FactoryMerger(factory, factory, this.mPrivateFactory, this.mPrivateFactory);
    }

    public Filter getFilter() {
        return this.mFilter;
    }

    public void setFilter(Filter filter) {
        this.mFilter = filter;
        if (filter != null) {
            this.mFilterMap = new HashMap();
        }
    }

    private void initPrecompiledViews() {
        boolean enabled = false;
        this.initPrecompiledViews(enabled);
    }

    private void initPrecompiledViews(boolean enablePrecompiledViews) {
        this.mUseCompiledView = enablePrecompiledViews;
        if (!this.mUseCompiledView) {
            this.mPrecompiledClassLoader = null;
            return;
        }
        ApplicationInfo appInfo = this.mContext.getApplicationInfo();
        if (appInfo.isEmbeddedDexUsed() || appInfo.isPrivilegedApp()) {
            this.mUseCompiledView = false;
            return;
        }
        try {
            this.mPrecompiledClassLoader = this.mContext.getClassLoader();
            String dexFile = this.mContext.getCodeCacheDir() + COMPILED_VIEW_DEX_FILE_NAME;
            if (new File(dexFile).exists()) {
                this.mPrecompiledClassLoader = new PathClassLoader(dexFile, this.mPrecompiledClassLoader);
            } else {
                this.mUseCompiledView = false;
            }
        }
        catch (Throwable e) {
            this.mUseCompiledView = false;
        }
        if (!this.mUseCompiledView) {
            this.mPrecompiledClassLoader = null;
        }
    }

    public void setPrecompiledLayoutsEnabledForTesting(boolean enablePrecompiledLayouts) {
        this.initPrecompiledViews(enablePrecompiledLayouts);
    }

    public View inflate(int resource, ViewGroup root) {
        return this.inflate(resource, root, root != null);
    }

    public View inflate(XmlPullParser parser, ViewGroup root) {
        return this.inflate(parser, root, root != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View inflate(int resource, ViewGroup root, boolean attachToRoot) {
        Resources res = this.getContext().getResources();
        View view = this.tryInflatePrecompiled(resource, res, root, attachToRoot);
        if (view != null) {
            return view;
        }
        try (XmlResourceParser parser = res.getLayout(resource);){
            View view2 = this.inflate(parser, root, attachToRoot);
            return view2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private View tryInflatePrecompiled(int resource, Resources res, ViewGroup root, boolean attachToRoot) {
        if (!this.mUseCompiledView) {
            return null;
        }
        Trace.traceBegin(8L, "inflate (precompiled)");
        String pkg = res.getResourcePackageName(resource);
        String layout2 = res.getResourceEntryName(resource);
        try {
            Class<?> clazz = Class.forName("" + pkg + ".CompiledView", false, this.mPrecompiledClassLoader);
            Method inflater = clazz.getMethod(layout2, Context.class, Integer.TYPE);
            View view = (View)inflater.invoke(null, this.mContext, resource);
            if (view != null && root != null) {
                try (XmlResourceParser parser = res.getLayout(resource);){
                    AttributeSet attrs = Xml.asAttributeSet(parser);
                    this.advanceToRootNode(parser);
                    ViewGroup.LayoutParams params = root.generateLayoutParams(attrs);
                    if (attachToRoot) {
                        root.addView(view, params);
                    } else {
                        view.setLayoutParams(params);
                    }
                }
            }
            View view2 = view;
            return view2;
        }
        catch (Throwable throwable) {
        }
        finally {
            Trace.traceEnd(8L);
        }
        return null;
    }

    private void advanceToRootNode(XmlPullParser parser) throws InflateException, IOException, XmlPullParserException {
        int type;
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            throw new InflateException(parser.getPositionDescription() + ": No start tag found!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View inflate(XmlPullParser parser, ViewGroup root, boolean attachToRoot) {
        Object[] objectArray = this.mConstructorArgs;
        synchronized (this.mConstructorArgs) {
            Trace.traceBegin(8L, "inflate");
            Context inflaterContext = this.mContext;
            AttributeSet attrs = Xml.asAttributeSet(parser);
            Context lastContext = (Context)this.mConstructorArgs[0];
            this.mConstructorArgs[0] = inflaterContext;
            View result = root;
            try {
                this.advanceToRootNode(parser);
                String name = parser.getName();
                if (TAG_MERGE.equals(name)) {
                    if (root == null || !attachToRoot) {
                        throw new InflateException("<merge /> can be used only with a valid ViewGroup root and attachToRoot=true");
                    }
                    this.rInflate(parser, root, inflaterContext, attrs, false);
                } else {
                    View temp = this.createViewFromTag(root, name, inflaterContext, attrs);
                    ViewGroup.LayoutParams params = null;
                    if (root != null) {
                        params = root.generateLayoutParams(attrs);
                        if (!attachToRoot) {
                            temp.setLayoutParams(params);
                        }
                    }
                    this.rInflateChildren(parser, temp, attrs, true);
                    if (root != null && attachToRoot) {
                        root.addView(temp, params);
                    }
                    if (root == null || !attachToRoot) {
                        result = temp;
                    }
                }
            }
            catch (XmlPullParserException e) {
                InflateException ie = new InflateException(e.getMessage(), e);
                ie.setStackTrace(EMPTY_STACK_TRACE);
                throw ie;
            }
            catch (Exception e) {
                InflateException ie = new InflateException(LayoutInflater.getParserStateDescription(inflaterContext, attrs) + ": " + e.getMessage(), e);
                ie.setStackTrace(EMPTY_STACK_TRACE);
                throw ie;
            }
            finally {
                this.mConstructorArgs[0] = lastContext;
                this.mConstructorArgs[1] = null;
                Trace.traceEnd(8L);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return result;
        }
    }

    private static String getParserStateDescription(Context context, AttributeSet attrs) {
        int sourceResId = Resources.getAttributeSetSourceResId(attrs);
        if (sourceResId == 0) {
            return attrs.getPositionDescription();
        }
        return attrs.getPositionDescription() + " in " + context.getResources().getResourceName(sourceResId);
    }

    private final boolean verifyClassLoader(Constructor<? extends View> constructor) {
        ClassLoader constructorLoader = constructor.getDeclaringClass().getClassLoader();
        if (constructorLoader == BOOT_CLASS_LOADER) {
            return true;
        }
        ClassLoader cl = this.mContext.getClassLoader();
        do {
            if (constructorLoader != cl) continue;
            return true;
        } while ((cl = cl.getParent()) != null);
        return false;
    }

    public final View createView(String name, String prefix, AttributeSet attrs) throws ClassNotFoundException, InflateException {
        Context context = (Context)this.mConstructorArgs[0];
        if (context == null) {
            context = this.mContext;
        }
        return this.createView(context, name, prefix, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final View createView(Context viewContext, String name, String prefix, AttributeSet attrs) throws ClassNotFoundException, InflateException {
        Objects.requireNonNull(viewContext);
        Objects.requireNonNull(name);
        Constructor<? extends View> constructor = sConstructorMap.get(name);
        if (constructor != null && !this.verifyClassLoader(constructor)) {
            constructor = null;
            sConstructorMap.remove(name);
        }
        Class<View> clazz = null;
        try {
            Trace.traceBegin(8L, name);
            if (constructor == null) {
                boolean allowed;
                clazz = Class.forName(prefix != null ? prefix + name : name, false, this.mContext.getClassLoader()).asSubclass(View.class);
                if (this.mFilter != null && clazz != null && !(allowed = this.mFilter.onLoadClass(clazz))) {
                    this.failNotAllowed(name, prefix, viewContext, attrs);
                }
                constructor = clazz.getConstructor(mConstructorSignature);
                constructor.setAccessible(true);
                sConstructorMap.put(name, constructor);
            } else if (this.mFilter != null) {
                Boolean allowedState = this.mFilterMap.get(name);
                if (allowedState == null) {
                    clazz = Class.forName(prefix != null ? prefix + name : name, false, this.mContext.getClassLoader()).asSubclass(View.class);
                    boolean allowed = clazz != null && this.mFilter.onLoadClass(clazz);
                    this.mFilterMap.put(name, allowed);
                    if (!allowed) {
                        this.failNotAllowed(name, prefix, viewContext, attrs);
                    }
                } else if (allowedState.equals(Boolean.FALSE)) {
                    this.failNotAllowed(name, prefix, viewContext, attrs);
                }
            }
            Object lastContext = this.mConstructorArgs[0];
            this.mConstructorArgs[0] = viewContext;
            Object[] args = this.mConstructorArgs;
            args[1] = attrs;
            try {
                View view = constructor.newInstance(args);
                if (view instanceof ViewStub) {
                    ViewStub viewStub = (ViewStub)view;
                    viewStub.setLayoutInflater(this.cloneInContext((Context)args[0]));
                }
                View view2 = view;
                this.mConstructorArgs[0] = lastContext;
                return view2;
            }
            catch (Throwable throwable) {
                InflateException ie;
                try {
                    this.mConstructorArgs[0] = lastContext;
                    throw throwable;
                }
                catch (NoSuchMethodException e) {
                    ie = new InflateException(LayoutInflater.getParserStateDescription(viewContext, attrs) + ": Error inflating class " + (prefix != null ? prefix + name : name), e);
                    ie.setStackTrace(EMPTY_STACK_TRACE);
                    throw ie;
                }
                catch (ClassCastException e) {
                    ie = new InflateException(LayoutInflater.getParserStateDescription(viewContext, attrs) + ": Class is not a View " + (prefix != null ? prefix + name : name), e);
                    ie.setStackTrace(EMPTY_STACK_TRACE);
                    throw ie;
                }
                catch (ClassNotFoundException e) {
                    throw e;
                }
                catch (Exception e) {
                    ie = new InflateException(LayoutInflater.getParserStateDescription(viewContext, attrs) + ": Error inflating class " + (clazz == null ? "<unknown>" : clazz.getName()), e);
                    ie.setStackTrace(EMPTY_STACK_TRACE);
                    throw ie;
                }
            }
        }
        finally {
            Trace.traceEnd(8L);
        }
    }

    private void failNotAllowed(String name, String prefix, Context context, AttributeSet attrs) {
        throw new InflateException(LayoutInflater.getParserStateDescription(context, attrs) + ": Class not allowed to be inflated " + (prefix != null ? prefix + name : name));
    }

    protected View onCreateView(String name, AttributeSet attrs) throws ClassNotFoundException {
        return this.createView(name, "android.view.", attrs);
    }

    protected View onCreateView(View parent, String name, AttributeSet attrs) throws ClassNotFoundException {
        return this.onCreateView(name, attrs);
    }

    public View onCreateView(Context viewContext, View parent, String name, AttributeSet attrs) throws ClassNotFoundException {
        return this.onCreateView(parent, name, attrs);
    }

    @UnsupportedAppUsage
    private View createViewFromTag(View parent, String name, Context context, AttributeSet attrs) {
        return this.createViewFromTag(parent, name, context, attrs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    View createViewFromTag(View parent, String name, Context context, AttributeSet attrs, boolean ignoreThemeAttr) {
        if (name.equals("view")) {
            name = attrs.getAttributeValue(null, "class");
        }
        if (!ignoreThemeAttr) {
            TypedArray ta = context.obtainStyledAttributes(attrs, ATTRS_THEME);
            int themeResId = ta.getResourceId(0, 0);
            if (themeResId != 0) {
                context = new ContextThemeWrapper(context, themeResId);
            }
            ta.recycle();
        }
        try {
            View view = this.tryCreateView(parent, name, context, attrs);
            if (view == null) {
                Object lastContext = this.mConstructorArgs[0];
                this.mConstructorArgs[0] = context;
                try {
                    view = -1 == name.indexOf(46) ? this.onCreateView(context, parent, name, attrs) : this.createView(context, name, null, attrs);
                }
                finally {
                    this.mConstructorArgs[0] = lastContext;
                }
            }
            return view;
        }
        catch (InflateException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            InflateException ie = new InflateException(LayoutInflater.getParserStateDescription(context, attrs) + ": Error inflating class " + name, e);
            ie.setStackTrace(EMPTY_STACK_TRACE);
            throw ie;
        }
        catch (Exception e) {
            InflateException ie = new InflateException(LayoutInflater.getParserStateDescription(context, attrs) + ": Error inflating class " + name, e);
            ie.setStackTrace(EMPTY_STACK_TRACE);
            throw ie;
        }
    }

    @UnsupportedAppUsage(trackingBug=122360734L)
    public final View tryCreateView(View parent, String name, Context context, AttributeSet attrs) {
        if (name.equals(TAG_1995)) {
            return new BlinkLayout(context, attrs);
        }
        View view = this.mFactory2 != null ? this.mFactory2.onCreateView(parent, name, context, attrs) : (this.mFactory != null ? this.mFactory.onCreateView(name, context, attrs) : null);
        if (view == null && this.mPrivateFactory != null) {
            view = this.mPrivateFactory.onCreateView(parent, name, context, attrs);
        }
        return view;
    }

    final void rInflateChildren(XmlPullParser parser, View parent, AttributeSet attrs, boolean finishInflate) throws XmlPullParserException, IOException {
        this.rInflate(parser, parent, parent.getContext(), attrs, finishInflate);
    }

    void rInflate(XmlPullParser parser, View parent, Context context, AttributeSet attrs, boolean finishInflate) throws XmlPullParserException, IOException {
        int type;
        int depth = parser.getDepth();
        boolean pendingRequestFocus = false;
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if (TAG_REQUEST_FOCUS.equals(name)) {
                pendingRequestFocus = true;
                LayoutInflater.consumeChildElements(parser);
                continue;
            }
            if (TAG_TAG.equals(name)) {
                this.parseViewTag(parser, parent, attrs);
                continue;
            }
            if (TAG_INCLUDE.equals(name)) {
                if (parser.getDepth() == 0) {
                    throw new InflateException("<include /> cannot be the root element");
                }
                this.parseInclude(parser, context, parent, attrs);
                continue;
            }
            if (TAG_MERGE.equals(name)) {
                throw new InflateException("<merge /> must be the root element");
            }
            View view = this.createViewFromTag(parent, name, context, attrs);
            ViewGroup viewGroup = (ViewGroup)parent;
            ViewGroup.LayoutParams params = viewGroup.generateLayoutParams(attrs);
            this.rInflateChildren(parser, view, attrs, true);
            viewGroup.addView(view, params);
        }
        if (pendingRequestFocus) {
            parent.restoreDefaultFocus();
        }
        if (finishInflate) {
            parent.onFinishInflate();
        }
    }

    private void parseViewTag(XmlPullParser parser, View view, AttributeSet attrs) throws XmlPullParserException, IOException {
        Context context = view.getContext();
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ViewTag);
        int key = ta.getResourceId(1, 0);
        CharSequence value = ta.getText(0);
        view.setTag(key, value);
        ta.recycle();
        LayoutInflater.consumeChildElements(parser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    private void parseInclude(XmlPullParser parser, Context context, View parent, AttributeSet attrs) throws XmlPullParserException, IOException {
        block23: {
            String value;
            boolean hasThemeOverride;
            if (!(parent instanceof ViewGroup)) {
                throw new InflateException("<include /> can only be used inside of a ViewGroup");
            }
            TypedArray ta = context.obtainStyledAttributes(attrs, ATTRS_THEME);
            int themeResId = ta.getResourceId(0, 0);
            boolean bl = hasThemeOverride = themeResId != 0;
            if (hasThemeOverride) {
                context = new ContextThemeWrapper(context, themeResId);
            }
            ta.recycle();
            int layout2 = attrs.getAttributeResourceValue(null, ATTR_LAYOUT, 0);
            if (layout2 == 0) {
                value = attrs.getAttributeValue(null, ATTR_LAYOUT);
                if (value == null || value.length() <= 0) {
                    throw new InflateException("You must specify a layout in the include tag: <include layout=\"@layout/layoutID\" />");
                }
                layout2 = context.getResources().getIdentifier(value.substring(1), "attr", context.getPackageName());
            }
            if (this.mTempValue == null) {
                this.mTempValue = new TypedValue();
            }
            if (layout2 != 0 && context.getTheme().resolveAttribute(layout2, this.mTempValue, true)) {
                layout2 = this.mTempValue.resourceId;
            }
            if (layout2 == 0) {
                value = attrs.getAttributeValue(null, ATTR_LAYOUT);
                throw new InflateException("You must specify a valid layout reference. The layout ID " + value + " is not valid.");
            }
            View precompiled = this.tryInflatePrecompiled(layout2, context.getResources(), (ViewGroup)parent, true);
            if (precompiled == null) {
                try (XmlResourceParser childParser = context.getResources().getLayout(layout2);){
                    int type;
                    AttributeSet childAttrs = Xml.asAttributeSet(childParser);
                    while ((type = childParser.next()) != 2 && type != 1) {
                    }
                    if (type != 2) {
                        throw new InflateException(LayoutInflater.getParserStateDescription(context, childAttrs) + ": No start tag found!");
                    }
                    String childName = childParser.getName();
                    if (TAG_MERGE.equals(childName)) {
                        this.rInflate(childParser, parent, context, childAttrs, false);
                        break block23;
                    }
                    View view = this.createViewFromTag(parent, childName, context, childAttrs, hasThemeOverride);
                    ViewGroup group = (ViewGroup)parent;
                    TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Include);
                    int id2 = a.getResourceId(0, -1);
                    int visibility = a.getInt(1, -1);
                    a.recycle();
                    ViewGroup.LayoutParams params = null;
                    try {
                        params = group.generateLayoutParams(attrs);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    if (params == null) {
                        params = group.generateLayoutParams(childAttrs);
                    }
                    view.setLayoutParams(params);
                    this.rInflateChildren(childParser, view, childAttrs, true);
                    if (id2 != -1) {
                        view.setId(id2);
                    }
                    switch (visibility) {
                        case 0: {
                            view.setVisibility(0);
                            break;
                        }
                        case 1: {
                            view.setVisibility(4);
                            break;
                        }
                        case 2: {
                            view.setVisibility(8);
                        }
                    }
                    group.addView(view);
                }
            }
        }
        LayoutInflater.consumeChildElements(parser);
    }

    static final void consumeChildElements(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        int currentDepth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > currentDepth) && type != 1) {
        }
    }

    private static class BlinkLayout
    extends FrameLayout {
        private static final int MESSAGE_BLINK = 66;
        private static final int BLINK_DELAY = 500;
        private boolean mBlink;
        private boolean mBlinkState;
        private final Handler mHandler = new Handler(new Handler.Callback(){

            @Override
            public boolean handleMessage(Message msg) {
                if (msg.what == 66) {
                    if (mBlink) {
                        mBlinkState = !mBlinkState;
                        this.makeBlink();
                    }
                    this.invalidate();
                    return true;
                }
                return false;
            }
        });

        public BlinkLayout(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        private void makeBlink() {
            Message message = this.mHandler.obtainMessage(66);
            this.mHandler.sendMessageDelayed(message, 500L);
        }

        @Override
        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            this.mBlink = true;
            this.mBlinkState = true;
            this.makeBlink();
        }

        @Override
        protected void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            this.mBlink = false;
            this.mBlinkState = true;
            this.mHandler.removeMessages(66);
        }

        @Override
        protected void dispatchDraw(Canvas canvas) {
            if (this.mBlinkState) {
                super.dispatchDraw(canvas);
            }
        }
    }

    private static class FactoryMerger
    implements Factory2 {
        private final Factory mF1;
        private final Factory mF2;
        private final Factory2 mF12;
        private final Factory2 mF22;

        FactoryMerger(Factory f1, Factory2 f12, Factory f2, Factory2 f22) {
            this.mF1 = f1;
            this.mF2 = f2;
            this.mF12 = f12;
            this.mF22 = f22;
        }

        @Override
        public View onCreateView(String name, Context context, AttributeSet attrs) {
            View v = this.mF1.onCreateView(name, context, attrs);
            if (v != null) {
                return v;
            }
            return this.mF2.onCreateView(name, context, attrs);
        }

        @Override
        public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
            View v;
            View view = v = this.mF12 != null ? this.mF12.onCreateView(parent, name, context, attrs) : this.mF1.onCreateView(name, context, attrs);
            if (v != null) {
                return v;
            }
            return this.mF22 != null ? this.mF22.onCreateView(parent, name, context, attrs) : this.mF2.onCreateView(name, context, attrs);
        }
    }

    public static interface Factory2
    extends Factory {
        public View onCreateView(View var1, String var2, Context var3, AttributeSet var4);
    }

    public static interface Factory {
        public View onCreateView(String var1, Context var2, AttributeSet var3);
    }

    public static interface Filter {
        public boolean onLoadClass(Class var1);
    }
}

