/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.UnsupportedAppUsage;
import android.app.WindowConfiguration;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import android.util.SparseArray;
import android.view.RemoteAnimationAdapter;

public class RemoteAnimationDefinition
implements Parcelable {
    private final SparseArray<RemoteAnimationAdapterEntry> mTransitionAnimationMap;
    public static final Parcelable.Creator<RemoteAnimationDefinition> CREATOR = new Parcelable.Creator<RemoteAnimationDefinition>(){

        @Override
        public RemoteAnimationDefinition createFromParcel(Parcel in) {
            return new RemoteAnimationDefinition(in);
        }

        public RemoteAnimationDefinition[] newArray(int size) {
            return new RemoteAnimationDefinition[size];
        }
    };

    @UnsupportedAppUsage
    public RemoteAnimationDefinition() {
        this.mTransitionAnimationMap = new SparseArray();
    }

    @UnsupportedAppUsage
    public void addRemoteAnimation(int transition2, @WindowConfiguration.ActivityType int activityTypeFilter, RemoteAnimationAdapter adapter) {
        this.mTransitionAnimationMap.put(transition2, new RemoteAnimationAdapterEntry(adapter, activityTypeFilter));
    }

    @UnsupportedAppUsage
    public void addRemoteAnimation(int transition2, RemoteAnimationAdapter adapter) {
        this.addRemoteAnimation(transition2, 0, adapter);
    }

    public boolean hasTransition(int transition2, ArraySet<Integer> activityTypes) {
        return this.getAdapter(transition2, activityTypes) != null;
    }

    public RemoteAnimationAdapter getAdapter(int transition2, ArraySet<Integer> activityTypes) {
        RemoteAnimationAdapterEntry entry = this.mTransitionAnimationMap.get(transition2);
        if (entry == null) {
            return null;
        }
        if (entry.activityTypeFilter == 0 || activityTypes.contains(entry.activityTypeFilter)) {
            return entry.adapter;
        }
        return null;
    }

    public RemoteAnimationDefinition(Parcel in) {
        int size = in.readInt();
        this.mTransitionAnimationMap = new SparseArray(size);
        for (int i = 0; i < size; ++i) {
            int transition2 = in.readInt();
            RemoteAnimationAdapterEntry entry = (RemoteAnimationAdapterEntry)in.readTypedObject(RemoteAnimationAdapterEntry.CREATOR);
            this.mTransitionAnimationMap.put(transition2, entry);
        }
    }

    public void setCallingPid(int pid) {
        for (int i = this.mTransitionAnimationMap.size() - 1; i >= 0; --i) {
            this.mTransitionAnimationMap.valueAt((int)i).adapter.setCallingPid(pid);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        int size = this.mTransitionAnimationMap.size();
        dest.writeInt(size);
        for (int i = 0; i < size; ++i) {
            dest.writeInt(this.mTransitionAnimationMap.keyAt(i));
            dest.writeTypedObject(this.mTransitionAnimationMap.valueAt(i), flags);
        }
    }

    private static class RemoteAnimationAdapterEntry
    implements Parcelable {
        final RemoteAnimationAdapter adapter;
        @WindowConfiguration.ActivityType
        final int activityTypeFilter;
        private static final Parcelable.Creator<RemoteAnimationAdapterEntry> CREATOR = new Parcelable.Creator<RemoteAnimationAdapterEntry>(){

            @Override
            public RemoteAnimationAdapterEntry createFromParcel(Parcel in) {
                return new RemoteAnimationAdapterEntry(in);
            }

            public RemoteAnimationAdapterEntry[] newArray(int size) {
                return new RemoteAnimationAdapterEntry[size];
            }
        };

        RemoteAnimationAdapterEntry(RemoteAnimationAdapter adapter, int activityTypeFilter) {
            this.adapter = adapter;
            this.activityTypeFilter = activityTypeFilter;
        }

        private RemoteAnimationAdapterEntry(Parcel in) {
            this.adapter = (RemoteAnimationAdapter)in.readParcelable(RemoteAnimationAdapter.class.getClassLoader());
            this.activityTypeFilter = in.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable(this.adapter, flags);
            dest.writeInt(this.activityTypeFilter);
        }

        @Override
        public int describeContents() {
            return 0;
        }
    }
}

