/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.UnsupportedAppUsage;
import android.graphics.CanvasProperty;
import android.graphics.Paint;
import android.graphics.RecordingCanvas;
import android.graphics.RenderNode;
import android.os.Handler;
import android.os.Looper;
import android.util.SparseIntArray;
import android.view.Choreographer;
import android.view.DisplayListCanvas;
import android.view.View;
import com.android.internal.util.VirtualRefBasePtr;
import com.android.internal.view.animation.FallbackLUTInterpolator;
import com.android.internal.view.animation.HasNativeInterpolator;
import com.android.internal.view.animation.NativeInterpolatorFactory;
import java.util.ArrayList;

public class RenderNodeAnimator
extends Animator {
    public static final int TRANSLATION_X = 0;
    public static final int TRANSLATION_Y = 1;
    public static final int TRANSLATION_Z = 2;
    public static final int SCALE_X = 3;
    public static final int SCALE_Y = 4;
    public static final int ROTATION = 5;
    public static final int ROTATION_X = 6;
    public static final int ROTATION_Y = 7;
    public static final int X = 8;
    public static final int Y = 9;
    public static final int Z = 10;
    public static final int ALPHA = 11;
    public static final int LAST_VALUE = 11;
    public static final int PAINT_STROKE_WIDTH = 0;
    public static final int PAINT_ALPHA = 1;
    private static final SparseIntArray sViewPropertyAnimatorMap = new SparseIntArray(15){
        {
            this.put(1, 0);
            this.put(2, 1);
            this.put(4, 2);
            this.put(8, 3);
            this.put(16, 4);
            this.put(32, 5);
            this.put(64, 6);
            this.put(128, 7);
            this.put(256, 8);
            this.put(512, 9);
            this.put(1024, 10);
            this.put(2048, 11);
        }
    };
    private VirtualRefBasePtr mNativePtr;
    private Handler mHandler;
    private RenderNode mTarget;
    private View mViewTarget;
    private int mRenderProperty = -1;
    private float mFinalValue;
    private TimeInterpolator mInterpolator;
    private static final int STATE_PREPARE = 0;
    private static final int STATE_DELAYED = 1;
    private static final int STATE_RUNNING = 2;
    private static final int STATE_FINISHED = 3;
    private int mState = 0;
    private long mUnscaledDuration = 300L;
    private long mUnscaledStartDelay = 0L;
    private final boolean mUiThreadHandlesDelay;
    private long mStartDelay = 0L;
    private long mStartTime;
    private static ThreadLocal<DelayedAnimationHelper> sAnimationHelper = new ThreadLocal();

    @UnsupportedAppUsage
    public static int mapViewPropertyToRenderProperty(int viewProperty) {
        return sViewPropertyAnimatorMap.get(viewProperty);
    }

    @UnsupportedAppUsage
    public RenderNodeAnimator(int property, float finalValue) {
        this.mRenderProperty = property;
        this.mFinalValue = finalValue;
        this.mUiThreadHandlesDelay = true;
        this.init(RenderNodeAnimator.nCreateAnimator(property, finalValue));
    }

    @UnsupportedAppUsage
    public RenderNodeAnimator(CanvasProperty<Float> property, float finalValue) {
        this.init(RenderNodeAnimator.nCreateCanvasPropertyFloatAnimator(property.getNativeContainer(), finalValue));
        this.mUiThreadHandlesDelay = false;
    }

    @UnsupportedAppUsage
    public RenderNodeAnimator(CanvasProperty<Paint> property, int paintField, float finalValue) {
        this.init(RenderNodeAnimator.nCreateCanvasPropertyPaintAnimator(property.getNativeContainer(), paintField, finalValue));
        this.mUiThreadHandlesDelay = false;
    }

    public RenderNodeAnimator(int x, int y, float startRadius, float endRadius) {
        this.init(RenderNodeAnimator.nCreateRevealAnimator(x, y, startRadius, endRadius));
        this.mUiThreadHandlesDelay = true;
    }

    private void init(long ptr) {
        this.mNativePtr = new VirtualRefBasePtr(ptr);
    }

    private void checkMutable() {
        if (this.mState != 0) {
            throw new IllegalStateException("Animator has already started, cannot change it now!");
        }
        if (this.mNativePtr == null) {
            throw new IllegalStateException("Animator's target has been destroyed (trying to modify an animation after activity destroy?)");
        }
    }

    static boolean isNativeInterpolator(TimeInterpolator interpolator2) {
        return interpolator2.getClass().isAnnotationPresent(HasNativeInterpolator.class);
    }

    private void applyInterpolator() {
        long ni;
        if (this.mInterpolator == null || this.mNativePtr == null) {
            return;
        }
        if (RenderNodeAnimator.isNativeInterpolator(this.mInterpolator)) {
            ni = ((NativeInterpolatorFactory)((Object)this.mInterpolator)).createNativeInterpolator();
        } else {
            long duration = RenderNodeAnimator.nGetDuration(this.mNativePtr.get());
            ni = FallbackLUTInterpolator.createNativeInterpolator(this.mInterpolator, duration);
        }
        RenderNodeAnimator.nSetInterpolator(this.mNativePtr.get(), ni);
    }

    @Override
    public void start() {
        if (this.mTarget == null) {
            throw new IllegalStateException("Missing target!");
        }
        if (this.mState != 0) {
            throw new IllegalStateException("Already started!");
        }
        this.mState = 1;
        if (this.mHandler == null) {
            this.mHandler = new Handler(true);
        }
        this.applyInterpolator();
        if (this.mNativePtr == null) {
            this.cancel();
        } else if (this.mStartDelay <= 0L || !this.mUiThreadHandlesDelay) {
            RenderNodeAnimator.nSetStartDelay(this.mNativePtr.get(), this.mStartDelay);
            this.doStart();
        } else {
            RenderNodeAnimator.getHelper().addDelayedAnimation(this);
        }
    }

    private void doStart() {
        if (this.mRenderProperty == 11) {
            this.mViewTarget.ensureTransformationInfo();
            this.mViewTarget.setAlphaInternal(this.mFinalValue);
        }
        this.moveToRunningState();
        if (this.mViewTarget != null) {
            this.mViewTarget.invalidateViewProperty(true, false);
        }
    }

    private void moveToRunningState() {
        this.mState = 2;
        if (this.mNativePtr != null) {
            RenderNodeAnimator.nStart(this.mNativePtr.get());
        }
        this.notifyStartListeners();
    }

    private void notifyStartListeners() {
        ArrayList<Animator.AnimatorListener> listeners = this.cloneListeners();
        int numListeners = listeners == null ? 0 : listeners.size();
        for (int i = 0; i < numListeners; ++i) {
            listeners.get(i).onAnimationStart(this);
        }
    }

    @Override
    public void cancel() {
        if (this.mState != 0 && this.mState != 3) {
            ArrayList<Animator.AnimatorListener> listeners;
            if (this.mState == 1) {
                RenderNodeAnimator.getHelper().removeDelayedAnimation(this);
                this.moveToRunningState();
            }
            int numListeners = (listeners = this.cloneListeners()) == null ? 0 : listeners.size();
            for (int i = 0; i < numListeners; ++i) {
                listeners.get(i).onAnimationCancel(this);
            }
            this.end();
        }
    }

    @Override
    public void end() {
        if (this.mState != 3) {
            if (this.mState < 2) {
                RenderNodeAnimator.getHelper().removeDelayedAnimation(this);
                this.doStart();
            }
            if (this.mNativePtr != null) {
                RenderNodeAnimator.nEnd(this.mNativePtr.get());
                if (this.mViewTarget != null) {
                    this.mViewTarget.invalidateViewProperty(true, false);
                }
            } else {
                this.onFinished();
            }
        }
    }

    @Override
    public void pause() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resume() {
        throw new UnsupportedOperationException();
    }

    @UnsupportedAppUsage
    public void setTarget(View view) {
        this.mViewTarget = view;
        this.setTarget(this.mViewTarget.mRenderNode);
    }

    public void setTarget(RecordingCanvas canvas) {
        this.setTarget(canvas.mNode);
    }

    @UnsupportedAppUsage
    public void setTarget(DisplayListCanvas canvas) {
        this.setTarget((RecordingCanvas)canvas);
    }

    private void setTarget(RenderNode node) {
        this.checkMutable();
        if (this.mTarget != null) {
            throw new IllegalStateException("Target already set!");
        }
        RenderNodeAnimator.nSetListener(this.mNativePtr.get(), this);
        this.mTarget = node;
        this.mTarget.addAnimator(this);
    }

    @UnsupportedAppUsage
    public void setStartValue(float startValue) {
        this.checkMutable();
        RenderNodeAnimator.nSetStartValue(this.mNativePtr.get(), startValue);
    }

    @Override
    public void setStartDelay(long startDelay) {
        this.checkMutable();
        if (startDelay < 0L) {
            throw new IllegalArgumentException("startDelay must be positive; " + startDelay);
        }
        this.mUnscaledStartDelay = startDelay;
        this.mStartDelay = (long)(ValueAnimator.getDurationScale() * (float)startDelay);
    }

    @Override
    public long getStartDelay() {
        return this.mUnscaledStartDelay;
    }

    @Override
    @UnsupportedAppUsage
    public RenderNodeAnimator setDuration(long duration) {
        this.checkMutable();
        if (duration < 0L) {
            throw new IllegalArgumentException("duration must be positive; " + duration);
        }
        this.mUnscaledDuration = duration;
        RenderNodeAnimator.nSetDuration(this.mNativePtr.get(), (long)((float)duration * ValueAnimator.getDurationScale()));
        return this;
    }

    @Override
    public long getDuration() {
        return this.mUnscaledDuration;
    }

    @Override
    public long getTotalDuration() {
        return this.mUnscaledDuration + this.mUnscaledStartDelay;
    }

    @Override
    public boolean isRunning() {
        return this.mState == 1 || this.mState == 2;
    }

    @Override
    public boolean isStarted() {
        return this.mState != 0;
    }

    @Override
    public void setInterpolator(TimeInterpolator interpolator2) {
        this.checkMutable();
        this.mInterpolator = interpolator2;
    }

    @Override
    public TimeInterpolator getInterpolator() {
        return this.mInterpolator;
    }

    protected void onFinished() {
        if (this.mState == 0) {
            this.releaseNativePtr();
            return;
        }
        if (this.mState == 1) {
            RenderNodeAnimator.getHelper().removeDelayedAnimation(this);
            this.notifyStartListeners();
        }
        this.mState = 3;
        ArrayList<Animator.AnimatorListener> listeners = this.cloneListeners();
        int numListeners = listeners == null ? 0 : listeners.size();
        for (int i = 0; i < numListeners; ++i) {
            listeners.get(i).onAnimationEnd(this);
        }
        this.releaseNativePtr();
    }

    private void releaseNativePtr() {
        if (this.mNativePtr != null) {
            this.mNativePtr.release();
            this.mNativePtr = null;
        }
    }

    private ArrayList<Animator.AnimatorListener> cloneListeners() {
        ArrayList listeners = this.getListeners();
        if (listeners != null) {
            listeners = (ArrayList)listeners.clone();
        }
        return listeners;
    }

    public long getNativeAnimator() {
        return this.mNativePtr.get();
    }

    private boolean processDelayed(long frameTimeMs) {
        if (this.mStartTime == 0L) {
            this.mStartTime = frameTimeMs;
        } else if (frameTimeMs - this.mStartTime >= this.mStartDelay) {
            this.doStart();
            return true;
        }
        return false;
    }

    private static DelayedAnimationHelper getHelper() {
        DelayedAnimationHelper helper = sAnimationHelper.get();
        if (helper == null) {
            helper = new DelayedAnimationHelper();
            sAnimationHelper.set(helper);
        }
        return helper;
    }

    @UnsupportedAppUsage
    private static void callOnFinished(RenderNodeAnimator animator2) {
        if (animator2.mHandler != null) {
            animator2.mHandler.post(animator2::onFinished);
        } else {
            new Handler(Looper.getMainLooper(), null, true).post(animator2::onFinished);
        }
    }

    @Override
    public Animator clone() {
        throw new IllegalStateException("Cannot clone this animator");
    }

    @Override
    public void setAllowRunningAsynchronously(boolean mayRunAsync) {
        this.checkMutable();
        RenderNodeAnimator.nSetAllowRunningAsync(this.mNativePtr.get(), mayRunAsync);
    }

    private static native long nCreateAnimator(int var0, float var1);

    private static native long nCreateCanvasPropertyFloatAnimator(long var0, float var2);

    private static native long nCreateCanvasPropertyPaintAnimator(long var0, int var2, float var3);

    private static native long nCreateRevealAnimator(int var0, int var1, float var2, float var3);

    private static native void nSetStartValue(long var0, float var2);

    private static native void nSetDuration(long var0, long var2);

    private static native long nGetDuration(long var0);

    private static native void nSetStartDelay(long var0, long var2);

    private static native void nSetInterpolator(long var0, long var2);

    private static native void nSetAllowRunningAsync(long var0, boolean var2);

    private static native void nSetListener(long var0, RenderNodeAnimator var2);

    private static native void nStart(long var0);

    private static native void nEnd(long var0);

    private static class DelayedAnimationHelper
    implements Runnable {
        private ArrayList<RenderNodeAnimator> mDelayedAnims = new ArrayList();
        private final Choreographer mChoreographer = Choreographer.getInstance();
        private boolean mCallbackScheduled;

        public void addDelayedAnimation(RenderNodeAnimator animator2) {
            this.mDelayedAnims.add(animator2);
            this.scheduleCallback();
        }

        public void removeDelayedAnimation(RenderNodeAnimator animator2) {
            this.mDelayedAnims.remove(animator2);
        }

        private void scheduleCallback() {
            if (!this.mCallbackScheduled) {
                this.mCallbackScheduled = true;
                this.mChoreographer.postCallback(1, this, null);
            }
        }

        @Override
        public void run() {
            long frameTimeMs = this.mChoreographer.getFrameTime();
            this.mCallbackScheduled = false;
            int end = 0;
            for (int i = 0; i < this.mDelayedAnims.size(); ++i) {
                RenderNodeAnimator animator2 = this.mDelayedAnims.get(i);
                if (animator2.processDelayed(frameTimeMs)) continue;
                if (end != i) {
                    this.mDelayedAnims.set(end, animator2);
                }
                ++end;
            }
            while (this.mDelayedAnims.size() > end) {
                this.mDelayedAnims.remove(this.mDelayedAnims.size() - 1);
            }
            if (this.mDelayedAnims.size() > 0) {
                this.scheduleCallback();
            }
        }
    }
}

