/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.HardwareRenderer;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.SurfaceTexture;
import com.android.internal.util.VirtualRefBasePtr;

public final class TextureLayer {
    private HardwareRenderer mRenderer;
    private VirtualRefBasePtr mFinalizer;

    private TextureLayer(HardwareRenderer renderer, long deferredUpdater) {
        if (renderer == null || deferredUpdater == 0L) {
            throw new IllegalArgumentException("Either hardware renderer: " + renderer + " or deferredUpdater: " + deferredUpdater + " is invalid");
        }
        this.mRenderer = renderer;
        this.mFinalizer = new VirtualRefBasePtr(deferredUpdater);
    }

    public void setLayerPaint(Paint paint) {
        TextureLayer.nSetLayerPaint(this.mFinalizer.get(), paint != null ? paint.getNativeInstance() : 0L);
        this.mRenderer.pushLayerUpdate(this);
    }

    public boolean isValid() {
        return this.mFinalizer != null && this.mFinalizer.get() != 0L;
    }

    public void destroy() {
        if (!this.isValid()) {
            return;
        }
        this.mRenderer.onLayerDestroyed(this);
        this.mRenderer = null;
        this.mFinalizer.release();
        this.mFinalizer = null;
    }

    public long getDeferredLayerUpdater() {
        return this.mFinalizer.get();
    }

    public boolean copyInto(Bitmap bitmap) {
        return this.mRenderer.copyLayerInto(this, bitmap);
    }

    public boolean prepare(int width, int height, boolean isOpaque) {
        return TextureLayer.nPrepare(this.mFinalizer.get(), width, height, isOpaque);
    }

    public void setTransform(Matrix matrix) {
        TextureLayer.nSetTransform(this.mFinalizer.get(), matrix.native_instance);
        this.mRenderer.pushLayerUpdate(this);
    }

    public void detachSurfaceTexture() {
        this.mRenderer.detachSurfaceTexture(this.mFinalizer.get());
    }

    public long getLayerHandle() {
        return this.mFinalizer.get();
    }

    public void setSurfaceTexture(SurfaceTexture surface) {
        TextureLayer.nSetSurfaceTexture(this.mFinalizer.get(), surface);
        this.mRenderer.pushLayerUpdate(this);
    }

    public void updateSurfaceTexture() {
        TextureLayer.nUpdateSurfaceTexture(this.mFinalizer.get());
        this.mRenderer.pushLayerUpdate(this);
    }

    public static TextureLayer adoptTextureLayer(HardwareRenderer renderer, long layer) {
        return new TextureLayer(renderer, layer);
    }

    private static native boolean nPrepare(long var0, int var2, int var3, boolean var4);

    private static native void nSetLayerPaint(long var0, long var2);

    private static native void nSetTransform(long var0, long var2);

    private static native void nSetSurfaceTexture(long var0, SurfaceTexture var2);

    private static native void nUpdateSurfaceTexture(long var0);
}

