/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.RenderNode;
import android.view.View;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class ViewPropertyAnimator {
    final View mView;
    private long mDuration;
    private boolean mDurationSet = false;
    private long mStartDelay = 0L;
    private boolean mStartDelaySet = false;
    private TimeInterpolator mInterpolator;
    private boolean mInterpolatorSet = false;
    private Animator.AnimatorListener mListener = null;
    private ValueAnimator.AnimatorUpdateListener mUpdateListener = null;
    private ValueAnimator mTempValueAnimator;
    private AnimatorEventListener mAnimatorEventListener = new AnimatorEventListener();
    ArrayList<NameValuesHolder> mPendingAnimations = new ArrayList();
    private Runnable mPendingSetupAction;
    private Runnable mPendingCleanupAction;
    private Runnable mPendingOnStartAction;
    private Runnable mPendingOnEndAction;
    static final int NONE = 0;
    static final int TRANSLATION_X = 1;
    static final int TRANSLATION_Y = 2;
    static final int TRANSLATION_Z = 4;
    static final int SCALE_X = 8;
    static final int SCALE_Y = 16;
    static final int ROTATION = 32;
    static final int ROTATION_X = 64;
    static final int ROTATION_Y = 128;
    static final int X = 256;
    static final int Y = 512;
    static final int Z = 1024;
    static final int ALPHA = 2048;
    private static final int TRANSFORM_MASK = 2047;
    private Runnable mAnimationStarter = new Runnable(){

        @Override
        public void run() {
            ViewPropertyAnimator.this.startAnimation();
        }
    };
    private HashMap<Animator, PropertyBundle> mAnimatorMap = new HashMap();
    private HashMap<Animator, Runnable> mAnimatorSetupMap;
    private HashMap<Animator, Runnable> mAnimatorCleanupMap;
    private HashMap<Animator, Runnable> mAnimatorOnStartMap;
    private HashMap<Animator, Runnable> mAnimatorOnEndMap;

    ViewPropertyAnimator(View view) {
        this.mView = view;
        view.ensureTransformationInfo();
    }

    public ViewPropertyAnimator setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + duration);
        }
        this.mDurationSet = true;
        this.mDuration = duration;
        return this;
    }

    public long getDuration() {
        if (this.mDurationSet) {
            return this.mDuration;
        }
        if (this.mTempValueAnimator == null) {
            this.mTempValueAnimator = new ValueAnimator();
        }
        return this.mTempValueAnimator.getDuration();
    }

    public long getStartDelay() {
        if (this.mStartDelaySet) {
            return this.mStartDelay;
        }
        return 0L;
    }

    public ViewPropertyAnimator setStartDelay(long startDelay) {
        if (startDelay < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative start delay: " + startDelay);
        }
        this.mStartDelaySet = true;
        this.mStartDelay = startDelay;
        return this;
    }

    public ViewPropertyAnimator setInterpolator(TimeInterpolator interpolator2) {
        this.mInterpolatorSet = true;
        this.mInterpolator = interpolator2;
        return this;
    }

    public TimeInterpolator getInterpolator() {
        if (this.mInterpolatorSet) {
            return this.mInterpolator;
        }
        if (this.mTempValueAnimator == null) {
            this.mTempValueAnimator = new ValueAnimator();
        }
        return this.mTempValueAnimator.getInterpolator();
    }

    public ViewPropertyAnimator setListener(Animator.AnimatorListener listener) {
        this.mListener = listener;
        return this;
    }

    Animator.AnimatorListener getListener() {
        return this.mListener;
    }

    public ViewPropertyAnimator setUpdateListener(ValueAnimator.AnimatorUpdateListener listener) {
        this.mUpdateListener = listener;
        return this;
    }

    ValueAnimator.AnimatorUpdateListener getUpdateListener() {
        return this.mUpdateListener;
    }

    public void start() {
        this.mView.removeCallbacks(this.mAnimationStarter);
        this.startAnimation();
    }

    public void cancel() {
        if (this.mAnimatorMap.size() > 0) {
            HashMap mAnimatorMapCopy = (HashMap)this.mAnimatorMap.clone();
            Set animatorSet = mAnimatorMapCopy.keySet();
            for (Animator runningAnim : animatorSet) {
                runningAnim.cancel();
            }
        }
        this.mPendingAnimations.clear();
        this.mPendingSetupAction = null;
        this.mPendingCleanupAction = null;
        this.mPendingOnStartAction = null;
        this.mPendingOnEndAction = null;
        this.mView.removeCallbacks(this.mAnimationStarter);
    }

    public ViewPropertyAnimator x(float value) {
        this.animateProperty(256, value);
        return this;
    }

    public ViewPropertyAnimator xBy(float value) {
        this.animatePropertyBy(256, value);
        return this;
    }

    public ViewPropertyAnimator y(float value) {
        this.animateProperty(512, value);
        return this;
    }

    public ViewPropertyAnimator yBy(float value) {
        this.animatePropertyBy(512, value);
        return this;
    }

    public ViewPropertyAnimator z(float value) {
        this.animateProperty(1024, value);
        return this;
    }

    public ViewPropertyAnimator zBy(float value) {
        this.animatePropertyBy(1024, value);
        return this;
    }

    public ViewPropertyAnimator rotation(float value) {
        this.animateProperty(32, value);
        return this;
    }

    public ViewPropertyAnimator rotationBy(float value) {
        this.animatePropertyBy(32, value);
        return this;
    }

    public ViewPropertyAnimator rotationX(float value) {
        this.animateProperty(64, value);
        return this;
    }

    public ViewPropertyAnimator rotationXBy(float value) {
        this.animatePropertyBy(64, value);
        return this;
    }

    public ViewPropertyAnimator rotationY(float value) {
        this.animateProperty(128, value);
        return this;
    }

    public ViewPropertyAnimator rotationYBy(float value) {
        this.animatePropertyBy(128, value);
        return this;
    }

    public ViewPropertyAnimator translationX(float value) {
        this.animateProperty(1, value);
        return this;
    }

    public ViewPropertyAnimator translationXBy(float value) {
        this.animatePropertyBy(1, value);
        return this;
    }

    public ViewPropertyAnimator translationY(float value) {
        this.animateProperty(2, value);
        return this;
    }

    public ViewPropertyAnimator translationYBy(float value) {
        this.animatePropertyBy(2, value);
        return this;
    }

    public ViewPropertyAnimator translationZ(float value) {
        this.animateProperty(4, value);
        return this;
    }

    public ViewPropertyAnimator translationZBy(float value) {
        this.animatePropertyBy(4, value);
        return this;
    }

    public ViewPropertyAnimator scaleX(float value) {
        this.animateProperty(8, value);
        return this;
    }

    public ViewPropertyAnimator scaleXBy(float value) {
        this.animatePropertyBy(8, value);
        return this;
    }

    public ViewPropertyAnimator scaleY(float value) {
        this.animateProperty(16, value);
        return this;
    }

    public ViewPropertyAnimator scaleYBy(float value) {
        this.animatePropertyBy(16, value);
        return this;
    }

    public ViewPropertyAnimator alpha(float value) {
        this.animateProperty(2048, value);
        return this;
    }

    public ViewPropertyAnimator alphaBy(float value) {
        this.animatePropertyBy(2048, value);
        return this;
    }

    public ViewPropertyAnimator withLayer() {
        this.mPendingSetupAction = new Runnable(){

            @Override
            public void run() {
                ViewPropertyAnimator.this.mView.setLayerType(2, null);
                if (ViewPropertyAnimator.this.mView.isAttachedToWindow()) {
                    ViewPropertyAnimator.this.mView.buildLayer();
                }
            }
        };
        final int currentLayerType = this.mView.getLayerType();
        this.mPendingCleanupAction = new Runnable(){

            @Override
            public void run() {
                ViewPropertyAnimator.this.mView.setLayerType(currentLayerType, null);
            }
        };
        if (this.mAnimatorSetupMap == null) {
            this.mAnimatorSetupMap = new HashMap();
        }
        if (this.mAnimatorCleanupMap == null) {
            this.mAnimatorCleanupMap = new HashMap();
        }
        return this;
    }

    public ViewPropertyAnimator withStartAction(Runnable runnable) {
        this.mPendingOnStartAction = runnable;
        if (runnable != null && this.mAnimatorOnStartMap == null) {
            this.mAnimatorOnStartMap = new HashMap();
        }
        return this;
    }

    public ViewPropertyAnimator withEndAction(Runnable runnable) {
        this.mPendingOnEndAction = runnable;
        if (runnable != null && this.mAnimatorOnEndMap == null) {
            this.mAnimatorOnEndMap = new HashMap();
        }
        return this;
    }

    boolean hasActions() {
        return this.mPendingSetupAction != null || this.mPendingCleanupAction != null || this.mPendingOnStartAction != null || this.mPendingOnEndAction != null;
    }

    private void startAnimation() {
        this.mView.setHasTransientState(true);
        ValueAnimator animator2 = ValueAnimator.ofFloat(1.0f);
        ArrayList nameValueList = (ArrayList)this.mPendingAnimations.clone();
        this.mPendingAnimations.clear();
        int propertyMask = 0;
        int propertyCount = nameValueList.size();
        for (int i = 0; i < propertyCount; ++i) {
            NameValuesHolder nameValuesHolder = (NameValuesHolder)nameValueList.get(i);
            propertyMask |= nameValuesHolder.mNameConstant;
        }
        this.mAnimatorMap.put(animator2, new PropertyBundle(propertyMask, nameValueList));
        if (this.mPendingSetupAction != null) {
            this.mAnimatorSetupMap.put(animator2, this.mPendingSetupAction);
            this.mPendingSetupAction = null;
        }
        if (this.mPendingCleanupAction != null) {
            this.mAnimatorCleanupMap.put(animator2, this.mPendingCleanupAction);
            this.mPendingCleanupAction = null;
        }
        if (this.mPendingOnStartAction != null) {
            this.mAnimatorOnStartMap.put(animator2, this.mPendingOnStartAction);
            this.mPendingOnStartAction = null;
        }
        if (this.mPendingOnEndAction != null) {
            this.mAnimatorOnEndMap.put(animator2, this.mPendingOnEndAction);
            this.mPendingOnEndAction = null;
        }
        animator2.addUpdateListener(this.mAnimatorEventListener);
        animator2.addListener(this.mAnimatorEventListener);
        if (this.mStartDelaySet) {
            animator2.setStartDelay(this.mStartDelay);
        }
        if (this.mDurationSet) {
            animator2.setDuration(this.mDuration);
        }
        if (this.mInterpolatorSet) {
            animator2.setInterpolator(this.mInterpolator);
        }
        animator2.start();
    }

    private void animateProperty(int constantName, float toValue) {
        float fromValue = this.getValue(constantName);
        float deltaValue = toValue - fromValue;
        this.animatePropertyBy(constantName, fromValue, deltaValue);
    }

    private void animatePropertyBy(int constantName, float byValue) {
        float fromValue = this.getValue(constantName);
        this.animatePropertyBy(constantName, fromValue, byValue);
    }

    private void animatePropertyBy(int constantName, float startValue, float byValue) {
        if (this.mAnimatorMap.size() > 0) {
            Animator animatorToCancel = null;
            Set<Animator> animatorSet = this.mAnimatorMap.keySet();
            for (Animator runningAnim : animatorSet) {
                PropertyBundle bundle = this.mAnimatorMap.get(runningAnim);
                if (!bundle.cancel(constantName) || bundle.mPropertyMask != 0) continue;
                animatorToCancel = runningAnim;
                break;
            }
            if (animatorToCancel != null) {
                animatorToCancel.cancel();
            }
        }
        NameValuesHolder nameValuePair = new NameValuesHolder(constantName, startValue, byValue);
        this.mPendingAnimations.add(nameValuePair);
        this.mView.removeCallbacks(this.mAnimationStarter);
        this.mView.postOnAnimation(this.mAnimationStarter);
    }

    private void setValue(int propertyConstant, float value) {
        RenderNode renderNode = this.mView.mRenderNode;
        switch (propertyConstant) {
            case 1: {
                renderNode.setTranslationX(value);
                break;
            }
            case 2: {
                renderNode.setTranslationY(value);
                break;
            }
            case 4: {
                renderNode.setTranslationZ(value);
                break;
            }
            case 32: {
                renderNode.setRotationZ(value);
                break;
            }
            case 64: {
                renderNode.setRotationX(value);
                break;
            }
            case 128: {
                renderNode.setRotationY(value);
                break;
            }
            case 8: {
                renderNode.setScaleX(value);
                break;
            }
            case 16: {
                renderNode.setScaleY(value);
                break;
            }
            case 256: {
                renderNode.setTranslationX(value - (float)this.mView.mLeft);
                break;
            }
            case 512: {
                renderNode.setTranslationY(value - (float)this.mView.mTop);
                break;
            }
            case 1024: {
                renderNode.setTranslationZ(value - renderNode.getElevation());
                break;
            }
            case 2048: {
                this.mView.setAlphaInternal(value);
                renderNode.setAlpha(value);
            }
        }
    }

    private float getValue(int propertyConstant) {
        RenderNode node = this.mView.mRenderNode;
        switch (propertyConstant) {
            case 1: {
                return node.getTranslationX();
            }
            case 2: {
                return node.getTranslationY();
            }
            case 4: {
                return node.getTranslationZ();
            }
            case 32: {
                return node.getRotationZ();
            }
            case 64: {
                return node.getRotationX();
            }
            case 128: {
                return node.getRotationY();
            }
            case 8: {
                return node.getScaleX();
            }
            case 16: {
                return node.getScaleY();
            }
            case 256: {
                return (float)this.mView.mLeft + node.getTranslationX();
            }
            case 512: {
                return (float)this.mView.mTop + node.getTranslationY();
            }
            case 1024: {
                return node.getElevation() + node.getTranslationZ();
            }
            case 2048: {
                return this.mView.getAlpha();
            }
        }
        return 0.0f;
    }

    private class AnimatorEventListener
    implements Animator.AnimatorListener,
    ValueAnimator.AnimatorUpdateListener {
        private AnimatorEventListener() {
        }

        @Override
        public void onAnimationStart(Animator animation) {
            Runnable r;
            if (ViewPropertyAnimator.this.mAnimatorSetupMap != null) {
                r = (Runnable)ViewPropertyAnimator.this.mAnimatorSetupMap.get(animation);
                if (r != null) {
                    r.run();
                }
                ViewPropertyAnimator.this.mAnimatorSetupMap.remove(animation);
            }
            if (ViewPropertyAnimator.this.mAnimatorOnStartMap != null) {
                r = (Runnable)ViewPropertyAnimator.this.mAnimatorOnStartMap.get(animation);
                if (r != null) {
                    r.run();
                }
                ViewPropertyAnimator.this.mAnimatorOnStartMap.remove(animation);
            }
            if (ViewPropertyAnimator.this.mListener != null) {
                ViewPropertyAnimator.this.mListener.onAnimationStart(animation);
            }
        }

        @Override
        public void onAnimationCancel(Animator animation) {
            if (ViewPropertyAnimator.this.mListener != null) {
                ViewPropertyAnimator.this.mListener.onAnimationCancel(animation);
            }
            if (ViewPropertyAnimator.this.mAnimatorOnEndMap != null) {
                ViewPropertyAnimator.this.mAnimatorOnEndMap.remove(animation);
            }
        }

        @Override
        public void onAnimationRepeat(Animator animation) {
            if (ViewPropertyAnimator.this.mListener != null) {
                ViewPropertyAnimator.this.mListener.onAnimationRepeat(animation);
            }
        }

        @Override
        public void onAnimationEnd(Animator animation) {
            Runnable r;
            ViewPropertyAnimator.this.mView.setHasTransientState(false);
            if (ViewPropertyAnimator.this.mAnimatorCleanupMap != null) {
                r = (Runnable)ViewPropertyAnimator.this.mAnimatorCleanupMap.get(animation);
                if (r != null) {
                    r.run();
                }
                ViewPropertyAnimator.this.mAnimatorCleanupMap.remove(animation);
            }
            if (ViewPropertyAnimator.this.mListener != null) {
                ViewPropertyAnimator.this.mListener.onAnimationEnd(animation);
            }
            if (ViewPropertyAnimator.this.mAnimatorOnEndMap != null) {
                r = (Runnable)ViewPropertyAnimator.this.mAnimatorOnEndMap.get(animation);
                if (r != null) {
                    r.run();
                }
                ViewPropertyAnimator.this.mAnimatorOnEndMap.remove(animation);
            }
            ViewPropertyAnimator.this.mAnimatorMap.remove(animation);
        }

        @Override
        public void onAnimationUpdate(ValueAnimator animation) {
            ArrayList<NameValuesHolder> valueList;
            PropertyBundle propertyBundle = (PropertyBundle)ViewPropertyAnimator.this.mAnimatorMap.get(animation);
            if (propertyBundle == null) {
                return;
            }
            boolean hardwareAccelerated = ViewPropertyAnimator.this.mView.isHardwareAccelerated();
            if (!hardwareAccelerated) {
                ViewPropertyAnimator.this.mView.invalidateParentCaches();
            }
            float fraction2 = animation.getAnimatedFraction();
            int propertyMask = propertyBundle.mPropertyMask;
            if ((propertyMask & 0x7FF) != 0) {
                ViewPropertyAnimator.this.mView.invalidateViewProperty(hardwareAccelerated, false);
            }
            if ((valueList = propertyBundle.mNameValuesHolder) != null) {
                int count = valueList.size();
                for (int i = 0; i < count; ++i) {
                    NameValuesHolder values = valueList.get(i);
                    float value = values.mFromValue + fraction2 * values.mDeltaValue;
                    ViewPropertyAnimator.this.setValue(values.mNameConstant, value);
                }
            }
            if ((propertyMask & 0x7FF) != 0 && !hardwareAccelerated) {
                ViewPropertyAnimator.this.mView.mPrivateFlags |= 0x20;
            }
            ViewPropertyAnimator.this.mView.invalidateViewProperty(false, false);
            if (ViewPropertyAnimator.this.mUpdateListener != null) {
                ViewPropertyAnimator.this.mUpdateListener.onAnimationUpdate(animation);
            }
        }
    }

    static class NameValuesHolder {
        int mNameConstant;
        float mFromValue;
        float mDeltaValue;

        NameValuesHolder(int nameConstant, float fromValue, float deltaValue) {
            this.mNameConstant = nameConstant;
            this.mFromValue = fromValue;
            this.mDeltaValue = deltaValue;
        }
    }

    private static class PropertyBundle {
        int mPropertyMask;
        ArrayList<NameValuesHolder> mNameValuesHolder;

        PropertyBundle(int propertyMask, ArrayList<NameValuesHolder> nameValuesHolder) {
            this.mPropertyMask = propertyMask;
            this.mNameValuesHolder = nameValuesHolder;
        }

        boolean cancel(int propertyConstant) {
            if ((this.mPropertyMask & propertyConstant) != 0 && this.mNameValuesHolder != null) {
                int count = this.mNameValuesHolder.size();
                for (int i = 0; i < count; ++i) {
                    NameValuesHolder nameValuesHolder = this.mNameValuesHolder.get(i);
                    if (nameValuesHolder.mNameConstant != propertyConstant) continue;
                    this.mNameValuesHolder.remove(i);
                    this.mPropertyMask &= ~propertyConstant;
                    return true;
                }
            }
            return false;
        }
    }
}

