/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.os.Build;
import android.util.ArraySet;
import android.util.Log;
import android.util.LongArray;
import android.util.LongSparseArray;
import android.util.SparseArray;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import java.util.ArrayList;
import java.util.List;

public class AccessibilityCache {
    private static final String LOG_TAG = "AccessibilityCache";
    private static final boolean DEBUG = false;
    private static final boolean CHECK_INTEGRITY = Build.IS_ENG;
    public static final int CACHE_CRITICAL_EVENTS_MASK = 4307005;
    private final Object mLock = new Object();
    private final AccessibilityNodeRefresher mAccessibilityNodeRefresher;
    private long mAccessibilityFocus = Integer.MAX_VALUE;
    private long mInputFocus = Integer.MAX_VALUE;
    private boolean mIsAllWindowsCached;
    private final SparseArray<AccessibilityWindowInfo> mWindowCache = new SparseArray();
    private final SparseArray<LongSparseArray<AccessibilityNodeInfo>> mNodeCache = new SparseArray();
    private final SparseArray<AccessibilityWindowInfo> mTempWindowArray = new SparseArray();

    public AccessibilityCache(AccessibilityNodeRefresher nodeRefresher) {
        this.mAccessibilityNodeRefresher = nodeRefresher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindows(List<AccessibilityWindowInfo> windows) {
        Object object = this.mLock;
        synchronized (object) {
            this.clearWindowCache();
            if (windows == null) {
                return;
            }
            int windowCount = windows.size();
            for (int i = 0; i < windowCount; ++i) {
                AccessibilityWindowInfo window = windows.get(i);
                this.addWindow(window);
            }
            this.mIsAllWindowsCached = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWindow(AccessibilityWindowInfo window) {
        Object object = this.mLock;
        synchronized (object) {
            int windowId = window.getId();
            this.mWindowCache.put(windowId, new AccessibilityWindowInfo(window));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAccessibilityEvent(AccessibilityEvent event) {
        Object object = this.mLock;
        synchronized (object) {
            int eventType = event.getEventType();
            switch (eventType) {
                case 32768: {
                    if (this.mAccessibilityFocus != Integer.MAX_VALUE) {
                        this.refreshCachedNodeLocked(event.getWindowId(), this.mAccessibilityFocus);
                    }
                    this.mAccessibilityFocus = event.getSourceNodeId();
                    this.refreshCachedNodeLocked(event.getWindowId(), this.mAccessibilityFocus);
                    break;
                }
                case 65536: {
                    if (this.mAccessibilityFocus != event.getSourceNodeId()) break;
                    this.refreshCachedNodeLocked(event.getWindowId(), this.mAccessibilityFocus);
                    this.mAccessibilityFocus = Integer.MAX_VALUE;
                    break;
                }
                case 8: {
                    if (this.mInputFocus != Integer.MAX_VALUE) {
                        this.refreshCachedNodeLocked(event.getWindowId(), this.mInputFocus);
                    }
                    this.mInputFocus = event.getSourceNodeId();
                    this.refreshCachedNodeLocked(event.getWindowId(), this.mInputFocus);
                    break;
                }
                case 1: 
                case 4: 
                case 16: 
                case 8192: {
                    this.refreshCachedNodeLocked(event.getWindowId(), event.getSourceNodeId());
                    break;
                }
                case 2048: {
                    Object object2 = this.mLock;
                    synchronized (object2) {
                        int windowId = event.getWindowId();
                        long sourceId = event.getSourceNodeId();
                        if ((event.getContentChangeTypes() & 1) != 0) {
                            this.clearSubTreeLocked(windowId, sourceId);
                        } else {
                            this.refreshCachedNodeLocked(windowId, sourceId);
                        }
                        break;
                    }
                }
                case 4096: {
                    this.clearSubTreeLocked(event.getWindowId(), event.getSourceNodeId());
                    break;
                }
                case 32: 
                case 0x400000: {
                    this.clear();
                }
            }
        }
        if (CHECK_INTEGRITY) {
            this.checkIntegrity();
        }
    }

    private void refreshCachedNodeLocked(int windowId, long sourceId) {
        LongSparseArray<AccessibilityNodeInfo> nodes = this.mNodeCache.get(windowId);
        if (nodes == null) {
            return;
        }
        AccessibilityNodeInfo cachedInfo = nodes.get(sourceId);
        if (cachedInfo == null) {
            return;
        }
        if (this.mAccessibilityNodeRefresher.refreshNode(cachedInfo, true)) {
            return;
        }
        this.clearSubTreeLocked(windowId, sourceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityNodeInfo getNode(int windowId, long accessibilityNodeId) {
        Object object = this.mLock;
        synchronized (object) {
            LongSparseArray<AccessibilityNodeInfo> nodes = this.mNodeCache.get(windowId);
            if (nodes == null) {
                return null;
            }
            AccessibilityNodeInfo info = nodes.get(accessibilityNodeId);
            if (info != null) {
                info = new AccessibilityNodeInfo(info);
            }
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessibilityWindowInfo> getWindows() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mIsAllWindowsCached) {
                return null;
            }
            int windowCount = this.mWindowCache.size();
            if (windowCount > 0) {
                SparseArray<AccessibilityWindowInfo> sortedWindows = this.mTempWindowArray;
                sortedWindows.clear();
                for (int i = 0; i < windowCount; ++i) {
                    AccessibilityWindowInfo window = this.mWindowCache.valueAt(i);
                    sortedWindows.put(window.getLayer(), window);
                }
                int sortedWindowCount = sortedWindows.size();
                ArrayList<AccessibilityWindowInfo> windows = new ArrayList<AccessibilityWindowInfo>(sortedWindowCount);
                for (int i = sortedWindowCount - 1; i >= 0; --i) {
                    AccessibilityWindowInfo window = sortedWindows.valueAt(i);
                    windows.add(new AccessibilityWindowInfo(window));
                    sortedWindows.removeAt(i);
                }
                return windows;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityWindowInfo getWindow(int windowId) {
        Object object = this.mLock;
        synchronized (object) {
            AccessibilityWindowInfo window = this.mWindowCache.get(windowId);
            if (window != null) {
                return new AccessibilityWindowInfo(window);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AccessibilityNodeInfo info) {
        Object object = this.mLock;
        synchronized (object) {
            long sourceId;
            AccessibilityNodeInfo oldInfo;
            int windowId = info.getWindowId();
            LongSparseArray<AccessibilityNodeInfo> nodes = this.mNodeCache.get(windowId);
            if (nodes == null) {
                nodes = new LongSparseArray();
                this.mNodeCache.put(windowId, nodes);
            }
            if ((oldInfo = nodes.get(sourceId = info.getSourceNodeId())) != null) {
                LongArray newChildrenIds = info.getChildNodeIds();
                int oldChildCount = oldInfo.getChildCount();
                for (int i = 0; i < oldChildCount; ++i) {
                    long oldChildId = oldInfo.getChildId(i);
                    if (newChildrenIds == null || newChildrenIds.indexOf(oldChildId) < 0) {
                        this.clearSubTreeLocked(windowId, oldChildId);
                    }
                    if (nodes.get(sourceId) != null) continue;
                    this.clearNodesForWindowLocked(windowId);
                    return;
                }
                long oldParentId = oldInfo.getParentNodeId();
                if (info.getParentNodeId() != oldParentId) {
                    this.clearSubTreeLocked(windowId, oldParentId);
                }
            }
            AccessibilityNodeInfo clone = new AccessibilityNodeInfo(info);
            nodes.put(sourceId, clone);
            if (clone.isAccessibilityFocused()) {
                if (this.mAccessibilityFocus != Integer.MAX_VALUE && this.mAccessibilityFocus != sourceId) {
                    this.refreshCachedNodeLocked(windowId, this.mAccessibilityFocus);
                }
                this.mAccessibilityFocus = sourceId;
            } else if (this.mAccessibilityFocus == sourceId) {
                this.mAccessibilityFocus = Integer.MAX_VALUE;
            }
            if (clone.isFocused()) {
                this.mInputFocus = sourceId;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            this.clearWindowCache();
            int nodesForWindowCount = this.mNodeCache.size();
            for (int i = nodesForWindowCount - 1; i >= 0; --i) {
                int windowId = this.mNodeCache.keyAt(i);
                this.clearNodesForWindowLocked(windowId);
            }
            this.mAccessibilityFocus = Integer.MAX_VALUE;
            this.mInputFocus = Integer.MAX_VALUE;
        }
    }

    private void clearWindowCache() {
        this.mWindowCache.clear();
        this.mIsAllWindowsCached = false;
    }

    private void clearNodesForWindowLocked(int windowId) {
        LongSparseArray<AccessibilityNodeInfo> nodes = this.mNodeCache.get(windowId);
        if (nodes == null) {
            return;
        }
        this.mNodeCache.remove(windowId);
    }

    private void clearSubTreeLocked(int windowId, long rootNodeId) {
        LongSparseArray<AccessibilityNodeInfo> nodes = this.mNodeCache.get(windowId);
        if (nodes != null) {
            this.clearSubTreeRecursiveLocked(nodes, rootNodeId);
        }
    }

    private boolean clearSubTreeRecursiveLocked(LongSparseArray<AccessibilityNodeInfo> nodes, long rootNodeId) {
        AccessibilityNodeInfo current = nodes.get(rootNodeId);
        if (current == null) {
            this.clear();
            return true;
        }
        nodes.remove(rootNodeId);
        int childCount = current.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            long childNodeId = current.getChildId(i);
            if (!this.clearSubTreeRecursiveLocked(nodes, childNodeId)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIntegrity() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mWindowCache.size() <= 0 && this.mNodeCache.size() == 0) {
                return;
            }
            AccessibilityWindowInfo focusedWindow = null;
            AccessibilityWindowInfo activeWindow = null;
            int windowCount = this.mWindowCache.size();
            for (int i = 0; i < windowCount; ++i) {
                AccessibilityWindowInfo window = this.mWindowCache.valueAt(i);
                if (window.isActive()) {
                    if (activeWindow != null) {
                        Log.e(LOG_TAG, "Duplicate active window:" + window);
                    } else {
                        activeWindow = window;
                    }
                }
                if (!window.isFocused()) continue;
                if (focusedWindow != null) {
                    Log.e(LOG_TAG, "Duplicate focused window:" + window);
                    continue;
                }
                focusedWindow = window;
            }
            AccessibilityNodeInfo accessFocus = null;
            AccessibilityNodeInfo inputFocus = null;
            int nodesForWindowCount = this.mNodeCache.size();
            for (int i = 0; i < nodesForWindowCount; ++i) {
                LongSparseArray<AccessibilityNodeInfo> nodes = this.mNodeCache.valueAt(i);
                if (nodes.size() <= 0) continue;
                ArraySet<AccessibilityNodeInfo> seen = new ArraySet<AccessibilityNodeInfo>();
                int windowId = this.mNodeCache.keyAt(i);
                int nodeCount = nodes.size();
                for (int j = 0; j < nodeCount; ++j) {
                    AccessibilityNodeInfo nodeParent;
                    AccessibilityNodeInfo node = nodes.valueAt(j);
                    if (!seen.add(node)) {
                        Log.e(LOG_TAG, "Duplicate node: " + node + " in window:" + windowId);
                        continue;
                    }
                    if (node.isAccessibilityFocused()) {
                        if (accessFocus != null) {
                            Log.e(LOG_TAG, "Duplicate accessibility focus:" + node + " in window:" + windowId);
                        } else {
                            accessFocus = node;
                        }
                    }
                    if (node.isFocused()) {
                        if (inputFocus != null) {
                            Log.e(LOG_TAG, "Duplicate input focus: " + node + " in window:" + windowId);
                        } else {
                            inputFocus = node;
                        }
                    }
                    if ((nodeParent = nodes.get(node.getParentNodeId())) != null) {
                        boolean childOfItsParent = false;
                        int childCount = nodeParent.getChildCount();
                        for (int k = 0; k < childCount; ++k) {
                            AccessibilityNodeInfo child = nodes.get(nodeParent.getChildId(k));
                            if (child != node) continue;
                            childOfItsParent = true;
                            break;
                        }
                        if (!childOfItsParent) {
                            Log.e(LOG_TAG, "Invalid parent-child relation between parent: " + nodeParent + " and child: " + node);
                        }
                    }
                    int childCount = node.getChildCount();
                    for (int k = 0; k < childCount; ++k) {
                        AccessibilityNodeInfo parent;
                        AccessibilityNodeInfo child = nodes.get(node.getChildId(k));
                        if (child == null || (parent = nodes.get(child.getParentNodeId())) == node) continue;
                        Log.e(LOG_TAG, "Invalid child-parent relation between child: " + node + " and parent: " + nodeParent);
                    }
                }
            }
        }
    }

    public static class AccessibilityNodeRefresher {
        public boolean refreshNode(AccessibilityNodeInfo info, boolean bypassCache) {
            return info.refresh(null, bypassCache);
        }
    }
}

