/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.view.View;
import android.view.accessibility.WeakSparseArray;

public final class AccessibilityNodeIdManager {
    private WeakSparseArray<View> mIdsToViews = new WeakSparseArray();
    private static AccessibilityNodeIdManager sIdManager;

    public static synchronized AccessibilityNodeIdManager getInstance() {
        if (sIdManager == null) {
            sIdManager = new AccessibilityNodeIdManager();
        }
        return sIdManager;
    }

    private AccessibilityNodeIdManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerViewWithId(View view, int id2) {
        WeakSparseArray<View> weakSparseArray = this.mIdsToViews;
        synchronized (weakSparseArray) {
            this.mIdsToViews.append(id2, view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterViewWithId(int id2) {
        WeakSparseArray<View> weakSparseArray = this.mIdsToViews;
        synchronized (weakSparseArray) {
            this.mIdsToViews.remove(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View findView(int id2) {
        View view = null;
        WeakSparseArray<View> weakSparseArray = this.mIdsToViews;
        synchronized (weakSparseArray) {
            view = this.mIdsToViews.get(id2);
        }
        return view != null && view.includeForAccessibility() ? view : null;
    }
}

