/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.annotation.UnsupportedAppUsage;
import android.os.Parcelable;
import android.view.View;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import java.util.ArrayList;
import java.util.List;

public class AccessibilityRecord {
    protected static final boolean DEBUG_CONCISE_TOSTRING = false;
    private static final int UNDEFINED = -1;
    private static final int PROPERTY_CHECKED = 1;
    private static final int PROPERTY_ENABLED = 2;
    private static final int PROPERTY_PASSWORD = 4;
    private static final int PROPERTY_FULL_SCREEN = 128;
    private static final int PROPERTY_SCROLLABLE = 256;
    private static final int PROPERTY_IMPORTANT_FOR_ACCESSIBILITY = 512;
    private static final int GET_SOURCE_PREFETCH_FLAGS = 7;
    private static final int MAX_POOL_SIZE = 10;
    private static final Object sPoolLock = new Object();
    private static AccessibilityRecord sPool;
    private static int sPoolSize;
    private AccessibilityRecord mNext;
    private boolean mIsInPool;
    @UnsupportedAppUsage
    boolean mSealed;
    int mBooleanProperties = 0;
    int mCurrentItemIndex = -1;
    int mItemCount = -1;
    int mFromIndex = -1;
    int mToIndex = -1;
    int mScrollX = -1;
    int mScrollY = -1;
    int mScrollDeltaX = -1;
    int mScrollDeltaY = -1;
    int mMaxScrollX = -1;
    int mMaxScrollY = -1;
    int mAddedCount = -1;
    int mRemovedCount = -1;
    @UnsupportedAppUsage
    long mSourceNodeId = AccessibilityNodeInfo.UNDEFINED_NODE_ID;
    int mSourceWindowId = -1;
    CharSequence mClassName;
    CharSequence mContentDescription;
    CharSequence mBeforeText;
    Parcelable mParcelableData;
    final List<CharSequence> mText = new ArrayList<CharSequence>();
    int mConnectionId = -1;

    AccessibilityRecord() {
    }

    public void setSource(View source) {
        this.setSource(source, -1);
    }

    public void setSource(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        boolean important = true;
        int rootViewId = Integer.MAX_VALUE;
        this.mSourceWindowId = -1;
        if (root != null) {
            important = root.isImportantForAccessibility();
            rootViewId = root.getAccessibilityViewId();
            this.mSourceWindowId = root.getAccessibilityWindowId();
        }
        this.setBooleanProperty(512, important);
        this.mSourceNodeId = AccessibilityNodeInfo.makeNodeId(rootViewId, virtualDescendantId);
    }

    public void setSourceNodeId(long sourceNodeId) {
        this.mSourceNodeId = sourceNodeId;
    }

    public AccessibilityNodeInfo getSource() {
        this.enforceSealed();
        if (this.mConnectionId == -1 || this.mSourceWindowId == -1 || AccessibilityNodeInfo.getAccessibilityViewId(this.mSourceNodeId) == Integer.MAX_VALUE) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mSourceWindowId, this.mSourceNodeId, false, 7, null);
    }

    public void setWindowId(int windowId) {
        this.mSourceWindowId = windowId;
    }

    public int getWindowId() {
        return this.mSourceWindowId;
    }

    public boolean isChecked() {
        return this.getBooleanProperty(1);
    }

    public void setChecked(boolean isChecked) {
        this.enforceNotSealed();
        this.setBooleanProperty(1, isChecked);
    }

    public boolean isEnabled() {
        return this.getBooleanProperty(2);
    }

    public void setEnabled(boolean isEnabled) {
        this.enforceNotSealed();
        this.setBooleanProperty(2, isEnabled);
    }

    public boolean isPassword() {
        return this.getBooleanProperty(4);
    }

    public void setPassword(boolean isPassword) {
        this.enforceNotSealed();
        this.setBooleanProperty(4, isPassword);
    }

    public boolean isFullScreen() {
        return this.getBooleanProperty(128);
    }

    public void setFullScreen(boolean isFullScreen) {
        this.enforceNotSealed();
        this.setBooleanProperty(128, isFullScreen);
    }

    public boolean isScrollable() {
        return this.getBooleanProperty(256);
    }

    public void setScrollable(boolean scrollable) {
        this.enforceNotSealed();
        this.setBooleanProperty(256, scrollable);
    }

    public boolean isImportantForAccessibility() {
        return this.getBooleanProperty(512);
    }

    public void setImportantForAccessibility(boolean importantForAccessibility) {
        this.enforceNotSealed();
        this.setBooleanProperty(512, importantForAccessibility);
    }

    public int getItemCount() {
        return this.mItemCount;
    }

    public void setItemCount(int itemCount) {
        this.enforceNotSealed();
        this.mItemCount = itemCount;
    }

    public int getCurrentItemIndex() {
        return this.mCurrentItemIndex;
    }

    public void setCurrentItemIndex(int currentItemIndex) {
        this.enforceNotSealed();
        this.mCurrentItemIndex = currentItemIndex;
    }

    public int getFromIndex() {
        return this.mFromIndex;
    }

    public void setFromIndex(int fromIndex) {
        this.enforceNotSealed();
        this.mFromIndex = fromIndex;
    }

    public int getToIndex() {
        return this.mToIndex;
    }

    public void setToIndex(int toIndex) {
        this.enforceNotSealed();
        this.mToIndex = toIndex;
    }

    public int getScrollX() {
        return this.mScrollX;
    }

    public void setScrollX(int scrollX) {
        this.enforceNotSealed();
        this.mScrollX = scrollX;
    }

    public int getScrollY() {
        return this.mScrollY;
    }

    public void setScrollY(int scrollY) {
        this.enforceNotSealed();
        this.mScrollY = scrollY;
    }

    public int getScrollDeltaX() {
        return this.mScrollDeltaX;
    }

    public void setScrollDeltaX(int scrollDeltaX) {
        this.enforceNotSealed();
        this.mScrollDeltaX = scrollDeltaX;
    }

    public int getScrollDeltaY() {
        return this.mScrollDeltaY;
    }

    public void setScrollDeltaY(int scrollDeltaY) {
        this.enforceNotSealed();
        this.mScrollDeltaY = scrollDeltaY;
    }

    public int getMaxScrollX() {
        return this.mMaxScrollX;
    }

    public void setMaxScrollX(int maxScrollX) {
        this.enforceNotSealed();
        this.mMaxScrollX = maxScrollX;
    }

    public int getMaxScrollY() {
        return this.mMaxScrollY;
    }

    public void setMaxScrollY(int maxScrollY) {
        this.enforceNotSealed();
        this.mMaxScrollY = maxScrollY;
    }

    public int getAddedCount() {
        return this.mAddedCount;
    }

    public void setAddedCount(int addedCount) {
        this.enforceNotSealed();
        this.mAddedCount = addedCount;
    }

    public int getRemovedCount() {
        return this.mRemovedCount;
    }

    public void setRemovedCount(int removedCount) {
        this.enforceNotSealed();
        this.mRemovedCount = removedCount;
    }

    public CharSequence getClassName() {
        return this.mClassName;
    }

    public void setClassName(CharSequence className) {
        this.enforceNotSealed();
        this.mClassName = className;
    }

    public List<CharSequence> getText() {
        return this.mText;
    }

    public CharSequence getBeforeText() {
        return this.mBeforeText;
    }

    public void setBeforeText(CharSequence beforeText) {
        this.enforceNotSealed();
        this.mBeforeText = beforeText == null ? null : beforeText.subSequence(0, beforeText.length());
    }

    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    public void setContentDescription(CharSequence contentDescription) {
        this.enforceNotSealed();
        this.mContentDescription = contentDescription == null ? null : contentDescription.subSequence(0, contentDescription.length());
    }

    public Parcelable getParcelableData() {
        return this.mParcelableData;
    }

    public void setParcelableData(Parcelable parcelableData) {
        this.enforceNotSealed();
        this.mParcelableData = parcelableData;
    }

    @UnsupportedAppUsage
    public long getSourceNodeId() {
        return this.mSourceNodeId;
    }

    public void setConnectionId(int connectionId) {
        this.enforceNotSealed();
        this.mConnectionId = connectionId;
    }

    public void setSealed(boolean sealed) {
        this.mSealed = sealed;
    }

    boolean isSealed() {
        return this.mSealed;
    }

    void enforceSealed() {
        if (!this.isSealed()) {
            throw new IllegalStateException("Cannot perform this action on a not sealed instance.");
        }
    }

    void enforceNotSealed() {
        if (this.isSealed()) {
            throw new IllegalStateException("Cannot perform this action on a sealed instance.");
        }
    }

    private boolean getBooleanProperty(int property) {
        return (this.mBooleanProperties & property) == property;
    }

    private void setBooleanProperty(int property, boolean value) {
        this.mBooleanProperties = value ? (this.mBooleanProperties |= property) : (this.mBooleanProperties &= ~property);
    }

    public static AccessibilityRecord obtain(AccessibilityRecord record) {
        AccessibilityRecord clone = AccessibilityRecord.obtain();
        clone.init(record);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessibilityRecord obtain() {
        Object object = sPoolLock;
        synchronized (object) {
            if (sPool != null) {
                AccessibilityRecord record = sPool;
                sPool = AccessibilityRecord.sPool.mNext;
                --sPoolSize;
                record.mNext = null;
                record.mIsInPool = false;
                return record;
            }
            return new AccessibilityRecord();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        if (this.mIsInPool) {
            throw new IllegalStateException("Record already recycled!");
        }
        this.clear();
        Object object = sPoolLock;
        synchronized (object) {
            if (sPoolSize <= 10) {
                this.mNext = sPool;
                sPool = this;
                this.mIsInPool = true;
                ++sPoolSize;
            }
        }
    }

    void init(AccessibilityRecord record) {
        this.mSealed = record.mSealed;
        this.mBooleanProperties = record.mBooleanProperties;
        this.mCurrentItemIndex = record.mCurrentItemIndex;
        this.mItemCount = record.mItemCount;
        this.mFromIndex = record.mFromIndex;
        this.mToIndex = record.mToIndex;
        this.mScrollX = record.mScrollX;
        this.mScrollY = record.mScrollY;
        this.mMaxScrollX = record.mMaxScrollX;
        this.mMaxScrollY = record.mMaxScrollY;
        this.mAddedCount = record.mAddedCount;
        this.mRemovedCount = record.mRemovedCount;
        this.mClassName = record.mClassName;
        this.mContentDescription = record.mContentDescription;
        this.mBeforeText = record.mBeforeText;
        this.mParcelableData = record.mParcelableData;
        this.mText.addAll(record.mText);
        this.mSourceWindowId = record.mSourceWindowId;
        this.mSourceNodeId = record.mSourceNodeId;
        this.mConnectionId = record.mConnectionId;
    }

    void clear() {
        this.mSealed = false;
        this.mBooleanProperties = 0;
        this.mCurrentItemIndex = -1;
        this.mItemCount = -1;
        this.mFromIndex = -1;
        this.mToIndex = -1;
        this.mScrollX = -1;
        this.mScrollY = -1;
        this.mMaxScrollX = -1;
        this.mMaxScrollY = -1;
        this.mAddedCount = -1;
        this.mRemovedCount = -1;
        this.mClassName = null;
        this.mContentDescription = null;
        this.mBeforeText = null;
        this.mParcelableData = null;
        this.mText.clear();
        this.mSourceNodeId = Integer.MAX_VALUE;
        this.mSourceWindowId = -1;
        this.mConnectionId = -1;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    StringBuilder appendTo(StringBuilder builder) {
        builder.append(" [ ClassName: ").append(this.mClassName);
        this.appendPropName(builder, "Text").append(this.mText);
        this.append(builder, "ContentDescription", this.mContentDescription);
        this.append(builder, "ItemCount", this.mItemCount);
        this.append(builder, "CurrentItemIndex", this.mCurrentItemIndex);
        this.appendUnless(true, 2, builder);
        this.appendUnless(false, 4, builder);
        this.appendUnless(false, 1, builder);
        this.appendUnless(false, 128, builder);
        this.appendUnless(false, 256, builder);
        this.append(builder, "BeforeText", this.mBeforeText);
        this.append(builder, "FromIndex", this.mFromIndex);
        this.append(builder, "ToIndex", this.mToIndex);
        this.append(builder, "ScrollX", this.mScrollX);
        this.append(builder, "ScrollY", this.mScrollY);
        this.append(builder, "MaxScrollX", this.mMaxScrollX);
        this.append(builder, "MaxScrollY", this.mMaxScrollY);
        this.append(builder, "AddedCount", this.mAddedCount);
        this.append(builder, "RemovedCount", this.mRemovedCount);
        this.append(builder, "ParcelableData", this.mParcelableData);
        builder.append(" ]");
        return builder;
    }

    private void appendUnless(boolean defValue, int prop, StringBuilder builder) {
        boolean value = this.getBooleanProperty(prop);
        this.appendPropName(builder, AccessibilityRecord.singleBooleanPropertyToString(prop)).append(value);
    }

    private static String singleBooleanPropertyToString(int prop) {
        switch (prop) {
            case 1: {
                return "Checked";
            }
            case 2: {
                return "Enabled";
            }
            case 4: {
                return "Password";
            }
            case 128: {
                return "FullScreen";
            }
            case 256: {
                return "Scrollable";
            }
            case 512: {
                return "ImportantForAccessibility";
            }
        }
        return Integer.toHexString(prop);
    }

    private void append(StringBuilder builder, String propName, int propValue) {
        this.appendPropName(builder, propName).append(propValue);
    }

    private void append(StringBuilder builder, String propName, Object propValue) {
        this.appendPropName(builder, propName).append(propValue);
    }

    private StringBuilder appendPropName(StringBuilder builder, String propName) {
        return builder.append("; ").append(propName).append(": ");
    }
}

