/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.util.SparseArray;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

final class WeakSparseArray<E> {
    private final ReferenceQueue<E> mRefQueue = new ReferenceQueue();
    private final SparseArray<WeakReferenceWithId<E>> mSparseArray = new SparseArray();

    WeakSparseArray() {
    }

    public void append(int key, E value) {
        this.removeUnreachableValues();
        this.mSparseArray.append(key, new WeakReferenceWithId<E>(value, this.mRefQueue, key));
    }

    public void remove(int key) {
        this.removeUnreachableValues();
        this.mSparseArray.remove(key);
    }

    public E get(int key) {
        this.removeUnreachableValues();
        WeakReferenceWithId<E> ref = this.mSparseArray.get(key);
        return ref != null ? (E)ref.get() : null;
    }

    private void removeUnreachableValues() {
        Reference<E> ref = this.mRefQueue.poll();
        while (ref != null) {
            this.mSparseArray.remove(((WeakReferenceWithId)ref).mId);
            ref = this.mRefQueue.poll();
        }
    }

    private static class WeakReferenceWithId<E>
    extends WeakReference<E> {
        final int mId;

        WeakReferenceWithId(E referent, ReferenceQueue<? super E> q, int id2) {
            super(referent, q);
            this.mId = id2;
        }
    }
}

