/*
 * Decompiled with CFR 0.152.
 */
package android.view.contentcapture;

import android.view.autofill.AutofillId;
import android.view.contentcapture.ContentCaptureContext;
import android.view.contentcapture.ContentCaptureSession;
import android.view.contentcapture.MainContentCaptureSession;
import android.view.contentcapture.ViewNode;

final class ChildContentCaptureSession
extends ContentCaptureSession {
    private final ContentCaptureSession mParent;

    protected ChildContentCaptureSession(ContentCaptureSession parent, ContentCaptureContext clientContext) {
        super(clientContext);
        this.mParent = parent;
    }

    @Override
    MainContentCaptureSession getMainCaptureSession() {
        if (this.mParent instanceof MainContentCaptureSession) {
            return (MainContentCaptureSession)this.mParent;
        }
        return this.mParent.getMainCaptureSession();
    }

    @Override
    ContentCaptureSession newChild(ContentCaptureContext clientContext) {
        ChildContentCaptureSession child = new ChildContentCaptureSession(this, clientContext);
        this.getMainCaptureSession().notifyChildSessionStarted(this.mId, child.mId, clientContext);
        return child;
    }

    @Override
    void flush(int reason) {
        this.mParent.flush(reason);
    }

    @Override
    public void updateContentCaptureContext(ContentCaptureContext context) {
        this.getMainCaptureSession().notifyContextUpdated(this.mId, context);
    }

    @Override
    void onDestroy() {
        this.getMainCaptureSession().notifyChildSessionFinished(this.mParent.mId, this.mId);
    }

    @Override
    void internalNotifyViewAppeared(ViewNode.ViewStructureImpl node) {
        this.getMainCaptureSession().notifyViewAppeared(this.mId, node);
    }

    @Override
    void internalNotifyViewDisappeared(AutofillId id2) {
        this.getMainCaptureSession().notifyViewDisappeared(this.mId, id2);
    }

    @Override
    void internalNotifyViewTextChanged(AutofillId id2, CharSequence text) {
        this.getMainCaptureSession().notifyViewTextChanged(this.mId, id2, text);
    }

    @Override
    public void internalNotifyViewTreeEvent(boolean started) {
        this.getMainCaptureSession().notifyViewTreeEvent(this.mId, started);
    }

    @Override
    boolean isContentCaptureEnabled() {
        return this.getMainCaptureSession().isContentCaptureEnabled();
    }
}

