/*
 * Decompiled with CFR 0.152.
 */
package android.view.contentcapture;

import android.os.Build;
import android.provider.DeviceConfig;
import android.util.ArraySet;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class ContentCaptureHelper {
    private static final String TAG = ContentCaptureHelper.class.getSimpleName();
    public static boolean sVerbose = false;
    public static boolean sDebug = true;

    public static String getSanitizedString(CharSequence text) {
        return text == null ? null : text.length() + "_chars";
    }

    public static int getDefaultLoggingLevel() {
        return Build.IS_DEBUGGABLE ? 1 : 0;
    }

    public static void setLoggingLevel() {
        int defaultLevel = ContentCaptureHelper.getDefaultLoggingLevel();
        int level = DeviceConfig.getInt("content_capture", "logging_level", defaultLevel);
        ContentCaptureHelper.setLoggingLevel(level);
    }

    public static void setLoggingLevel(int level) {
        Log.i(TAG, "Setting logging level to " + ContentCaptureHelper.getLoggingLevelAsString(level));
        sDebug = false;
        sVerbose = false;
        switch (level) {
            case 2: {
                sVerbose = true;
            }
            case 1: {
                sDebug = true;
                return;
            }
            case 0: {
                return;
            }
        }
        Log.w(TAG, "setLoggingLevel(): invalud level: " + level);
    }

    public static String getLoggingLevelAsString(int level) {
        switch (level) {
            case 0: {
                return "OFF";
            }
            case 1: {
                return "DEBUG";
            }
            case 2: {
                return "VERBOSE";
            }
        }
        return "UNKNOWN-" + level;
    }

    public static <T> ArrayList<T> toList(Set<T> set) {
        return set == null ? null : new ArrayList<T>(set);
    }

    public static <T> ArraySet<T> toSet(List<T> list) {
        return list == null ? null : new ArraySet<T>(list);
    }

    private ContentCaptureHelper() {
        throw new UnsupportedOperationException("contains only static methods");
    }
}

