/*
 * Decompiled with CFR 0.152.
 */
package android.view.contentcapture;

import android.util.DebugUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewStructure;
import android.view.autofill.AutofillId;
import android.view.contentcapture.ContentCaptureContext;
import android.view.contentcapture.ContentCaptureHelper;
import android.view.contentcapture.ContentCaptureSessionId;
import android.view.contentcapture.MainContentCaptureSession;
import android.view.contentcapture.ViewNode;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Random;

public abstract class ContentCaptureSession
implements AutoCloseable {
    private static final String TAG = ContentCaptureSession.class.getSimpleName();
    private static final Random sIdGenerator = new Random();
    public static final int NO_SESSION_ID = 0;
    public static final int UNKNOWN_STATE = 0;
    public static final int STATE_WAITING_FOR_SERVER = 1;
    public static final int STATE_ACTIVE = 2;
    public static final int STATE_DISABLED = 4;
    public static final int STATE_DUPLICATED_ID = 8;
    public static final int STATE_NO_SERVICE = 16;
    public static final int STATE_FLAG_SECURE = 32;
    public static final int STATE_BY_APP = 64;
    public static final int STATE_NO_RESPONSE = 128;
    public static final int STATE_INTERNAL_ERROR = 256;
    public static final int STATE_NOT_WHITELISTED = 512;
    public static final int STATE_SERVICE_DIED = 1024;
    public static final int STATE_SERVICE_UPDATING = 2048;
    public static final int STATE_SERVICE_RESURRECTED = 4096;
    private static final int INITIAL_CHILDREN_CAPACITY = 5;
    public static final int FLUSH_REASON_FULL = 1;
    public static final int FLUSH_REASON_VIEW_ROOT_ENTERED = 2;
    public static final int FLUSH_REASON_SESSION_STARTED = 3;
    public static final int FLUSH_REASON_SESSION_FINISHED = 4;
    public static final int FLUSH_REASON_IDLE_TIMEOUT = 5;
    public static final int FLUSH_REASON_TEXT_CHANGE_TIMEOUT = 6;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private boolean mDestroyed;
    protected final int mId;
    private int mState = 0;
    private ContentCaptureSessionId mContentCaptureSessionId;
    private ContentCaptureContext mClientContext;
    @GuardedBy(value={"mLock"})
    private ArrayList<ContentCaptureSession> mChildren;

    protected ContentCaptureSession() {
        this(ContentCaptureSession.getRandomSessionId());
    }

    @VisibleForTesting
    public ContentCaptureSession(int id2) {
        Preconditions.checkArgument(id2 != 0);
        this.mId = id2;
    }

    ContentCaptureSession(ContentCaptureContext initialContext) {
        this();
        this.mClientContext = Preconditions.checkNotNull(initialContext);
    }

    abstract MainContentCaptureSession getMainCaptureSession();

    public final ContentCaptureSessionId getContentCaptureSessionId() {
        if (this.mContentCaptureSessionId == null) {
            this.mContentCaptureSessionId = new ContentCaptureSessionId(this.mId);
        }
        return this.mContentCaptureSessionId;
    }

    public int getId() {
        return this.mId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ContentCaptureSession createContentCaptureSession(ContentCaptureContext context) {
        ContentCaptureSession child = this.newChild(context);
        if (ContentCaptureHelper.sDebug) {
            Log.d(TAG, "createContentCaptureSession(" + context + ": parent=" + this.mId + ", child=" + child.mId);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mChildren == null) {
                this.mChildren = new ArrayList(5);
            }
            this.mChildren.add(child);
        }
        return child;
    }

    abstract ContentCaptureSession newChild(ContentCaptureContext var1);

    abstract void flush(int var1);

    public final void setContentCaptureContext(ContentCaptureContext context) {
        this.mClientContext = context;
        this.updateContentCaptureContext(context);
    }

    abstract void updateContentCaptureContext(ContentCaptureContext var1);

    public final ContentCaptureContext getContentCaptureContext() {
        return this.mClientContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                if (ContentCaptureHelper.sDebug) {
                    Log.d(TAG, "destroy(" + this.mId + "): already destroyed");
                }
                return;
            }
            this.mDestroyed = true;
            if (ContentCaptureHelper.sVerbose) {
                Log.v(TAG, "destroy(): state=" + ContentCaptureSession.getStateAsString(this.mState) + ", mId=" + this.mId);
            }
            if (this.mChildren != null) {
                int numberChildren = this.mChildren.size();
                if (ContentCaptureHelper.sVerbose) {
                    Log.v(TAG, "Destroying " + numberChildren + " children first");
                }
                for (int i = 0; i < numberChildren; ++i) {
                    ContentCaptureSession child = this.mChildren.get(i);
                    try {
                        child.destroy();
                        continue;
                    }
                    catch (Exception e) {
                        Log.w(TAG, "exception destroying child session #" + i + ": " + e);
                    }
                }
            }
        }
        try {
            this.flush(4);
        }
        finally {
            this.onDestroy();
        }
    }

    abstract void onDestroy();

    @Override
    public void close() {
        this.destroy();
    }

    public final void notifyViewAppeared(ViewStructure node) {
        Preconditions.checkNotNull(node);
        if (!this.isContentCaptureEnabled()) {
            return;
        }
        if (!(node instanceof ViewNode.ViewStructureImpl)) {
            throw new IllegalArgumentException("Invalid node class: " + node.getClass());
        }
        this.internalNotifyViewAppeared((ViewNode.ViewStructureImpl)node);
    }

    abstract void internalNotifyViewAppeared(ViewNode.ViewStructureImpl var1);

    public final void notifyViewDisappeared(AutofillId id2) {
        Preconditions.checkNotNull(id2);
        if (!this.isContentCaptureEnabled()) {
            return;
        }
        this.internalNotifyViewDisappeared(id2);
    }

    abstract void internalNotifyViewDisappeared(AutofillId var1);

    public final void notifyViewsDisappeared(AutofillId hostId, long[] virtualIds) {
        Preconditions.checkArgument(hostId.isNonVirtual(), "hostId cannot be virtual: %s", hostId);
        Preconditions.checkArgument(!ArrayUtils.isEmpty(virtualIds), "virtual ids cannot be empty");
        if (!this.isContentCaptureEnabled()) {
            return;
        }
        for (long id2 : virtualIds) {
            this.internalNotifyViewDisappeared(new AutofillId(hostId, id2, this.mId));
        }
    }

    public final void notifyViewTextChanged(AutofillId id2, CharSequence text) {
        Preconditions.checkNotNull(id2);
        if (!this.isContentCaptureEnabled()) {
            return;
        }
        this.internalNotifyViewTextChanged(id2, text);
    }

    abstract void internalNotifyViewTextChanged(AutofillId var1, CharSequence var2);

    public abstract void internalNotifyViewTreeEvent(boolean var1);

    public final ViewStructure newViewStructure(View view) {
        return new ViewNode.ViewStructureImpl(view);
    }

    public AutofillId newAutofillId(AutofillId hostId, long virtualChildId) {
        Preconditions.checkNotNull(hostId);
        Preconditions.checkArgument(hostId.isNonVirtual(), "hostId cannot be virtual: %s", hostId);
        return new AutofillId(hostId, virtualChildId, this.mId);
    }

    public final ViewStructure newVirtualViewStructure(AutofillId parentId, long virtualId) {
        return new ViewNode.ViewStructureImpl(parentId, virtualId, this.mId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isContentCaptureEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return !this.mDestroyed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("id: ");
        pw.println(this.mId);
        if (this.mClientContext != null) {
            pw.print(prefix);
            this.mClientContext.dump(pw);
            pw.println();
        }
        Object object = this.mLock;
        synchronized (object) {
            pw.print(prefix);
            pw.print("destroyed: ");
            pw.println(this.mDestroyed);
            if (this.mChildren != null && !this.mChildren.isEmpty()) {
                String prefix2 = prefix + "  ";
                int numberChildren = this.mChildren.size();
                pw.print(prefix);
                pw.print("number children: ");
                pw.println(numberChildren);
                for (int i = 0; i < numberChildren; ++i) {
                    ContentCaptureSession child = this.mChildren.get(i);
                    pw.print(prefix);
                    pw.print(i);
                    pw.println(": ");
                    child.dump(prefix2, pw);
                }
            }
        }
    }

    public String toString() {
        return Integer.toString(this.mId);
    }

    protected static String getStateAsString(int state) {
        return state + " (" + (state == 0 ? "UNKNOWN" : DebugUtils.flagsToString(ContentCaptureSession.class, "STATE_", state)) + ")";
    }

    public static String getFlushReasonAsString(int reason) {
        switch (reason) {
            case 1: {
                return "FULL";
            }
            case 2: {
                return "VIEW_ROOT";
            }
            case 3: {
                return "STARTED";
            }
            case 4: {
                return "FINISHED";
            }
            case 5: {
                return "IDLE";
            }
            case 6: {
                return "TEXT_CHANGE";
            }
        }
        return "UNKOWN-" + reason;
    }

    private static int getRandomSessionId() {
        int id2;
        while ((id2 = sIdGenerator.nextInt()) == 0) {
        }
        return id2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FlushReason {
    }
}

