/*
 * Decompiled with CFR 0.152.
 */
package android.view.inspector;

import android.view.inspector.InspectionCompanion;
import android.view.inspector.InspectionCompanionProvider;

public class StaticInspectionCompanionProvider
implements InspectionCompanionProvider {
    private static final String COMPANION_SUFFIX = "$InspectionCompanion";

    @Override
    public <T> InspectionCompanion<T> provide(Class<T> cls) {
        String companionName = cls.getName() + COMPANION_SUFFIX;
        try {
            Class<?> companionClass = cls.getClassLoader().loadClass(companionName);
            if (InspectionCompanion.class.isAssignableFrom(companionClass)) {
                return (InspectionCompanion)companionClass.newInstance();
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

