/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.app.Person;
import android.app.RemoteAction;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Pair;
import android.view.textclassifier.ConversationAction;
import android.view.textclassifier.ConversationActions;
import android.view.textclassifier.ExtrasUtils;
import android.view.textclassifier.Log;
import android.view.textclassifier.SelectionSessionLogger;
import android.view.textclassifier.intent.LabeledIntent;
import android.view.textclassifier.intent.TemplateIntentFactory;
import com.android.internal.annotations.VisibleForTesting;
import com.google.android.textclassifier.ActionsSuggestionsModel;
import com.google.android.textclassifier.RemoteActionTemplate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public final class ActionsSuggestionsHelper {
    private static final String TAG = "ActionsSuggestions";
    private static final int USER_LOCAL = 0;
    private static final int FIRST_NON_LOCAL_USER = 1;

    private ActionsSuggestionsHelper() {
    }

    public static ActionsSuggestionsModel.ConversationMessage[] toNativeMessages(List<ConversationActions.Message> messages, Function<CharSequence, String> languageDetector) {
        List messagesWithText = messages.stream().filter(message -> !TextUtils.isEmpty(message.getText())).collect(Collectors.toCollection(ArrayList::new));
        if (messagesWithText.isEmpty()) {
            return new ActionsSuggestionsModel.ConversationMessage[0];
        }
        ArrayDeque<ActionsSuggestionsModel.ConversationMessage> nativeMessages = new ArrayDeque<ActionsSuggestionsModel.ConversationMessage>();
        PersonEncoder personEncoder = new PersonEncoder();
        int size = messagesWithText.size();
        for (int i = size - 1; i >= 0; --i) {
            ConversationActions.Message message2 = (ConversationActions.Message)messagesWithText.get(i);
            long referenceTime = message2.getReferenceTime() == null ? 0L : message2.getReferenceTime().toInstant().toEpochMilli();
            String timeZone = message2.getReferenceTime() == null ? null : message2.getReferenceTime().getZone().getId();
            nativeMessages.push(new ActionsSuggestionsModel.ConversationMessage(personEncoder.encode(message2.getAuthor()), message2.getText().toString(), referenceTime, timeZone, languageDetector.apply(message2.getText())));
        }
        return nativeMessages.toArray(new ActionsSuggestionsModel.ConversationMessage[nativeMessages.size()]);
    }

    public static String createResultId(Context context, List<ConversationActions.Message> messages, int modelVersion, List<Locale> modelLocales) {
        StringJoiner localesJoiner = new StringJoiner(",");
        for (Locale locale : modelLocales) {
            localesJoiner.add(locale.toLanguageTag());
        }
        String modelName = String.format(Locale.US, "%s_v%d", localesJoiner.toString(), modelVersion);
        int hash = Objects.hash(messages.stream().mapToInt(ActionsSuggestionsHelper::hashMessage), context.getPackageName(), System.currentTimeMillis());
        return SelectionSessionLogger.SignatureParser.createSignature("androidtc", modelName, hash);
    }

    public static LabeledIntent.Result createLabeledIntentResult(Context context, TemplateIntentFactory templateIntentFactory, ActionsSuggestionsModel.ActionSuggestion nativeSuggestion) {
        RemoteActionTemplate[] remoteActionTemplates = nativeSuggestion.getRemoteActionTemplates();
        if (remoteActionTemplates == null) {
            Log.w(TAG, "createRemoteAction: Missing template for type " + nativeSuggestion.getActionType());
            return null;
        }
        List<LabeledIntent> labeledIntents = templateIntentFactory.create(remoteActionTemplates);
        if (labeledIntents.isEmpty()) {
            return null;
        }
        LabeledIntent.TitleChooser titleChooser = ActionsSuggestionsHelper.createTitleChooser(nativeSuggestion.getActionType());
        return labeledIntents.get(0).resolve(context, titleChooser, null);
    }

    public static LabeledIntent.TitleChooser createTitleChooser(String actionType) {
        if ("open_url".equals(actionType)) {
            return (labeledIntent, resolveInfo) -> {
                if (resolveInfo.handleAllWebDataURI) {
                    return labeledIntent.titleWithEntity;
                }
                if ("android".equals(resolveInfo.activityInfo.packageName)) {
                    return labeledIntent.titleWithEntity;
                }
                return labeledIntent.titleWithoutEntity;
            };
        }
        return null;
    }

    public static List<ConversationAction> removeActionsWithDuplicates(List<ConversationAction> conversationActions) {
        ArrayMap<Pair<String, String>, Integer> counter = new ArrayMap<Pair<String, String>, Integer>();
        for (ConversationAction conversationAction : conversationActions) {
            Pair<String, String> representation = ActionsSuggestionsHelper.getRepresentation(conversationAction);
            if (representation == null) continue;
            Integer existingCount = counter.getOrDefault(representation, 0);
            counter.put(representation, existingCount + 1);
        }
        ArrayList<ConversationAction> result = new ArrayList<ConversationAction>();
        for (ConversationAction conversationAction : conversationActions) {
            Pair<String, String> representation = ActionsSuggestionsHelper.getRepresentation(conversationAction);
            if (representation != null && counter.getOrDefault(representation, 0) != 1) continue;
            result.add(conversationAction);
        }
        return result;
    }

    private static Pair<String, String> getRepresentation(ConversationAction conversationAction) {
        RemoteAction remoteAction = conversationAction.getAction();
        if (remoteAction == null) {
            return null;
        }
        Intent actionIntent = ExtrasUtils.getActionIntent(conversationAction.getExtras());
        ComponentName componentName = actionIntent.getComponent();
        String packageName = componentName == null ? null : componentName.getPackageName();
        return new Pair<String, String>(conversationAction.getAction().getTitle().toString(), packageName);
    }

    private static int hashMessage(ConversationActions.Message message) {
        return Objects.hash(message.getAuthor(), message.getText(), message.getReferenceTime());
    }

    private static final class PersonEncoder {
        private final Map<Person, Integer> mMapping = new ArrayMap<Person, Integer>();
        private int mNextUserId = 1;

        private PersonEncoder() {
        }

        private int encode(Person person) {
            if (ConversationActions.Message.PERSON_USER_SELF.equals(person)) {
                return 0;
            }
            Integer result = this.mMapping.get(person);
            if (result == null) {
                this.mMapping.put(person, this.mNextUserId);
                result = this.mNextUserId;
                ++this.mNextUserId;
            }
            return result;
        }
    }
}

