/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.metrics.LogMaker;
import android.util.ArrayMap;
import android.view.textclassifier.Log;
import android.view.textclassifier.TextLinks;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.Preconditions;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public final class GenerateLinksLogger {
    private static final String LOG_TAG = "GenerateLinksLogger";
    private static final String ZERO = "0";
    private final MetricsLogger mMetricsLogger;
    private final Random mRng;
    private final int mSampleRate;

    public GenerateLinksLogger(int sampleRate) {
        this.mSampleRate = sampleRate;
        this.mRng = new Random(System.nanoTime());
        this.mMetricsLogger = new MetricsLogger();
    }

    @VisibleForTesting
    public GenerateLinksLogger(int sampleRate, MetricsLogger metricsLogger) {
        this.mSampleRate = sampleRate;
        this.mRng = new Random(System.nanoTime());
        this.mMetricsLogger = metricsLogger;
    }

    public void logGenerateLinks(CharSequence text, TextLinks links, String callingPackageName, long latencyMs) {
        Preconditions.checkNotNull(text);
        Preconditions.checkNotNull(links);
        Preconditions.checkNotNull(callingPackageName);
        if (!this.shouldLog()) {
            return;
        }
        LinkifyStats totalStats = new LinkifyStats();
        ArrayMap<String, LinkifyStats> perEntityTypeStats = new ArrayMap<String, LinkifyStats>();
        for (TextLinks.TextLink link : links.getLinks()) {
            String entityType;
            if (link.getEntityCount() == 0 || (entityType = link.getEntity(0)) == null || "other".equals(entityType) || "".equals(entityType)) continue;
            totalStats.countLink(link);
            perEntityTypeStats.computeIfAbsent(entityType, k -> new LinkifyStats()).countLink(link);
        }
        String callId = UUID.randomUUID().toString();
        this.writeStats(callId, callingPackageName, null, totalStats, text, latencyMs);
        for (Map.Entry entry : perEntityTypeStats.entrySet()) {
            this.writeStats(callId, callingPackageName, (String)entry.getKey(), (LinkifyStats)entry.getValue(), text, latencyMs);
        }
    }

    private boolean shouldLog() {
        if (this.mSampleRate <= 1) {
            return true;
        }
        return this.mRng.nextInt(this.mSampleRate) == 0;
    }

    private void writeStats(String callId, String callingPackageName, String entityType, LinkifyStats stats, CharSequence text, long latencyMs) {
        LogMaker log = new LogMaker(1313).setPackageName(callingPackageName).addTaggedData(1319, callId).addTaggedData(1316, stats.mNumLinks).addTaggedData(1317, stats.mNumLinksTextLength).addTaggedData(1315, text.length()).addTaggedData(1314, latencyMs);
        if (entityType != null) {
            log.addTaggedData(1318, entityType);
        }
        this.mMetricsLogger.write(log);
        GenerateLinksLogger.debugLog(log);
    }

    private static void debugLog(LogMaker log) {
        if (!Log.ENABLE_FULL_LOGGING) {
            return;
        }
        String callId = Objects.toString(log.getTaggedData(1319), "");
        String entityType = Objects.toString(log.getTaggedData(1318), "ANY_ENTITY");
        int numLinks = Integer.parseInt(Objects.toString(log.getTaggedData(1316), ZERO));
        int linkLength = Integer.parseInt(Objects.toString(log.getTaggedData(1317), ZERO));
        int textLength = Integer.parseInt(Objects.toString(log.getTaggedData(1315), ZERO));
        int latencyMs = Integer.parseInt(Objects.toString(log.getTaggedData(1314), ZERO));
        Log.v(LOG_TAG, String.format(Locale.US, "%s:%s %d links (%d/%d chars) %dms %s", callId, entityType, numLinks, linkLength, textLength, latencyMs, log.getPackageName()));
    }

    private static final class LinkifyStats {
        int mNumLinks;
        int mNumLinksTextLength;

        private LinkifyStats() {
        }

        void countLink(TextLinks.TextLink link) {
            ++this.mNumLinks;
            this.mNumLinksTextLength += link.getEnd() - link.getStart();
        }
    }
}

