/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.os.LocaleList;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.view.textclassifier.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public final class ModelFileManager {
    private final Object mLock = new Object();
    private final Supplier<List<ModelFile>> mModelFileSupplier;
    private List<ModelFile> mModelFiles;

    public ModelFileManager(Supplier<List<ModelFile>> modelFileSupplier) {
        this.mModelFileSupplier = Preconditions.checkNotNull(modelFileSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ModelFile> listModelFiles() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mModelFiles == null) {
                this.mModelFiles = Collections.unmodifiableList(this.mModelFileSupplier.get());
            }
            return this.mModelFiles;
        }
    }

    public ModelFile findBestModelFile(LocaleList localeList) {
        String languages = localeList == null || localeList.isEmpty() ? LocaleList.getDefault().toLanguageTags() : localeList.toLanguageTags();
        List<Locale.LanguageRange> languageRangeList = Locale.LanguageRange.parse(languages);
        ModelFile bestModel = null;
        for (ModelFile model : this.listModelFiles()) {
            if (!model.isAnyLanguageSupported(languageRangeList) || !model.isPreferredTo(bestModel)) continue;
            bestModel = model;
        }
        return bestModel;
    }

    public static final class ModelFile {
        public static final String LANGUAGE_INDEPENDENT = "*";
        private final File mFile;
        private final int mVersion;
        private final List<Locale> mSupportedLocales;
        private final String mSupportedLocalesStr;
        private final boolean mLanguageIndependent;

        public ModelFile(File file, int version, List<Locale> supportedLocales, String supportedLocalesStr, boolean languageIndependent) {
            this.mFile = Preconditions.checkNotNull(file);
            this.mVersion = version;
            this.mSupportedLocales = Preconditions.checkNotNull(supportedLocales);
            this.mSupportedLocalesStr = Preconditions.checkNotNull(supportedLocalesStr);
            this.mLanguageIndependent = languageIndependent;
        }

        public String getPath() {
            return this.mFile.getAbsolutePath();
        }

        public String getName() {
            return this.mFile.getName();
        }

        public int getVersion() {
            return this.mVersion;
        }

        public boolean isAnyLanguageSupported(List<Locale.LanguageRange> languageRanges) {
            Preconditions.checkNotNull(languageRanges);
            return this.mLanguageIndependent || Locale.lookup(languageRanges, this.mSupportedLocales) != null;
        }

        public List<Locale> getSupportedLocales() {
            return Collections.unmodifiableList(this.mSupportedLocales);
        }

        public String getSupportedLocalesStr() {
            return this.mSupportedLocalesStr;
        }

        public boolean isPreferredTo(ModelFile model) {
            if (model == null) {
                return true;
            }
            if (!this.mLanguageIndependent && model.mLanguageIndependent) {
                return true;
            }
            if (this.mLanguageIndependent && !model.mLanguageIndependent) {
                return false;
            }
            return this.mVersion > model.getVersion();
        }

        public int hashCode() {
            return Objects.hash(this.getPath());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof ModelFile) {
                ModelFile otherModel = (ModelFile)other;
                return TextUtils.equals(this.getPath(), otherModel.getPath());
            }
            return false;
        }

        public String toString() {
            StringJoiner localesJoiner = new StringJoiner(",");
            for (Locale locale : this.mSupportedLocales) {
                localesJoiner.add(locale.toLanguageTag());
            }
            return String.format(Locale.US, "ModelFile { path=%s name=%s version=%d locales=%s }", this.getPath(), this.getName(), this.mVersion, localesJoiner.toString());
        }
    }

    public static final class ModelFileSupplierImpl
    implements Supplier<List<ModelFile>> {
        private final File mUpdatedModelFile;
        private final File mFactoryModelDir;
        private final Pattern mModelFilenamePattern;
        private final Function<Integer, Integer> mVersionSupplier;
        private final Function<Integer, String> mSupportedLocalesSupplier;

        public ModelFileSupplierImpl(File factoryModelDir, String factoryModelFileNameRegex, File updatedModelFile, Function<Integer, Integer> versionSupplier, Function<Integer, String> supportedLocalesSupplier) {
            this.mUpdatedModelFile = Preconditions.checkNotNull(updatedModelFile);
            this.mFactoryModelDir = Preconditions.checkNotNull(factoryModelDir);
            this.mModelFilenamePattern = Pattern.compile(Preconditions.checkNotNull(factoryModelFileNameRegex));
            this.mVersionSupplier = Preconditions.checkNotNull(versionSupplier);
            this.mSupportedLocalesSupplier = Preconditions.checkNotNull(supportedLocalesSupplier);
        }

        @Override
        public List<ModelFile> get() {
            ModelFile updatedModel;
            ArrayList<ModelFile> modelFiles = new ArrayList<ModelFile>();
            if (this.mUpdatedModelFile.exists() && (updatedModel = this.createModelFile(this.mUpdatedModelFile)) != null) {
                modelFiles.add(updatedModel);
            }
            if (this.mFactoryModelDir.exists() && this.mFactoryModelDir.isDirectory()) {
                File[] files;
                for (File file : files = this.mFactoryModelDir.listFiles()) {
                    ModelFile model;
                    Matcher matcher = this.mModelFilenamePattern.matcher(file.getName());
                    if (!matcher.matches() || !file.isFile() || (model = this.createModelFile(file)) == null) continue;
                    modelFiles.add(model);
                }
            }
            return modelFiles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ModelFile createModelFile(File file) {
            if (!file.exists()) {
                return null;
            }
            ParcelFileDescriptor modelFd = null;
            try {
                modelFd = ParcelFileDescriptor.open(file, 0x10000000);
                if (modelFd == null) {
                    ModelFile modelFile = null;
                    return modelFile;
                }
                int modelFdInt = modelFd.getFd();
                int version = this.mVersionSupplier.apply(modelFdInt);
                String supportedLocalesStr = this.mSupportedLocalesSupplier.apply(modelFdInt);
                if (supportedLocalesStr.isEmpty()) {
                    Log.d("androidtc", "Ignoring " + file.getAbsolutePath());
                    ModelFile modelFile = null;
                    return modelFile;
                }
                ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
                for (String langTag : supportedLocalesStr.split(",")) {
                    supportedLocales.add(Locale.forLanguageTag(langTag));
                }
                ModelFile modelFile = new ModelFile(file, version, supportedLocales, supportedLocalesStr, "*".equals(supportedLocalesStr));
                return modelFile;
            }
            catch (FileNotFoundException e) {
                Log.e("androidtc", "Failed to find " + file.getAbsolutePath(), e);
                ModelFile modelFile = null;
                return modelFile;
            }
            finally {
                ModelFileSupplierImpl.maybeCloseAndLogError(modelFd);
            }
        }

        private static void maybeCloseAndLogError(ParcelFileDescriptor fd) {
            if (fd == null) {
                return;
            }
            try {
                fd.close();
            }
            catch (IOException e) {
                Log.e("androidtc", "Error closing file.", e);
            }
        }
    }
}

