/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.metrics.LogMaker;
import android.view.textclassifier.Log;
import android.view.textclassifier.SelectionSessionLogger;
import android.view.textclassifier.TextClassificationContext;
import android.view.textclassifier.TextClassifierEvent;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.Preconditions;

public final class TextClassifierEventTronLogger {
    private static final String TAG = "TCEventTronLogger";
    private final MetricsLogger mMetricsLogger;

    public TextClassifierEventTronLogger() {
        this(new MetricsLogger());
    }

    @VisibleForTesting
    public TextClassifierEventTronLogger(MetricsLogger metricsLogger) {
        this.mMetricsLogger = Preconditions.checkNotNull(metricsLogger);
    }

    public void writeEvent(TextClassifierEvent event) {
        TextClassificationContext eventContext;
        String[] entityTypes;
        Preconditions.checkNotNull(event);
        int category = TextClassifierEventTronLogger.getCategory(event);
        if (category == -1) {
            Log.w(TAG, "Unknown category: " + event.getEventCategory());
            return;
        }
        LogMaker log = new LogMaker(category).setSubtype(TextClassifierEventTronLogger.getLogType(event)).addTaggedData(1634, event.getResultId()).addTaggedData(1256, TextClassifierEventTronLogger.getModelName(event));
        if (event.getScores().length >= 1) {
            log.addTaggedData(1638, Float.valueOf(event.getScores()[0]));
        }
        if ((entityTypes = event.getEntityTypes()).length >= 1) {
            log.addTaggedData(1635, entityTypes[0]);
        }
        if (entityTypes.length >= 2) {
            log.addTaggedData(1636, entityTypes[1]);
        }
        if (entityTypes.length >= 3) {
            log.addTaggedData(1637, entityTypes[2]);
        }
        if ((eventContext = event.getEventContext()) != null) {
            log.addTaggedData(1639, eventContext.getWidgetType());
            log.addTaggedData(1640, eventContext.getWidgetVersion());
            log.setPackageName(eventContext.getPackageName());
        }
        this.mMetricsLogger.write(log);
        this.debugLog(log);
    }

    private static String getModelName(TextClassifierEvent event) {
        if (event.getModelName() != null) {
            return event.getModelName();
        }
        return SelectionSessionLogger.SignatureParser.getModelName(event.getResultId());
    }

    private static int getCategory(TextClassifierEvent event) {
        switch (event.getEventCategory()) {
            case 3: {
                return 1615;
            }
            case 4: {
                return 1614;
            }
        }
        return -1;
    }

    private static int getLogType(TextClassifierEvent event) {
        switch (event.getEventType()) {
            case 13: {
                return 1113;
            }
            case 6: {
                return 1616;
            }
            case 19: {
                return 1618;
            }
            case 20: {
                return 1619;
            }
        }
        return 0;
    }

    private String toCategoryName(int category) {
        switch (category) {
            case 1615: {
                return "conversation_actions";
            }
            case 1614: {
                return "language_detection";
            }
        }
        return "unknown";
    }

    private String toEventName(int logType) {
        switch (logType) {
            case 1113: {
                return "smart_share";
            }
            case 1616: {
                return "actions_shown";
            }
            case 1618: {
                return "manual_reply";
            }
            case 1619: {
                return "actions_generated";
            }
        }
        return "unknown";
    }

    private void debugLog(LogMaker log) {
        if (!Log.ENABLE_FULL_LOGGING) {
            return;
        }
        String id2 = String.valueOf(log.getTaggedData(1634));
        String categoryName = this.toCategoryName(log.getCategory());
        String eventName = this.toEventName(log.getSubtype());
        String widgetType = String.valueOf(log.getTaggedData(1639));
        String widgetVersion = String.valueOf(log.getTaggedData(1640));
        String model = String.valueOf(log.getTaggedData(1256));
        String firstEntityType = String.valueOf(log.getTaggedData(1635));
        String secondEntityType = String.valueOf(log.getTaggedData(1636));
        String thirdEntityType = String.valueOf(log.getTaggedData(1637));
        String score = String.valueOf(log.getTaggedData(1638));
        StringBuilder builder = new StringBuilder();
        builder.append("writeEvent: ");
        builder.append("id=").append(id2);
        builder.append(", category=").append(categoryName);
        builder.append(", eventName=").append(eventName);
        builder.append(", widgetType=").append(widgetType);
        builder.append(", widgetVersion=").append(widgetVersion);
        builder.append(", model=").append(model);
        builder.append(", firstEntityType=").append(firstEntityType);
        builder.append(", secondEntityType=").append(secondEntityType);
        builder.append(", thirdEntityType=").append(thirdEntityType);
        builder.append(", score=").append(score);
        Log.v(TAG, builder.toString());
    }
}

