/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.app.RemoteAction;
import android.content.Context;
import android.content.Intent;
import android.icu.util.ULocale;
import android.os.Bundle;
import android.os.LocaleList;
import android.os.ParcelFileDescriptor;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Pair;
import android.view.textclassifier.ActionsModelParamsSupplier;
import android.view.textclassifier.ActionsSuggestionsHelper;
import android.view.textclassifier.ConversationAction;
import android.view.textclassifier.ConversationActions;
import android.view.textclassifier.EntityConfidence;
import android.view.textclassifier.ExtrasUtils;
import android.view.textclassifier.GenerateLinksLogger;
import android.view.textclassifier.Log;
import android.view.textclassifier.ModelFileManager;
import android.view.textclassifier.SelectionEvent;
import android.view.textclassifier.SelectionSessionLogger;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassificationConstants;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextClassifierEvent;
import android.view.textclassifier.TextClassifierEventTronLogger;
import android.view.textclassifier.TextLanguage;
import android.view.textclassifier.TextLinks;
import android.view.textclassifier.TextSelection;
import android.view.textclassifier.intent.ClassificationIntentFactory;
import android.view.textclassifier.intent.LabeledIntent;
import android.view.textclassifier.intent.LegacyClassificationIntentFactory;
import android.view.textclassifier.intent.TemplateClassificationIntentFactory;
import android.view.textclassifier.intent.TemplateIntentFactory;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import com.google.android.textclassifier.ActionsSuggestionsModel;
import com.google.android.textclassifier.AnnotatorModel;
import com.google.android.textclassifier.LangIdModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;

public final class TextClassifierImpl
implements TextClassifier {
    private static final String LOG_TAG = "androidtc";
    private static final boolean DEBUG = false;
    private static final File FACTORY_MODEL_DIR = new File("/etc/textclassifier/");
    private static final String ANNOTATOR_FACTORY_MODEL_FILENAME_REGEX = "textclassifier\\.(.*)\\.model";
    private static final File ANNOTATOR_UPDATED_MODEL_FILE = new File("/data/misc/textclassifier/textclassifier.model");
    private static final String LANG_ID_FACTORY_MODEL_FILENAME_REGEX = "lang_id.model";
    private static final File UPDATED_LANG_ID_MODEL_FILE = new File("/data/misc/textclassifier/lang_id.model");
    private static final String ACTIONS_FACTORY_MODEL_FILENAME_REGEX = "actions_suggestions\\.(.*)\\.model";
    private static final File UPDATED_ACTIONS_MODEL = new File("/data/misc/textclassifier/actions_suggestions.model");
    private final Context mContext;
    private final TextClassifier mFallback;
    private final GenerateLinksLogger mGenerateLinksLogger;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private ModelFileManager.ModelFile mAnnotatorModelInUse;
    @GuardedBy(value={"mLock"})
    private AnnotatorModel mAnnotatorImpl;
    @GuardedBy(value={"mLock"})
    private ModelFileManager.ModelFile mLangIdModelInUse;
    @GuardedBy(value={"mLock"})
    private LangIdModel mLangIdImpl;
    @GuardedBy(value={"mLock"})
    private ModelFileManager.ModelFile mActionModelInUse;
    @GuardedBy(value={"mLock"})
    private ActionsSuggestionsModel mActionsImpl;
    private final SelectionSessionLogger mSessionLogger = new SelectionSessionLogger();
    private final TextClassifierEventTronLogger mTextClassifierEventTronLogger = new TextClassifierEventTronLogger();
    private final TextClassificationConstants mSettings;
    private final ModelFileManager mAnnotatorModelFileManager;
    private final ModelFileManager mLangIdModelFileManager;
    private final ModelFileManager mActionsModelFileManager;
    private final ClassificationIntentFactory mClassificationIntentFactory;
    private final TemplateIntentFactory mTemplateIntentFactory;
    private final Supplier<ActionsModelParamsSupplier.ActionsModelParams> mActionsModelParamsSupplier;

    public TextClassifierImpl(Context context, TextClassificationConstants settings, TextClassifier fallback) {
        this.mContext = Preconditions.checkNotNull(context);
        this.mFallback = Preconditions.checkNotNull(fallback);
        this.mSettings = Preconditions.checkNotNull(settings);
        this.mGenerateLinksLogger = new GenerateLinksLogger(this.mSettings.getGenerateLinksLogSampleRate());
        this.mAnnotatorModelFileManager = new ModelFileManager(new ModelFileManager.ModelFileSupplierImpl(FACTORY_MODEL_DIR, ANNOTATOR_FACTORY_MODEL_FILENAME_REGEX, ANNOTATOR_UPDATED_MODEL_FILE, AnnotatorModel::getVersion, AnnotatorModel::getLocales));
        this.mLangIdModelFileManager = new ModelFileManager(new ModelFileManager.ModelFileSupplierImpl(FACTORY_MODEL_DIR, LANG_ID_FACTORY_MODEL_FILENAME_REGEX, UPDATED_LANG_ID_MODEL_FILE, LangIdModel::getVersion, fd -> "*"));
        this.mActionsModelFileManager = new ModelFileManager(new ModelFileManager.ModelFileSupplierImpl(FACTORY_MODEL_DIR, ACTIONS_FACTORY_MODEL_FILENAME_REGEX, UPDATED_ACTIONS_MODEL, ActionsSuggestionsModel::getVersion, ActionsSuggestionsModel::getLocales));
        this.mTemplateIntentFactory = new TemplateIntentFactory();
        this.mClassificationIntentFactory = this.mSettings.isTemplateIntentFactoryEnabled() ? new TemplateClassificationIntentFactory(this.mTemplateIntentFactory, new LegacyClassificationIntentFactory()) : new LegacyClassificationIntentFactory();
        this.mActionsModelParamsSupplier = new ActionsModelParamsSupplier(this.mContext, () -> {
            Object object = this.mLock;
            synchronized (object) {
                this.mActionsImpl = null;
                this.mActionModelInUse = null;
            }
        });
    }

    public TextClassifierImpl(Context context, TextClassificationConstants settings) {
        this(context, settings, TextClassifier.NO_OP);
    }

    @Override
    public TextSelection suggestSelection(TextSelection.Request request) {
        Preconditions.checkNotNull(request);
        TextClassifier.Utils.checkMainThread();
        try {
            int rangeLength = request.getEndIndex() - request.getStartIndex();
            String string2 = request.getText().toString();
            if (string2.length() > 0 && rangeLength <= this.mSettings.getSuggestSelectionMaxRangeLength()) {
                int end;
                int start;
                String localesString = TextClassifierImpl.concatenateLocales(request.getDefaultLocales());
                String detectLanguageTags = this.detectLanguageTagsFromText(request.getText());
                ZonedDateTime refTime = ZonedDateTime.now();
                AnnotatorModel annotatorImpl = this.getAnnotatorImpl(request.getDefaultLocales());
                if (this.mSettings.isModelDarkLaunchEnabled() && !request.isDarkLaunchAllowed()) {
                    start = request.getStartIndex();
                    end = request.getEndIndex();
                } else {
                    int[] startEnd = annotatorImpl.suggestSelection(string2, request.getStartIndex(), request.getEndIndex(), new AnnotatorModel.SelectionOptions(localesString, detectLanguageTags));
                    start = startEnd[0];
                    end = startEnd[1];
                }
                if (start < end && start >= 0 && end <= string2.length() && start <= request.getStartIndex() && end >= request.getEndIndex()) {
                    TextSelection.Builder tsBuilder = new TextSelection.Builder(start, end);
                    AnnotatorModel.ClassificationResult[] results = annotatorImpl.classifyText(string2, start, end, new AnnotatorModel.ClassificationOptions(refTime.toInstant().toEpochMilli(), refTime.getZone().getId(), localesString, detectLanguageTags), null, null);
                    int size = results.length;
                    for (int i = 0; i < size; ++i) {
                        tsBuilder.setEntityType(results[i].getCollection(), results[i].getScore());
                    }
                    return tsBuilder.setId(this.createId(string2, request.getStartIndex(), request.getEndIndex())).build();
                }
                Log.d(LOG_TAG, "Got bad indices for input text. Ignoring result.");
            }
        }
        catch (Throwable t) {
            Log.e(LOG_TAG, "Error suggesting selection for text. No changes to selection suggested.", t);
        }
        return this.mFallback.suggestSelection(request);
    }

    @Override
    public TextClassification classifyText(TextClassification.Request request) {
        Preconditions.checkNotNull(request);
        TextClassifier.Utils.checkMainThread();
        try {
            int rangeLength = request.getEndIndex() - request.getStartIndex();
            String string2 = request.getText().toString();
            if (string2.length() > 0 && rangeLength <= this.mSettings.getClassifyTextMaxRangeLength()) {
                String localesString = TextClassifierImpl.concatenateLocales(request.getDefaultLocales());
                String detectLanguageTags = this.detectLanguageTagsFromText(request.getText());
                ZonedDateTime refTime = request.getReferenceTime() != null ? request.getReferenceTime() : ZonedDateTime.now();
                AnnotatorModel.ClassificationResult[] results = this.getAnnotatorImpl(request.getDefaultLocales()).classifyText(string2, request.getStartIndex(), request.getEndIndex(), new AnnotatorModel.ClassificationOptions(refTime.toInstant().toEpochMilli(), refTime.getZone().getId(), localesString, detectLanguageTags), this.mContext, this.getResourceLocalesString());
                if (results.length > 0) {
                    return this.createClassificationResult(results, string2, request.getStartIndex(), request.getEndIndex(), refTime.toInstant());
                }
            }
        }
        catch (Throwable t) {
            Log.e(LOG_TAG, "Error getting text classification info.", t);
        }
        return this.mFallback.classifyText(request);
    }

    @Override
    public TextLinks generateLinks(TextLinks.Request request) {
        Preconditions.checkNotNull(request);
        TextClassifier.Utils.checkTextLength(request.getText(), this.getMaxGenerateLinksTextLength());
        TextClassifier.Utils.checkMainThread();
        if (!this.mSettings.isSmartLinkifyEnabled() && request.isLegacyFallback()) {
            return TextClassifier.Utils.generateLegacyLinks(request);
        }
        String textString = request.getText().toString();
        TextLinks.Builder builder = new TextLinks.Builder(textString);
        try {
            AnnotatorModel.AnnotatedSpan[] annotations;
            long startTimeMs = System.currentTimeMillis();
            ZonedDateTime refTime = ZonedDateTime.now();
            List<String> entitiesToIdentify = request.getEntityConfig() != null ? request.getEntityConfig().resolveEntityListModifications(this.getEntitiesForHints(request.getEntityConfig().getHints())) : this.mSettings.getEntityListDefault();
            String localesString = TextClassifierImpl.concatenateLocales(request.getDefaultLocales());
            String detectLanguageTags = this.detectLanguageTagsFromText(request.getText());
            AnnotatorModel annotatorImpl = this.getAnnotatorImpl(request.getDefaultLocales());
            boolean isSerializedEntityDataEnabled = ExtrasUtils.isSerializedEntityDataEnabled(request);
            for (AnnotatorModel.AnnotatedSpan span : annotations = annotatorImpl.annotate(textString, new AnnotatorModel.AnnotationOptions(refTime.toInstant().toEpochMilli(), refTime.getZone().getId(), localesString, detectLanguageTags, entitiesToIdentify, AnnotatorModel.AnnotationUsecase.SMART.getValue(), isSerializedEntityDataEnabled))) {
                AnnotatorModel.ClassificationResult[] results = span.getClassification();
                if (results.length == 0 || !entitiesToIdentify.contains(results[0].getCollection())) continue;
                ArrayMap<String, Float> entityScores = new ArrayMap<String, Float>();
                for (int i = 0; i < results.length; ++i) {
                    entityScores.put(results[i].getCollection(), Float.valueOf(results[i].getScore()));
                }
                Bundle extras = new Bundle();
                if (isSerializedEntityDataEnabled) {
                    ExtrasUtils.putEntities(extras, results);
                }
                builder.addLink(span.getStartIndex(), span.getEndIndex(), entityScores, extras);
            }
            TextLinks links = builder.build();
            long endTimeMs = System.currentTimeMillis();
            String callingPackageName = request.getCallingPackageName() == null ? this.mContext.getPackageName() : request.getCallingPackageName();
            this.mGenerateLinksLogger.logGenerateLinks(request.getText(), links, callingPackageName, endTimeMs - startTimeMs);
            return links;
        }
        catch (Throwable t) {
            Log.e(LOG_TAG, "Error getting links info.", t);
            return this.mFallback.generateLinks(request);
        }
    }

    @Override
    public int getMaxGenerateLinksTextLength() {
        return this.mSettings.getGenerateLinksMaxTextLength();
    }

    private Collection<String> getEntitiesForHints(Collection<String> hints) {
        boolean notEditable;
        boolean useDefault;
        boolean editable = hints.contains("android.text_is_editable");
        boolean bl = useDefault = editable == (notEditable = hints.contains("android.text_is_not_editable"));
        if (useDefault) {
            return this.mSettings.getEntityListDefault();
        }
        if (editable) {
            return this.mSettings.getEntityListEditable();
        }
        return this.mSettings.getEntityListNotEditable();
    }

    @Override
    public void onSelectionEvent(SelectionEvent event) {
        this.mSessionLogger.writeEvent(event);
    }

    @Override
    public void onTextClassifierEvent(TextClassifierEvent event) {
        try {
            SelectionEvent selEvent = event.toSelectionEvent();
            if (selEvent != null) {
                this.mSessionLogger.writeEvent(selEvent);
            } else {
                this.mTextClassifierEventTronLogger.writeEvent(event);
            }
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "Error writing event", e);
        }
    }

    @Override
    public TextLanguage detectLanguage(TextLanguage.Request request) {
        Preconditions.checkNotNull(request);
        TextClassifier.Utils.checkMainThread();
        try {
            TextLanguage.Builder builder = new TextLanguage.Builder();
            LangIdModel.LanguageResult[] langResults = this.getLangIdImpl().detectLanguages(request.getText().toString());
            for (int i = 0; i < langResults.length; ++i) {
                builder.putLocale(ULocale.forLanguageTag(langResults[i].getLanguage()), langResults[i].getScore());
            }
            return builder.build();
        }
        catch (Throwable t) {
            Log.e(LOG_TAG, "Error detecting text language.", t);
            return this.mFallback.detectLanguage(request);
        }
    }

    @Override
    public ConversationActions suggestConversationActions(ConversationActions.Request request) {
        Preconditions.checkNotNull(request);
        TextClassifier.Utils.checkMainThread();
        try {
            ActionsSuggestionsModel actionsImpl = this.getActionsImpl();
            if (actionsImpl == null) {
                return this.mFallback.suggestConversationActions(request);
            }
            ActionsSuggestionsModel.ConversationMessage[] nativeMessages = ActionsSuggestionsHelper.toNativeMessages(request.getConversation(), this::detectLanguageTagsFromText);
            if (nativeMessages.length == 0) {
                return this.mFallback.suggestConversationActions(request);
            }
            ActionsSuggestionsModel.Conversation nativeConversation = new ActionsSuggestionsModel.Conversation(nativeMessages);
            ActionsSuggestionsModel.ActionSuggestion[] nativeSuggestions = actionsImpl.suggestActionsWithIntents(nativeConversation, null, this.mContext, this.getResourceLocalesString(), this.getAnnotatorImpl(LocaleList.getDefault()));
            return this.createConversationActionResult(request, nativeSuggestions);
        }
        catch (Throwable t) {
            Log.e(LOG_TAG, "Error suggesting conversation actions.", t);
            return this.mFallback.suggestConversationActions(request);
        }
    }

    private ConversationActions createConversationActionResult(ConversationActions.Request request, ActionsSuggestionsModel.ActionSuggestion[] nativeSuggestions) {
        Collection<String> expectedTypes = this.resolveActionTypesFromRequest(request);
        List<ConversationAction> conversationActions = new ArrayList<ConversationAction>();
        for (ActionsSuggestionsModel.ActionSuggestion nativeSuggestion : nativeSuggestions) {
            String actionType = nativeSuggestion.getActionType();
            if (!expectedTypes.contains(actionType)) continue;
            LabeledIntent.Result labeledIntentResult = ActionsSuggestionsHelper.createLabeledIntentResult(this.mContext, this.mTemplateIntentFactory, nativeSuggestion);
            RemoteAction remoteAction = null;
            Bundle extras = new Bundle();
            if (labeledIntentResult != null) {
                remoteAction = labeledIntentResult.remoteAction;
                ExtrasUtils.putActionIntent(extras, labeledIntentResult.resolvedIntent);
            }
            ExtrasUtils.putSerializedEntityData(extras, nativeSuggestion.getSerializedEntityData());
            ExtrasUtils.putEntitiesExtras(extras, TemplateIntentFactory.nameVariantsToBundle(nativeSuggestion.getEntityData()));
            conversationActions.add(new ConversationAction.Builder(actionType).setConfidenceScore(nativeSuggestion.getScore()).setTextReply(nativeSuggestion.getResponseText()).setAction(remoteAction).setExtras(extras).build());
        }
        conversationActions = ActionsSuggestionsHelper.removeActionsWithDuplicates(conversationActions);
        if (request.getMaxSuggestions() >= 0 && conversationActions.size() > request.getMaxSuggestions()) {
            conversationActions = conversationActions.subList(0, request.getMaxSuggestions());
        }
        String resultId = ActionsSuggestionsHelper.createResultId(this.mContext, request.getConversation(), this.mActionModelInUse.getVersion(), this.mActionModelInUse.getSupportedLocales());
        return new ConversationActions(conversationActions, resultId);
    }

    private String detectLanguageTagsFromText(CharSequence text) {
        ULocale locale;
        if (!this.mSettings.isDetectLanguagesFromTextEnabled()) {
            return null;
        }
        float threshold = this.getLangIdThreshold();
        if (threshold < 0.0f || threshold > 1.0f) {
            Log.w(LOG_TAG, "[detectLanguageTagsFromText] unexpected threshold is found: " + threshold);
            return null;
        }
        TextLanguage.Request request = new TextLanguage.Request.Builder(text).build();
        TextLanguage textLanguage = this.detectLanguage(request);
        int localeHypothesisCount = textLanguage.getLocaleHypothesisCount();
        ArrayList<String> languageTags = new ArrayList<String>();
        for (int i = 0; i < localeHypothesisCount && !(textLanguage.getConfidenceScore(locale = textLanguage.getLocale(i)) < threshold); ++i) {
            languageTags.add(locale.toLanguageTag());
        }
        if (languageTags.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)",", languageTags);
    }

    private Collection<String> resolveActionTypesFromRequest(ConversationActions.Request request) {
        List<String> defaultActionTypes = request.getHints().contains("notification") ? this.mSettings.getNotificationConversationActionTypes() : this.mSettings.getInAppConversationActionTypes();
        return request.getTypeConfig().resolveEntityListModifications(defaultActionTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnnotatorModel getAnnotatorImpl(LocaleList localeList) throws FileNotFoundException {
        Object object = this.mLock;
        synchronized (object) {
            localeList = localeList == null ? LocaleList.getDefault() : localeList;
            ModelFileManager.ModelFile bestModel = this.mAnnotatorModelFileManager.findBestModelFile(localeList);
            if (bestModel == null) {
                throw new FileNotFoundException("No annotator model for " + localeList.toLanguageTags());
            }
            if (this.mAnnotatorImpl == null || !Objects.equals(this.mAnnotatorModelInUse, bestModel)) {
                Log.d(LOG_TAG, "Loading " + bestModel);
                ParcelFileDescriptor pfd = ParcelFileDescriptor.open(new File(bestModel.getPath()), 0x10000000);
                try {
                    if (pfd != null) {
                        this.mAnnotatorImpl = new AnnotatorModel(pfd.getFd());
                        this.mAnnotatorModelInUse = bestModel;
                    }
                }
                finally {
                    TextClassifierImpl.maybeCloseAndLogError(pfd);
                }
            }
            return this.mAnnotatorImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LangIdModel getLangIdImpl() throws FileNotFoundException {
        Object object = this.mLock;
        synchronized (object) {
            ModelFileManager.ModelFile bestModel = this.mLangIdModelFileManager.findBestModelFile(null);
            if (bestModel == null) {
                throw new FileNotFoundException("No LangID model is found");
            }
            if (this.mLangIdImpl == null || !Objects.equals(this.mLangIdModelInUse, bestModel)) {
                Log.d(LOG_TAG, "Loading " + bestModel);
                ParcelFileDescriptor pfd = ParcelFileDescriptor.open(new File(bestModel.getPath()), 0x10000000);
                try {
                    if (pfd != null) {
                        this.mLangIdImpl = new LangIdModel(pfd.getFd());
                        this.mLangIdModelInUse = bestModel;
                    }
                }
                finally {
                    TextClassifierImpl.maybeCloseAndLogError(pfd);
                }
            }
            return this.mLangIdImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionsSuggestionsModel getActionsImpl() throws FileNotFoundException {
        Object object = this.mLock;
        synchronized (object) {
            ModelFileManager.ModelFile bestModel = this.mActionsModelFileManager.findBestModelFile(LocaleList.getDefault());
            if (bestModel == null) {
                return null;
            }
            if (this.mActionsImpl == null || !Objects.equals(this.mActionModelInUse, bestModel)) {
                Log.d(LOG_TAG, "Loading " + bestModel);
                ParcelFileDescriptor pfd = ParcelFileDescriptor.open(new File(bestModel.getPath()), 0x10000000);
                try {
                    if (pfd == null) {
                        Log.d(LOG_TAG, "Failed to read the model file: " + bestModel.getPath());
                        ActionsSuggestionsModel actionsSuggestionsModel = null;
                        return actionsSuggestionsModel;
                    }
                    ActionsModelParamsSupplier.ActionsModelParams params = this.mActionsModelParamsSupplier.get();
                    this.mActionsImpl = new ActionsSuggestionsModel(pfd.getFd(), params.getSerializedPreconditions(bestModel));
                    this.mActionModelInUse = bestModel;
                }
                finally {
                    TextClassifierImpl.maybeCloseAndLogError(pfd);
                }
            }
            return this.mActionsImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createId(String text, int start, int end) {
        Object object = this.mLock;
        synchronized (object) {
            return SelectionSessionLogger.createId(text, start, end, this.mContext, this.mAnnotatorModelInUse.getVersion(), this.mAnnotatorModelInUse.getSupportedLocales());
        }
    }

    private static String concatenateLocales(LocaleList locales) {
        return locales == null ? "" : locales.toLanguageTags();
    }

    private TextClassification createClassificationResult(AnnotatorModel.ClassificationResult[] classifications, String text, int start, int end, Instant referenceTime) {
        String classifiedText = text.substring(start, end);
        TextClassification.Builder builder = new TextClassification.Builder().setText(classifiedText);
        int typeCount = classifications.length;
        AnnotatorModel.ClassificationResult highestScoringResult = typeCount > 0 ? classifications[0] : null;
        for (int i = 0; i < typeCount; ++i) {
            builder.setEntityType(classifications[i]);
            if (!(classifications[i].getScore() > highestScoringResult.getScore())) continue;
            highestScoringResult = classifications[i];
        }
        Pair<Bundle, Bundle> languagesBundles = this.generateLanguageBundles(text, start, end);
        Bundle textLanguagesBundle = (Bundle)languagesBundles.first;
        Bundle foreignLanguageBundle = (Bundle)languagesBundles.second;
        builder.setForeignLanguageExtra(foreignLanguageBundle);
        boolean isPrimaryAction = true;
        List<LabeledIntent> labeledIntents = this.mClassificationIntentFactory.create(this.mContext, classifiedText, foreignLanguageBundle != null, referenceTime, highestScoringResult);
        LabeledIntent.TitleChooser titleChooser = (labeledIntent, resolveInfo) -> labeledIntent.titleWithoutEntity;
        for (LabeledIntent labeledIntent2 : labeledIntents) {
            LabeledIntent.Result result = labeledIntent2.resolve(this.mContext, titleChooser, textLanguagesBundle);
            if (result == null) continue;
            Intent intent = result.resolvedIntent;
            RemoteAction action = result.remoteAction;
            if (isPrimaryAction) {
                builder.setIcon(action.getIcon().loadDrawable(this.mContext));
                builder.setLabel(action.getTitle().toString());
                builder.setIntent(intent);
                builder.setOnClickListener(TextClassification.createIntentOnClickListener(TextClassification.createPendingIntent(this.mContext, intent, labeledIntent2.requestCode)));
                isPrimaryAction = false;
            }
            builder.addAction(action, intent);
        }
        return builder.setId(this.createId(text, start, end)).build();
    }

    private Pair<Bundle, Bundle> generateLanguageBundles(String context, int start, int end) {
        if (!this.mSettings.isTranslateInClassificationEnabled()) {
            return null;
        }
        try {
            float threshold = this.getLangIdThreshold();
            if (threshold < 0.0f || threshold > 1.0f) {
                Log.w(LOG_TAG, "[detectForeignLanguage] unexpected threshold is found: " + threshold);
                return Pair.create(null, null);
            }
            EntityConfidence languageScores = this.detectLanguages(context, start, end);
            if (languageScores.getEntities().isEmpty()) {
                return Pair.create(null, null);
            }
            Bundle textLanguagesBundle = new Bundle();
            ExtrasUtils.putTopLanguageScores(textLanguagesBundle, languageScores);
            String language = languageScores.getEntities().get(0);
            float score = languageScores.getConfidenceScore(language);
            if (score < threshold) {
                return Pair.create(textLanguagesBundle, null);
            }
            Log.v(LOG_TAG, String.format(Locale.US, "Language detected: <%s:%.2f>", language, Float.valueOf(score)));
            Locale detected = new Locale(language);
            LocaleList deviceLocales = LocaleList.getDefault();
            int size = deviceLocales.size();
            for (int i = 0; i < size; ++i) {
                if (!deviceLocales.get(i).getLanguage().equals(detected.getLanguage())) continue;
                return Pair.create(textLanguagesBundle, null);
            }
            Bundle foreignLanguageBundle = ExtrasUtils.createForeignLanguageExtra(detected.getLanguage(), score, this.getLangIdImpl().getVersion());
            return Pair.create(textLanguagesBundle, foreignLanguageBundle);
        }
        catch (Throwable t) {
            Log.e(LOG_TAG, "Error generating language bundles.", t);
            return Pair.create(null, null);
        }
    }

    private EntityConfidence detectLanguages(String text, int start, int end) throws FileNotFoundException {
        EntityConfidence moreTextScores;
        Preconditions.checkArgument(start >= 0);
        Preconditions.checkArgument(end <= text.length());
        Preconditions.checkArgument(start <= end);
        float[] langIdContextSettings = this.mSettings.getLangIdContextSettings();
        int minimumTextSize = (int)langIdContextSettings[0];
        float penalizeRatio = langIdContextSettings[1];
        float subjectTextScoreRatio = langIdContextSettings[2];
        float moreTextScoreRatio = 1.0f - subjectTextScoreRatio;
        Log.v(LOG_TAG, String.format(Locale.US, "LangIdContextSettings: minimumTextSize=%d, penalizeRatio=%.2f, subjectTextScoreRatio=%.2f, moreTextScoreRatio=%.2f", minimumTextSize, Float.valueOf(penalizeRatio), Float.valueOf(subjectTextScoreRatio), Float.valueOf(moreTextScoreRatio)));
        if (end - start < minimumTextSize && penalizeRatio <= 0.0f) {
            return new EntityConfidence(Collections.emptyMap());
        }
        String subject = text.substring(start, end);
        EntityConfidence scores = this.detectLanguages(subject);
        if (subject.length() >= minimumTextSize || subject.length() == text.length() || subjectTextScoreRatio * penalizeRatio >= 1.0f) {
            return scores;
        }
        if (moreTextScoreRatio >= 0.0f) {
            String moreText = TextClassifier.Utils.getSubString(text, start, end, minimumTextSize);
            moreTextScores = this.detectLanguages(moreText);
        } else {
            moreTextScores = new EntityConfidence(Collections.emptyMap());
        }
        ArrayMap<String, Float> newScores = new ArrayMap<String, Float>();
        ArraySet<String> languages = new ArraySet<String>();
        languages.addAll(scores.getEntities());
        languages.addAll(moreTextScores.getEntities());
        for (String language : languages) {
            float score = (subjectTextScoreRatio * scores.getConfidenceScore(language) + moreTextScoreRatio * moreTextScores.getConfidenceScore(language)) * penalizeRatio;
            newScores.put(language, Float.valueOf(score));
        }
        return new EntityConfidence(newScores);
    }

    private EntityConfidence detectLanguages(String text) throws FileNotFoundException {
        LangIdModel langId = this.getLangIdImpl();
        LangIdModel.LanguageResult[] langResults = langId.detectLanguages(text);
        ArrayMap<String, Float> languagesMap = new ArrayMap<String, Float>();
        for (LangIdModel.LanguageResult langResult : langResults) {
            languagesMap.put(langResult.getLanguage(), Float.valueOf(langResult.getScore()));
        }
        return new EntityConfidence(languagesMap);
    }

    private float getLangIdThreshold() {
        try {
            return this.mSettings.getLangIdThresholdOverride() >= 0.0f ? this.mSettings.getLangIdThresholdOverride() : this.getLangIdImpl().getLangIdThreshold();
        }
        catch (FileNotFoundException e) {
            float defaultThreshold = 0.5f;
            Log.v(LOG_TAG, "Using default foreign language threshold: 0.5");
            return 0.5f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(IndentingPrintWriter printWriter) {
        Object object = this.mLock;
        synchronized (object) {
            printWriter.println("TextClassifierImpl:");
            printWriter.increaseIndent();
            printWriter.println("Annotator model file(s):");
            printWriter.increaseIndent();
            for (ModelFileManager.ModelFile modelFile : this.mAnnotatorModelFileManager.listModelFiles()) {
                printWriter.println(modelFile.toString());
            }
            printWriter.decreaseIndent();
            printWriter.println("LangID model file(s):");
            printWriter.increaseIndent();
            for (ModelFileManager.ModelFile modelFile : this.mLangIdModelFileManager.listModelFiles()) {
                printWriter.println(modelFile.toString());
            }
            printWriter.decreaseIndent();
            printWriter.println("Actions model file(s):");
            printWriter.increaseIndent();
            for (ModelFileManager.ModelFile modelFile : this.mActionsModelFileManager.listModelFiles()) {
                printWriter.println(modelFile.toString());
            }
            printWriter.decreaseIndent();
            printWriter.printPair("mFallback", this.mFallback);
            printWriter.decreaseIndent();
            printWriter.println();
        }
    }

    private static void maybeCloseAndLogError(ParcelFileDescriptor fd) {
        if (fd == null) {
            return;
        }
        try {
            fd.close();
        }
        catch (IOException e) {
            Log.e(LOG_TAG, "Error closing file.", e);
        }
    }

    private String getResourceLocalesString() {
        try {
            return this.mContext.getResources().getConfiguration().getLocales().toLanguageTags();
        }
        catch (NullPointerException e) {
            return LocaleList.getDefault().toLanguageTags();
        }
    }
}

