/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.icu.util.Calendar;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.CalendarViewLegacyDelegate;
import android.widget.CalendarViewMaterialDelegate;
import android.widget.FrameLayout;
import com.android.internal.R;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class CalendarView
extends FrameLayout {
    private static final String LOG_TAG = "CalendarView";
    private static final int MODE_HOLO = 0;
    private static final int MODE_MATERIAL = 1;
    @UnsupportedAppUsage
    private final CalendarViewDelegate mDelegate;
    private static final String DATE_FORMAT = "MM/dd/yyyy";
    private static final DateFormat DATE_FORMATTER = new SimpleDateFormat("MM/dd/yyyy");

    public CalendarView(Context context) {
        this(context, null);
    }

    public CalendarView(Context context, AttributeSet attrs) {
        this(context, attrs, 16843613);
    }

    public CalendarView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public CalendarView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CalendarView, defStyleAttr, defStyleRes);
        this.saveAttributeDataForStyleable(context, R.styleable.CalendarView, attrs, a, defStyleAttr, defStyleRes);
        int mode = a.getInt(13, 0);
        a.recycle();
        switch (mode) {
            case 0: {
                this.mDelegate = new CalendarViewLegacyDelegate(this, context, attrs, defStyleAttr, defStyleRes);
                break;
            }
            case 1: {
                this.mDelegate = new CalendarViewMaterialDelegate(this, context, attrs, defStyleAttr, defStyleRes);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid calendarViewMode attribute");
            }
        }
    }

    @Deprecated
    public void setShownWeekCount(int count) {
        this.mDelegate.setShownWeekCount(count);
    }

    @Deprecated
    public int getShownWeekCount() {
        return this.mDelegate.getShownWeekCount();
    }

    @Deprecated
    public void setSelectedWeekBackgroundColor(int color2) {
        this.mDelegate.setSelectedWeekBackgroundColor(color2);
    }

    @Deprecated
    public int getSelectedWeekBackgroundColor() {
        return this.mDelegate.getSelectedWeekBackgroundColor();
    }

    @Deprecated
    public void setFocusedMonthDateColor(int color2) {
        this.mDelegate.setFocusedMonthDateColor(color2);
    }

    @Deprecated
    public int getFocusedMonthDateColor() {
        return this.mDelegate.getFocusedMonthDateColor();
    }

    @Deprecated
    public void setUnfocusedMonthDateColor(int color2) {
        this.mDelegate.setUnfocusedMonthDateColor(color2);
    }

    @Deprecated
    public int getUnfocusedMonthDateColor() {
        return this.mDelegate.getUnfocusedMonthDateColor();
    }

    @Deprecated
    public void setWeekNumberColor(int color2) {
        this.mDelegate.setWeekNumberColor(color2);
    }

    @Deprecated
    public int getWeekNumberColor() {
        return this.mDelegate.getWeekNumberColor();
    }

    @Deprecated
    public void setWeekSeparatorLineColor(int color2) {
        this.mDelegate.setWeekSeparatorLineColor(color2);
    }

    @Deprecated
    public int getWeekSeparatorLineColor() {
        return this.mDelegate.getWeekSeparatorLineColor();
    }

    @Deprecated
    public void setSelectedDateVerticalBar(int resourceId) {
        this.mDelegate.setSelectedDateVerticalBar(resourceId);
    }

    @Deprecated
    public void setSelectedDateVerticalBar(Drawable drawable2) {
        this.mDelegate.setSelectedDateVerticalBar(drawable2);
    }

    @Deprecated
    public Drawable getSelectedDateVerticalBar() {
        return this.mDelegate.getSelectedDateVerticalBar();
    }

    public void setWeekDayTextAppearance(int resourceId) {
        this.mDelegate.setWeekDayTextAppearance(resourceId);
    }

    public int getWeekDayTextAppearance() {
        return this.mDelegate.getWeekDayTextAppearance();
    }

    public void setDateTextAppearance(int resourceId) {
        this.mDelegate.setDateTextAppearance(resourceId);
    }

    public int getDateTextAppearance() {
        return this.mDelegate.getDateTextAppearance();
    }

    public long getMinDate() {
        return this.mDelegate.getMinDate();
    }

    public void setMinDate(long minDate) {
        this.mDelegate.setMinDate(minDate);
    }

    public long getMaxDate() {
        return this.mDelegate.getMaxDate();
    }

    public void setMaxDate(long maxDate) {
        this.mDelegate.setMaxDate(maxDate);
    }

    @Deprecated
    public void setShowWeekNumber(boolean showWeekNumber) {
        this.mDelegate.setShowWeekNumber(showWeekNumber);
    }

    @Deprecated
    public boolean getShowWeekNumber() {
        return this.mDelegate.getShowWeekNumber();
    }

    public int getFirstDayOfWeek() {
        return this.mDelegate.getFirstDayOfWeek();
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.mDelegate.setFirstDayOfWeek(firstDayOfWeek);
    }

    public void setOnDateChangeListener(OnDateChangeListener listener) {
        this.mDelegate.setOnDateChangeListener(listener);
    }

    public long getDate() {
        return this.mDelegate.getDate();
    }

    public void setDate(long date) {
        this.mDelegate.setDate(date);
    }

    public void setDate(long date, boolean animate, boolean center) {
        this.mDelegate.setDate(date, animate, center);
    }

    public boolean getBoundsForDate(long date, Rect outBounds) {
        return this.mDelegate.getBoundsForDate(date, outBounds);
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mDelegate.onConfigurationChanged(newConfig);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return CalendarView.class.getName();
    }

    public static boolean parseDate(String date, Calendar outDate) {
        if (date == null || date.isEmpty()) {
            return false;
        }
        try {
            Date parsedDate = DATE_FORMATTER.parse(date);
            outDate.setTime(parsedDate);
            return true;
        }
        catch (ParseException e) {
            Log.w(LOG_TAG, "Date: " + date + " not in format: " + DATE_FORMAT);
            return false;
        }
    }

    static abstract class AbstractCalendarViewDelegate
    implements CalendarViewDelegate {
        protected static final String DEFAULT_MIN_DATE = "01/01/1900";
        protected static final String DEFAULT_MAX_DATE = "01/01/2100";
        protected CalendarView mDelegator;
        protected Context mContext;
        protected Locale mCurrentLocale;

        AbstractCalendarViewDelegate(CalendarView delegator, Context context) {
            this.mDelegator = delegator;
            this.mContext = context;
            this.setCurrentLocale(Locale.getDefault());
        }

        protected void setCurrentLocale(Locale locale) {
            if (locale.equals(this.mCurrentLocale)) {
                return;
            }
            this.mCurrentLocale = locale;
        }

        @Override
        public void setShownWeekCount(int count) {
        }

        @Override
        public int getShownWeekCount() {
            return 0;
        }

        @Override
        public void setSelectedWeekBackgroundColor(int color2) {
        }

        @Override
        public int getSelectedWeekBackgroundColor() {
            return 0;
        }

        @Override
        public void setFocusedMonthDateColor(int color2) {
        }

        @Override
        public int getFocusedMonthDateColor() {
            return 0;
        }

        @Override
        public void setUnfocusedMonthDateColor(int color2) {
        }

        @Override
        public int getUnfocusedMonthDateColor() {
            return 0;
        }

        @Override
        public void setWeekNumberColor(int color2) {
        }

        @Override
        public int getWeekNumberColor() {
            return 0;
        }

        @Override
        public void setWeekSeparatorLineColor(int color2) {
        }

        @Override
        public int getWeekSeparatorLineColor() {
            return 0;
        }

        @Override
        public void setSelectedDateVerticalBar(int resId) {
        }

        @Override
        public void setSelectedDateVerticalBar(Drawable drawable2) {
        }

        @Override
        public Drawable getSelectedDateVerticalBar() {
            return null;
        }

        @Override
        public void setShowWeekNumber(boolean showWeekNumber) {
        }

        @Override
        public boolean getShowWeekNumber() {
            return false;
        }

        @Override
        public void onConfigurationChanged(Configuration newConfig) {
        }
    }

    private static interface CalendarViewDelegate {
        public void setShownWeekCount(int var1);

        public int getShownWeekCount();

        public void setSelectedWeekBackgroundColor(int var1);

        public int getSelectedWeekBackgroundColor();

        public void setFocusedMonthDateColor(int var1);

        public int getFocusedMonthDateColor();

        public void setUnfocusedMonthDateColor(int var1);

        public int getUnfocusedMonthDateColor();

        public void setWeekNumberColor(int var1);

        public int getWeekNumberColor();

        public void setWeekSeparatorLineColor(int var1);

        public int getWeekSeparatorLineColor();

        public void setSelectedDateVerticalBar(int var1);

        public void setSelectedDateVerticalBar(Drawable var1);

        public Drawable getSelectedDateVerticalBar();

        public void setWeekDayTextAppearance(int var1);

        public int getWeekDayTextAppearance();

        public void setDateTextAppearance(int var1);

        public int getDateTextAppearance();

        public void setMinDate(long var1);

        public long getMinDate();

        public void setMaxDate(long var1);

        public long getMaxDate();

        public void setShowWeekNumber(boolean var1);

        public boolean getShowWeekNumber();

        public void setFirstDayOfWeek(int var1);

        public int getFirstDayOfWeek();

        public void setDate(long var1);

        public void setDate(long var1, boolean var3, boolean var4);

        public long getDate();

        public boolean getBoundsForDate(long var1, Rect var3);

        public void setOnDateChangeListener(OnDateChangeListener var1);

        public void onConfigurationChanged(Configuration var1);
    }

    public static interface OnDateChangeListener {
        public void onSelectedDayChange(CalendarView var1, int var2, int var3, int var4);
    }
}

