/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.icu.util.Calendar;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.CalendarView;
import android.widget.ListView;
import android.widget.TextView;
import com.android.internal.R;
import java.util.Locale;
import libcore.icu.LocaleData;

class CalendarViewLegacyDelegate
extends CalendarView.AbstractCalendarViewDelegate {
    private static final boolean DEFAULT_SHOW_WEEK_NUMBER = true;
    private static final long MILLIS_IN_DAY = 86400000L;
    private static final int DAYS_PER_WEEK = 7;
    private static final long MILLIS_IN_WEEK = 604800000L;
    private static final int SCROLL_HYST_WEEKS = 2;
    private static final int GOTO_SCROLL_DURATION = 1000;
    private static final int ADJUSTMENT_SCROLL_DURATION = 500;
    private static final int SCROLL_CHANGE_DELAY = 40;
    private static final int DEFAULT_SHOWN_WEEK_COUNT = 6;
    private static final int DEFAULT_DATE_TEXT_SIZE = 14;
    private static final int UNSCALED_SELECTED_DATE_VERTICAL_BAR_WIDTH = 6;
    private static final int UNSCALED_WEEK_MIN_VISIBLE_HEIGHT = 12;
    private static final int UNSCALED_LIST_SCROLL_TOP_OFFSET = 2;
    private static final int UNSCALED_BOTTOM_BUFFER = 20;
    private static final int UNSCALED_WEEK_SEPARATOR_LINE_WIDTH = 1;
    private static final int DEFAULT_WEEK_DAY_TEXT_APPEARANCE_RES_ID = -1;
    private final int mWeekSeparatorLineWidth;
    private int mDateTextSize;
    private Drawable mSelectedDateVerticalBar;
    private final int mSelectedDateVerticalBarWidth;
    private int mSelectedWeekBackgroundColor;
    private int mFocusedMonthDateColor;
    private int mUnfocusedMonthDateColor;
    private int mWeekSeparatorLineColor;
    private int mWeekNumberColor;
    private int mWeekDayTextAppearanceResId;
    private int mDateTextAppearanceResId;
    private int mListScrollTopOffset = 2;
    private int mWeekMinVisibleHeight = 12;
    private int mBottomBuffer = 20;
    private int mShownWeekCount;
    private boolean mShowWeekNumber;
    private int mDaysPerWeek = 7;
    private float mFriction = 0.05f;
    private float mVelocityScale = 0.333f;
    private WeeksAdapter mAdapter;
    private ListView mListView;
    private TextView mMonthName;
    private ViewGroup mDayNamesHeader;
    private String[] mDayNamesShort;
    private String[] mDayNamesLong;
    private int mFirstDayOfWeek;
    private int mCurrentMonthDisplayed = -1;
    private long mPreviousScrollPosition;
    private boolean mIsScrollingUp = false;
    private int mPreviousScrollState = 0;
    private int mCurrentScrollState = 0;
    private CalendarView.OnDateChangeListener mOnDateChangeListener;
    private ScrollStateRunnable mScrollStateChangedRunnable = new ScrollStateRunnable();
    private Calendar mTempDate;
    private Calendar mFirstDayOfMonth;
    private Calendar mMinDate;
    private Calendar mMaxDate;

    CalendarViewLegacyDelegate(CalendarView delegator, Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(delegator, context);
        String maxDate;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CalendarView, defStyleAttr, defStyleRes);
        this.mShowWeekNumber = a.getBoolean(1, true);
        this.mFirstDayOfWeek = a.getInt(0, LocaleData.get((Locale)Locale.getDefault()).firstDayOfWeek);
        String minDate = a.getString(2);
        if (!CalendarView.parseDate(minDate, this.mMinDate)) {
            CalendarView.parseDate("01/01/1900", this.mMinDate);
        }
        if (!CalendarView.parseDate(maxDate = a.getString(3), this.mMaxDate)) {
            CalendarView.parseDate("01/01/2100", this.mMaxDate);
        }
        if (this.mMaxDate.before(this.mMinDate)) {
            throw new IllegalArgumentException("Max date cannot be before min date.");
        }
        this.mShownWeekCount = a.getInt(4, 6);
        this.mSelectedWeekBackgroundColor = a.getColor(5, 0);
        this.mFocusedMonthDateColor = a.getColor(6, 0);
        this.mUnfocusedMonthDateColor = a.getColor(7, 0);
        this.mWeekSeparatorLineColor = a.getColor(9, 0);
        this.mWeekNumberColor = a.getColor(8, 0);
        this.mSelectedDateVerticalBar = a.getDrawable(10);
        this.mDateTextAppearanceResId = a.getResourceId(12, 16973894);
        this.updateDateTextSize();
        this.mWeekDayTextAppearanceResId = a.getResourceId(11, -1);
        a.recycle();
        DisplayMetrics displayMetrics = this.mDelegator.getResources().getDisplayMetrics();
        this.mWeekMinVisibleHeight = (int)TypedValue.applyDimension(1, 12.0f, displayMetrics);
        this.mListScrollTopOffset = (int)TypedValue.applyDimension(1, 2.0f, displayMetrics);
        this.mBottomBuffer = (int)TypedValue.applyDimension(1, 20.0f, displayMetrics);
        this.mSelectedDateVerticalBarWidth = (int)TypedValue.applyDimension(1, 6.0f, displayMetrics);
        this.mWeekSeparatorLineWidth = (int)TypedValue.applyDimension(1, 1.0f, displayMetrics);
        LayoutInflater layoutInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        View content = layoutInflater.inflate(17367106, null, false);
        this.mDelegator.addView(content);
        this.mListView = (ListView)this.mDelegator.findViewById(16908298);
        this.mDayNamesHeader = (ViewGroup)content.findViewById(16908866);
        this.mMonthName = (TextView)content.findViewById(16909128);
        this.setUpHeader();
        this.setUpListView();
        this.setUpAdapter();
        this.mTempDate.setTimeInMillis(System.currentTimeMillis());
        if (this.mTempDate.before(this.mMinDate)) {
            this.goTo(this.mMinDate, false, true, true);
        } else if (this.mMaxDate.before(this.mTempDate)) {
            this.goTo(this.mMaxDate, false, true, true);
        } else {
            this.goTo(this.mTempDate, false, true, true);
        }
        this.mDelegator.invalidate();
    }

    @Override
    public void setShownWeekCount(int count) {
        if (this.mShownWeekCount != count) {
            this.mShownWeekCount = count;
            this.mDelegator.invalidate();
        }
    }

    @Override
    public int getShownWeekCount() {
        return this.mShownWeekCount;
    }

    @Override
    public void setSelectedWeekBackgroundColor(int color2) {
        if (this.mSelectedWeekBackgroundColor != color2) {
            this.mSelectedWeekBackgroundColor = color2;
            int childCount = this.mListView.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                WeekView weekView = (WeekView)this.mListView.getChildAt(i);
                if (!weekView.mHasSelectedDay) continue;
                weekView.invalidate();
            }
        }
    }

    @Override
    public int getSelectedWeekBackgroundColor() {
        return this.mSelectedWeekBackgroundColor;
    }

    @Override
    public void setFocusedMonthDateColor(int color2) {
        if (this.mFocusedMonthDateColor != color2) {
            this.mFocusedMonthDateColor = color2;
            int childCount = this.mListView.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                WeekView weekView = (WeekView)this.mListView.getChildAt(i);
                if (!weekView.mHasFocusedDay) continue;
                weekView.invalidate();
            }
        }
    }

    @Override
    public int getFocusedMonthDateColor() {
        return this.mFocusedMonthDateColor;
    }

    @Override
    public void setUnfocusedMonthDateColor(int color2) {
        if (this.mUnfocusedMonthDateColor != color2) {
            this.mUnfocusedMonthDateColor = color2;
            int childCount = this.mListView.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                WeekView weekView = (WeekView)this.mListView.getChildAt(i);
                if (!weekView.mHasUnfocusedDay) continue;
                weekView.invalidate();
            }
        }
    }

    @Override
    public int getUnfocusedMonthDateColor() {
        return this.mUnfocusedMonthDateColor;
    }

    @Override
    public void setWeekNumberColor(int color2) {
        if (this.mWeekNumberColor != color2) {
            this.mWeekNumberColor = color2;
            if (this.mShowWeekNumber) {
                this.invalidateAllWeekViews();
            }
        }
    }

    @Override
    public int getWeekNumberColor() {
        return this.mWeekNumberColor;
    }

    @Override
    public void setWeekSeparatorLineColor(int color2) {
        if (this.mWeekSeparatorLineColor != color2) {
            this.mWeekSeparatorLineColor = color2;
            this.invalidateAllWeekViews();
        }
    }

    @Override
    public int getWeekSeparatorLineColor() {
        return this.mWeekSeparatorLineColor;
    }

    @Override
    public void setSelectedDateVerticalBar(int resourceId) {
        Drawable drawable2 = this.mDelegator.getContext().getDrawable(resourceId);
        this.setSelectedDateVerticalBar(drawable2);
    }

    @Override
    public void setSelectedDateVerticalBar(Drawable drawable2) {
        if (this.mSelectedDateVerticalBar != drawable2) {
            this.mSelectedDateVerticalBar = drawable2;
            int childCount = this.mListView.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                WeekView weekView = (WeekView)this.mListView.getChildAt(i);
                if (!weekView.mHasSelectedDay) continue;
                weekView.invalidate();
            }
        }
    }

    @Override
    public Drawable getSelectedDateVerticalBar() {
        return this.mSelectedDateVerticalBar;
    }

    @Override
    public void setWeekDayTextAppearance(int resourceId) {
        if (this.mWeekDayTextAppearanceResId != resourceId) {
            this.mWeekDayTextAppearanceResId = resourceId;
            this.setUpHeader();
        }
    }

    @Override
    public int getWeekDayTextAppearance() {
        return this.mWeekDayTextAppearanceResId;
    }

    @Override
    public void setDateTextAppearance(int resourceId) {
        if (this.mDateTextAppearanceResId != resourceId) {
            this.mDateTextAppearanceResId = resourceId;
            this.updateDateTextSize();
            this.invalidateAllWeekViews();
        }
    }

    @Override
    public int getDateTextAppearance() {
        return this.mDateTextAppearanceResId;
    }

    @Override
    public void setMinDate(long minDate) {
        this.mTempDate.setTimeInMillis(minDate);
        if (CalendarViewLegacyDelegate.isSameDate(this.mTempDate, this.mMinDate)) {
            return;
        }
        this.mMinDate.setTimeInMillis(minDate);
        Calendar date = this.mAdapter.mSelectedDate;
        if (date.before(this.mMinDate)) {
            this.mAdapter.setSelectedDay(this.mMinDate);
        }
        this.mAdapter.init();
        if (date.before(this.mMinDate)) {
            this.setDate(this.mTempDate.getTimeInMillis());
        } else {
            this.goTo(date, false, true, false);
        }
    }

    @Override
    public long getMinDate() {
        return this.mMinDate.getTimeInMillis();
    }

    @Override
    public void setMaxDate(long maxDate) {
        this.mTempDate.setTimeInMillis(maxDate);
        if (CalendarViewLegacyDelegate.isSameDate(this.mTempDate, this.mMaxDate)) {
            return;
        }
        this.mMaxDate.setTimeInMillis(maxDate);
        this.mAdapter.init();
        Calendar date = this.mAdapter.mSelectedDate;
        if (date.after(this.mMaxDate)) {
            this.setDate(this.mMaxDate.getTimeInMillis());
        } else {
            this.goTo(date, false, true, false);
        }
    }

    @Override
    public long getMaxDate() {
        return this.mMaxDate.getTimeInMillis();
    }

    @Override
    public void setShowWeekNumber(boolean showWeekNumber) {
        if (this.mShowWeekNumber == showWeekNumber) {
            return;
        }
        this.mShowWeekNumber = showWeekNumber;
        this.mAdapter.notifyDataSetChanged();
        this.setUpHeader();
    }

    @Override
    public boolean getShowWeekNumber() {
        return this.mShowWeekNumber;
    }

    @Override
    public void setFirstDayOfWeek(int firstDayOfWeek) {
        if (this.mFirstDayOfWeek == firstDayOfWeek) {
            return;
        }
        this.mFirstDayOfWeek = firstDayOfWeek;
        this.mAdapter.init();
        this.mAdapter.notifyDataSetChanged();
        this.setUpHeader();
    }

    @Override
    public int getFirstDayOfWeek() {
        return this.mFirstDayOfWeek;
    }

    @Override
    public void setDate(long date) {
        this.setDate(date, false, false);
    }

    @Override
    public void setDate(long date, boolean animate, boolean center) {
        this.mTempDate.setTimeInMillis(date);
        if (CalendarViewLegacyDelegate.isSameDate(this.mTempDate, this.mAdapter.mSelectedDate)) {
            return;
        }
        this.goTo(this.mTempDate, animate, true, center);
    }

    @Override
    public long getDate() {
        return this.mAdapter.mSelectedDate.getTimeInMillis();
    }

    @Override
    public void setOnDateChangeListener(CalendarView.OnDateChangeListener listener) {
        this.mOnDateChangeListener = listener;
    }

    @Override
    public boolean getBoundsForDate(long date, Rect outBounds) {
        Calendar calendarDate = Calendar.getInstance();
        calendarDate.setTimeInMillis(date);
        int listViewEntryCount = this.mListView.getCount();
        for (int i = 0; i < listViewEntryCount; ++i) {
            WeekView currWeekView = (WeekView)this.mListView.getChildAt(i);
            if (!currWeekView.getBoundsForDate(calendarDate, outBounds)) continue;
            int[] weekViewPositionOnScreen = new int[2];
            int[] delegatorPositionOnScreen = new int[2];
            currWeekView.getLocationOnScreen(weekViewPositionOnScreen);
            this.mDelegator.getLocationOnScreen(delegatorPositionOnScreen);
            int extraVerticalOffset = weekViewPositionOnScreen[1] - delegatorPositionOnScreen[1];
            outBounds.top += extraVerticalOffset;
            outBounds.bottom += extraVerticalOffset;
            return true;
        }
        return false;
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        this.setCurrentLocale(newConfig.locale);
    }

    @Override
    protected void setCurrentLocale(Locale locale) {
        super.setCurrentLocale(locale);
        this.mTempDate = CalendarViewLegacyDelegate.getCalendarForLocale(this.mTempDate, locale);
        this.mFirstDayOfMonth = CalendarViewLegacyDelegate.getCalendarForLocale(this.mFirstDayOfMonth, locale);
        this.mMinDate = CalendarViewLegacyDelegate.getCalendarForLocale(this.mMinDate, locale);
        this.mMaxDate = CalendarViewLegacyDelegate.getCalendarForLocale(this.mMaxDate, locale);
    }

    private void updateDateTextSize() {
        TypedArray dateTextAppearance = this.mDelegator.getContext().obtainStyledAttributes(this.mDateTextAppearanceResId, R.styleable.TextAppearance);
        this.mDateTextSize = dateTextAppearance.getDimensionPixelSize(0, 14);
        dateTextAppearance.recycle();
    }

    private void invalidateAllWeekViews() {
        int childCount = this.mListView.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View view = this.mListView.getChildAt(i);
            view.invalidate();
        }
    }

    private static Calendar getCalendarForLocale(Calendar oldCalendar, Locale locale) {
        if (oldCalendar == null) {
            return Calendar.getInstance(locale);
        }
        long currentTimeMillis = oldCalendar.getTimeInMillis();
        Calendar newCalendar = Calendar.getInstance(locale);
        newCalendar.setTimeInMillis(currentTimeMillis);
        return newCalendar;
    }

    private static boolean isSameDate(Calendar firstDate, Calendar secondDate) {
        return firstDate.get(6) == secondDate.get(6) && firstDate.get(1) == secondDate.get(1);
    }

    private void setUpAdapter() {
        if (this.mAdapter == null) {
            this.mAdapter = new WeeksAdapter(this.mContext);
            this.mAdapter.registerDataSetObserver(new DataSetObserver(){

                @Override
                public void onChanged() {
                    if (CalendarViewLegacyDelegate.this.mOnDateChangeListener != null) {
                        Calendar selectedDay = CalendarViewLegacyDelegate.this.mAdapter.getSelectedDay();
                        CalendarViewLegacyDelegate.this.mOnDateChangeListener.onSelectedDayChange(CalendarViewLegacyDelegate.this.mDelegator, selectedDay.get(1), selectedDay.get(2), selectedDay.get(5));
                    }
                }
            });
            this.mListView.setAdapter(this.mAdapter);
        }
        this.mAdapter.notifyDataSetChanged();
    }

    private void setUpHeader() {
        this.mDayNamesShort = new String[this.mDaysPerWeek];
        this.mDayNamesLong = new String[this.mDaysPerWeek];
        int count = this.mFirstDayOfWeek + this.mDaysPerWeek;
        for (int i = this.mFirstDayOfWeek; i < count; ++i) {
            int calendarDay = i > 7 ? i - 7 : i;
            this.mDayNamesShort[i - this.mFirstDayOfWeek] = DateUtils.getDayOfWeekString(calendarDay, 50);
            this.mDayNamesLong[i - this.mFirstDayOfWeek] = DateUtils.getDayOfWeekString(calendarDay, 10);
        }
        TextView label = (TextView)this.mDayNamesHeader.getChildAt(0);
        if (this.mShowWeekNumber) {
            label.setVisibility(0);
        } else {
            label.setVisibility(8);
        }
        int count2 = this.mDayNamesHeader.getChildCount();
        for (int i = 1; i < count2; ++i) {
            label = (TextView)this.mDayNamesHeader.getChildAt(i);
            if (this.mWeekDayTextAppearanceResId > -1) {
                label.setTextAppearance(this.mWeekDayTextAppearanceResId);
            }
            if (i < this.mDaysPerWeek + 1) {
                label.setText(this.mDayNamesShort[i - 1]);
                label.setContentDescription(this.mDayNamesLong[i - 1]);
                label.setVisibility(0);
                continue;
            }
            label.setVisibility(8);
        }
        this.mDayNamesHeader.invalidate();
    }

    private void setUpListView() {
        this.mListView.setDivider(null);
        this.mListView.setItemsCanFocus(true);
        this.mListView.setVerticalScrollBarEnabled(false);
        this.mListView.setOnScrollListener(new AbsListView.OnScrollListener(){

            @Override
            public void onScrollStateChanged(AbsListView view, int scrollState) {
                CalendarViewLegacyDelegate.this.onScrollStateChanged(view, scrollState);
            }

            @Override
            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                CalendarViewLegacyDelegate.this.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
            }
        });
        this.mListView.setFriction(this.mFriction);
        this.mListView.setVelocityScale(this.mVelocityScale);
    }

    private void goTo(Calendar date, boolean animate, boolean setSelected, boolean forceScroll) {
        int position;
        if (date.before(this.mMinDate) || date.after(this.mMaxDate)) {
            throw new IllegalArgumentException("timeInMillis must be between the values of getMinDate() and getMaxDate()");
        }
        int firstFullyVisiblePosition = this.mListView.getFirstVisiblePosition();
        View firstChild = this.mListView.getChildAt(0);
        if (firstChild != null && firstChild.getTop() < 0) {
            ++firstFullyVisiblePosition;
        }
        int lastFullyVisiblePosition = firstFullyVisiblePosition + this.mShownWeekCount - 1;
        if (firstChild != null && firstChild.getTop() > this.mBottomBuffer) {
            --lastFullyVisiblePosition;
        }
        if (setSelected) {
            this.mAdapter.setSelectedDay(date);
        }
        if ((position = this.getWeeksSinceMinDate(date)) < firstFullyVisiblePosition || position > lastFullyVisiblePosition || forceScroll) {
            this.mFirstDayOfMonth.setTimeInMillis(date.getTimeInMillis());
            this.mFirstDayOfMonth.set(5, 1);
            this.setMonthDisplayed(this.mFirstDayOfMonth);
            position = this.mFirstDayOfMonth.before(this.mMinDate) ? 0 : this.getWeeksSinceMinDate(this.mFirstDayOfMonth);
            this.mPreviousScrollState = 2;
            if (animate) {
                this.mListView.smoothScrollToPositionFromTop(position, this.mListScrollTopOffset, 1000);
            } else {
                this.mListView.setSelectionFromTop(position, this.mListScrollTopOffset);
                this.onScrollStateChanged(this.mListView, 0);
            }
        } else if (setSelected) {
            this.setMonthDisplayed(date);
        }
    }

    private void onScrollStateChanged(AbsListView view, int scrollState) {
        this.mScrollStateChangedRunnable.doScrollStateChange(view, scrollState);
    }

    private void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        int offset;
        WeekView child = (WeekView)view.getChildAt(0);
        if (child == null) {
            return;
        }
        long currScroll = view.getFirstVisiblePosition() * child.getHeight() - child.getBottom();
        if (currScroll < this.mPreviousScrollPosition) {
            this.mIsScrollingUp = true;
        } else if (currScroll > this.mPreviousScrollPosition) {
            this.mIsScrollingUp = false;
        } else {
            return;
        }
        int n = offset = child.getBottom() < this.mWeekMinVisibleHeight ? 1 : 0;
        if (this.mIsScrollingUp) {
            child = (WeekView)view.getChildAt(2 + offset);
        } else if (offset != 0) {
            child = (WeekView)view.getChildAt(offset);
        }
        if (child != null) {
            int month = this.mIsScrollingUp ? child.getMonthOfFirstWeekDay() : child.getMonthOfLastWeekDay();
            int monthDiff = this.mCurrentMonthDisplayed == 11 && month == 0 ? 1 : (this.mCurrentMonthDisplayed == 0 && month == 11 ? -1 : month - this.mCurrentMonthDisplayed);
            if (!this.mIsScrollingUp && monthDiff > 0 || this.mIsScrollingUp && monthDiff < 0) {
                Calendar firstDay = child.getFirstDay();
                if (this.mIsScrollingUp) {
                    firstDay.add(5, -7);
                } else {
                    firstDay.add(5, 7);
                }
                this.setMonthDisplayed(firstDay);
            }
        }
        this.mPreviousScrollPosition = currScroll;
        this.mPreviousScrollState = this.mCurrentScrollState;
    }

    private void setMonthDisplayed(Calendar calendar) {
        this.mCurrentMonthDisplayed = calendar.get(2);
        this.mAdapter.setFocusMonth(this.mCurrentMonthDisplayed);
        int flags = 52;
        long millis = calendar.getTimeInMillis();
        String newMonthName = DateUtils.formatDateRange(this.mContext, millis, millis, 52);
        this.mMonthName.setText(newMonthName);
        this.mMonthName.invalidate();
    }

    private int getWeeksSinceMinDate(Calendar date) {
        if (date.before(this.mMinDate)) {
            throw new IllegalArgumentException("fromDate: " + this.mMinDate.getTime() + " does not precede toDate: " + date.getTime());
        }
        long endTimeMillis = date.getTimeInMillis() + (long)date.getTimeZone().getOffset(date.getTimeInMillis());
        long startTimeMillis = this.mMinDate.getTimeInMillis() + (long)this.mMinDate.getTimeZone().getOffset(this.mMinDate.getTimeInMillis());
        long dayOffsetMillis = (long)(this.mMinDate.get(7) - this.mFirstDayOfWeek) * 86400000L;
        return (int)((endTimeMillis - startTimeMillis + dayOffsetMillis) / 604800000L);
    }

    private class WeekView
    extends View {
        private final Rect mTempRect;
        private final Paint mDrawPaint;
        private final Paint mMonthNumDrawPaint;
        private String[] mDayNumbers;
        private boolean[] mFocusDay;
        private boolean mHasFocusedDay;
        private boolean mHasUnfocusedDay;
        private Calendar mFirstDay;
        private int mMonthOfFirstWeekDay;
        private int mLastWeekDayMonth;
        private int mWeek;
        private int mWidth;
        private int mHeight;
        private boolean mHasSelectedDay;
        private int mSelectedDay;
        private int mNumCells;
        private int mSelectedLeft;
        private int mSelectedRight;

        public WeekView(Context context) {
            super(context);
            this.mTempRect = new Rect();
            this.mDrawPaint = new Paint();
            this.mMonthNumDrawPaint = new Paint();
            this.mMonthOfFirstWeekDay = -1;
            this.mLastWeekDayMonth = -1;
            this.mWeek = -1;
            this.mHasSelectedDay = false;
            this.mSelectedDay = -1;
            this.mSelectedLeft = -1;
            this.mSelectedRight = -1;
            this.initializePaints();
        }

        public void init(int weekNumber, int selectedWeekDay, int focusedMonth) {
            this.mSelectedDay = selectedWeekDay;
            this.mHasSelectedDay = this.mSelectedDay != -1;
            this.mNumCells = CalendarViewLegacyDelegate.this.mShowWeekNumber ? CalendarViewLegacyDelegate.this.mDaysPerWeek + 1 : CalendarViewLegacyDelegate.this.mDaysPerWeek;
            this.mWeek = weekNumber;
            CalendarViewLegacyDelegate.this.mTempDate.setTimeInMillis(CalendarViewLegacyDelegate.this.mMinDate.getTimeInMillis());
            CalendarViewLegacyDelegate.this.mTempDate.add(3, this.mWeek);
            CalendarViewLegacyDelegate.this.mTempDate.setFirstDayOfWeek(CalendarViewLegacyDelegate.this.mFirstDayOfWeek);
            this.mDayNumbers = new String[this.mNumCells];
            this.mFocusDay = new boolean[this.mNumCells];
            int i = 0;
            if (CalendarViewLegacyDelegate.this.mShowWeekNumber) {
                this.mDayNumbers[0] = String.format(Locale.getDefault(), "%d", CalendarViewLegacyDelegate.this.mTempDate.get(3));
                ++i;
            }
            int diff = CalendarViewLegacyDelegate.this.mFirstDayOfWeek - CalendarViewLegacyDelegate.this.mTempDate.get(7);
            CalendarViewLegacyDelegate.this.mTempDate.add(5, diff);
            this.mFirstDay = (Calendar)CalendarViewLegacyDelegate.this.mTempDate.clone();
            this.mMonthOfFirstWeekDay = CalendarViewLegacyDelegate.this.mTempDate.get(2);
            this.mHasUnfocusedDay = true;
            while (i < this.mNumCells) {
                boolean isFocusedDay;
                this.mFocusDay[i] = isFocusedDay = CalendarViewLegacyDelegate.this.mTempDate.get(2) == focusedMonth;
                this.mHasFocusedDay |= isFocusedDay;
                this.mHasUnfocusedDay &= !isFocusedDay;
                this.mDayNumbers[i] = CalendarViewLegacyDelegate.this.mTempDate.before(CalendarViewLegacyDelegate.this.mMinDate) || CalendarViewLegacyDelegate.this.mTempDate.after(CalendarViewLegacyDelegate.this.mMaxDate) ? "" : String.format(Locale.getDefault(), "%d", CalendarViewLegacyDelegate.this.mTempDate.get(5));
                CalendarViewLegacyDelegate.this.mTempDate.add(5, 1);
                ++i;
            }
            if (CalendarViewLegacyDelegate.this.mTempDate.get(5) == 1) {
                CalendarViewLegacyDelegate.this.mTempDate.add(5, -1);
            }
            this.mLastWeekDayMonth = CalendarViewLegacyDelegate.this.mTempDate.get(2);
            this.updateSelectionPositions();
        }

        private void initializePaints() {
            this.mDrawPaint.setFakeBoldText(false);
            this.mDrawPaint.setAntiAlias(true);
            this.mDrawPaint.setStyle(Paint.Style.FILL);
            this.mMonthNumDrawPaint.setFakeBoldText(true);
            this.mMonthNumDrawPaint.setAntiAlias(true);
            this.mMonthNumDrawPaint.setStyle(Paint.Style.FILL);
            this.mMonthNumDrawPaint.setTextAlign(Paint.Align.CENTER);
            this.mMonthNumDrawPaint.setTextSize(CalendarViewLegacyDelegate.this.mDateTextSize);
        }

        public int getMonthOfFirstWeekDay() {
            return this.mMonthOfFirstWeekDay;
        }

        public int getMonthOfLastWeekDay() {
            return this.mLastWeekDayMonth;
        }

        public Calendar getFirstDay() {
            return this.mFirstDay;
        }

        public boolean getDayFromLocation(float x, Calendar outCalendar) {
            int end;
            int start;
            boolean isLayoutRtl = this.isLayoutRtl();
            if (isLayoutRtl) {
                start = 0;
                end = CalendarViewLegacyDelegate.this.mShowWeekNumber ? this.mWidth - this.mWidth / this.mNumCells : this.mWidth;
            } else {
                start = CalendarViewLegacyDelegate.this.mShowWeekNumber ? this.mWidth / this.mNumCells : 0;
                end = this.mWidth;
            }
            if (x < (float)start || x > (float)end) {
                outCalendar.clear();
                return false;
            }
            int dayPosition = (int)((x - (float)start) * (float)CalendarViewLegacyDelegate.this.mDaysPerWeek / (float)(end - start));
            if (isLayoutRtl) {
                dayPosition = CalendarViewLegacyDelegate.this.mDaysPerWeek - 1 - dayPosition;
            }
            outCalendar.setTimeInMillis(this.mFirstDay.getTimeInMillis());
            outCalendar.add(5, dayPosition);
            return true;
        }

        public boolean getBoundsForDate(Calendar date, Rect outBounds) {
            Calendar currDay = Calendar.getInstance();
            currDay.setTime(this.mFirstDay.getTime());
            for (int i = 0; i < CalendarViewLegacyDelegate.this.mDaysPerWeek; ++i) {
                if (date.get(1) == currDay.get(1) && date.get(2) == currDay.get(2) && date.get(5) == currDay.get(5)) {
                    int cellSize = this.mWidth / this.mNumCells;
                    outBounds.left = this.isLayoutRtl() ? cellSize * (CalendarViewLegacyDelegate.this.mShowWeekNumber ? this.mNumCells - i - 2 : this.mNumCells - i - 1) : cellSize * (CalendarViewLegacyDelegate.this.mShowWeekNumber ? i + 1 : i);
                    outBounds.top = 0;
                    outBounds.right = outBounds.left + cellSize;
                    outBounds.bottom = this.getHeight();
                    return true;
                }
                currDay.add(5, 1);
            }
            return false;
        }

        @Override
        protected void onDraw(Canvas canvas) {
            this.drawBackground(canvas);
            this.drawWeekNumbersAndDates(canvas);
            this.drawWeekSeparators(canvas);
            this.drawSelectedDateVerticalBars(canvas);
        }

        private void drawBackground(Canvas canvas) {
            if (!this.mHasSelectedDay) {
                return;
            }
            this.mDrawPaint.setColor(CalendarViewLegacyDelegate.this.mSelectedWeekBackgroundColor);
            this.mTempRect.top = CalendarViewLegacyDelegate.this.mWeekSeparatorLineWidth;
            this.mTempRect.bottom = this.mHeight;
            boolean isLayoutRtl = this.isLayoutRtl();
            if (isLayoutRtl) {
                this.mTempRect.left = 0;
                this.mTempRect.right = this.mSelectedLeft - 2;
            } else {
                this.mTempRect.left = CalendarViewLegacyDelegate.this.mShowWeekNumber ? this.mWidth / this.mNumCells : 0;
                this.mTempRect.right = this.mSelectedLeft - 2;
            }
            canvas.drawRect(this.mTempRect, this.mDrawPaint);
            if (isLayoutRtl) {
                this.mTempRect.left = this.mSelectedRight + 3;
                this.mTempRect.right = CalendarViewLegacyDelegate.this.mShowWeekNumber ? this.mWidth - this.mWidth / this.mNumCells : this.mWidth;
            } else {
                this.mTempRect.left = this.mSelectedRight + 3;
                this.mTempRect.right = this.mWidth;
            }
            canvas.drawRect(this.mTempRect, this.mDrawPaint);
        }

        private void drawWeekNumbersAndDates(Canvas canvas) {
            int i;
            float textHeight = this.mDrawPaint.getTextSize();
            int y = (int)(((float)this.mHeight + textHeight) / 2.0f) - CalendarViewLegacyDelegate.this.mWeekSeparatorLineWidth;
            int nDays = this.mNumCells;
            int divisor = 2 * nDays;
            this.mDrawPaint.setTextAlign(Paint.Align.CENTER);
            this.mDrawPaint.setTextSize(CalendarViewLegacyDelegate.this.mDateTextSize);
            if (this.isLayoutRtl()) {
                int x;
                for (i = 0; i < nDays - 1; ++i) {
                    this.mMonthNumDrawPaint.setColor(this.mFocusDay[i] ? CalendarViewLegacyDelegate.this.mFocusedMonthDateColor : CalendarViewLegacyDelegate.this.mUnfocusedMonthDateColor);
                    x = (2 * i + 1) * this.mWidth / divisor;
                    canvas.drawText(this.mDayNumbers[nDays - 1 - i], x, y, this.mMonthNumDrawPaint);
                }
                if (CalendarViewLegacyDelegate.this.mShowWeekNumber) {
                    this.mDrawPaint.setColor(CalendarViewLegacyDelegate.this.mWeekNumberColor);
                    x = this.mWidth - this.mWidth / divisor;
                    canvas.drawText(this.mDayNumbers[0], x, y, this.mDrawPaint);
                }
            } else {
                int x;
                if (CalendarViewLegacyDelegate.this.mShowWeekNumber) {
                    this.mDrawPaint.setColor(CalendarViewLegacyDelegate.this.mWeekNumberColor);
                    x = this.mWidth / divisor;
                    canvas.drawText(this.mDayNumbers[0], x, y, this.mDrawPaint);
                    ++i;
                }
                while (i < nDays) {
                    this.mMonthNumDrawPaint.setColor(this.mFocusDay[i] ? CalendarViewLegacyDelegate.this.mFocusedMonthDateColor : CalendarViewLegacyDelegate.this.mUnfocusedMonthDateColor);
                    x = (2 * i + 1) * this.mWidth / divisor;
                    canvas.drawText(this.mDayNumbers[i], x, y, this.mMonthNumDrawPaint);
                    ++i;
                }
            }
        }

        private void drawWeekSeparators(Canvas canvas) {
            float stopX;
            float startX;
            int firstFullyVisiblePosition = CalendarViewLegacyDelegate.this.mListView.getFirstVisiblePosition();
            if (CalendarViewLegacyDelegate.this.mListView.getChildAt(0).getTop() < 0) {
                ++firstFullyVisiblePosition;
            }
            if (firstFullyVisiblePosition == this.mWeek) {
                return;
            }
            this.mDrawPaint.setColor(CalendarViewLegacyDelegate.this.mWeekSeparatorLineColor);
            this.mDrawPaint.setStrokeWidth(CalendarViewLegacyDelegate.this.mWeekSeparatorLineWidth);
            if (this.isLayoutRtl()) {
                startX = 0.0f;
                stopX = CalendarViewLegacyDelegate.this.mShowWeekNumber ? (float)(this.mWidth - this.mWidth / this.mNumCells) : (float)this.mWidth;
            } else {
                startX = CalendarViewLegacyDelegate.this.mShowWeekNumber ? (float)(this.mWidth / this.mNumCells) : 0.0f;
                stopX = this.mWidth;
            }
            canvas.drawLine(startX, 0.0f, stopX, 0.0f, this.mDrawPaint);
        }

        private void drawSelectedDateVerticalBars(Canvas canvas) {
            if (!this.mHasSelectedDay) {
                return;
            }
            CalendarViewLegacyDelegate.this.mSelectedDateVerticalBar.setBounds(this.mSelectedLeft - CalendarViewLegacyDelegate.this.mSelectedDateVerticalBarWidth / 2, CalendarViewLegacyDelegate.this.mWeekSeparatorLineWidth, this.mSelectedLeft + CalendarViewLegacyDelegate.this.mSelectedDateVerticalBarWidth / 2, this.mHeight);
            CalendarViewLegacyDelegate.this.mSelectedDateVerticalBar.draw(canvas);
            CalendarViewLegacyDelegate.this.mSelectedDateVerticalBar.setBounds(this.mSelectedRight - CalendarViewLegacyDelegate.this.mSelectedDateVerticalBarWidth / 2, CalendarViewLegacyDelegate.this.mWeekSeparatorLineWidth, this.mSelectedRight + CalendarViewLegacyDelegate.this.mSelectedDateVerticalBarWidth / 2, this.mHeight);
            CalendarViewLegacyDelegate.this.mSelectedDateVerticalBar.draw(canvas);
        }

        @Override
        protected void onSizeChanged(int w, int h, int oldw, int oldh) {
            this.mWidth = w;
            this.updateSelectionPositions();
        }

        private void updateSelectionPositions() {
            if (this.mHasSelectedDay) {
                boolean isLayoutRtl = this.isLayoutRtl();
                int selectedPosition = this.mSelectedDay - CalendarViewLegacyDelegate.this.mFirstDayOfWeek;
                if (selectedPosition < 0) {
                    selectedPosition += 7;
                }
                if (CalendarViewLegacyDelegate.this.mShowWeekNumber && !isLayoutRtl) {
                    ++selectedPosition;
                }
                this.mSelectedLeft = isLayoutRtl ? (CalendarViewLegacyDelegate.this.mDaysPerWeek - 1 - selectedPosition) * this.mWidth / this.mNumCells : selectedPosition * this.mWidth / this.mNumCells;
                this.mSelectedRight = this.mSelectedLeft + this.mWidth / this.mNumCells;
            }
        }

        @Override
        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            this.mHeight = (CalendarViewLegacyDelegate.this.mListView.getHeight() - CalendarViewLegacyDelegate.this.mListView.getPaddingTop() - CalendarViewLegacyDelegate.this.mListView.getPaddingBottom()) / CalendarViewLegacyDelegate.this.mShownWeekCount;
            this.setMeasuredDimension(View.MeasureSpec.getSize(widthMeasureSpec), this.mHeight);
        }
    }

    private class WeeksAdapter
    extends BaseAdapter
    implements View.OnTouchListener {
        private int mSelectedWeek;
        private GestureDetector mGestureDetector;
        private int mFocusedMonth;
        private final Calendar mSelectedDate = Calendar.getInstance();
        private int mTotalWeekCount;

        public WeeksAdapter(Context context) {
            CalendarViewLegacyDelegate.this.mContext = context;
            this.mGestureDetector = new GestureDetector(CalendarViewLegacyDelegate.this.mContext, new CalendarGestureListener());
            this.init();
        }

        private void init() {
            this.mSelectedWeek = CalendarViewLegacyDelegate.this.getWeeksSinceMinDate(this.mSelectedDate);
            this.mTotalWeekCount = CalendarViewLegacyDelegate.this.getWeeksSinceMinDate(CalendarViewLegacyDelegate.this.mMaxDate);
            if (CalendarViewLegacyDelegate.this.mMinDate.get(7) != CalendarViewLegacyDelegate.this.mFirstDayOfWeek || CalendarViewLegacyDelegate.this.mMaxDate.get(7) != CalendarViewLegacyDelegate.this.mFirstDayOfWeek) {
                ++this.mTotalWeekCount;
            }
            this.notifyDataSetChanged();
        }

        public void setSelectedDay(Calendar selectedDay) {
            if (selectedDay.get(6) == this.mSelectedDate.get(6) && selectedDay.get(1) == this.mSelectedDate.get(1)) {
                return;
            }
            this.mSelectedDate.setTimeInMillis(selectedDay.getTimeInMillis());
            this.mSelectedWeek = CalendarViewLegacyDelegate.this.getWeeksSinceMinDate(this.mSelectedDate);
            this.mFocusedMonth = this.mSelectedDate.get(2);
            this.notifyDataSetChanged();
        }

        public Calendar getSelectedDay() {
            return this.mSelectedDate;
        }

        @Override
        public int getCount() {
            return this.mTotalWeekCount;
        }

        @Override
        public Object getItem(int position) {
            return null;
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            WeekView weekView = null;
            if (convertView != null) {
                weekView = (WeekView)convertView;
            } else {
                weekView = new WeekView(CalendarViewLegacyDelegate.this.mContext);
                AbsListView.LayoutParams params = new AbsListView.LayoutParams(-2, -2);
                weekView.setLayoutParams(params);
                weekView.setClickable(true);
                weekView.setOnTouchListener(this);
            }
            int selectedWeekDay = this.mSelectedWeek == position ? this.mSelectedDate.get(7) : -1;
            weekView.init(position, selectedWeekDay, this.mFocusedMonth);
            return weekView;
        }

        public void setFocusMonth(int month) {
            if (this.mFocusedMonth == month) {
                return;
            }
            this.mFocusedMonth = month;
            this.notifyDataSetChanged();
        }

        @Override
        public boolean onTouch(View v, MotionEvent event) {
            if (CalendarViewLegacyDelegate.this.mListView.isEnabled() && this.mGestureDetector.onTouchEvent(event)) {
                WeekView weekView = (WeekView)v;
                if (!weekView.getDayFromLocation(event.getX(), CalendarViewLegacyDelegate.this.mTempDate)) {
                    return true;
                }
                if (CalendarViewLegacyDelegate.this.mTempDate.before(CalendarViewLegacyDelegate.this.mMinDate) || CalendarViewLegacyDelegate.this.mTempDate.after(CalendarViewLegacyDelegate.this.mMaxDate)) {
                    return true;
                }
                this.onDateTapped(CalendarViewLegacyDelegate.this.mTempDate);
                return true;
            }
            return false;
        }

        private void onDateTapped(Calendar day) {
            this.setSelectedDay(day);
            CalendarViewLegacyDelegate.this.setMonthDisplayed(day);
        }

        class CalendarGestureListener
        extends GestureDetector.SimpleOnGestureListener {
            CalendarGestureListener() {
            }

            @Override
            public boolean onSingleTapUp(MotionEvent e) {
                return true;
            }
        }
    }

    private class ScrollStateRunnable
    implements Runnable {
        private AbsListView mView;
        private int mNewState;

        private ScrollStateRunnable() {
        }

        public void doScrollStateChange(AbsListView view, int scrollState) {
            this.mView = view;
            this.mNewState = scrollState;
            CalendarViewLegacyDelegate.this.mDelegator.removeCallbacks(this);
            CalendarViewLegacyDelegate.this.mDelegator.postDelayed(this, 40L);
        }

        @Override
        public void run() {
            CalendarViewLegacyDelegate.this.mCurrentScrollState = this.mNewState;
            if (this.mNewState == 0 && CalendarViewLegacyDelegate.this.mPreviousScrollState != 0) {
                View child = this.mView.getChildAt(0);
                if (child == null) {
                    return;
                }
                int dist = child.getBottom() - CalendarViewLegacyDelegate.this.mListScrollTopOffset;
                if (dist > CalendarViewLegacyDelegate.this.mListScrollTopOffset) {
                    if (CalendarViewLegacyDelegate.this.mIsScrollingUp) {
                        this.mView.smoothScrollBy(dist - child.getHeight(), 500);
                    } else {
                        this.mView.smoothScrollBy(dist, 500);
                    }
                }
            }
            CalendarViewLegacyDelegate.this.mPreviousScrollState = this.mNewState;
        }
    }
}

