/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.android.internal.policy.PhoneWindow;
import java.util.Formatter;
import java.util.Locale;

public class MediaController
extends FrameLayout {
    @UnsupportedAppUsage
    private MediaPlayerControl mPlayer;
    @UnsupportedAppUsage
    private final Context mContext;
    @UnsupportedAppUsage
    private View mAnchor;
    @UnsupportedAppUsage
    private View mRoot;
    @UnsupportedAppUsage
    private WindowManager mWindowManager;
    @UnsupportedAppUsage
    private Window mWindow;
    @UnsupportedAppUsage
    private View mDecor;
    @UnsupportedAppUsage
    private WindowManager.LayoutParams mDecorLayoutParams;
    @UnsupportedAppUsage
    private ProgressBar mProgress;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private TextView mEndTime;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private TextView mCurrentTime;
    @UnsupportedAppUsage
    private boolean mShowing;
    private boolean mDragging;
    private static final int sDefaultTimeout = 3000;
    private final boolean mUseFastForward;
    private boolean mFromXml;
    private boolean mListenersSet;
    private View.OnClickListener mNextListener;
    private View.OnClickListener mPrevListener;
    StringBuilder mFormatBuilder;
    Formatter mFormatter;
    @UnsupportedAppUsage
    private ImageButton mPauseButton;
    @UnsupportedAppUsage
    private ImageButton mFfwdButton;
    @UnsupportedAppUsage
    private ImageButton mRewButton;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private ImageButton mNextButton;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private ImageButton mPrevButton;
    private CharSequence mPlayDescription;
    private CharSequence mPauseDescription;
    private final AccessibilityManager mAccessibilityManager;
    private final View.OnLayoutChangeListener mLayoutChangeListener = new View.OnLayoutChangeListener(){

        @Override
        public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            MediaController.this.updateFloatingWindowLayout();
            if (MediaController.this.mShowing) {
                MediaController.this.mWindowManager.updateViewLayout(MediaController.this.mDecor, MediaController.this.mDecorLayoutParams);
            }
        }
    };
    private final View.OnTouchListener mTouchListener = new View.OnTouchListener(){

        @Override
        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == 0 && MediaController.this.mShowing) {
                MediaController.this.hide();
            }
            return false;
        }
    };
    private final Runnable mFadeOut = new Runnable(){

        @Override
        public void run() {
            MediaController.this.hide();
        }
    };
    private final Runnable mShowProgress = new Runnable(){

        @Override
        public void run() {
            int pos = MediaController.this.setProgress();
            if (!MediaController.this.mDragging && MediaController.this.mShowing && MediaController.this.mPlayer.isPlaying()) {
                MediaController.this.postDelayed(MediaController.this.mShowProgress, 1000 - pos % 1000);
            }
        }
    };
    private final View.OnClickListener mPauseListener = new View.OnClickListener(){

        @Override
        public void onClick(View v) {
            MediaController.this.doPauseResume();
            MediaController.this.show(3000);
        }
    };
    @UnsupportedAppUsage
    private final SeekBar.OnSeekBarChangeListener mSeekListener = new SeekBar.OnSeekBarChangeListener(){

        @Override
        public void onStartTrackingTouch(SeekBar bar) {
            MediaController.this.show(3600000);
            MediaController.this.mDragging = true;
            MediaController.this.removeCallbacks(MediaController.this.mShowProgress);
        }

        @Override
        public void onProgressChanged(SeekBar bar, int progress, boolean fromuser) {
            if (!fromuser) {
                return;
            }
            long duration = MediaController.this.mPlayer.getDuration();
            long newposition = duration * (long)progress / 1000L;
            MediaController.this.mPlayer.seekTo((int)newposition);
            if (MediaController.this.mCurrentTime != null) {
                MediaController.this.mCurrentTime.setText(MediaController.this.stringForTime((int)newposition));
            }
        }

        @Override
        public void onStopTrackingTouch(SeekBar bar) {
            MediaController.this.mDragging = false;
            MediaController.this.setProgress();
            MediaController.this.updatePausePlay();
            MediaController.this.show(3000);
            MediaController.this.post(MediaController.this.mShowProgress);
        }
    };
    @UnsupportedAppUsage
    private final View.OnClickListener mRewListener = new View.OnClickListener(){

        @Override
        public void onClick(View v) {
            int pos = MediaController.this.mPlayer.getCurrentPosition();
            MediaController.this.mPlayer.seekTo(pos -= 5000);
            MediaController.this.setProgress();
            MediaController.this.show(3000);
        }
    };
    @UnsupportedAppUsage
    private final View.OnClickListener mFfwdListener = new View.OnClickListener(){

        @Override
        public void onClick(View v) {
            int pos = MediaController.this.mPlayer.getCurrentPosition();
            MediaController.this.mPlayer.seekTo(pos += 15000);
            MediaController.this.setProgress();
            MediaController.this.show(3000);
        }
    };

    public MediaController(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mRoot = this;
        this.mContext = context;
        this.mUseFastForward = true;
        this.mFromXml = true;
        this.mAccessibilityManager = AccessibilityManager.getInstance(context);
    }

    @Override
    public void onFinishInflate() {
        if (this.mRoot != null) {
            this.initControllerView(this.mRoot);
        }
    }

    public MediaController(Context context, boolean useFastForward) {
        super(context);
        this.mContext = context;
        this.mUseFastForward = useFastForward;
        this.initFloatingWindowLayout();
        this.initFloatingWindow();
        this.mAccessibilityManager = AccessibilityManager.getInstance(context);
    }

    public MediaController(Context context) {
        this(context, true);
    }

    private void initFloatingWindow() {
        this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
        this.mWindow = new PhoneWindow(this.mContext);
        this.mWindow.setWindowManager(this.mWindowManager, null, null);
        this.mWindow.requestFeature(1);
        this.mDecor = this.mWindow.getDecorView();
        this.mDecor.setOnTouchListener(this.mTouchListener);
        this.mWindow.setContentView(this);
        this.mWindow.setBackgroundDrawableResource(17170445);
        this.mWindow.setVolumeControlStream(3);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setDescendantFocusability(262144);
        this.requestFocus();
    }

    private void initFloatingWindowLayout() {
        WindowManager.LayoutParams p = this.mDecorLayoutParams = new WindowManager.LayoutParams();
        p.gravity = 51;
        p.height = -2;
        p.x = 0;
        p.format = -3;
        p.type = 1000;
        p.flags |= 0x820020;
        p.token = null;
        p.windowAnimations = 0;
    }

    private void updateFloatingWindowLayout() {
        int[] anchorPos = new int[2];
        this.mAnchor.getLocationOnScreen(anchorPos);
        this.mDecor.measure(View.MeasureSpec.makeMeasureSpec(this.mAnchor.getWidth(), Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(this.mAnchor.getHeight(), Integer.MIN_VALUE));
        WindowManager.LayoutParams p = this.mDecorLayoutParams;
        p.width = this.mAnchor.getWidth();
        p.x = anchorPos[0] + (this.mAnchor.getWidth() - p.width) / 2;
        p.y = anchorPos[1] + this.mAnchor.getHeight() - this.mDecor.getMeasuredHeight();
    }

    public void setMediaPlayer(MediaPlayerControl player) {
        this.mPlayer = player;
        this.updatePausePlay();
    }

    public void setAnchorView(View view) {
        if (this.mAnchor != null) {
            this.mAnchor.removeOnLayoutChangeListener(this.mLayoutChangeListener);
        }
        this.mAnchor = view;
        if (this.mAnchor != null) {
            this.mAnchor.addOnLayoutChangeListener(this.mLayoutChangeListener);
        }
        FrameLayout.LayoutParams frameParams = new FrameLayout.LayoutParams(-1, -1);
        this.removeAllViews();
        View v = this.makeControllerView();
        this.addView(v, frameParams);
    }

    protected View makeControllerView() {
        LayoutInflater inflate = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.mRoot = inflate.inflate(0x1090090, null);
        this.initControllerView(this.mRoot);
        return this.mRoot;
    }

    private void initControllerView(View v) {
        Resources res = this.mContext.getResources();
        this.mPlayDescription = res.getText(17040290);
        this.mPauseDescription = res.getText(17040289);
        this.mPauseButton = (ImageButton)v.findViewById(16909218);
        if (this.mPauseButton != null) {
            this.mPauseButton.requestFocus();
            this.mPauseButton.setOnClickListener(this.mPauseListener);
        }
        this.mFfwdButton = (ImageButton)v.findViewById(16908911);
        if (this.mFfwdButton != null) {
            this.mFfwdButton.setOnClickListener(this.mFfwdListener);
            if (!this.mFromXml) {
                this.mFfwdButton.setVisibility(this.mUseFastForward ? 0 : 8);
            }
        }
        this.mRewButton = (ImageButton)v.findViewById(16909290);
        if (this.mRewButton != null) {
            this.mRewButton.setOnClickListener(this.mRewListener);
            if (!this.mFromXml) {
                this.mRewButton.setVisibility(this.mUseFastForward ? 0 : 8);
            }
        }
        this.mNextButton = (ImageButton)v.findViewById(16909144);
        if (this.mNextButton != null && !this.mFromXml && !this.mListenersSet) {
            this.mNextButton.setVisibility(8);
        }
        this.mPrevButton = (ImageButton)v.findViewById(16909254);
        if (this.mPrevButton != null && !this.mFromXml && !this.mListenersSet) {
            this.mPrevButton.setVisibility(8);
        }
        this.mProgress = (ProgressBar)v.findViewById(16909103);
        if (this.mProgress != null) {
            if (this.mProgress instanceof SeekBar) {
                SeekBar seeker = (SeekBar)this.mProgress;
                seeker.setOnSeekBarChangeListener(this.mSeekListener);
            }
            this.mProgress.setMax(1000);
        }
        this.mEndTime = (TextView)v.findViewById(16909460);
        this.mCurrentTime = (TextView)v.findViewById(16909463);
        this.mFormatBuilder = new StringBuilder();
        this.mFormatter = new Formatter(this.mFormatBuilder, Locale.getDefault());
        this.installPrevNextListeners();
    }

    public void show() {
        this.show(3000);
    }

    private void disableUnsupportedButtons() {
        try {
            if (this.mPauseButton != null && !this.mPlayer.canPause()) {
                this.mPauseButton.setEnabled(false);
            }
            if (this.mRewButton != null && !this.mPlayer.canSeekBackward()) {
                this.mRewButton.setEnabled(false);
            }
            if (this.mFfwdButton != null && !this.mPlayer.canSeekForward()) {
                this.mFfwdButton.setEnabled(false);
            }
            if (this.mProgress != null && !this.mPlayer.canSeekBackward() && !this.mPlayer.canSeekForward()) {
                this.mProgress.setEnabled(false);
            }
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            // empty catch block
        }
    }

    public void show(int timeout) {
        if (!this.mShowing && this.mAnchor != null) {
            this.setProgress();
            if (this.mPauseButton != null) {
                this.mPauseButton.requestFocus();
            }
            this.disableUnsupportedButtons();
            this.updateFloatingWindowLayout();
            this.mWindowManager.addView(this.mDecor, this.mDecorLayoutParams);
            this.mShowing = true;
        }
        this.updatePausePlay();
        this.post(this.mShowProgress);
        if (timeout != 0 && !this.mAccessibilityManager.isTouchExplorationEnabled()) {
            this.removeCallbacks(this.mFadeOut);
            this.postDelayed(this.mFadeOut, timeout);
        }
    }

    public boolean isShowing() {
        return this.mShowing;
    }

    public void hide() {
        if (this.mAnchor == null) {
            return;
        }
        if (this.mShowing) {
            try {
                this.removeCallbacks(this.mShowProgress);
                this.mWindowManager.removeView(this.mDecor);
            }
            catch (IllegalArgumentException ex) {
                Log.w("MediaController", "already removed");
            }
            this.mShowing = false;
        }
    }

    private String stringForTime(int timeMs) {
        int totalSeconds = timeMs / 1000;
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        int hours = totalSeconds / 3600;
        this.mFormatBuilder.setLength(0);
        if (hours > 0) {
            return this.mFormatter.format("%d:%02d:%02d", hours, minutes, seconds).toString();
        }
        return this.mFormatter.format("%02d:%02d", minutes, seconds).toString();
    }

    private int setProgress() {
        if (this.mPlayer == null || this.mDragging) {
            return 0;
        }
        int position = this.mPlayer.getCurrentPosition();
        int duration = this.mPlayer.getDuration();
        if (this.mProgress != null) {
            if (duration > 0) {
                long pos = 1000L * (long)position / (long)duration;
                this.mProgress.setProgress((int)pos);
            }
            int percent = this.mPlayer.getBufferPercentage();
            this.mProgress.setSecondaryProgress(percent * 10);
        }
        if (this.mEndTime != null) {
            this.mEndTime.setText(this.stringForTime(duration));
        }
        if (this.mCurrentTime != null) {
            this.mCurrentTime.setText(this.stringForTime(position));
        }
        return position;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.show(0);
                break;
            }
            case 1: {
                this.show(3000);
                break;
            }
            case 3: {
                this.hide();
                break;
            }
        }
        return true;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent ev) {
        this.show(3000);
        return false;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean uniqueDown;
        int keyCode = event.getKeyCode();
        boolean bl = uniqueDown = event.getRepeatCount() == 0 && event.getAction() == 0;
        if (keyCode == 79 || keyCode == 85 || keyCode == 62) {
            if (uniqueDown) {
                this.doPauseResume();
                this.show(3000);
                if (this.mPauseButton != null) {
                    this.mPauseButton.requestFocus();
                }
            }
            return true;
        }
        if (keyCode == 126) {
            if (uniqueDown && !this.mPlayer.isPlaying()) {
                this.mPlayer.start();
                this.updatePausePlay();
                this.show(3000);
            }
            return true;
        }
        if (keyCode == 86 || keyCode == 127) {
            if (uniqueDown && this.mPlayer.isPlaying()) {
                this.mPlayer.pause();
                this.updatePausePlay();
                this.show(3000);
            }
            return true;
        }
        if (keyCode == 25 || keyCode == 24 || keyCode == 164 || keyCode == 27) {
            return super.dispatchKeyEvent(event);
        }
        if (keyCode == 4 || keyCode == 82) {
            if (uniqueDown) {
                this.hide();
            }
            return true;
        }
        this.show(3000);
        return super.dispatchKeyEvent(event);
    }

    @UnsupportedAppUsage
    private void updatePausePlay() {
        if (this.mRoot == null || this.mPauseButton == null) {
            return;
        }
        if (this.mPlayer.isPlaying()) {
            this.mPauseButton.setImageResource(17301539);
            this.mPauseButton.setContentDescription(this.mPauseDescription);
        } else {
            this.mPauseButton.setImageResource(17301540);
            this.mPauseButton.setContentDescription(this.mPlayDescription);
        }
    }

    private void doPauseResume() {
        if (this.mPlayer.isPlaying()) {
            this.mPlayer.pause();
        } else {
            this.mPlayer.start();
        }
        this.updatePausePlay();
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.mPauseButton != null) {
            this.mPauseButton.setEnabled(enabled);
        }
        if (this.mFfwdButton != null) {
            this.mFfwdButton.setEnabled(enabled);
        }
        if (this.mRewButton != null) {
            this.mRewButton.setEnabled(enabled);
        }
        if (this.mNextButton != null) {
            this.mNextButton.setEnabled(enabled && this.mNextListener != null);
        }
        if (this.mPrevButton != null) {
            this.mPrevButton.setEnabled(enabled && this.mPrevListener != null);
        }
        if (this.mProgress != null) {
            this.mProgress.setEnabled(enabled);
        }
        this.disableUnsupportedButtons();
        super.setEnabled(enabled);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return MediaController.class.getName();
    }

    private void installPrevNextListeners() {
        if (this.mNextButton != null) {
            this.mNextButton.setOnClickListener(this.mNextListener);
            this.mNextButton.setEnabled(this.mNextListener != null);
        }
        if (this.mPrevButton != null) {
            this.mPrevButton.setOnClickListener(this.mPrevListener);
            this.mPrevButton.setEnabled(this.mPrevListener != null);
        }
    }

    public void setPrevNextListeners(View.OnClickListener next, View.OnClickListener prev) {
        this.mNextListener = next;
        this.mPrevListener = prev;
        this.mListenersSet = true;
        if (this.mRoot != null) {
            this.installPrevNextListeners();
            if (this.mNextButton != null && !this.mFromXml) {
                this.mNextButton.setVisibility(0);
            }
            if (this.mPrevButton != null && !this.mFromXml) {
                this.mPrevButton.setVisibility(0);
            }
        }
    }

    public static interface MediaPlayerControl {
        public void start();

        public void pause();

        public int getDuration();

        public int getCurrentPosition();

        public void seekTo(int var1);

        public boolean isPlaying();

        public int getBufferPercentage();

        public boolean canPause();

        public boolean canSeekBackward();

        public boolean canSeekForward();

        public int getAudioSessionId();
    }
}

