/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.R;
import android.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewGroup;

@Deprecated
public class SlidingDrawer
extends ViewGroup {
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    private static final int TAP_THRESHOLD = 6;
    private static final float MAXIMUM_TAP_VELOCITY = 100.0f;
    private static final float MAXIMUM_MINOR_VELOCITY = 150.0f;
    private static final float MAXIMUM_MAJOR_VELOCITY = 200.0f;
    private static final float MAXIMUM_ACCELERATION = 2000.0f;
    private static final int VELOCITY_UNITS = 1000;
    private static final int ANIMATION_FRAME_DURATION = 16;
    private static final int EXPANDED_FULL_OPEN = -10001;
    private static final int COLLAPSED_FULL_CLOSED = -10002;
    private final int mHandleId;
    private final int mContentId;
    private View mHandle;
    private View mContent;
    private final Rect mFrame = new Rect();
    private final Rect mInvalidate = new Rect();
    @UnsupportedAppUsage
    private boolean mTracking;
    private boolean mLocked;
    @UnsupportedAppUsage
    private VelocityTracker mVelocityTracker;
    private boolean mVertical;
    private boolean mExpanded;
    private int mBottomOffset;
    @UnsupportedAppUsage
    private int mTopOffset;
    private int mHandleHeight;
    private int mHandleWidth;
    private OnDrawerOpenListener mOnDrawerOpenListener;
    private OnDrawerCloseListener mOnDrawerCloseListener;
    private OnDrawerScrollListener mOnDrawerScrollListener;
    private float mAnimatedAcceleration;
    private float mAnimatedVelocity;
    private float mAnimationPosition;
    private long mAnimationLastTime;
    private long mCurrentAnimationTime;
    @UnsupportedAppUsage
    private int mTouchDelta;
    private boolean mAnimating;
    private boolean mAllowSingleTap;
    private boolean mAnimateOnClick;
    private final int mTapThreshold;
    private final int mMaximumTapVelocity;
    private final int mMaximumMinorVelocity;
    private final int mMaximumMajorVelocity;
    private final int mMaximumAcceleration;
    private final int mVelocityUnits;
    private final Runnable mSlidingRunnable = new Runnable(){

        @Override
        public void run() {
            SlidingDrawer.this.doAnimation();
        }
    };

    public SlidingDrawer(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SlidingDrawer(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public SlidingDrawer(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SlidingDrawer, defStyleAttr, defStyleRes);
        this.saveAttributeDataForStyleable(context, R.styleable.SlidingDrawer, attrs, a, defStyleAttr, defStyleRes);
        int orientation = a.getInt(0, 1);
        this.mVertical = orientation == 1;
        this.mBottomOffset = (int)a.getDimension(1, 0.0f);
        this.mTopOffset = (int)a.getDimension(2, 0.0f);
        this.mAllowSingleTap = a.getBoolean(3, true);
        this.mAnimateOnClick = a.getBoolean(6, true);
        int handleId = a.getResourceId(4, 0);
        if (handleId == 0) {
            throw new IllegalArgumentException("The handle attribute is required and must refer to a valid child.");
        }
        int contentId = a.getResourceId(5, 0);
        if (contentId == 0) {
            throw new IllegalArgumentException("The content attribute is required and must refer to a valid child.");
        }
        if (handleId == contentId) {
            throw new IllegalArgumentException("The content and handle attributes must refer to different children.");
        }
        this.mHandleId = handleId;
        this.mContentId = contentId;
        float density = this.getResources().getDisplayMetrics().density;
        this.mTapThreshold = (int)(6.0f * density + 0.5f);
        this.mMaximumTapVelocity = (int)(100.0f * density + 0.5f);
        this.mMaximumMinorVelocity = (int)(150.0f * density + 0.5f);
        this.mMaximumMajorVelocity = (int)(200.0f * density + 0.5f);
        this.mMaximumAcceleration = (int)(2000.0f * density + 0.5f);
        this.mVelocityUnits = (int)(1000.0f * density + 0.5f);
        a.recycle();
        this.setAlwaysDrawnWithCacheEnabled(false);
    }

    @Override
    protected void onFinishInflate() {
        this.mHandle = this.findViewById(this.mHandleId);
        if (this.mHandle == null) {
            throw new IllegalArgumentException("The handle attribute is must refer to an existing child.");
        }
        this.mHandle.setOnClickListener(new DrawerToggler());
        this.mContent = this.findViewById(this.mContentId);
        if (this.mContent == null) {
            throw new IllegalArgumentException("The content attribute is must refer to an existing child.");
        }
        this.mContent.setVisibility(8);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpecMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int widthSpecSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize(heightMeasureSpec);
        if (widthSpecMode == 0 || heightSpecMode == 0) {
            throw new RuntimeException("SlidingDrawer cannot have UNSPECIFIED dimensions");
        }
        View handle = this.mHandle;
        this.measureChild(handle, widthMeasureSpec, heightMeasureSpec);
        if (this.mVertical) {
            int height = heightSpecSize - handle.getMeasuredHeight() - this.mTopOffset;
            this.mContent.measure(View.MeasureSpec.makeMeasureSpec(widthSpecSize, 0x40000000), View.MeasureSpec.makeMeasureSpec(height, 0x40000000));
        } else {
            int width = widthSpecSize - handle.getMeasuredWidth() - this.mTopOffset;
            this.mContent.measure(View.MeasureSpec.makeMeasureSpec(width, 0x40000000), View.MeasureSpec.makeMeasureSpec(heightSpecSize, 0x40000000));
        }
        this.setMeasuredDimension(widthSpecSize, heightSpecSize);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        long drawingTime = this.getDrawingTime();
        View handle = this.mHandle;
        boolean isVertical = this.mVertical;
        this.drawChild(canvas, handle, drawingTime);
        if (this.mTracking || this.mAnimating) {
            Bitmap cache = this.mContent.getDrawingCache();
            if (cache != null) {
                if (isVertical) {
                    canvas.drawBitmap(cache, 0.0f, handle.getBottom(), null);
                } else {
                    canvas.drawBitmap(cache, handle.getRight(), 0.0f, null);
                }
            } else {
                canvas.save();
                canvas.translate(isVertical ? 0.0f : (float)(handle.getLeft() - this.mTopOffset), isVertical ? (float)(handle.getTop() - this.mTopOffset) : 0.0f);
                this.drawChild(canvas, this.mContent, drawingTime);
                canvas.restore();
            }
        } else if (this.mExpanded) {
            this.drawChild(canvas, this.mContent, drawingTime);
        }
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int childTop;
        int childLeft;
        if (this.mTracking) {
            return;
        }
        int width = r - l;
        int height = b - t;
        View handle = this.mHandle;
        int childWidth = handle.getMeasuredWidth();
        int childHeight = handle.getMeasuredHeight();
        View content = this.mContent;
        if (this.mVertical) {
            childLeft = (width - childWidth) / 2;
            childTop = this.mExpanded ? this.mTopOffset : height - childHeight + this.mBottomOffset;
            content.layout(0, this.mTopOffset + childHeight, content.getMeasuredWidth(), this.mTopOffset + childHeight + content.getMeasuredHeight());
        } else {
            childLeft = this.mExpanded ? this.mTopOffset : width - childWidth + this.mBottomOffset;
            childTop = (height - childHeight) / 2;
            content.layout(this.mTopOffset + childWidth, 0, this.mTopOffset + childWidth + content.getMeasuredWidth(), content.getMeasuredHeight());
        }
        handle.layout(childLeft, childTop, childLeft + childWidth, childTop + childHeight);
        this.mHandleHeight = handle.getHeight();
        this.mHandleWidth = handle.getWidth();
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (this.mLocked) {
            return false;
        }
        int action = event.getAction();
        float x = event.getX();
        float y = event.getY();
        Rect frame = this.mFrame;
        View handle = this.mHandle;
        handle.getHitRect(frame);
        if (!this.mTracking && !frame.contains((int)x, (int)y)) {
            return false;
        }
        if (action == 0) {
            this.mTracking = true;
            handle.setPressed(true);
            this.prepareContent();
            if (this.mOnDrawerScrollListener != null) {
                this.mOnDrawerScrollListener.onScrollStarted();
            }
            if (this.mVertical) {
                int top = this.mHandle.getTop();
                this.mTouchDelta = (int)y - top;
                this.prepareTracking(top);
            } else {
                int left = this.mHandle.getLeft();
                this.mTouchDelta = (int)x - left;
                this.prepareTracking(left);
            }
            this.mVelocityTracker.addMovement(event);
        }
        return true;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (this.mLocked) {
            return true;
        }
        if (this.mTracking) {
            this.mVelocityTracker.addMovement(event);
            int action = event.getAction();
            switch (action) {
                case 2: {
                    this.moveHandle((int)(this.mVertical ? event.getY() : event.getX()) - this.mTouchDelta);
                    break;
                }
                case 1: 
                case 3: {
                    boolean negative;
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    velocityTracker.computeCurrentVelocity(this.mVelocityUnits);
                    float yVelocity = velocityTracker.getYVelocity();
                    float xVelocity = velocityTracker.getXVelocity();
                    boolean vertical = this.mVertical;
                    if (vertical) {
                        boolean bl = negative = yVelocity < 0.0f;
                        if (xVelocity < 0.0f) {
                            xVelocity = -xVelocity;
                        }
                        if (xVelocity > (float)this.mMaximumMinorVelocity) {
                            xVelocity = this.mMaximumMinorVelocity;
                        }
                    } else {
                        boolean bl = negative = xVelocity < 0.0f;
                        if (yVelocity < 0.0f) {
                            yVelocity = -yVelocity;
                        }
                        if (yVelocity > (float)this.mMaximumMinorVelocity) {
                            yVelocity = this.mMaximumMinorVelocity;
                        }
                    }
                    float velocity = (float)Math.hypot(xVelocity, yVelocity);
                    if (negative) {
                        velocity = -velocity;
                    }
                    int top = this.mHandle.getTop();
                    int left = this.mHandle.getLeft();
                    if (Math.abs(velocity) < (float)this.mMaximumTapVelocity) {
                        if (vertical ? this.mExpanded && top < this.mTapThreshold + this.mTopOffset || !this.mExpanded && top > this.mBottomOffset + this.mBottom - this.mTop - this.mHandleHeight - this.mTapThreshold : this.mExpanded && left < this.mTapThreshold + this.mTopOffset || !this.mExpanded && left > this.mBottomOffset + this.mRight - this.mLeft - this.mHandleWidth - this.mTapThreshold) {
                            if (this.mAllowSingleTap) {
                                this.playSoundEffect(0);
                                if (this.mExpanded) {
                                    this.animateClose(vertical ? top : left, true);
                                    break;
                                }
                                this.animateOpen(vertical ? top : left, true);
                                break;
                            }
                            this.performFling(vertical ? top : left, velocity, false, true);
                            break;
                        }
                        this.performFling(vertical ? top : left, velocity, false, true);
                        break;
                    }
                    this.performFling(vertical ? top : left, velocity, false, true);
                }
            }
        }
        return this.mTracking || this.mAnimating || super.onTouchEvent(event);
    }

    private void animateClose(int position, boolean notifyScrollListener) {
        this.prepareTracking(position);
        this.performFling(position, this.mMaximumAcceleration, true, notifyScrollListener);
    }

    private void animateOpen(int position, boolean notifyScrollListener) {
        this.prepareTracking(position);
        this.performFling(position, -this.mMaximumAcceleration, true, notifyScrollListener);
    }

    private void performFling(int position, float velocity, boolean always, boolean notifyScrollListener) {
        long now;
        this.mAnimationPosition = position;
        this.mAnimatedVelocity = velocity;
        if (this.mExpanded) {
            if (always || velocity > (float)this.mMaximumMajorVelocity || position > this.mTopOffset + (this.mVertical ? this.mHandleHeight : this.mHandleWidth) && velocity > (float)(-this.mMaximumMajorVelocity)) {
                this.mAnimatedAcceleration = this.mMaximumAcceleration;
                if (velocity < 0.0f) {
                    this.mAnimatedVelocity = 0.0f;
                }
            } else {
                this.mAnimatedAcceleration = -this.mMaximumAcceleration;
                if (velocity > 0.0f) {
                    this.mAnimatedVelocity = 0.0f;
                }
            }
        } else if (!always && (velocity > (float)this.mMaximumMajorVelocity || position > (this.mVertical ? this.getHeight() : this.getWidth()) / 2 && velocity > (float)(-this.mMaximumMajorVelocity))) {
            this.mAnimatedAcceleration = this.mMaximumAcceleration;
            if (velocity < 0.0f) {
                this.mAnimatedVelocity = 0.0f;
            }
        } else {
            this.mAnimatedAcceleration = -this.mMaximumAcceleration;
            if (velocity > 0.0f) {
                this.mAnimatedVelocity = 0.0f;
            }
        }
        this.mAnimationLastTime = now = SystemClock.uptimeMillis();
        this.mCurrentAnimationTime = now + 16L;
        this.mAnimating = true;
        this.removeCallbacks(this.mSlidingRunnable);
        this.postDelayed(this.mSlidingRunnable, 16L);
        this.stopTracking(notifyScrollListener);
    }

    @UnsupportedAppUsage
    private void prepareTracking(int position) {
        boolean opening;
        this.mTracking = true;
        this.mVelocityTracker = VelocityTracker.obtain();
        boolean bl = opening = !this.mExpanded;
        if (opening) {
            long now;
            this.mAnimatedAcceleration = this.mMaximumAcceleration;
            this.mAnimatedVelocity = this.mMaximumMajorVelocity;
            this.mAnimationPosition = this.mBottomOffset + (this.mVertical ? this.getHeight() - this.mHandleHeight : this.getWidth() - this.mHandleWidth);
            this.moveHandle((int)this.mAnimationPosition);
            this.mAnimating = true;
            this.removeCallbacks(this.mSlidingRunnable);
            this.mAnimationLastTime = now = SystemClock.uptimeMillis();
            this.mCurrentAnimationTime = now + 16L;
            this.mAnimating = true;
        } else {
            if (this.mAnimating) {
                this.mAnimating = false;
                this.removeCallbacks(this.mSlidingRunnable);
            }
            this.moveHandle(position);
        }
    }

    private void moveHandle(int position) {
        View handle = this.mHandle;
        if (this.mVertical) {
            if (position == -10001) {
                handle.offsetTopAndBottom(this.mTopOffset - handle.getTop());
                this.invalidate();
            } else if (position == -10002) {
                handle.offsetTopAndBottom(this.mBottomOffset + this.mBottom - this.mTop - this.mHandleHeight - handle.getTop());
                this.invalidate();
            } else {
                int top = handle.getTop();
                int deltaY = position - top;
                if (position < this.mTopOffset) {
                    deltaY = this.mTopOffset - top;
                } else if (deltaY > this.mBottomOffset + this.mBottom - this.mTop - this.mHandleHeight - top) {
                    deltaY = this.mBottomOffset + this.mBottom - this.mTop - this.mHandleHeight - top;
                }
                handle.offsetTopAndBottom(deltaY);
                Rect frame = this.mFrame;
                Rect region = this.mInvalidate;
                handle.getHitRect(frame);
                region.set(frame);
                region.union(frame.left, frame.top - deltaY, frame.right, frame.bottom - deltaY);
                region.union(0, frame.bottom - deltaY, this.getWidth(), frame.bottom - deltaY + this.mContent.getHeight());
                this.invalidate(region);
            }
        } else if (position == -10001) {
            handle.offsetLeftAndRight(this.mTopOffset - handle.getLeft());
            this.invalidate();
        } else if (position == -10002) {
            handle.offsetLeftAndRight(this.mBottomOffset + this.mRight - this.mLeft - this.mHandleWidth - handle.getLeft());
            this.invalidate();
        } else {
            int left = handle.getLeft();
            int deltaX = position - left;
            if (position < this.mTopOffset) {
                deltaX = this.mTopOffset - left;
            } else if (deltaX > this.mBottomOffset + this.mRight - this.mLeft - this.mHandleWidth - left) {
                deltaX = this.mBottomOffset + this.mRight - this.mLeft - this.mHandleWidth - left;
            }
            handle.offsetLeftAndRight(deltaX);
            Rect frame = this.mFrame;
            Rect region = this.mInvalidate;
            handle.getHitRect(frame);
            region.set(frame);
            region.union(frame.left - deltaX, frame.top, frame.right - deltaX, frame.bottom);
            region.union(frame.right - deltaX, 0, frame.right - deltaX + this.mContent.getWidth(), this.getHeight());
            this.invalidate(region);
        }
    }

    @UnsupportedAppUsage
    private void prepareContent() {
        if (this.mAnimating) {
            return;
        }
        View content = this.mContent;
        if (content.isLayoutRequested()) {
            if (this.mVertical) {
                int childHeight = this.mHandleHeight;
                int height = this.mBottom - this.mTop - childHeight - this.mTopOffset;
                content.measure(View.MeasureSpec.makeMeasureSpec(this.mRight - this.mLeft, 0x40000000), View.MeasureSpec.makeMeasureSpec(height, 0x40000000));
                content.layout(0, this.mTopOffset + childHeight, content.getMeasuredWidth(), this.mTopOffset + childHeight + content.getMeasuredHeight());
            } else {
                int childWidth = this.mHandle.getWidth();
                int width = this.mRight - this.mLeft - childWidth - this.mTopOffset;
                content.measure(View.MeasureSpec.makeMeasureSpec(width, 0x40000000), View.MeasureSpec.makeMeasureSpec(this.mBottom - this.mTop, 0x40000000));
                content.layout(childWidth + this.mTopOffset, 0, this.mTopOffset + childWidth + content.getMeasuredWidth(), content.getMeasuredHeight());
            }
        }
        content.getViewTreeObserver().dispatchOnPreDraw();
        if (!content.isHardwareAccelerated()) {
            content.buildDrawingCache();
        }
        content.setVisibility(8);
    }

    private void stopTracking(boolean notifyScrollListener) {
        this.mHandle.setPressed(false);
        this.mTracking = false;
        if (notifyScrollListener && this.mOnDrawerScrollListener != null) {
            this.mOnDrawerScrollListener.onScrollEnded();
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private void doAnimation() {
        if (this.mAnimating) {
            this.incrementAnimation();
            int n = this.mVertical ? this.getHeight() : this.getWidth();
            if (this.mAnimationPosition >= (float)(this.mBottomOffset + n - 1)) {
                this.mAnimating = false;
                this.closeDrawer();
            } else if (this.mAnimationPosition < (float)this.mTopOffset) {
                this.mAnimating = false;
                this.openDrawer();
            } else {
                this.moveHandle((int)this.mAnimationPosition);
                this.mCurrentAnimationTime += 16L;
                this.postDelayed(this.mSlidingRunnable, 16L);
            }
        }
    }

    private void incrementAnimation() {
        long now = SystemClock.uptimeMillis();
        float t = (float)(now - this.mAnimationLastTime) / 1000.0f;
        float position = this.mAnimationPosition;
        float v = this.mAnimatedVelocity;
        float a = this.mAnimatedAcceleration;
        this.mAnimationPosition = position + v * t + 0.5f * a * t * t;
        this.mAnimatedVelocity = v + a * t;
        this.mAnimationLastTime = now;
    }

    public void toggle() {
        if (!this.mExpanded) {
            this.openDrawer();
        } else {
            this.closeDrawer();
        }
        this.invalidate();
        this.requestLayout();
    }

    public void animateToggle() {
        if (!this.mExpanded) {
            this.animateOpen();
        } else {
            this.animateClose();
        }
    }

    public void open() {
        this.openDrawer();
        this.invalidate();
        this.requestLayout();
        this.sendAccessibilityEvent(32);
    }

    public void close() {
        this.closeDrawer();
        this.invalidate();
        this.requestLayout();
    }

    public void animateClose() {
        this.prepareContent();
        OnDrawerScrollListener scrollListener = this.mOnDrawerScrollListener;
        if (scrollListener != null) {
            scrollListener.onScrollStarted();
        }
        this.animateClose(this.mVertical ? this.mHandle.getTop() : this.mHandle.getLeft(), false);
        if (scrollListener != null) {
            scrollListener.onScrollEnded();
        }
    }

    public void animateOpen() {
        this.prepareContent();
        OnDrawerScrollListener scrollListener = this.mOnDrawerScrollListener;
        if (scrollListener != null) {
            scrollListener.onScrollStarted();
        }
        this.animateOpen(this.mVertical ? this.mHandle.getTop() : this.mHandle.getLeft(), false);
        this.sendAccessibilityEvent(32);
        if (scrollListener != null) {
            scrollListener.onScrollEnded();
        }
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return SlidingDrawer.class.getName();
    }

    private void closeDrawer() {
        this.moveHandle(-10002);
        this.mContent.setVisibility(8);
        this.mContent.destroyDrawingCache();
        if (!this.mExpanded) {
            return;
        }
        this.mExpanded = false;
        if (this.mOnDrawerCloseListener != null) {
            this.mOnDrawerCloseListener.onDrawerClosed();
        }
    }

    private void openDrawer() {
        this.moveHandle(-10001);
        this.mContent.setVisibility(0);
        if (this.mExpanded) {
            return;
        }
        this.mExpanded = true;
        if (this.mOnDrawerOpenListener != null) {
            this.mOnDrawerOpenListener.onDrawerOpened();
        }
    }

    public void setOnDrawerOpenListener(OnDrawerOpenListener onDrawerOpenListener) {
        this.mOnDrawerOpenListener = onDrawerOpenListener;
    }

    public void setOnDrawerCloseListener(OnDrawerCloseListener onDrawerCloseListener) {
        this.mOnDrawerCloseListener = onDrawerCloseListener;
    }

    public void setOnDrawerScrollListener(OnDrawerScrollListener onDrawerScrollListener) {
        this.mOnDrawerScrollListener = onDrawerScrollListener;
    }

    public View getHandle() {
        return this.mHandle;
    }

    public View getContent() {
        return this.mContent;
    }

    public void unlock() {
        this.mLocked = false;
    }

    public void lock() {
        this.mLocked = true;
    }

    public boolean isOpened() {
        return this.mExpanded;
    }

    public boolean isMoving() {
        return this.mTracking || this.mAnimating;
    }

    private class DrawerToggler
    implements View.OnClickListener {
        private DrawerToggler() {
        }

        @Override
        public void onClick(View v) {
            if (SlidingDrawer.this.mLocked) {
                return;
            }
            if (SlidingDrawer.this.mAnimateOnClick) {
                SlidingDrawer.this.animateToggle();
            } else {
                SlidingDrawer.this.toggle();
            }
        }
    }

    public static interface OnDrawerScrollListener {
        public void onScrollStarted();

        public void onScrollEnded();
    }

    public static interface OnDrawerCloseListener {
        public void onDrawerClosed();
    }

    public static interface OnDrawerOpenListener {
        public void onDrawerOpened();
    }
}

