/*
 * Decompiled with CFR 0.152.
 */
package com.android.ims;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Message;
import android.os.Parcel;
import android.telecom.ConferenceParticipant;
import android.telephony.CallQuality;
import android.telephony.Rlog;
import android.telephony.ims.ImsCallProfile;
import android.telephony.ims.ImsCallSession;
import android.telephony.ims.ImsConferenceState;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.ImsStreamMediaProfile;
import android.telephony.ims.ImsSuppServiceNotification;
import android.util.Log;
import com.android.ims.ImsException;
import com.android.ims.internal.ICall;
import com.android.ims.internal.ImsStreamMediaSession;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class ImsCall
implements ICall {
    public static final int USSD_MODE_NOTIFY = 0;
    public static final int USSD_MODE_REQUEST = 1;
    private static final String TAG = "ImsCall";
    private static final boolean FORCE_DEBUG = false;
    private static final boolean DBG = Log.isLoggable("ImsCall", 3);
    private static final boolean VDBG = Log.isLoggable("ImsCall", 2);
    private static final boolean CONF_DBG = true;
    private List<ConferenceParticipant> mConferenceParticipants;
    private static final int UPDATE_NONE = 0;
    private static final int UPDATE_HOLD = 1;
    private static final int UPDATE_HOLD_MERGE = 2;
    private static final int UPDATE_RESUME = 3;
    private static final int UPDATE_MERGE = 4;
    private static final int UPDATE_EXTEND_TO_CONFERENCE = 5;
    private static final int UPDATE_UNSPECIFIED = 6;
    private Object mLockObj = new Object();
    private Context mContext;
    private boolean mInCall = false;
    private boolean mHold = false;
    private boolean mMute = false;
    private int mUpdateRequest = 0;
    private Listener mListener = null;
    private ImsCall mMergePeer = null;
    private ImsCall mMergeHost = null;
    private boolean mMergeRequestedByConference = false;
    private ImsCallSession mSession = null;
    private ImsCallProfile mCallProfile = null;
    private ImsCallProfile mProposedCallProfile = null;
    private ImsReasonInfo mLastReasonInfo = null;
    private ImsStreamMediaSession mMediaSession = null;
    private ImsCallSession mTransientConferenceSession = null;
    private boolean mSessionEndDuringMerge = false;
    private ImsReasonInfo mSessionEndDuringMergeReasonInfo = null;
    private boolean mIsMerged = false;
    private boolean mCallSessionMergePending = false;
    private boolean mTerminationRequestPending = false;
    private boolean mIsConferenceHost = false;
    private boolean mWasVideoCall = false;
    private static final AtomicInteger sUniqueIdGenerator = new AtomicInteger();
    public final int uniqueId;
    private ImsCallSessionListenerProxy mImsCallSessionListenerProxy;
    private int mOverrideReason = 0;
    private boolean mAnswerWithRtt = false;

    public ImsCall(Context context, ImsCallProfile profile) {
        this.mContext = context;
        this.setCallProfile(profile);
        this.uniqueId = sUniqueIdGenerator.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mSession != null) {
                this.mSession.close();
                this.mSession = null;
            } else {
                this.logi("close :: Cannot close Null call session!");
            }
            this.mCallProfile = null;
            this.mProposedCallProfile = null;
            this.mLastReasonInfo = null;
            this.mMediaSession = null;
        }
    }

    @Override
    public boolean checkIfRemoteUserIsSame(String userId) {
        if (userId == null) {
            return false;
        }
        return userId.equals(this.mCallProfile.getCallExtra("remote_uri", ""));
    }

    @Override
    public boolean equalsTo(ICall call) {
        if (call == null) {
            return false;
        }
        if (call instanceof ImsCall) {
            return this.equals(call);
        }
        return false;
    }

    public static boolean isSessionAlive(ImsCallSession session) {
        return session != null && session.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImsCallProfile getCallProfile() {
        Object object = this.mLockObj;
        synchronized (object) {
            return this.mCallProfile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void setCallProfile(ImsCallProfile profile) {
        Object object = this.mLockObj;
        synchronized (object) {
            this.mCallProfile = profile;
            this.trackVideoStateHistory(this.mCallProfile);
        }
    }

    public ImsCallProfile getLocalCallProfile() throws ImsException {
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mSession == null) {
                throw new ImsException("No call session", 148);
            }
            try {
                return this.mSession.getLocalCallProfile();
            }
            catch (Throwable t) {
                this.loge("getLocalCallProfile :: ", t);
                throw new ImsException("getLocalCallProfile()", t, 0);
            }
        }
    }

    public ImsCallProfile getRemoteCallProfile() throws ImsException {
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mSession == null) {
                throw new ImsException("No call session", 148);
            }
            try {
                return this.mSession.getRemoteCallProfile();
            }
            catch (Throwable t) {
                this.loge("getRemoteCallProfile :: ", t);
                throw new ImsException("getRemoteCallProfile()", t, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImsCallProfile getProposedCallProfile() {
        Object object = this.mLockObj;
        synchronized (object) {
            if (!this.isInCall()) {
                return null;
            }
            return this.mProposedCallProfile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConferenceParticipant> getConferenceParticipants() {
        Object object = this.mLockObj;
        synchronized (object) {
            this.logi("getConferenceParticipants :: mConferenceParticipants" + this.mConferenceParticipants);
            if (this.mConferenceParticipants == null) {
                return null;
            }
            if (this.mConferenceParticipants.isEmpty()) {
                return new ArrayList<ConferenceParticipant>(0);
            }
            return new ArrayList<ConferenceParticipant>(this.mConferenceParticipants);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mSession == null) {
                return 0;
            }
            return this.mSession.getState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImsCallSession getCallSession() {
        Object object = this.mLockObj;
        synchronized (object) {
            return this.mSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImsStreamMediaSession getMediaSession() {
        Object object = this.mLockObj;
        synchronized (object) {
            return this.mMediaSession;
        }
    }

    public String getCallExtra(String name) throws ImsException {
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mSession == null) {
                throw new ImsException("No call session", 148);
            }
            try {
                return this.mSession.getProperty(name);
            }
            catch (Throwable t) {
                this.loge("getCallExtra :: ", t);
                throw new ImsException("getCallExtra()", t, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImsReasonInfo getLastReasonInfo() {
        Object object = this.mLockObj;
        synchronized (object) {
            return this.mLastReasonInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingUpdate() {
        Object object = this.mLockObj;
        synchronized (object) {
            return this.mUpdateRequest != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPendingHold() {
        Object object = this.mLockObj;
        synchronized (object) {
            return this.mUpdateRequest == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInCall() {
        Object object = this.mLockObj;
        synchronized (object) {
            return this.mInCall;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMuted() {
        Object object = this.mLockObj;
        synchronized (object) {
            return this.mMute;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOnHold() {
        Object object = this.mLockObj;
        synchronized (object) {
            return this.mHold;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMultiparty() {
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mSession == null) {
                return false;
            }
            return this.mSession.isMultiparty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConferenceHost() {
        Object object = this.mLockObj;
        synchronized (object) {
            return this.isMultiparty() && this.mIsConferenceHost;
        }
    }

    public void setIsMerged(boolean isMerged) {
        this.mIsMerged = isMerged;
    }

    public boolean isMerged() {
        return this.mIsMerged;
    }

    public void setListener(Listener listener) {
        this.setListener(listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(Listener listener, boolean callbackImmediately) {
        ImsReasonInfo lastReasonInfo;
        int state;
        boolean onHold;
        boolean inCall;
        Object object = this.mLockObj;
        synchronized (object) {
            this.mListener = listener;
            if (listener == null || !callbackImmediately) {
                return;
            }
            inCall = this.mInCall;
            onHold = this.mHold;
            state = this.getState();
            lastReasonInfo = this.mLastReasonInfo;
        }
        try {
            if (lastReasonInfo != null) {
                listener.onCallError(this, lastReasonInfo);
            } else if (inCall) {
                if (onHold) {
                    listener.onCallHeld(this);
                } else {
                    listener.onCallStarted(this);
                }
            } else {
                switch (state) {
                    case 3: {
                        listener.onCallProgressing(this);
                        break;
                    }
                    case 8: {
                        listener.onCallTerminated(this, lastReasonInfo);
                        break;
                    }
                }
            }
        }
        catch (Throwable t) {
            this.loge("setListener() :: ", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMute(boolean muted) throws ImsException {
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mMute != muted) {
                this.logi("setMute :: turning mute " + (muted ? "on" : "off"));
                this.mMute = muted;
                try {
                    this.mSession.setMute(muted);
                }
                catch (Throwable t) {
                    this.loge("setMute :: ", t);
                    this.throwImsException(t, 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachSession(ImsCallSession session) throws ImsException {
        this.logi("attachSession :: session=" + session);
        Object object = this.mLockObj;
        synchronized (object) {
            this.mSession = session;
            try {
                this.mSession.setListener(this.createCallSessionListener());
            }
            catch (Throwable t) {
                this.loge("attachSession :: ", t);
                this.throwImsException(t, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ImsCallSession session, String callee) throws ImsException {
        this.logi("start(1) :: session=" + session);
        Object object = this.mLockObj;
        synchronized (object) {
            this.mSession = session;
            try {
                session.setListener(this.createCallSessionListener());
                session.start(callee, this.mCallProfile);
            }
            catch (Throwable t) {
                this.loge("start(1) :: ", t);
                throw new ImsException("start(1)", t, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ImsCallSession session, String[] participants) throws ImsException {
        this.logi("start(n) :: session=" + session);
        Object object = this.mLockObj;
        synchronized (object) {
            this.mSession = session;
            try {
                session.setListener(this.createCallSessionListener());
                session.start(participants, this.mCallProfile);
            }
            catch (Throwable t) {
                this.loge("start(n) :: ", t);
                throw new ImsException("start(n)", t, 0);
            }
        }
    }

    public void accept(int callType) throws ImsException {
        this.accept(callType, new ImsStreamMediaProfile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(int callType, ImsStreamMediaProfile profile) throws ImsException {
        this.logi("accept :: callType=" + callType + ", profile=" + profile);
        if (this.mAnswerWithRtt) {
            profile.mRttMode = 1;
            this.logi("accept :: changing media profile RTT mode to full");
        }
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mSession == null) {
                throw new ImsException("No call to answer", 148);
            }
            try {
                this.mSession.accept(callType, profile);
            }
            catch (Throwable t) {
                this.loge("accept :: ", t);
                throw new ImsException("accept()", t, 0);
            }
            if (this.mInCall && this.mProposedCallProfile != null) {
                if (DBG) {
                    this.logi("accept :: call profile will be updated");
                }
                this.mCallProfile = this.mProposedCallProfile;
                this.trackVideoStateHistory(this.mCallProfile);
                this.mProposedCallProfile = null;
            }
            if (this.mInCall && this.mUpdateRequest == 6) {
                this.mUpdateRequest = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deflect(String number) throws ImsException {
        this.logi("deflect :: session=" + this.mSession + ", number=" + Rlog.pii(TAG, (Object)number));
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mSession == null) {
                throw new ImsException("No call to deflect", 148);
            }
            try {
                this.mSession.deflect(number);
            }
            catch (Throwable t) {
                this.loge("deflect :: ", t);
                throw new ImsException("deflect()", t, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reject(int reason) throws ImsException {
        this.logi("reject :: reason=" + reason);
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mSession != null) {
                this.mSession.reject(reason);
            }
            if (this.mInCall && this.mProposedCallProfile != null) {
                if (DBG) {
                    this.logi("reject :: call profile is not updated; destroy it...");
                }
                this.mProposedCallProfile = null;
            }
            if (this.mInCall && this.mUpdateRequest == 6) {
                this.mUpdateRequest = 0;
            }
        }
    }

    public void terminate(int reason, int overrideReason) {
        this.logi("terminate :: reason=" + reason + " ; overrideReason=" + overrideReason);
        this.mOverrideReason = overrideReason;
        this.terminate(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(int reason) {
        this.logi("terminate :: reason=" + reason);
        Object object = this.mLockObj;
        synchronized (object) {
            this.mHold = false;
            this.mInCall = false;
            this.mTerminationRequestPending = true;
            if (this.mSession != null) {
                this.mSession.terminate(reason);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hold() throws ImsException {
        this.logi("hold :: ");
        if (this.isOnHold()) {
            if (DBG) {
                this.logi("hold :: call is already on hold");
            }
            return;
        }
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mUpdateRequest != 0) {
                this.loge("hold :: update is in progress; request=" + this.updateRequestToString(this.mUpdateRequest));
                throw new ImsException("Call update is in progress", 102);
            }
            if (this.mSession == null) {
                throw new ImsException("No call session", 148);
            }
            this.mSession.hold(this.createHoldMediaProfile());
            this.mHold = true;
            this.mUpdateRequest = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws ImsException {
        this.logi("resume :: ");
        if (!this.isOnHold()) {
            if (DBG) {
                this.logi("resume :: call is not being held");
            }
            return;
        }
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mUpdateRequest != 0) {
                this.loge("resume :: update is in progress; request=" + this.updateRequestToString(this.mUpdateRequest));
                throw new ImsException("Call update is in progress", 102);
            }
            if (this.mSession == null) {
                this.loge("resume :: ");
                throw new ImsException("No call session", 148);
            }
            this.mUpdateRequest = 3;
            this.mSession.resume(this.createResumeMediaProfile());
        }
    }

    private boolean isUpdatePending(ImsCall imsCall) {
        if (imsCall != null && imsCall.mUpdateRequest != 0) {
            this.loge("merge :: update is in progress; request=" + this.updateRequestToString(this.mUpdateRequest));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void merge() throws ImsException {
        this.logi("merge :: ");
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.isUpdatePending(this)) {
                this.setCallSessionMergePending(false);
                if (this.mMergePeer != null) {
                    this.mMergePeer.setCallSessionMergePending(false);
                }
                if (this.mMergeHost != null) {
                    this.mMergeHost.setCallSessionMergePending(false);
                }
                throw new ImsException("Call update is in progress", 102);
            }
            if (this.isUpdatePending(this.mMergePeer) || this.isUpdatePending(this.mMergeHost)) {
                this.setCallSessionMergePending(false);
                if (this.mMergePeer != null) {
                    this.mMergePeer.setCallSessionMergePending(false);
                }
                if (this.mMergeHost != null) {
                    this.mMergeHost.setCallSessionMergePending(false);
                }
                throw new ImsException("Peer or host call update is in progress", 102);
            }
            if (this.mSession == null) {
                this.loge("merge :: no call session");
                throw new ImsException("No call session", 148);
            }
            if (this.mHold || this.mContext.getResources().getBoolean(0x111011E)) {
                if (this.mMergePeer != null && !this.mMergePeer.isMultiparty() && !this.isMultiparty()) {
                    this.mUpdateRequest = 4;
                    this.mMergePeer.mUpdateRequest = 4;
                } else if (this.mMergeHost != null && !this.mMergeHost.isMultiparty() && !this.isMultiparty()) {
                    this.mUpdateRequest = 4;
                    this.mMergeHost.mUpdateRequest = 4;
                }
                this.mSession.merge();
            } else {
                this.mSession.hold(this.createHoldMediaProfile());
                this.mHold = true;
                this.mUpdateRequest = 2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(ImsCall bgCall) throws ImsException {
        this.logi("merge(1) :: bgImsCall=" + bgCall);
        if (bgCall == null) {
            throw new ImsException("No background call", 101);
        }
        Object object = this.mLockObj;
        synchronized (object) {
            this.setCallSessionMergePending(true);
            bgCall.setCallSessionMergePending(true);
            if (!this.isMultiparty() && !bgCall.isMultiparty() || this.isMultiparty()) {
                this.setMergePeer(bgCall);
            } else {
                this.setMergeHost(bgCall);
            }
        }
        if (this.isMultiparty()) {
            this.mMergeRequestedByConference = true;
        } else {
            this.logi("merge : mMergeRequestedByConference not set");
        }
        this.merge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int callType, ImsStreamMediaProfile mediaProfile) throws ImsException {
        this.logi("update :: callType=" + callType + ", mediaProfile=" + mediaProfile);
        if (this.isOnHold()) {
            if (DBG) {
                this.logi("update :: call is on hold");
            }
            throw new ImsException("Not in a call to update call", 102);
        }
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mUpdateRequest != 0) {
                if (DBG) {
                    this.logi("update :: update is in progress; request=" + this.updateRequestToString(this.mUpdateRequest));
                }
                throw new ImsException("Call update is in progress", 102);
            }
            if (this.mSession == null) {
                this.loge("update :: ");
                throw new ImsException("No call session", 148);
            }
            this.mSession.update(callType, mediaProfile);
            this.mUpdateRequest = 6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extendToConference(String[] participants) throws ImsException {
        this.logi("extendToConference ::");
        if (this.isOnHold()) {
            if (DBG) {
                this.logi("extendToConference :: call is on hold");
            }
            throw new ImsException("Not in a call to extend a call to conference", 102);
        }
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mUpdateRequest != 0) {
                this.logi("extendToConference :: update is in progress; request=" + this.updateRequestToString(this.mUpdateRequest));
                throw new ImsException("Call update is in progress", 102);
            }
            if (this.mSession == null) {
                this.loge("extendToConference :: ");
                throw new ImsException("No call session", 148);
            }
            this.mSession.extendToConference(participants);
            this.mUpdateRequest = 5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inviteParticipants(String[] participants) throws ImsException {
        this.logi("inviteParticipants ::");
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mSession == null) {
                this.loge("inviteParticipants :: ");
                throw new ImsException("No call session", 148);
            }
            this.mSession.inviteParticipants(participants);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParticipants(String[] participants) throws ImsException {
        this.logi("removeParticipants :: session=" + this.mSession);
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mSession == null) {
                this.loge("removeParticipants :: ");
                throw new ImsException("No call session", 148);
            }
            this.mSession.removeParticipants(participants);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDtmf(char c, Message result) {
        this.logi("sendDtmf :: ");
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mSession != null) {
                this.mSession.sendDtmf(c, result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDtmf(char c) {
        this.logi("startDtmf :: ");
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mSession != null) {
                this.mSession.startDtmf(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDtmf() {
        this.logi("stopDtmf :: ");
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mSession != null) {
                this.mSession.stopDtmf();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUssd(String ussdMessage) throws ImsException {
        this.logi("sendUssd :: ussdMessage=" + ussdMessage);
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mSession == null) {
                this.loge("sendUssd :: ");
                throw new ImsException("No call session", 148);
            }
            this.mSession.sendUssd(ussdMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRttMessage(String rttMessage) {
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mSession == null) {
                this.loge("sendRttMessage::no session");
            }
            if (!this.mCallProfile.mMediaProfile.isRttCall()) {
                this.logi("sendRttMessage::Not an rtt call, ignoring");
                return;
            }
            this.mSession.sendRttMessage(rttMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRttModifyRequest(boolean rttOn) {
        this.logi("sendRttModifyRequest");
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mSession == null) {
                this.loge("sendRttModifyRequest::no session");
            }
            if (rttOn && this.mCallProfile.mMediaProfile.isRttCall()) {
                this.logi("sendRttModifyRequest::Already RTT call, ignoring request to turn on.");
                return;
            }
            if (!rttOn && !this.mCallProfile.mMediaProfile.isRttCall()) {
                this.logi("sendRttModifyRequest::Not RTT call, ignoring request to turn off.");
                return;
            }
            Parcel p = Parcel.obtain();
            this.mCallProfile.writeToParcel(p, 0);
            p.setDataPosition(0);
            ImsCallProfile requestedProfile = new ImsCallProfile(p);
            requestedProfile.mMediaProfile.setRttMode(rttOn ? 1 : 0);
            this.mSession.sendRttModifyRequest(requestedProfile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRttModifyResponse(boolean status) {
        this.logi("sendRttModifyResponse");
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mSession == null) {
                this.loge("sendRttModifyResponse::no session");
            }
            if (this.mCallProfile.mMediaProfile.isRttCall()) {
                this.logi("sendRttModifyResponse::Already RTT call, ignoring.");
                return;
            }
            this.mSession.sendRttModifyResponse(status);
        }
    }

    public void setAnswerWithRtt() {
        this.mAnswerWithRtt = true;
    }

    private void clear(ImsReasonInfo lastReasonInfo) {
        this.mInCall = false;
        this.mHold = false;
        this.mUpdateRequest = 0;
        this.mLastReasonInfo = lastReasonInfo;
    }

    private ImsCallSession.Listener createCallSessionListener() {
        this.mImsCallSessionListenerProxy = new ImsCallSessionListenerProxy();
        return this.mImsCallSessionListenerProxy;
    }

    @VisibleForTesting
    public ImsCallSessionListenerProxy getImsCallSessionListenerProxy() {
        return this.mImsCallSessionListenerProxy;
    }

    private ImsCall createNewCall(ImsCallSession session, ImsCallProfile profile) {
        ImsCall call;
        block2: {
            call = new ImsCall(this.mContext, profile);
            try {
                call.attachSession(session);
            }
            catch (ImsException e) {
                if (call == null) break block2;
                call.close();
                call = null;
            }
        }
        return call;
    }

    private ImsStreamMediaProfile createHoldMediaProfile() {
        ImsStreamMediaProfile mediaProfile = new ImsStreamMediaProfile();
        if (this.mCallProfile == null) {
            return mediaProfile;
        }
        mediaProfile.mAudioQuality = this.mCallProfile.mMediaProfile.mAudioQuality;
        mediaProfile.mVideoQuality = this.mCallProfile.mMediaProfile.mVideoQuality;
        mediaProfile.mAudioDirection = 2;
        if (mediaProfile.mVideoQuality != 0) {
            mediaProfile.mVideoDirection = 2;
        }
        return mediaProfile;
    }

    private ImsStreamMediaProfile createResumeMediaProfile() {
        ImsStreamMediaProfile mediaProfile = new ImsStreamMediaProfile();
        if (this.mCallProfile == null) {
            return mediaProfile;
        }
        mediaProfile.mAudioQuality = this.mCallProfile.mMediaProfile.mAudioQuality;
        mediaProfile.mVideoQuality = this.mCallProfile.mMediaProfile.mVideoQuality;
        mediaProfile.mAudioDirection = 3;
        if (mediaProfile.mVideoQuality != 0) {
            mediaProfile.mVideoDirection = 3;
        }
        return mediaProfile;
    }

    private void enforceConversationMode() {
        if (this.mInCall) {
            this.mHold = false;
            this.mUpdateRequest = 0;
        }
    }

    private void mergeInternal() {
        this.logi("mergeInternal :: ");
        this.mSession.merge();
        this.mUpdateRequest = 4;
    }

    private void notifyConferenceSessionTerminated(ImsReasonInfo reasonInfo) {
        Listener listener = this.mListener;
        this.clear(reasonInfo);
        if (listener != null) {
            try {
                listener.onCallTerminated(this, reasonInfo);
            }
            catch (Throwable t) {
                this.loge("notifyConferenceSessionTerminated :: ", t);
            }
        }
    }

    private void notifyConferenceStateUpdated(ImsConferenceState state) {
        if (state == null || state.mParticipants == null) {
            return;
        }
        Set<Map.Entry<String, Bundle>> participants = state.mParticipants.entrySet();
        if (participants == null) {
            return;
        }
        Iterator<Map.Entry<String, Bundle>> iterator = participants.iterator();
        this.mConferenceParticipants = new ArrayList<ConferenceParticipant>(participants.size());
        while (iterator.hasNext()) {
            Map.Entry<String, Bundle> entry = iterator.next();
            String key = entry.getKey();
            Bundle confInfo = entry.getValue();
            String status = confInfo.getString("status");
            String user = confInfo.getString("user");
            String displayName = confInfo.getString("display-text");
            String endpoint = confInfo.getString("endpoint");
            this.logi("notifyConferenceStateUpdated :: key=" + Rlog.pii(TAG, (Object)key) + ", status=" + status + ", user=" + Rlog.pii(TAG, (Object)user) + ", displayName= " + Rlog.pii(TAG, (Object)displayName) + ", endpoint=" + endpoint);
            Uri handle = Uri.parse(user);
            if (endpoint == null) {
                endpoint = "";
            }
            Uri endpointUri = Uri.parse(endpoint);
            int connectionState = ImsConferenceState.getConnectionStateForStatus(status);
            if (connectionState == 6) continue;
            ConferenceParticipant conferenceParticipant = new ConferenceParticipant(handle, displayName, endpointUri, connectionState, -1);
            this.mConferenceParticipants.add(conferenceParticipant);
        }
        if (this.mConferenceParticipants != null && this.mListener != null) {
            try {
                this.mListener.onConferenceParticipantsStateChanged(this, this.mConferenceParticipants);
            }
            catch (Throwable t) {
                this.loge("notifyConferenceStateUpdated :: ", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCallTerminated(ImsReasonInfo reasonInfo) {
        this.logi("processCallTerminated :: reason=" + reasonInfo + " userInitiated = " + this.mTerminationRequestPending);
        Listener listener = null;
        ImsCall imsCall = this;
        synchronized (imsCall) {
            if (this.isCallSessionMergePending() && !this.mTerminationRequestPending) {
                this.logi("processCallTerminated :: burying termination during ongoing merge.");
                this.mSessionEndDuringMerge = true;
                this.mSessionEndDuringMergeReasonInfo = reasonInfo;
                return;
            }
            if (this.isMultiparty()) {
                this.notifyConferenceSessionTerminated(reasonInfo);
                return;
            }
            listener = this.mListener;
            this.clear(reasonInfo);
        }
        if (listener != null) {
            try {
                listener.onCallTerminated(this, reasonInfo);
            }
            catch (Throwable t) {
                this.loge("processCallTerminated :: ", t);
            }
        }
    }

    private boolean isTransientConferenceSession(ImsCallSession session) {
        return session != null && session != this.mSession && session == this.mTransientConferenceSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTransientSessionAsPrimary(ImsCallSession transientSession) {
        ImsCall imsCall = this;
        synchronized (imsCall) {
            this.mSession.setListener(null);
            this.mSession = transientSession;
            this.mSession.setListener(this.createCallSessionListener());
        }
    }

    private void markCallAsMerged(boolean playDisconnectTone) {
        if (!ImsCall.isSessionAlive(this.mSession)) {
            String reasonInfo;
            this.logi("markCallAsMerged");
            this.setIsMerged(playDisconnectTone);
            this.mSessionEndDuringMerge = true;
            int reasonCode = 0;
            if (playDisconnectTone) {
                reasonCode = 510;
                reasonInfo = "Call ended by network";
            } else {
                reasonCode = 108;
                reasonInfo = "Call ended during conference merge process.";
            }
            this.mSessionEndDuringMergeReasonInfo = new ImsReasonInfo(reasonCode, 0, reasonInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMergeRequestedByConf() {
        Object object = this.mLockObj;
        synchronized (object) {
            return this.mMergeRequestedByConference;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetIsMergeRequestedByConf(boolean value) {
        Object object = this.mLockObj;
        synchronized (object) {
            this.mMergeRequestedByConference = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImsCallSession getSession() {
        Object object = this.mLockObj;
        synchronized (object) {
            return this.mSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMergeComplete() {
        Listener listener;
        ImsCall finalPeerCall;
        ImsCall finalHostCall;
        this.logi("processMergeComplete :: ");
        if (!this.isMergeHost()) {
            this.loge("processMergeComplete :: We are not the merge host!");
            return;
        }
        boolean swapRequired = false;
        ImsCall imsCall = this;
        synchronized (imsCall) {
            if (this.isMultiparty()) {
                this.setIsMerged(false);
                if (!this.mMergeRequestedByConference) {
                    this.mHold = false;
                    swapRequired = true;
                }
                this.mMergePeer.markCallAsMerged(false);
                finalHostCall = this;
                finalPeerCall = this.mMergePeer;
            } else {
                if (this.mTransientConferenceSession == null) {
                    this.loge("processMergeComplete :: No transient session!");
                    return;
                }
                if (this.mMergePeer == null) {
                    this.loge("processMergeComplete :: No merge peer!");
                    return;
                }
                ImsCallSession transientConferenceSession = this.mTransientConferenceSession;
                this.mTransientConferenceSession = null;
                transientConferenceSession.setListener(null);
                if (ImsCall.isSessionAlive(this.mSession) && !ImsCall.isSessionAlive(this.mMergePeer.getCallSession())) {
                    this.mMergePeer.mHold = false;
                    this.mHold = true;
                    if (this.mConferenceParticipants != null && !this.mConferenceParticipants.isEmpty()) {
                        this.mMergePeer.mConferenceParticipants = this.mConferenceParticipants;
                    }
                    finalHostCall = this.mMergePeer;
                    finalPeerCall = this;
                    swapRequired = true;
                    this.setIsMerged(false);
                    this.mMergePeer.setIsMerged(false);
                    this.logi("processMergeComplete :: transient will transfer to merge peer");
                } else if (!ImsCall.isSessionAlive(this.mSession) && ImsCall.isSessionAlive(this.mMergePeer.getCallSession())) {
                    finalHostCall = this;
                    finalPeerCall = this.mMergePeer;
                    swapRequired = false;
                    this.setIsMerged(false);
                    this.mMergePeer.setIsMerged(false);
                    this.logi("processMergeComplete :: transient will stay with the merge host");
                } else {
                    finalHostCall = this;
                    finalPeerCall = this.mMergePeer;
                    this.mMergePeer.markCallAsMerged(false);
                    swapRequired = false;
                    this.setIsMerged(false);
                    this.mMergePeer.setIsMerged(true);
                    this.logi("processMergeComplete :: transient will stay with us (I'm the host).");
                }
                this.logi("processMergeComplete :: call=" + finalHostCall + " is the final host");
                finalHostCall.setTransientSessionAsPrimary(transientConferenceSession);
            }
            listener = finalHostCall.mListener;
            ImsCall.updateCallProfile(finalPeerCall);
            ImsCall.updateCallProfile(finalHostCall);
            this.clearMergeInfo();
            finalPeerCall.notifySessionTerminatedDuringMerge();
            finalHostCall.clearSessionTerminationFlags();
            finalHostCall.mIsConferenceHost = true;
        }
        if (listener != null) {
            try {
                listener.onCallMerged(finalHostCall, finalPeerCall, swapRequired);
            }
            catch (Throwable t) {
                this.loge("processMergeComplete :: ", t);
            }
            if (this.mConferenceParticipants != null && !this.mConferenceParticipants.isEmpty()) {
                try {
                    listener.onConferenceParticipantsStateChanged(finalHostCall, this.mConferenceParticipants);
                }
                catch (Throwable t) {
                    this.loge("processMergeComplete :: ", t);
                }
            }
        }
    }

    private static void updateCallProfile(ImsCall call) {
        if (call != null) {
            call.updateCallProfile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCallProfile() {
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mSession != null) {
                this.setCallProfile(this.mSession.getCallProfile());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySessionTerminatedDuringMerge() {
        Listener listener;
        boolean notifyFailure = false;
        ImsReasonInfo notifyFailureReasonInfo = null;
        ImsCall imsCall = this;
        synchronized (imsCall) {
            listener = this.mListener;
            if (this.mSessionEndDuringMerge) {
                this.logi("notifySessionTerminatedDuringMerge ::reporting terminate during merge");
                notifyFailure = true;
                notifyFailureReasonInfo = this.mSessionEndDuringMergeReasonInfo;
            }
            this.clearSessionTerminationFlags();
        }
        if (listener != null && notifyFailure) {
            try {
                this.processCallTerminated(notifyFailureReasonInfo);
            }
            catch (Throwable t) {
                this.loge("notifySessionTerminatedDuringMerge :: ", t);
            }
        }
    }

    private void clearSessionTerminationFlags() {
        this.mSessionEndDuringMerge = false;
        this.mSessionEndDuringMergeReasonInfo = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMergeFailed(ImsReasonInfo reasonInfo) {
        Listener listener;
        this.logi("processMergeFailed :: reason=" + reasonInfo);
        ImsCall imsCall = this;
        synchronized (imsCall) {
            if (!this.isMergeHost()) {
                this.loge("processMergeFailed :: We are not the merge host!");
                return;
            }
            if (this.mTransientConferenceSession != null) {
                this.mTransientConferenceSession.setListener(null);
                this.mTransientConferenceSession = null;
            }
            listener = this.mListener;
            this.markCallAsMerged(true);
            this.setCallSessionMergePending(false);
            this.notifySessionTerminatedDuringMerge();
            if (this.mMergePeer != null) {
                this.mMergePeer.markCallAsMerged(true);
                this.mMergePeer.setCallSessionMergePending(false);
                this.mMergePeer.notifySessionTerminatedDuringMerge();
            } else {
                this.loge("processMergeFailed :: No merge peer!");
            }
            this.clearMergeInfo();
        }
        if (listener != null) {
            try {
                listener.onCallMergeFailed(this, reasonInfo);
            }
            catch (Throwable t) {
                this.loge("processMergeFailed :: ", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void conferenceStateUpdated(ImsConferenceState state) {
        Listener listener;
        ImsCall imsCall = this;
        synchronized (imsCall) {
            this.notifyConferenceStateUpdated(state);
            listener = this.mListener;
        }
        if (listener != null) {
            try {
                listener.onCallConferenceStateUpdated(this, state);
            }
            catch (Throwable t) {
                this.loge("callSessionConferenceStateUpdated :: ", t);
            }
        }
    }

    private String updateRequestToString(int updateRequest) {
        switch (updateRequest) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "HOLD";
            }
            case 2: {
                return "HOLD_MERGE";
            }
            case 3: {
                return "RESUME";
            }
            case 4: {
                return "MERGE";
            }
            case 5: {
                return "EXTEND_TO_CONFERENCE";
            }
            case 6: {
                return "UNSPECIFIED";
            }
        }
        return "UNKNOWN";
    }

    private void clearMergeInfo() {
        this.logi("clearMergeInfo :: clearing all merge info");
        if (this.mMergeHost != null) {
            this.mMergeHost.mMergePeer = null;
            this.mMergeHost.mUpdateRequest = 0;
            this.mMergeHost.mCallSessionMergePending = false;
        }
        if (this.mMergePeer != null) {
            this.mMergePeer.mMergeHost = null;
            this.mMergePeer.mUpdateRequest = 0;
            this.mMergePeer.mCallSessionMergePending = false;
        }
        this.mMergeHost = null;
        this.mMergePeer = null;
        this.mUpdateRequest = 0;
        this.mCallSessionMergePending = false;
    }

    private void setMergePeer(ImsCall mergePeer) {
        this.mMergePeer = mergePeer;
        this.mMergeHost = null;
        mergePeer.mMergeHost = this;
        mergePeer.mMergePeer = null;
    }

    public void setMergeHost(ImsCall mergeHost) {
        this.mMergeHost = mergeHost;
        this.mMergePeer = null;
        mergeHost.mMergeHost = null;
        mergeHost.mMergePeer = this;
    }

    private boolean isMerging() {
        return this.mMergePeer != null || this.mMergeHost != null;
    }

    private boolean isMergeHost() {
        return this.mMergePeer != null && this.mMergeHost == null;
    }

    private boolean isMergePeer() {
        return this.mMergePeer == null && this.mMergeHost != null;
    }

    public boolean isCallSessionMergePending() {
        return this.mCallSessionMergePending;
    }

    private void setCallSessionMergePending(boolean callSessionMergePending) {
        this.mCallSessionMergePending = callSessionMergePending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldProcessConferenceResult() {
        boolean areMergeTriggersDone = false;
        ImsCall imsCall = this;
        synchronized (imsCall) {
            if (!this.isMergeHost() && !this.isMergePeer()) {
                this.loge("shouldProcessConferenceResult :: no merge in progress");
                return false;
            }
            if (this.isMergeHost()) {
                this.logi("shouldProcessConferenceResult :: We are a merge host");
                this.logi("shouldProcessConferenceResult :: Here is the merge peer=" + this.mMergePeer);
                boolean bl = areMergeTriggersDone = !this.isCallSessionMergePending() && !this.mMergePeer.isCallSessionMergePending();
                if (!this.isMultiparty()) {
                    areMergeTriggersDone &= ImsCall.isSessionAlive(this.mTransientConferenceSession);
                }
            } else if (this.isMergePeer()) {
                this.logi("shouldProcessConferenceResult :: We are a merge peer");
                this.logi("shouldProcessConferenceResult :: Here is the merge host=" + this.mMergeHost);
                boolean bl = areMergeTriggersDone = !this.isCallSessionMergePending() && !this.mMergeHost.isCallSessionMergePending();
                areMergeTriggersDone = !this.mMergeHost.isMultiparty() ? (areMergeTriggersDone &= ImsCall.isSessionAlive(this.mMergeHost.mTransientConferenceSession)) : !this.isCallSessionMergePending();
            } else {
                this.loge("shouldProcessConferenceResult : merge in progress but call is neither host nor peer.");
            }
            this.logi("shouldProcessConferenceResult :: returning:" + (areMergeTriggersDone ? "true" : "false"));
        }
        return areMergeTriggersDone;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ImsCall objId:");
        sb.append(System.identityHashCode(this));
        sb.append(" onHold:");
        sb.append(this.isOnHold() ? "Y" : "N");
        sb.append(" mute:");
        sb.append(this.isMuted() ? "Y" : "N");
        if (this.mCallProfile != null) {
            sb.append(" mCallProfile:" + this.mCallProfile);
            sb.append(" tech:");
            sb.append(this.mCallProfile.getCallExtra("CallRadioTech"));
        }
        sb.append(" updateRequest:");
        sb.append(this.updateRequestToString(this.mUpdateRequest));
        sb.append(" merging:");
        sb.append(this.isMerging() ? "Y" : "N");
        if (this.isMerging()) {
            if (this.isMergePeer()) {
                sb.append("P");
            } else {
                sb.append("H");
            }
        }
        sb.append(" merge action pending:");
        sb.append(this.isCallSessionMergePending() ? "Y" : "N");
        sb.append(" merged:");
        sb.append(this.isMerged() ? "Y" : "N");
        sb.append(" multiParty:");
        sb.append(this.isMultiparty() ? "Y" : "N");
        sb.append(" confHost:");
        sb.append(this.isConferenceHost() ? "Y" : "N");
        sb.append(" buried term:");
        sb.append(this.mSessionEndDuringMerge ? "Y" : "N");
        sb.append(" isVideo: ");
        sb.append(this.isVideoCall() ? "Y" : "N");
        sb.append(" wasVideo: ");
        sb.append(this.mWasVideoCall ? "Y" : "N");
        sb.append(" isWifi: ");
        sb.append(this.isWifiCall() ? "Y" : "N");
        sb.append(" session:");
        sb.append(this.mSession);
        sb.append(" transientSession:");
        sb.append(this.mTransientConferenceSession);
        sb.append("]");
        return sb.toString();
    }

    private void throwImsException(Throwable t, int code) throws ImsException {
        if (t instanceof ImsException) {
            throw (ImsException)t;
        }
        throw new ImsException(String.valueOf(code), t, code);
    }

    private String appendImsCallInfoToString(String s) {
        StringBuilder sb = new StringBuilder();
        sb.append(s);
        sb.append(" ImsCall=");
        sb.append(this);
        return sb.toString();
    }

    private void trackVideoStateHistory(ImsCallProfile profile) {
        this.mWasVideoCall = this.mWasVideoCall || profile.isVideoCall();
    }

    public boolean wasVideoCall() {
        return this.mWasVideoCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVideoCall() {
        Object object = this.mLockObj;
        synchronized (object) {
            return this.mCallProfile != null && this.mCallProfile.isVideoCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWifiCall() {
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mCallProfile == null) {
                return false;
            }
            int radioTechnology = this.getRadioTechnology();
            boolean bl = radioTechnology == 18;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRadioTechnology() {
        Object object = this.mLockObj;
        synchronized (object) {
            if (this.mCallProfile == null) {
                return 0;
            }
            String callType = this.mCallProfile.getCallExtra("CallRadioTech");
            if (callType == null || callType.isEmpty()) {
                callType = this.mCallProfile.getCallExtra("callRadioTech");
            }
            int radioTechnology = 0;
            try {
                radioTechnology = Integer.parseInt(callType);
            }
            catch (NumberFormatException nfe) {
                radioTechnology = 0;
            }
            return radioTechnology;
        }
    }

    private void logi(String s) {
        Log.i(TAG, this.appendImsCallInfoToString(s));
    }

    private void logd(String s) {
        Log.d(TAG, this.appendImsCallInfoToString(s));
    }

    private void logv(String s) {
        Log.v(TAG, this.appendImsCallInfoToString(s));
    }

    private void loge(String s) {
        Log.e(TAG, this.appendImsCallInfoToString(s));
    }

    private void loge(String s, Throwable t) {
        Log.e(TAG, this.appendImsCallInfoToString(s), t);
    }

    @VisibleForTesting
    public class ImsCallSessionListenerProxy
    extends ImsCallSession.Listener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionProgressing(ImsCallSession session, ImsStreamMediaProfile profile) {
            Listener listener;
            ImsCall.this.logi("callSessionProgressing :: session=" + session + " profile=" + profile);
            if (ImsCall.this.isTransientConferenceSession(session)) {
                ImsCall.this.logi("callSessionProgressing :: not supported for transient conference session=" + session);
                return;
            }
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
                ((ImsCall)ImsCall.this).mCallProfile.mMediaProfile.copyFrom(profile);
            }
            if (listener != null) {
                try {
                    listener.onCallProgressing(ImsCall.this);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionProgressing :: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionStarted(ImsCallSession session, ImsCallProfile profile) {
            Listener listener;
            ImsCall.this.logi("callSessionStarted :: session=" + session + " profile=" + profile);
            if (ImsCall.this.isTransientConferenceSession(session)) {
                ImsCall.this.logi("callSessionStarted :: on transient session=" + session);
                return;
            }
            ImsCall.this.setCallSessionMergePending(false);
            if (ImsCall.this.isTransientConferenceSession(session)) {
                return;
            }
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
                ImsCall.this.setCallProfile(profile);
            }
            if (listener != null) {
                try {
                    listener.onCallStarted(ImsCall.this);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionStarted :: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionStartFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
            Listener listener;
            ImsCall.this.loge("callSessionStartFailed :: session=" + session + " reasonInfo=" + reasonInfo);
            if (ImsCall.this.isTransientConferenceSession(session)) {
                ImsCall.this.logi("callSessionStartFailed :: not supported for transient conference session=" + session);
                return;
            }
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
                ImsCall.this.mLastReasonInfo = reasonInfo;
            }
            if (listener != null) {
                try {
                    listener.onCallStartFailed(ImsCall.this, reasonInfo);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionStarted :: ", t);
                }
            }
        }

        @Override
        public void callSessionTerminated(ImsCallSession session, ImsReasonInfo reasonInfo) {
            ImsCall.this.logi("callSessionTerminated :: session=" + session + " reasonInfo=" + reasonInfo);
            if (ImsCall.this.isTransientConferenceSession(session)) {
                ImsCall.this.logi("callSessionTerminated :: on transient session=" + session);
                ImsCall.this.processMergeFailed(reasonInfo);
                return;
            }
            if (ImsCall.this.mOverrideReason != 0) {
                ImsCall.this.logi("callSessionTerminated :: overrideReasonInfo=" + ImsCall.this.mOverrideReason);
                reasonInfo = new ImsReasonInfo(ImsCall.this.mOverrideReason, reasonInfo.getExtraCode(), reasonInfo.getExtraMessage());
            }
            ImsCall.this.processCallTerminated(reasonInfo);
            ImsCall.this.setCallSessionMergePending(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionHeld(ImsCallSession session, ImsCallProfile profile) {
            Listener listener;
            ImsCall.this.logi("callSessionHeld :: session=" + session + "profile=" + profile);
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                ImsCall.this.setCallSessionMergePending(false);
                ImsCall.this.setCallProfile(profile);
                if (ImsCall.this.mUpdateRequest == 2) {
                    ImsCall.this.mergeInternal();
                    return;
                }
                ImsCall.this.mUpdateRequest = 0;
                listener = ImsCall.this.mListener;
            }
            if (listener != null) {
                try {
                    listener.onCallHeld(ImsCall.this);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionHeld :: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionHoldFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
            Listener listener;
            ImsCall.this.loge("callSessionHoldFailed :: session" + session + "reasonInfo=" + reasonInfo);
            if (ImsCall.this.isTransientConferenceSession(session)) {
                ImsCall.this.logi("callSessionHoldFailed :: not supported for transient conference session=" + session);
                return;
            }
            ImsCall.this.logi("callSessionHoldFailed :: session=" + session + ", reasonInfo=" + reasonInfo);
            Object object = ImsCall.this.mLockObj;
            synchronized (object) {
                ImsCall.this.mHold = false;
            }
            boolean isHoldForMerge = false;
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                if (ImsCall.this.mUpdateRequest == 2) {
                    isHoldForMerge = true;
                }
                ImsCall.this.mUpdateRequest = 0;
                listener = ImsCall.this.mListener;
            }
            if (listener != null) {
                try {
                    listener.onCallHoldFailed(ImsCall.this, reasonInfo);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionHoldFailed :: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionHoldReceived(ImsCallSession session, ImsCallProfile profile) {
            Listener listener;
            ImsCall.this.logi("callSessionHoldReceived :: session=" + session + "profile=" + profile);
            if (ImsCall.this.isTransientConferenceSession(session)) {
                ImsCall.this.logi("callSessionHoldReceived :: not supported for transient conference session=" + session);
                return;
            }
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
                ImsCall.this.setCallProfile(profile);
            }
            if (listener != null) {
                try {
                    listener.onCallHoldReceived(ImsCall.this);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionHoldReceived :: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionResumed(ImsCallSession session, ImsCallProfile profile) {
            Listener listener;
            ImsCall.this.logi("callSessionResumed :: session=" + session + "profile=" + profile);
            if (ImsCall.this.isTransientConferenceSession(session)) {
                ImsCall.this.logi("callSessionResumed :: not supported for transient conference session=" + session);
                return;
            }
            ImsCall.this.setCallSessionMergePending(false);
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
                ImsCall.this.setCallProfile(profile);
                ImsCall.this.mUpdateRequest = 0;
                ImsCall.this.mHold = false;
            }
            if (listener != null) {
                try {
                    listener.onCallResumed(ImsCall.this);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionResumed :: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionResumeFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
            Listener listener;
            ImsCall.this.loge("callSessionResumeFailed :: session=" + session + "reasonInfo=" + reasonInfo);
            if (ImsCall.this.isTransientConferenceSession(session)) {
                ImsCall.this.logi("callSessionResumeFailed :: not supported for transient conference session=" + session);
                return;
            }
            Object object = ImsCall.this.mLockObj;
            synchronized (object) {
                ImsCall.this.mHold = true;
            }
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
                ImsCall.this.mUpdateRequest = 0;
            }
            if (listener != null) {
                try {
                    listener.onCallResumeFailed(ImsCall.this, reasonInfo);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionResumeFailed :: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionResumeReceived(ImsCallSession session, ImsCallProfile profile) {
            Listener listener;
            ImsCall.this.logi("callSessionResumeReceived :: session=" + session + "profile=" + profile);
            if (ImsCall.this.isTransientConferenceSession(session)) {
                ImsCall.this.logi("callSessionResumeReceived :: not supported for transient conference session=" + session);
                return;
            }
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
                ImsCall.this.setCallProfile(profile);
            }
            if (listener != null) {
                try {
                    listener.onCallResumeReceived(ImsCall.this);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionResumeReceived :: ", t);
                }
            }
        }

        @Override
        public void callSessionMergeStarted(ImsCallSession session, ImsCallSession newSession, ImsCallProfile profile) {
            ImsCall.this.logi("callSessionMergeStarted :: session=" + session + " newSession=" + newSession + ", profile=" + profile);
        }

        private boolean doesCallSessionExistsInMerge(ImsCallSession cs) {
            String callId = cs.getCallId();
            return ImsCall.this.isMergeHost() && Objects.equals(ImsCall.this.mMergePeer.mSession.getCallId(), callId) || ImsCall.this.isMergePeer() && Objects.equals(ImsCall.this.mMergeHost.mSession.getCallId(), callId) || Objects.equals(ImsCall.this.mSession.getCallId(), callId);
        }

        @Override
        public void callSessionMergeComplete(ImsCallSession newSession) {
            ImsCall.this.logi("callSessionMergeComplete :: newSession =" + newSession);
            if (!ImsCall.this.isMergeHost()) {
                ImsCall.this.mMergeHost.processMergeComplete();
            } else {
                if (newSession != null) {
                    ImsCall.this.mTransientConferenceSession = this.doesCallSessionExistsInMerge(newSession) ? null : newSession;
                }
                ImsCall.this.processMergeComplete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionMergeFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
            ImsCall.this.loge("callSessionMergeFailed :: session=" + session + "reasonInfo=" + reasonInfo);
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                if (ImsCall.this.isMergeHost()) {
                    ImsCall.this.processMergeFailed(reasonInfo);
                } else if (ImsCall.this.mMergeHost != null) {
                    ImsCall.this.mMergeHost.processMergeFailed(reasonInfo);
                } else {
                    ImsCall.this.loge("callSessionMergeFailed :: No merge host for this conference!");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionUpdated(ImsCallSession session, ImsCallProfile profile) {
            Listener listener;
            ImsCall.this.logi("callSessionUpdated :: session=" + session + " profile=" + profile);
            if (ImsCall.this.isTransientConferenceSession(session)) {
                ImsCall.this.logi("callSessionUpdated :: not supported for transient conference session=" + session);
                return;
            }
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
                ImsCall.this.setCallProfile(profile);
            }
            if (listener != null) {
                try {
                    listener.onCallUpdated(ImsCall.this);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionUpdated :: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionUpdateFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
            Listener listener;
            ImsCall.this.loge("callSessionUpdateFailed :: session=" + session + " reasonInfo=" + reasonInfo);
            if (ImsCall.this.isTransientConferenceSession(session)) {
                ImsCall.this.logi("callSessionUpdateFailed :: not supported for transient conference session=" + session);
                return;
            }
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
                ImsCall.this.mUpdateRequest = 0;
            }
            if (listener != null) {
                try {
                    listener.onCallUpdateFailed(ImsCall.this, reasonInfo);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionUpdateFailed :: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionUpdateReceived(ImsCallSession session, ImsCallProfile profile) {
            Listener listener;
            ImsCall.this.logi("callSessionUpdateReceived :: session=" + session + " profile=" + profile);
            if (ImsCall.this.isTransientConferenceSession(session)) {
                ImsCall.this.logi("callSessionUpdateReceived :: not supported for transient conference session=" + session);
                return;
            }
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
                ImsCall.this.mProposedCallProfile = profile;
                ImsCall.this.mUpdateRequest = 6;
            }
            if (listener != null) {
                try {
                    listener.onCallUpdateReceived(ImsCall.this);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionUpdateReceived :: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionConferenceExtended(ImsCallSession session, ImsCallSession newSession, ImsCallProfile profile) {
            Listener listener;
            ImsCall.this.logi("callSessionConferenceExtended :: session=" + session + " newSession=" + newSession + ", profile=" + profile);
            if (ImsCall.this.isTransientConferenceSession(session)) {
                ImsCall.this.logi("callSessionConferenceExtended :: not supported for transient conference session=" + session);
                return;
            }
            ImsCall newCall = ImsCall.this.createNewCall(newSession, profile);
            if (newCall == null) {
                this.callSessionConferenceExtendFailed(session, new ImsReasonInfo());
                return;
            }
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
                ImsCall.this.mUpdateRequest = 0;
            }
            if (listener != null) {
                try {
                    listener.onCallConferenceExtended(ImsCall.this, newCall);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionConferenceExtended :: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionConferenceExtendFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
            Listener listener;
            ImsCall.this.loge("callSessionConferenceExtendFailed :: reasonInfo=" + reasonInfo);
            if (ImsCall.this.isTransientConferenceSession(session)) {
                ImsCall.this.logi("callSessionConferenceExtendFailed :: not supported for transient conference session=" + session);
                return;
            }
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
                ImsCall.this.mUpdateRequest = 0;
            }
            if (listener != null) {
                try {
                    listener.onCallConferenceExtendFailed(ImsCall.this, reasonInfo);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionConferenceExtendFailed :: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionConferenceExtendReceived(ImsCallSession session, ImsCallSession newSession, ImsCallProfile profile) {
            Listener listener;
            ImsCall.this.logi("callSessionConferenceExtendReceived :: newSession=" + newSession + ", profile=" + profile);
            if (ImsCall.this.isTransientConferenceSession(session)) {
                ImsCall.this.logi("callSessionConferenceExtendReceived :: not supported for transient conference session" + session);
                return;
            }
            ImsCall newCall = ImsCall.this.createNewCall(newSession, profile);
            if (newCall == null) {
                return;
            }
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
            }
            if (listener != null) {
                try {
                    listener.onCallConferenceExtendReceived(ImsCall.this, newCall);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionConferenceExtendReceived :: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionInviteParticipantsRequestDelivered(ImsCallSession session) {
            Listener listener;
            ImsCall.this.logi("callSessionInviteParticipantsRequestDelivered ::");
            if (ImsCall.this.isTransientConferenceSession(session)) {
                ImsCall.this.logi("callSessionInviteParticipantsRequestDelivered :: not supported for conference session=" + session);
                return;
            }
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
            }
            if (listener != null) {
                try {
                    listener.onCallInviteParticipantsRequestDelivered(ImsCall.this);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionInviteParticipantsRequestDelivered :: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionInviteParticipantsRequestFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
            Listener listener;
            ImsCall.this.loge("callSessionInviteParticipantsRequestFailed :: reasonInfo=" + reasonInfo);
            if (ImsCall.this.isTransientConferenceSession(session)) {
                ImsCall.this.logi("callSessionInviteParticipantsRequestFailed :: not supported for conference session=" + session);
                return;
            }
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
            }
            if (listener != null) {
                try {
                    listener.onCallInviteParticipantsRequestFailed(ImsCall.this, reasonInfo);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionInviteParticipantsRequestFailed :: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionRemoveParticipantsRequestDelivered(ImsCallSession session) {
            Listener listener;
            ImsCall.this.logi("callSessionRemoveParticipantsRequestDelivered ::");
            if (ImsCall.this.isTransientConferenceSession(session)) {
                ImsCall.this.logi("callSessionRemoveParticipantsRequestDelivered :: not supported for conference session=" + session);
                return;
            }
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
            }
            if (listener != null) {
                try {
                    listener.onCallRemoveParticipantsRequestDelivered(ImsCall.this);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionRemoveParticipantsRequestDelivered :: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionRemoveParticipantsRequestFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
            Listener listener;
            ImsCall.this.loge("callSessionRemoveParticipantsRequestFailed :: reasonInfo=" + reasonInfo);
            if (ImsCall.this.isTransientConferenceSession(session)) {
                ImsCall.this.logi("callSessionRemoveParticipantsRequestFailed :: not supported for conference session=" + session);
                return;
            }
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
            }
            if (listener != null) {
                try {
                    listener.onCallRemoveParticipantsRequestFailed(ImsCall.this, reasonInfo);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionRemoveParticipantsRequestFailed :: ", t);
                }
            }
        }

        @Override
        public void callSessionConferenceStateUpdated(ImsCallSession session, ImsConferenceState state) {
            ImsCall.this.logi("callSessionConferenceStateUpdated :: state=" + state);
            ImsCall.this.conferenceStateUpdated(state);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionUssdMessageReceived(ImsCallSession session, int mode, String ussdMessage) {
            Listener listener;
            ImsCall.this.logi("callSessionUssdMessageReceived :: mode=" + mode + ", ussdMessage=" + ussdMessage);
            if (ImsCall.this.isTransientConferenceSession(session)) {
                ImsCall.this.logi("callSessionUssdMessageReceived :: not supported for transient conference session=" + session);
                return;
            }
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
            }
            if (listener != null) {
                try {
                    listener.onCallUssdMessageReceived(ImsCall.this, mode, ussdMessage);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionUssdMessageReceived :: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionTtyModeReceived(ImsCallSession session, int mode) {
            Listener listener;
            ImsCall.this.logi("callSessionTtyModeReceived :: mode=" + mode);
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
            }
            if (listener != null) {
                try {
                    listener.onCallSessionTtyModeReceived(ImsCall.this, mode);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionTtyModeReceived :: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionMultipartyStateChanged(ImsCallSession session, boolean isMultiParty) {
            Listener listener;
            if (VDBG) {
                ImsCall.this.logi("callSessionMultipartyStateChanged isMultiParty: " + (isMultiParty ? "Y" : "N"));
            }
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
            }
            if (listener != null) {
                try {
                    listener.onMultipartyStateChanged(ImsCall.this, isMultiParty);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionMultipartyStateChanged :: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionHandover(ImsCallSession session, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
            Listener listener;
            ImsCall.this.logi("callSessionHandover :: session=" + session + ", srcAccessTech=" + srcAccessTech + ", targetAccessTech=" + targetAccessTech + ", reasonInfo=" + reasonInfo);
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
            }
            if (listener != null) {
                try {
                    listener.onCallHandover(ImsCall.this, srcAccessTech, targetAccessTech, reasonInfo);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionHandover :: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionHandoverFailed(ImsCallSession session, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
            Listener listener;
            ImsCall.this.loge("callSessionHandoverFailed :: session=" + session + ", srcAccessTech=" + srcAccessTech + ", targetAccessTech=" + targetAccessTech + ", reasonInfo=" + reasonInfo);
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
            }
            if (listener != null) {
                try {
                    listener.onCallHandoverFailed(ImsCall.this, srcAccessTech, targetAccessTech, reasonInfo);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionHandoverFailed :: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionSuppServiceReceived(ImsCallSession session, ImsSuppServiceNotification suppServiceInfo) {
            Listener listener;
            if (ImsCall.this.isTransientConferenceSession(session)) {
                ImsCall.this.logi("callSessionSuppServiceReceived :: not supported for transient conference session=" + session);
                return;
            }
            ImsCall.this.logi("callSessionSuppServiceReceived :: session=" + session + ", suppServiceInfo" + suppServiceInfo);
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
            }
            if (listener != null) {
                try {
                    listener.onCallSuppServiceReceived(ImsCall.this, suppServiceInfo);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionSuppServiceReceived :: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionRttModifyRequestReceived(ImsCallSession session, ImsCallProfile callProfile) {
            Listener listener;
            ImsCall.this.logi("callSessionRttModifyRequestReceived");
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
            }
            if (!callProfile.mMediaProfile.isRttCall()) {
                ImsCall.this.logi("callSessionRttModifyRequestReceived:: ignoring request, requested profile is not RTT.");
                return;
            }
            if (listener != null) {
                try {
                    listener.onRttModifyRequestReceived(ImsCall.this);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionRttModifyRequestReceived:: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionRttModifyResponseReceived(int status) {
            Listener listener;
            ImsCall.this.logi("callSessionRttModifyResponseReceived: " + status);
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
            }
            if (listener != null) {
                try {
                    listener.onRttModifyResponseReceived(ImsCall.this, status);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionRttModifyResponseReceived:: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionRttMessageReceived(String rttMessage) {
            Listener listener;
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
            }
            if (listener != null) {
                try {
                    listener.onRttMessageReceived(ImsCall.this, rttMessage);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionRttMessageReceived:: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callSessionRttAudioIndicatorChanged(ImsStreamMediaProfile profile) {
            Listener listener;
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
            }
            if (listener != null) {
                try {
                    listener.onRttAudioIndicatorChanged(ImsCall.this, profile);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callSessionRttAudioIndicatorChanged:: ", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callQualityChanged(CallQuality callQuality) {
            Listener listener;
            ImsCall imsCall = ImsCall.this;
            synchronized (imsCall) {
                listener = ImsCall.this.mListener;
            }
            if (listener != null) {
                try {
                    listener.onCallQualityChanged(ImsCall.this, callQuality);
                }
                catch (Throwable t) {
                    ImsCall.this.loge("callQualityChanged:: ", t);
                }
            }
        }
    }

    public static class Listener {
        public void onCallProgressing(ImsCall call) {
            this.onCallStateChanged(call);
        }

        public void onCallStarted(ImsCall call) {
            this.onCallStateChanged(call);
        }

        public void onCallStartFailed(ImsCall call, ImsReasonInfo reasonInfo) {
            this.onCallError(call, reasonInfo);
        }

        public void onCallTerminated(ImsCall call, ImsReasonInfo reasonInfo) {
            this.onCallStateChanged(call);
        }

        public void onCallHeld(ImsCall call) {
            this.onCallStateChanged(call);
        }

        public void onCallHoldFailed(ImsCall call, ImsReasonInfo reasonInfo) {
            this.onCallError(call, reasonInfo);
        }

        public void onCallHoldReceived(ImsCall call) {
            this.onCallStateChanged(call);
        }

        public void onCallResumed(ImsCall call) {
            this.onCallStateChanged(call);
        }

        public void onCallResumeFailed(ImsCall call, ImsReasonInfo reasonInfo) {
            this.onCallError(call, reasonInfo);
        }

        public void onCallResumeReceived(ImsCall call) {
            this.onCallStateChanged(call);
        }

        public void onCallMerged(ImsCall call, ImsCall peerCall, boolean swapCalls) {
            this.onCallStateChanged(call);
        }

        public void onCallMergeFailed(ImsCall call, ImsReasonInfo reasonInfo) {
            this.onCallError(call, reasonInfo);
        }

        public void onCallUpdated(ImsCall call) {
            this.onCallStateChanged(call);
        }

        public void onCallUpdateFailed(ImsCall call, ImsReasonInfo reasonInfo) {
            this.onCallError(call, reasonInfo);
        }

        public void onCallUpdateReceived(ImsCall call) {
        }

        public void onCallConferenceExtended(ImsCall call, ImsCall newCall) {
            this.onCallStateChanged(call);
        }

        public void onCallConferenceExtendFailed(ImsCall call, ImsReasonInfo reasonInfo) {
            this.onCallError(call, reasonInfo);
        }

        public void onCallConferenceExtendReceived(ImsCall call, ImsCall newCall) {
            this.onCallStateChanged(call);
        }

        public void onCallInviteParticipantsRequestDelivered(ImsCall call) {
        }

        public void onCallInviteParticipantsRequestFailed(ImsCall call, ImsReasonInfo reasonInfo) {
        }

        public void onCallRemoveParticipantsRequestDelivered(ImsCall call) {
        }

        public void onCallRemoveParticipantsRequestFailed(ImsCall call, ImsReasonInfo reasonInfo) {
        }

        public void onCallConferenceStateUpdated(ImsCall call, ImsConferenceState state) {
        }

        public void onConferenceParticipantsStateChanged(ImsCall call, List<ConferenceParticipant> participants) {
        }

        public void onCallUssdMessageReceived(ImsCall call, int mode, String ussdMessage) {
        }

        public void onCallError(ImsCall call, ImsReasonInfo reasonInfo) {
        }

        public void onCallStateChanged(ImsCall call) {
        }

        public void onCallStateChanged(ImsCall call, int state) {
        }

        public void onCallSuppServiceReceived(ImsCall call, ImsSuppServiceNotification suppServiceInfo) {
        }

        public void onCallSessionTtyModeReceived(ImsCall call, int mode) {
        }

        public void onCallHandover(ImsCall imsCall, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
        }

        public void onRttModifyRequestReceived(ImsCall imsCall) {
        }

        public void onRttModifyResponseReceived(ImsCall imsCall, int status) {
        }

        public void onRttMessageReceived(ImsCall imsCall, String message) {
        }

        public void onCallHandoverFailed(ImsCall imsCall, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
        }

        public void onMultipartyStateChanged(ImsCall imsCall, boolean isMultiParty) {
        }

        public void onRttAudioIndicatorChanged(ImsCall imsCall, ImsStreamMediaProfile profile) {
        }

        public void onCallQualityChanged(ImsCall imsCall, CallQuality callQuality) {
        }
    }
}

