/*
 * Decompiled with CFR 0.152.
 */
package com.android.ims;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.telephony.Rlog;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.ims.ImsCallProfile;
import android.telephony.ims.aidl.IImsCapabilityCallback;
import android.telephony.ims.aidl.IImsConfig;
import android.telephony.ims.aidl.IImsConfigCallback;
import android.telephony.ims.aidl.IImsMmTelFeature;
import android.telephony.ims.aidl.IImsRegistration;
import android.telephony.ims.aidl.IImsRegistrationCallback;
import android.telephony.ims.aidl.IImsSmsListener;
import android.telephony.ims.feature.CapabilityChangeRequest;
import android.telephony.ims.feature.MmTelFeature;
import android.util.ArraySet;
import android.util.Log;
import android.util.SparseArray;
import com.android.ims.ImsManager;
import com.android.ims.internal.IImsCallSession;
import com.android.ims.internal.IImsEcbm;
import com.android.ims.internal.IImsMultiEndpoint;
import com.android.ims.internal.IImsServiceFeatureCallback;
import com.android.ims.internal.IImsUt;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public class MmTelFeatureConnection {
    protected static final String TAG = "MmTelFeatureConnection";
    protected final int mSlotId;
    protected IBinder mBinder;
    private Context mContext;
    private Executor mExecutor;
    private volatile boolean mIsAvailable = false;
    private Integer mFeatureStateCached = null;
    private IFeatureUpdate mStatusCallback;
    private final Object mLock = new Object();
    private boolean mSupportsEmergencyCalling = false;
    private static boolean sImsSupportedOnDevice = true;
    private IImsRegistration mRegistrationBinder;
    private IImsConfig mConfigBinder;
    private final IBinder.DeathRecipient mDeathRecipient = () -> {
        Log.w(TAG, "DeathRecipient triggered, binder died.");
        if (this.mContext != null && Looper.getMainLooper() != null) {
            this.mContext.getMainExecutor().execute(this::onRemovedOrDied);
            return;
        }
        this.onRemovedOrDied();
    };
    private final ImsRegistrationCallbackAdapter mRegistrationCallbackManager;
    private final CapabilityCallbackManager mCapabilityCallbackManager;
    private final ProvisioningCallbackManager mProvisioningCallbackManager;
    private final IImsServiceFeatureCallback mListenerBinder = new IImsServiceFeatureCallback.Stub(){

        @Override
        public void imsFeatureCreated(int slotId, int feature) {
            MmTelFeatureConnection.this.mExecutor.execute(() -> {
                Object object = MmTelFeatureConnection.this.mLock;
                synchronized (object) {
                    if (MmTelFeatureConnection.this.mSlotId != slotId) {
                        return;
                    }
                    switch (feature) {
                        case 1: {
                            if (MmTelFeatureConnection.this.mIsAvailable) break;
                            Log.i(MmTelFeatureConnection.TAG, "MmTel enabled on slotId: " + slotId);
                            MmTelFeatureConnection.this.mIsAvailable = true;
                            break;
                        }
                        case 0: {
                            MmTelFeatureConnection.this.mSupportsEmergencyCalling = true;
                            Log.i(MmTelFeatureConnection.TAG, "Emergency calling enabled on slotId: " + slotId);
                        }
                    }
                }
            });
        }

        @Override
        public void imsFeatureRemoved(int slotId, int feature) {
            MmTelFeatureConnection.this.mExecutor.execute(() -> {
                Object object = MmTelFeatureConnection.this.mLock;
                synchronized (object) {
                    if (MmTelFeatureConnection.this.mSlotId != slotId) {
                        return;
                    }
                    switch (feature) {
                        case 1: {
                            Log.i(MmTelFeatureConnection.TAG, "MmTel removed on slotId: " + slotId);
                            MmTelFeatureConnection.this.onRemovedOrDied();
                            break;
                        }
                        case 0: {
                            MmTelFeatureConnection.this.mSupportsEmergencyCalling = false;
                            Log.i(MmTelFeatureConnection.TAG, "Emergency calling disabled on slotId: " + slotId);
                        }
                    }
                }
            });
        }

        @Override
        public void imsStatusChanged(int slotId, int feature, int status) {
            MmTelFeatureConnection.this.mExecutor.execute(() -> {
                Object object = MmTelFeatureConnection.this.mLock;
                synchronized (object) {
                    Log.i(MmTelFeatureConnection.TAG, "imsStatusChanged: slot: " + slotId + " feature: " + feature + " status: " + status);
                    if (MmTelFeatureConnection.this.mSlotId == slotId && feature == 1) {
                        MmTelFeatureConnection.this.mFeatureStateCached = status;
                        if (MmTelFeatureConnection.this.mStatusCallback != null) {
                            MmTelFeatureConnection.this.mStatusCallback.notifyStateChanged();
                        }
                    }
                }
            });
        }
    };

    public static MmTelFeatureConnection create(Context context, int slotId) {
        MmTelFeatureConnection serviceProxy = new MmTelFeatureConnection(context, slotId);
        if (!ImsManager.isImsSupportedOnDevice(context)) {
            sImsSupportedOnDevice = false;
            return serviceProxy;
        }
        TelephonyManager tm = MmTelFeatureConnection.getTelephonyManager(context);
        if (tm == null) {
            Rlog.w(TAG, "create: TelephonyManager is null!");
            return serviceProxy;
        }
        IImsMmTelFeature binder = tm.getImsMmTelFeatureAndListen(slotId, serviceProxy.getListener());
        if (binder != null) {
            serviceProxy.setBinder(binder.asBinder());
            serviceProxy.getFeatureState();
        } else {
            Rlog.w(TAG, "create: binder is null! Slot Id: " + slotId);
        }
        return serviceProxy;
    }

    public static TelephonyManager getTelephonyManager(Context context) {
        return (TelephonyManager)context.getSystemService("phone");
    }

    public MmTelFeatureConnection(Context context, int slotId) {
        this.mSlotId = slotId;
        this.mContext = context;
        if (context.getMainLooper() != null) {
            this.mExecutor = context.getMainExecutor();
        } else {
            if (Looper.myLooper() == null) {
                Looper.prepare();
            }
            this.mExecutor = new HandlerExecutor(new Handler(Looper.myLooper()));
        }
        this.mRegistrationCallbackManager = new ImsRegistrationCallbackAdapter(context, this.mLock);
        this.mCapabilityCallbackManager = new CapabilityCallbackManager(context, this.mLock);
        this.mProvisioningCallbackManager = new ProvisioningCallbackManager(context, this.mLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRemovedOrDied() {
        Object object = this.mLock;
        synchronized (object) {
            this.mRegistrationCallbackManager.close();
            this.mCapabilityCallbackManager.close();
            this.mProvisioningCallbackManager.close();
            if (this.mIsAvailable) {
                this.mIsAvailable = false;
                this.mRegistrationBinder = null;
                this.mConfigBinder = null;
                if (this.mBinder != null) {
                    this.mBinder.unlinkToDeath(this.mDeathRecipient, 0);
                }
                if (this.mStatusCallback != null) {
                    this.mStatusCallback.notifyUnavailable();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IImsRegistration getRegistration() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mRegistrationBinder != null) {
                return this.mRegistrationBinder;
            }
        }
        TelephonyManager tm = MmTelFeatureConnection.getTelephonyManager(this.mContext);
        IImsRegistration regBinder = tm != null ? tm.getImsRegistration(this.mSlotId, 1) : null;
        Object object2 = this.mLock;
        synchronized (object2) {
            if (this.mRegistrationBinder == null) {
                this.mRegistrationBinder = regBinder;
            }
        }
        return this.mRegistrationBinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IImsConfig getConfig() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConfigBinder != null) {
                return this.mConfigBinder;
            }
        }
        TelephonyManager tm = MmTelFeatureConnection.getTelephonyManager(this.mContext);
        IImsConfig configBinder = tm != null ? tm.getImsConfig(this.mSlotId, 1) : null;
        Object object2 = this.mLock;
        synchronized (object2) {
            if (this.mConfigBinder == null) {
                this.mConfigBinder = configBinder;
            }
        }
        return this.mConfigBinder;
    }

    public boolean isEmergencyMmTelAvailable() {
        return this.mSupportsEmergencyCalling;
    }

    public IImsServiceFeatureCallback getListener() {
        return this.mListenerBinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinder(IBinder binder) {
        Object object = this.mLock;
        synchronized (object) {
            this.mBinder = binder;
            try {
                if (this.mBinder != null) {
                    this.mBinder.linkToDeath(this.mDeathRecipient, 0);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openConnection(MmTelFeature.Listener listener) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            this.getServiceInterface(this.mBinder).setListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() {
        this.mRegistrationCallbackManager.close();
        this.mCapabilityCallbackManager.close();
        this.mProvisioningCallbackManager.close();
        try {
            Object object = this.mLock;
            synchronized (object) {
                if (this.isBinderAlive()) {
                    this.getServiceInterface(this.mBinder).setListener(null);
                }
            }
        }
        catch (RemoteException e) {
            Log.w(TAG, "closeConnection: couldn't remove listener!");
        }
    }

    public void addRegistrationCallback(IImsRegistrationCallback callback) {
        this.mRegistrationCallbackManager.addCallback(callback);
    }

    public void addRegistrationCallbackForSubscription(IImsRegistrationCallback callback, int subId) {
        this.mRegistrationCallbackManager.addCallbackForSubscription(callback, subId);
    }

    public void removeRegistrationCallback(IImsRegistrationCallback callback) {
        this.mRegistrationCallbackManager.removeCallback(callback);
    }

    public void removeRegistrationCallbackForSubscription(IImsRegistrationCallback callback, int subId) {
        this.mRegistrationCallbackManager.removeCallbackForSubscription(callback, subId);
    }

    public void addCapabilityCallback(IImsCapabilityCallback callback) {
        this.mCapabilityCallbackManager.addCallback(callback);
    }

    public void addCapabilityCallbackForSubscription(IImsCapabilityCallback callback, int subId) {
        this.mCapabilityCallbackManager.addCallbackForSubscription(callback, subId);
    }

    public void removeCapabilityCallback(IImsCapabilityCallback callback) {
        this.mCapabilityCallbackManager.removeCallback(callback);
    }

    public void removeCapabilityCallbackForSubscription(IImsCapabilityCallback callback, int subId) {
        this.mCapabilityCallbackManager.removeCallbackForSubscription(callback, subId);
    }

    public void addProvisioningCallbackForSubscription(IImsConfigCallback callback, int subId) {
        this.mProvisioningCallbackManager.addCallbackForSubscription(callback, subId);
    }

    public void removeProvisioningCallbackForSubscription(IImsConfigCallback callback, int subId) {
        this.mProvisioningCallbackManager.removeCallbackForSubscription(callback, subId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeEnabledCapabilities(CapabilityChangeRequest request, IImsCapabilityCallback callback) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            this.getServiceInterface(this.mBinder).changeCapabilitiesConfiguration(request, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryEnabledCapabilities(int capability, int radioTech, IImsCapabilityCallback callback) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            this.getServiceInterface(this.mBinder).queryCapabilityConfiguration(capability, radioTech, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MmTelFeature.MmTelCapabilities queryCapabilityStatus() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return new MmTelFeature.MmTelCapabilities(this.getServiceInterface(this.mBinder).queryCapabilityStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImsCallProfile createCallProfile(int callServiceType, int callType) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getServiceInterface(this.mBinder).createCallProfile(callServiceType, callType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IImsCallSession createCallSession(ImsCallProfile profile) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getServiceInterface(this.mBinder).createCallSession(profile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IImsUt getUtInterface() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getServiceInterface(this.mBinder).getUtInterface();
        }
    }

    public IImsConfig getConfigInterface() {
        return this.getConfig();
    }

    public int getRegistrationTech() throws RemoteException {
        IImsRegistration registration = this.getRegistration();
        if (registration != null) {
            return registration.getRegistrationTechnology();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IImsEcbm getEcbmInterface() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getServiceInterface(this.mBinder).getEcbmInterface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUiTTYMode(int uiTtyMode, Message onComplete) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            this.getServiceInterface(this.mBinder).setUiTtyMode(uiTtyMode, onComplete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IImsMultiEndpoint getMultiEndpointInterface() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getServiceInterface(this.mBinder).getMultiEndpointInterface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSms(int token, int messageRef, String format, String smsc, boolean isRetry, byte[] pdu) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            this.getServiceInterface(this.mBinder).sendSms(token, messageRef, format, smsc, isRetry, pdu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeSms(int token, int messageRef, int result) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            this.getServiceInterface(this.mBinder).acknowledgeSms(token, messageRef, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeSmsReport(int token, int messageRef, int result) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            this.getServiceInterface(this.mBinder).acknowledgeSmsReport(token, messageRef, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSmsFormat() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getServiceInterface(this.mBinder).getSmsFormat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSmsReady() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            this.getServiceInterface(this.mBinder).onSmsReady();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSmsListener(IImsSmsListener listener) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            this.getServiceInterface(this.mBinder).setSmsListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int shouldProcessCall(boolean isEmergency, String[] numbers) throws RemoteException {
        if (isEmergency && !this.isEmergencyMmTelAvailable()) {
            Log.i(TAG, "MmTel does not support emergency over IMS, fallback to CS.");
            return 1;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getServiceInterface(this.mBinder).shouldProcessCall(numbers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFeatureState() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isBinderAlive() && this.mFeatureStateCached != null) {
                return this.mFeatureStateCached;
            }
        }
        Integer status = this.retrieveFeatureState();
        Object object2 = this.mLock;
        synchronized (object2) {
            if (status == null) {
                return 0;
            }
            this.mFeatureStateCached = status;
        }
        Log.i(TAG, "getFeatureState - returning " + status);
        return status;
    }

    private Integer retrieveFeatureState() {
        if (this.mBinder != null) {
            try {
                return this.getServiceInterface(this.mBinder).getFeatureState();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setStatusCallback(IFeatureUpdate c) {
        this.mStatusCallback = c;
    }

    public boolean isBinderReady() {
        return this.isBinderAlive() && this.getFeatureState() == 2;
    }

    public boolean isBinderAlive() {
        return this.mIsAvailable && this.mBinder != null && this.mBinder.isBinderAlive();
    }

    private void checkServiceIsReady() throws RemoteException {
        if (!sImsSupportedOnDevice) {
            throw new RemoteException("IMS is not supported on this device.");
        }
        if (!this.isBinderReady()) {
            throw new RemoteException("ImsServiceProxy is not ready to accept commands.");
        }
    }

    private IImsMmTelFeature getServiceInterface(IBinder b) {
        return IImsMmTelFeature.Stub.asInterface(b);
    }

    public static interface IFeatureUpdate {
        public void notifyStateChanged();

        public void notifyUnavailable();
    }

    private class ProvisioningCallbackManager
    extends CallbackAdapterManager<IImsConfigCallback> {
        public ProvisioningCallbackManager(Context context, Object lock) {
            super(context, lock);
        }

        @Override
        public void registerCallback(IImsConfigCallback localCallback) {
            IImsConfig binder = MmTelFeatureConnection.this.getConfigInterface();
            if (binder == null) {
                Log.w(MmTelFeatureConnection.TAG, "ProvisioningCallbackManager - couldn't register, binder is null.");
                throw new IllegalStateException("ImsConfig is not available!");
            }
            try {
                binder.addImsConfigCallback(localCallback);
            }
            catch (RemoteException e) {
                throw new IllegalStateException("ImsService is not available!");
            }
        }

        @Override
        public void unregisterCallback(IImsConfigCallback localCallback) {
            IImsConfig binder = MmTelFeatureConnection.this.getConfigInterface();
            if (binder == null) {
                Log.w(MmTelFeatureConnection.TAG, "ProvisioningCallbackManager - couldn't unregister, binder is null.");
                return;
            }
            try {
                binder.removeImsConfigCallback(localCallback);
            }
            catch (RemoteException e) {
                Log.w(MmTelFeatureConnection.TAG, "ProvisioningCallbackManager - couldn't unregister, binder is dead.");
            }
        }
    }

    private class CapabilityCallbackManager
    extends CallbackAdapterManager<IImsCapabilityCallback> {
        public CapabilityCallbackManager(Context context, Object lock) {
            super(context, lock);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerCallback(IImsCapabilityCallback localCallback) {
            IImsMmTelFeature binder;
            Object object = MmTelFeatureConnection.this.mLock;
            synchronized (object) {
                try {
                    MmTelFeatureConnection.this.checkServiceIsReady();
                    binder = MmTelFeatureConnection.this.getServiceInterface(MmTelFeatureConnection.this.mBinder);
                }
                catch (RemoteException e) {
                    throw new IllegalStateException("CapabilityCallbackManager - MmTelFeature binder is dead.");
                }
            }
            if (binder != null) {
                try {
                    binder.addCapabilityCallback(localCallback);
                }
                catch (RemoteException e) {
                    throw new IllegalStateException(" CapabilityCallbackManager - MmTelFeature binder is null.");
                }
            } else {
                Log.w(MmTelFeatureConnection.TAG, "CapabilityCallbackManager, register: Couldn't get binder");
                throw new IllegalStateException("CapabilityCallbackManager: MmTelFeature is not available!");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregisterCallback(IImsCapabilityCallback localCallback) {
            IImsMmTelFeature binder;
            Object object = MmTelFeatureConnection.this.mLock;
            synchronized (object) {
                try {
                    MmTelFeatureConnection.this.checkServiceIsReady();
                    binder = MmTelFeatureConnection.this.getServiceInterface(MmTelFeatureConnection.this.mBinder);
                }
                catch (RemoteException e) {
                    Log.w(MmTelFeatureConnection.TAG, "CapabilityCallbackManager, unregister: couldn't get binder.");
                    return;
                }
            }
            if (binder != null) {
                try {
                    binder.removeCapabilityCallback(localCallback);
                }
                catch (RemoteException e) {
                    Log.w(MmTelFeatureConnection.TAG, "CapabilityCallbackManager, unregister: Binder is dead.");
                }
            } else {
                Log.w(MmTelFeatureConnection.TAG, "CapabilityCallbackManager, unregister: binder is null.");
            }
        }
    }

    private class ImsRegistrationCallbackAdapter
    extends CallbackAdapterManager<IImsRegistrationCallback> {
        public ImsRegistrationCallbackAdapter(Context context, Object lock) {
            super(context, lock);
        }

        @Override
        public void registerCallback(IImsRegistrationCallback localCallback) {
            IImsRegistration imsRegistration = MmTelFeatureConnection.this.getRegistration();
            if (imsRegistration != null) {
                try {
                    imsRegistration.addRegistrationCallback(localCallback);
                }
                catch (RemoteException e) {
                    throw new IllegalStateException("ImsRegistrationCallbackAdapter: MmTelFeature binder is dead.");
                }
            } else {
                Log.e(MmTelFeatureConnection.TAG, "ImsRegistrationCallbackAdapter: ImsRegistration is null");
                throw new IllegalStateException("ImsRegistrationCallbackAdapter: MmTelFeature isnot available!");
            }
        }

        @Override
        public void unregisterCallback(IImsRegistrationCallback localCallback) {
            IImsRegistration imsRegistration = MmTelFeatureConnection.this.getRegistration();
            if (imsRegistration != null) {
                try {
                    imsRegistration.removeRegistrationCallback(localCallback);
                }
                catch (RemoteException e) {
                    Log.w(MmTelFeatureConnection.TAG, "ImsRegistrationCallbackAdapter - unregisterCallback: couldn't remove registration callback");
                }
            } else {
                Log.e(MmTelFeatureConnection.TAG, "ImsRegistrationCallbackAdapter: ImsRegistration is null");
            }
        }
    }

    @VisibleForTesting
    public static abstract class CallbackAdapterManager<T extends IInterface> {
        private static final String TAG = "CallbackAdapterManager";
        private final Context mContext;
        private final Object mLock;
        private final SparseArray<Set<T>> mCallbackSubscriptionMap = new SparseArray();
        private final RemoteCallbackList<T> mRemoteCallbacks = new RemoteCallbackList();
        @VisibleForTesting
        public SubscriptionManager.OnSubscriptionsChangedListener mSubChangedListener;

        public CallbackAdapterManager(Context context, Object lock) {
            this.mContext = context;
            this.mLock = lock;
            if (Looper.myLooper() == null) {
                Looper.prepare();
            }
            this.mSubChangedListener = new SubscriptionManager.OnSubscriptionsChangedListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSubscriptionsChanged() {
                    SubscriptionManager manager = mContext.getSystemService(SubscriptionManager.class);
                    if (manager == null) {
                        Log.w(CallbackAdapterManager.TAG, "onSubscriptionsChanged: could not find SubscriptionManager.");
                        return;
                    }
                    List<SubscriptionInfo> subInfos = manager.getActiveSubscriptionInfoList(false);
                    if (subInfos == null) {
                        subInfos = Collections.emptyList();
                    }
                    Set newSubIds = subInfos.stream().map(SubscriptionInfo::getSubscriptionId).collect(Collectors.toSet());
                    Object object = mLock;
                    synchronized (object) {
                        ArraySet<Integer> storedSubIds = new ArraySet<Integer>(mCallbackSubscriptionMap.size());
                        for (int keyIndex = 0; keyIndex < mCallbackSubscriptionMap.size(); ++keyIndex) {
                            storedSubIds.add(mCallbackSubscriptionMap.keyAt(keyIndex));
                        }
                        storedSubIds.removeAll(newSubIds);
                        for (Integer subId : storedSubIds) {
                            this.removeCallbacksForSubscription(subId);
                        }
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addCallback(T localCallback) {
            Object object = this.mLock;
            synchronized (object) {
                this.registerCallback(localCallback);
                Log.i(TAG, "Local callback added: " + localCallback);
                this.mRemoteCallbacks.register(localCallback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addCallbackForSubscription(T localCallback, int subId) {
            if (!SubscriptionManager.isValidSubscriptionId(subId)) {
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                this.addCallback(localCallback);
                this.linkCallbackToSubscription(localCallback, subId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeCallback(T localCallback) {
            Log.i(TAG, "Local callback removed: " + localCallback);
            Object object = this.mLock;
            synchronized (object) {
                if (this.mRemoteCallbacks.unregister(localCallback)) {
                    this.unregisterCallback(localCallback);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeCallbackForSubscription(T localCallback, int subId) {
            if (!SubscriptionManager.isValidSubscriptionId(subId)) {
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                this.removeCallback(localCallback);
                this.unlinkCallbackFromSubscription(localCallback, subId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void linkCallbackToSubscription(T callback, int subId) {
            Object object = this.mLock;
            synchronized (object) {
                Set<T> callbacksPerSub;
                if (this.mCallbackSubscriptionMap.size() == 0) {
                    this.registerForSubscriptionsChanged();
                }
                if ((callbacksPerSub = this.mCallbackSubscriptionMap.get(subId)) == null) {
                    callbacksPerSub = new ArraySet<T>();
                    this.mCallbackSubscriptionMap.put(subId, callbacksPerSub);
                }
                callbacksPerSub.add(callback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unlinkCallbackFromSubscription(T callback, int subId) {
            Object object = this.mLock;
            synchronized (object) {
                Set<T> callbacksPerSub = this.mCallbackSubscriptionMap.get(subId);
                if (callbacksPerSub != null) {
                    callbacksPerSub.remove(callback);
                    if (callbacksPerSub.isEmpty()) {
                        this.mCallbackSubscriptionMap.remove(subId);
                    }
                }
                if (this.mCallbackSubscriptionMap.size() == 0) {
                    this.unregisterForSubscriptionsChanged();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeCallbacksForSubscription(int subId) {
            if (!SubscriptionManager.isValidSubscriptionId(subId)) {
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                Set<T> callbacksPerSub = this.mCallbackSubscriptionMap.get(subId);
                if (callbacksPerSub == null) {
                    return;
                }
                this.mCallbackSubscriptionMap.remove(subId);
                for (IInterface callback : callbacksPerSub) {
                    this.removeCallback(callback);
                }
                if (this.mCallbackSubscriptionMap.size() == 0) {
                    this.unregisterForSubscriptionsChanged();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearCallbacksForAllSubscriptions() {
            Object object = this.mLock;
            synchronized (object) {
                ArrayList<Integer> keys = new ArrayList<Integer>();
                for (int keyIndex = 0; keyIndex < this.mCallbackSubscriptionMap.size(); ++keyIndex) {
                    keys.add(this.mCallbackSubscriptionMap.keyAt(keyIndex));
                }
                keys.forEach(this::removeCallbacksForSubscription);
            }
        }

        private void registerForSubscriptionsChanged() {
            SubscriptionManager manager = this.mContext.getSystemService(SubscriptionManager.class);
            if (manager != null) {
                manager.addOnSubscriptionsChangedListener(this.mSubChangedListener);
            } else {
                Log.w(TAG, "registerForSubscriptionsChanged: could not find SubscriptionManager.");
            }
        }

        private void unregisterForSubscriptionsChanged() {
            SubscriptionManager manager = this.mContext.getSystemService(SubscriptionManager.class);
            if (manager != null) {
                manager.removeOnSubscriptionsChangedListener(this.mSubChangedListener);
            } else {
                Log.w(TAG, "unregisterForSubscriptionsChanged: could not find SubscriptionManager.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void close() {
            Object object = this.mLock;
            synchronized (object) {
                int lastCallbackIndex;
                for (int ii = lastCallbackIndex = this.mRemoteCallbacks.getRegisteredCallbackCount() - 1; ii >= 0; --ii) {
                    T callbackItem = this.mRemoteCallbacks.getRegisteredCallbackItem(ii);
                    this.unregisterCallback(callbackItem);
                    this.mRemoteCallbacks.unregister(callbackItem);
                }
                this.clearCallbacksForAllSubscriptions();
                Log.i(TAG, "Closing connection and clearing callbacks");
            }
        }

        public abstract void registerCallback(T var1);

        public abstract void unregisterCallback(T var1);
    }
}

